#modname "LA Nation: Mistica : Cult of Mana"
#description "In the years of Ermor's decline, the remote vassal province of Mistica became a haven for persecuted mages seeking sanctuary. Over time, the various magical and mystic societies banded together to form a Mana Cult, extolling the virtues of magic in all its forms, both as a pragmatic means of protecting their own ability to gather for magical purposes, and as a means to extend their own arcane abilities. The populace embraced the new religion with an unexpected fervor and it has become clear that a divine presence has coalesced from the magical energies-- one who now blesses powerful magi with strange gifts.  With the departure of the Pantokrator, whether they will it or not, they are caught up in the struggle for divine omnipotence currently underway."
#icon "./MISTICA/logo.tga" 
#version 0.2

-->>>>>>>>>>>>>  THIS MOD REQUIRES CBM TO BE ENABLED FIRST AS IT USES WEAPON ID 710 FOR "WARHORSE HOOF" WEAPONS AND COPIES CBM UNITS <<<<<<<<<<<<<<<<<<<<<<


--Version notes: 
-- 0.2 Juggernaut: reduced HP, astral, and protection.  Made NoHeal.  Updated sprite.
       Fixed leadership stat for Master of Occult
	   Fixed MA typo in title.
	   Added Master Alchemist as pretender option.
-- 0.1 First public release.

------ ID slots

--Nation 84
--Weapons 620-621 
--Armour (none)
--Monsters 3200 - 3230 
--Sites 780-783 --alternatively, repurpose 30-32 (EA Mictlan) and 129 (EA Atlantis) if using something that consumes all site slots


-------- New Weapons

#newweapon 620 
#name "Spiked Gloves"
#dmg 3
#rcost 0
#att 0
#def -1
#length 0
#sound 38
#nratt 2
#end

#newweapon 621
#name "Hard Stare"
#dmg 10
#nratt 1
#rcost 0
#att 50
#def 0
#len 0
#sound 22
#range 50
#ammo 30
#armornegating
#magic
#dt_stun
#nostr
#secondaryeffect 440 --lesser fear, as per howling bow
#mind --don't affect mindless
#explspr -1 --no explosion
#end

-------- New Armour

--newarmor 321 --TODO: update
--name "Lightweight Plate"
--type 5 --body
--prot 14
--def 0
--enc 1
--rcost 20
--end

-------- Units


--PRETENDERS


--Sacred Statue
#newmonster 3201
#copystats 472 --Sacred Statue
#copyspr 472 --Sacred Statue
#restrictedgod 84
#end

--Juggernaut 
#newmonster 3203
--copystats 781 --can't copystat due to sacred
--copyspr 781 --Juggernaut
#spr1 "./MISTICA/mistican_juggernaut.tga" 
#spr1 "./MISTICA/mistican_juggernaut_atk.tga" 
#name "Juggernaut of Mistica"
#descr "A juggernaut is a colossal machine made out of religious idols and two pairs of enormous wheels, powered by Astral magic.  The juggernaut is covered by a layer of gold to make it look even more religiously important.  This juggernaut was constructed by the magocracy to serve as a focus for the religious concerns of the citizenry; it has apparently been affected by the confluence of extreme amounts of magical energy and the constant stream of religious devotion, and has become animated.  It can voice the will channeled into it by its devout worshippers by animating and speaking through the various golden idols on its surface.  This particular juggernaut, while exquisitely crafted, is somewhat more fragile than most, and requires extreme magical care to repair it in the event it should be damaged.  It excels at spreading its own dominion."
#weapon 90 --"Crush"
#magicskill 4 1
#hp 90 
#prot 18
#size 6
#str 20
#enc 0
#att 5
#def 5
#prec 5
#mr 18
#mor 50
#mapmove 1
#ap 4
#pathcost 50
#startdom 5
#neednoteat
#noitem
#poisonres 100
#trample
#magicbeing
#stonebeing
#inanimate --lifeless
#spreaddom 1
#noheal
#gcost 0
#restrictedgod 84
#end

--Divine Glyph
#newmonster 3204
#copyspr 1025 --Divine Glyph
#copystats 1025 --Divine Glyph
#restrictedgod 84
#end

-- CUSTOM

--Shimmering Veil
#newmonster 3205
#name "Shimmering Veil"
#spr1 "./MISTICA/veil.tga" 
#spr2 "./MISTICA/veil_atk.tga" 
#descr "The Shimmering Veil is a semi-transparent, ever-sparkling array of multi-colored flashing lights comprised of pure, chaotic magical energies. Periodically, gems of pure astral engergy will coalesce from the raw magical energies in its presence.  The Shimmering Veil can transform the mundane into the mystical, and can make its divine will known in a variety of ways, from possessing lesser beings to do its will, to telepathically communicating in words or visions, to manifesting visible representations of its desire.  While even the most devout of its followers may have difficulty interpreting these desires on occasion, it is manifestly evident that the Shimmering Veil seeks to assume the mantle left by the previous Pantokrator."
#ap 2
#mapmove 0
#hp 20
#prot 0
#size 4
#str 10
#enc 0
#att 5
#def 5
#prec 20
#mr 20
#mor 30
#gcost 50 --TBD
#rcost 1
#pathcost 10
#startdom 2
#restrictedgod 84
#magicbeing
#blind
#coldres 100
#fireres 100
#poisonres 100
#shockres 100
#maxage 1000
#neednoteat
#ethereal
#itemslots 28672 --3 misc
#magicskill 4 3 -- 3 S
#gemprod 4 1 -- 1 S gem
#onebattlespell "Astral Shield"
#poorleader
#superiormagicleader
#poorundeadleader
#end

--Pillar of Eternal Flame
#newmonster 3206
#name "Pillar of Eternal Flame"
#spr1 "./MISTICA/pillar.tga" 
#spr2 "./MISTICA/pillar_atk.tga"
#descr "The Pillar of Eternal Flame erupts as a swirling, roaring, raging column of flame from a blackened maw in the earth; no visible fuel source is evident, but occasionally shining fire gems will coalesce from the swirling flames near its base.  Bright sparks coruscate across its surface before the inferno tapers off some distance into the air.  When in its presence, one can feel its will, as if seared into one's brain straight through the eyes, branded onto the observer's soul.  Whatever the reason behind its inscrutable desires, it is immediately obvious that it wants to assume the mantle of the previous Pantokrator."
#ap 2
#mapmove 0
#hp 20
#prot 0
#size 4
#str 10
#enc 0
#att 5
#def 5
#prec 15
#mr 18
#mor 30
#gcost 20 --TBD
#pathcost 50
#weapon 350 --fire flare
#weapon 383 --throw flames
#startdom 4
#restrictedgod 84
#magicbeing
#blind
#fireres 100
#poisonres 100
#maxage 1000
#neednoteat
#ethereal
#fireshield 10
#heat 5
#itemslots 28672 --3 misc
#magicskill 0 3 -- 3 F
#gemprod 0 1 -- 1 F gem
#nametype 140 --Demon
#expertleader
#goodmagicleader
#end

--Golem King
#newmonster 3207
#copystats 1073 --Maker of the maze, to get construct lord
#name "Golem King"
#spr1 "./MISTICA/golem_king.tga" 
#spr2 "./MISTICA/golem_king_atk.tga"
#descr "In the ancient tracts that describe the process and rites involved in constructing a golem, it is frequently warned that one must never grant the resulting creation free will.  The Golem King is such a being, a golem created by other golems, a side effect of an ill-conceived attempt to improve the efficiency of the golem creation process (and due to this background, he has unusual skill in the creation of animated constructs.)  The Golem King is powerful, self-aware, ambitious, and aims to assume the mantle of the previous Pantokrator through the subjugation of the beings who once sought to be masters of its kind."
#siegebonus 0 --reset from copystats
#castledef -1 --reset from copystats
#ap 10
#mapmove 3
#hp 85
#prot 6 
#size 5
#str 25
#enc 0
#att 10
#def 10
#prec 8
#mr 18
#mor 30
#gcost 50 --TBD
#rcost 1
#pathcost 40
#startdom 1
#weapon 134 --Sceptre of Authority
#armor "Crown"
#restrictedgod 84
#inanimate --lifeless
#magicbeing
#poisonres 100
#fireres 100
#startage 65
#maxage 2000
#neednoteat
#itemslots 15494 --bitmask, standard slots = 15494
#clearmagic
#magicskill 4 2 -- 2 S
#nametype 139 --Angel
#okleader
#superiormagicleader
#end

--Ether lord
#newmonster 3229
#copystats 737 --Ether Lord
#copyspr 737 --Ether Lord
#descr "An Ether Lord is an ancient mage and clan leader of the Ether Warriors. It was the Ether Lords who had drained the world of Arcana and led their clans into their otherworldly realm to continue their clan wars. Ether Lords are ethereal and very difficult to harm with non-magical weapons. Ether Lords use Moon Lances, magical spears that cause additional damage to magical beings. Ether Lords are powerful wielders of Astral magic as well as Death magic.  This Ether Lord has broken through the astral barrier separating his people from the mortal realms and now seeks to claim the mantle of godhood."
#mor 30
#clearmagic
#pathcost 10
#gcost 20 --TBD
#restrictedgod 84
#magicskill 4 2 --2S
#magicskill 5 1 --1D
#end

--Master Alchemist
#newmonster 3230
#copystats 550 -- Master Alchemist
#copyspr 550
#restrictedgod 84
#end

--UNITS

--- Standard Units

--Longspearman 
#newmonster 3210
#spr1 "./MISTICA/longspear.tga" 
#spr2 "./MISTICA/longspear_atk.tga"
#name "Longspearman"
#descr "Spearmen consist of easily raised troops in relatively inexpensive gear. Nevertheless, they can be effective when trained and deployed en masse, and are frequently arranged as screeners defending critical assets.  Their morale suffers from a general sense that they are viewed as expendable by the army's battlemages."
#mor 8
#mr 12
#enc 3
#weapon 28 --Long spear
#armor "Ring Mail Cuirass"
#armor "Tower Shield"
#armor "Reinforced Leather Cap"
#gcost 9
#end

--Bowman
#newmonster 3211
#spr1 "./MISTICA/bowman.tga" 
#spr2 "./MISTICA/bowman_atk.tga" 
#name "Bowman"
#descr "Massed bowmen are a deterrent to any lightly armored force. However, missile fire represents one of their own great vulnerabilities.  Bowmen are much less of a threat to heavily armored forces, unless magical support is available.  Fortunately, Mistican forces are frequently in a position to provide said support.  Mistica's bowmen use composite bows adapted from designs originally used by tribes of invading barbarian horsemen."
#weapon 252 --Club
#weapon 264 --Composite Bow 
--weapon 23 --Short Bow
#armor "Reinforced Leather Cap"
#armor "Leather Cuirass"
#mor 8
#mr 12
#enc 3
#gcost 9
#end

--Hvy Inf (mornstar)
#newmonster 3212
#spr1 "./MISTICA/hvy_morningstar.tga" 
#spr2 "./MISTICA/hvy_morningstar_atk.tga"
#name "Mistican Heavy Infantry"
#descr "Mistican heavy infantry are outfitted either with morningstars or swords and heavy scale armor. Their morale suffers a bit from a general sense that they may be viewed as expendable by the army's battlemages."
#enc 3
#weapon 15 --Morningstar
--armor "Chain Mail Hauberk"
--armor "Full Ring Mail"
#armor "Scale Mail Hauberk"
#armor "Shield"
#armor "Iron Cap"
#mor 9
#mr 12
#gcost 10
#end

--Hvy Inf (falchion)
#newmonster 3208
#spr1 "./MISTICA/hvy_falchion.tga" 
#spr2 "./MISTICA/hvy_falchion_atk.tga"
#name "Mistican Heavy Infantry"
#descr "Mistican heavy infantry are outfitted either with morningstars or swords and heavy scale armor. Their morale suffers a bit from a general sense that they may be viewed as expendable by the army's battlemages."
#enc 3
#weapon 10 --falchion
--armor "Full Scale Mail"
--armor "Full Ring Mail"
#armor "Scale Mail Hauberk"
#armor "Shield"
#armor "Iron Cap"
#mor 9
#mr 12
#gcost 10
#end

--Hvy Cav
#newmonster 3213
#copystats 790 --Imperial Horseman
#spr1 "./MISTICA/cavalry.tga" 
#spr2 "./MISTICA/cavalry_atk.tga"
#name "Mistican Cavalry"
#descr "Cavalry units are expensive, but are both well armored and mobile.  Mistican cavalry have somewhat better morale than their infantry counterparts, possibly arising from the greater expenditure required to replace them and their horse."
--size 3
--ap 22
--enc 5
--mounted
--weapon 10 --falchion
--weapon 4 --Lance
--weapon 56 --warhorse hoof OR
--weapon 710 --CBM warhorse hoof
#armor "Full Scale Mail"
#armor "Kite Shield"
#armor "Iron Cap"
#mor 11
#mr 12
#gcost 30 --for non CBM, would need a bit of an increase
#end

--- Sacred/Elite Units



-- Temple Guard
#newmonster 3215
#name "Guard of the Mystic Source"
#descr "The Guard of the Mystic Source is an honorary service post, nominally in defense of the High Temple of Mana, undertaken for a year's time by elite initiates to the various magical academies, prior to entrance in the academies proper.  While perhaps not possessed of the same outstanding physique and extraordinary martial training common to most elite military cadres (although they have yet to gain the stooped gait and sun-forsaken pallor that a life of magical research and study will impose) they do have the benefit of an array of magical accoutrements to help make up some of the difference.  Having served in the temple guard bestows an extra honorific title upon graduation, as well as an inside track to securing key governmental and research posts, as most prominent members of society are former Mystic Guards.  While it was virtually unheard of in the past, they have recently been called upon for actual military service in support of the arising deity."
#spr1 "./MISTICA/templeguard.tga" 
#spr2 "./MISTICA/templeguard_atk.tga"
--copyspr 1992 --Zebulunite (Gath)
#ap 12
#mapmove 2
#hp 10
#prot 0
#size 2
#ressize 2
#str 10
#enc 3
#att 10
#def 10
#prec 10
#mr 14 --they're mage candidates
#mor 12
#gcost 35
#rcost 15 --Note: affected by #ressize
#weapon 201 --Magic Spear
--armor "Lightweight Plate"
#armor "Lightweight Scale Mail"
#armor "Enchanted Shield"
#armor "Crested Helmet"
#eyes 2
#holy
--startage --number. 0 clears, -1 == startage 0, if not specified use default
--maxage 50 --default human
#older -10
#itemslots 15494 --standard slots
#magicskill 50 1 --1 random, hidden
#nametype 114 --Marignon Male
#end

--COMMANDERS

--- Military

--Mounted Cmdr (8 broadsword, 56 hoof (warhorse), 13 chain hauberk, 3 kite shield, 118 Half Helmet)
#newmonster 3216
--copystats 44 --Mounted Commander
#name "Mistican Commander"
#spr1 "./MISTICA/commander.tga" 
#spr2 "./MISTICA/commander_atk.tga"
#descr "While Mistica's armies are frequently led by mages, some are instead led by members of noble families who could not learn magic, or by magicians that have a more traditional military bent and don protective armor and weapons.  In either case, the status accorded them is less than that of those focused purely on magical pursuits."
#custommagic 1920 33 -- 33% FAWE
#researchbonus -3
#size 3
#ap 24
#enc 4
#mounted
#weapon 10 --falchion
--weapon 56 --warhorse hoof
#weapon 710 --CBM warhorse hoof
#armor "Lightweight Scale Mail"
#armor "Kite Shield"
#armor "Crested Helmet"
#mor 12
#mr 14
#goodleader --80
#gcost 60
#nametype 114 --Marignon Male
#end

--- Scouts/Spies/Assassins

-- See Flying Eyeball summon


--- Sacred/Elite military

--- Priests (these are also mages)

--Initiate of Concordance (1S, 1H, 10% S)
#newmonster 3217
#copystats 240 --Priest
#name "Initiate of Concordance"
#spr1 "./MISTICA/concordance.tga" 
#spr2 "./MISTICA/concordance_atk.tga" 
#descr "Initiates of Concordance are magi who have devoted themselves to the promulgation of the concept of magical holiness and supremacy among the populace, rather than pursuing advanced instruction in arcane skills themselves.  They are responsible for the administration of temple facilities, perform day to day religious rites and cermonies for the general populace, provide public education services, and act as civil servants in a variety of minor capacities.  Some decide later to continue with their studies and re-enter the academies as initiates in specific disciplines."
#researchbonus -1
#clearmagic
#holy
#magicskill 4 1
#magicskill 8 1
#custommagic 2048 10
#mr 15
#gcost 90
#nametype 114 --Marignon Male
#end

--Master of Destruction 
#newmonster 3218
#name "Master of Destruction"
#spr1 "./MISTICA/master_destruction.tga" 
#spr2 "./MISTICA/master_destruction_atk.tga"
#descr "Masters of the Grand Academy of Destruction are graduates that have mastered the arts of calling arcane fire, ice, and acid down upon their foes.  In addition to their accomplishments in the study of battlemagic, they are also instructed in military strategy, tactics, and planning; they are frequently called upon to lead military endeavours.  Most graduates carry the magical staff they are required to create as part of their master training at all times."
#weapon 238 --Magic Staff
#ap 10
#mapmove 2
#att 8
#def 8
#enc 3
#mr 16
#startage 50
#researchbonus 1
#holy
#magicskill 4 1
#magicskill 8 1
#custommagic 640 100 --FW
#custommagic 640 100
#custommagic 640 50
#custommagic 2688 100 --SFW
#custommagic 2688 50
#gcost 280
#rcost 5
#nametype 114 --Marignon Male
#okleader --can't do copystats with this
#end

--Master of Essence 
#newmonster 3219
#copystats 98 --Pyromancer
#name "Master of Essence"
#spr1 "./MISTICA/master_essence.tga" 
#spr2 "./MISTICA/master_essence_atk.tga"
#descr "Masters of the Grand Academy of Essence are graduates that have mastered the arcane arts dealing with one's connection to the world and the magical bindings that link all living beings.  They are deeply in tune with their own inner selves, and as a result, can focus their energies on healing themselves and others.  They are frequently called upon to run houses of healing, government administration programs, and to provide enchantments, blessings, and elemental support for major undertakings.  Most graduates carry the magical staff they are required to create as part of their master training at all times."
#weapon 238 --Magic Staff
#mr 16
#startage 50
#maxage 50
#clearmagic
#researchbonus 1
#holy
#magicskill 4 1
#magicskill 8 1
#custommagic 9472 100 --AEN
#custommagic 9472 100
#custommagic 9472 50
#custommagic 11520 100 --AENS
#custommagic 11520 50
#gcost 280
#rcost 5
#nametype 114 --Marignon Male
#healer 15
#heal --recuperation
#end

--Master of the Occult 
#newmonster 3220
#copystats 1872 --Leo (for heretic 1 flag)
#noleader
#end

#selectmonster 3220
#name "Master of the Occult"
#spr1 "./MISTICA/master_occult.tga" 
#spr2 "./MISTICA/master_occult_atk.tga"
#descr "The Grand Academy of the Occult is the smallest and most selective of the Academies, and special approval is required in order to enroll after having trained initially in one of the other academies.  Masters of the Grand Academy of the Occult are a secretive lot, preferring to practice their arts away from public view; some whisper that that until recently they retained ties to the death cult in Ermor.  Nonetheless, they have strong representation in the upper echelons of government.  They are frequently called upon to deal with magical and otherworldly beings, and have great facility in communicating with unusual beings via arcane means.  Many are also employed in the courts system and administration of the slave infrastructure.  Most graduates carry the magical athame they are required to create as part of their master training at all times."
#weapon 101 --Athame
#armor "Nothing"
#stealthy 0 --sneaky bastards, but only "normal" sneaky, not drow rogue with enchanted padded boots sneaky
#firepower 0 --reset Leo
#fireres 0 --reset Leo
#hp 10
#size 2
#str 9
#att 8
#def 8
#prot 0
#ap 10
#mr 16
#startage 50
#maxage 50
#older 20
#clearmagic
#researchbonus 2 --slightly more selective...
#holy
#magicskill 4 1
#magicskill 8 1
#custommagic 20480 100 --DB
#custommagic 20480 100
#custommagic 20480 50
#custommagic 22528 100 --SDB
#custommagic 22528 50
#gcost 300
#rcost 5
#nametype 114 --Marignon Male
#poorleader
#poorundeadleader
#poormagicleader
#end

--- Mages

--Initiate of Destruction (1S, 1FW, 25% SFW)
#newmonster 3221
#copystats 98 --Pyromancer
#name "Initiate of Destruction"
#spr1 "./MISTICA/initiate_destruction.tga" 
#spr2 "./MISTICA/initiate_destruction_atk.tga"
#descr "Initiates of Destruction are magi who are graduates from the Grand Academy of Destruction, but are not yet masters."
#startage 37
#mr 15
#clearmagic
#magicskill 4 1
#custommagic 640 100
#custommagic 2688 25
#nametype 114 --Marignon Male
#gcost 120
#holy
#end

--Initiate of Essence (1S, 1AEN, 25% SAEW)
#newmonster 3222
#copystats 98 --Pyromancer
#name "Initiate of Essence"
#spr1 "./MISTICA/initiate_essence.tga" 
#spr2 "./MISTICA/initiate_essence_atk.tga"
#descr "Initiates of Essence are magi who are graduates from the Grand Academy of Essence, but are not yet masters."
#startage 37
#mr 15
#clearmagic
#magicskill 4 1
#custommagic 9472 100
#custommagic 11520 25
#nametype 114 --Marignon Male
#gcost 120
#holy
#end

#Initiate of the Occult (1S, 1DB, 25% SDB)
#newmonster 3223
#copystats 98 --Pyromancer
#name "Initiate of the Occult"
#spr1 "./MISTICA/initiate_occult.tga" 
#spr2 "./MISTICA/initiate_occult_atk.tga"
#descr "Initiates of the Occult are magi who are graduates from the Grand Academy of the Occult, but are not yet masters."
#startage 37
#mr 15
#clearmagic
#magicskill 4 1
#custommagic 20480 100
#custommagic 22528 25
#nametype 114 --Marignon Male
#gcost 130
#holy
#end


-- SUMMONS


-- Rageling
#newmonster 3214
#name "Rageling"
#descr "A rageling is a being transformed by a strange glowing potion administered via a specially constructed mask- designed both to force open the recipients mouth and to look imposing and frightful. The potion imposes a state similar to, yet horrifically not quite, undeath; the mask is never removed.  A pair of spiked gloves are fitted to the rageling's hands, as they are too undisciplined in their constant state of rage to use weapons of skill. Their body becomes tough and hardened, like leather, and digestion slows until the need for food and drink is minimal. The transformation slowly wastes away and consumes the subject from inside-out over a period of months, so even burial costs may be dispensed with. Entire prison populations and forces of captured enemy soldiers can quickly be converted to shock troops."
#spr1 "./MISTICA/rageling.tga" 
#spr2 "./MISTICA/rageling_atk.tga"
#ap 14
#mapmove 2
#hp 15
#prot 5
#size 2
#ressize 2
#str 14
#enc 1
#att 13
#def 8
#prec 8
#mr 8 --side effect of transformation
#mor 50 --mindless
#gcost 0
#rcost 1
#weapon 620 --Spiked Glove 
#armor "Leather Cuirass"
#armor "Mask"
#eyes 2
#itemslots 15360 --body, feet, 2 misc
#neednoteat
#berserk 4
#noleader
#end

-- Flying Eyeball
#newmonster 3224
#name "Flying Eyeball"
#spr1 "./MISTICA/flying_eye.tga"
#spr2 "./MISTICA/flying_eye_atk.tga"
#descr "Flying Eyeballs are odd little creatures summoned from a remote dimension to attend to scouting and observation duties; their use is said to have nearly eliminated pickpocketing and theft in public markets.  They have limited intelligence, but they understand speech and simple commands, and are able to accurately and telepathically convey images to magi.  Rumours that they are sometimes sighted near public bathing houses near the beginnings of terms in the academies cannot be confirmed."
#ap 20
#mapmove 3
#enc 2
#hp 3
#prot 0
#size 1
#str 3
#att 8
#def 8
#prec 18
#mr 10
#mor 8
#gcost 0
#rcost 1
#weapon 346 --Useless kick
#weapon 621 --Hard Stare (stun + lesser fear)
#eyes 1
#magicbeing
#flying
#darkvision 50
#stealthy 15
#startage -1
#maxage 100
#neednoteat
#patrolbonus 10
#itemslots 4096 -- 1 misc
#nametype 117 --Deep One
#noleader
#end


-- MULTIHEROES

-- Ascended One
--newmonster 3225
#selectmonster 2 --Old standard (need an OOTB unit with ID < 1000 to overwrite for Ritual of Rebirth copy spell target)
#clear
#name "Ascended One"
#spr1 "./MISTICA/ascended.tga"
#spr2 "./MISTICA/ascended_atk.tga"
#descr "Ascended ones are powerful mages that have been touched by god and granted strange gifts that leave them not quite human, including a mystic third eye in the center of their forehead.  They see and know things hidden to others, and have uncanny skill with magic.  Many of them are learned in multiple disciplines, while a few excel at a single path of study."
#ap 12
--mapmove 2
#hp 12
#prot 0
--size 2
--ressize 2
--str 10
#enc 1
--att 10
#def 12
#prec 15
#mr 17
#mor 15
#gcost 0
#rcost 1
--weapon 92 --fist
#weapon 238 --magic staff
#armor "Robes"
#eyes 3 --Mystic third eye...gives extra precision, darkvision, fortunetelling
#holy
#magicbeing
#darkvision 50
#startage 75
#maxage 200
#older 20
#neednoteat --doesn't consume supplies
#researchbonus 5
#forgebonus 10 --percent
#nobadevents 10 --percent bad event negation
#itemslots 31878 --CBM uses this for standard hero slots, +1 misc, standard slots = 15494
#magicskill 8 1 --1H
#magicskill 4 2 --2S
#magicskill 50 2 -- +2 any path except H
#magicskill 50 1 -- +1 any path except H
#magicskill 51 1 -- +1 any elemental path
#custommagic 28672 100 -- +1 any sorcery path except S
#custommagic 30592 15 -- +1 any except S/H
#nametype 114 --Marignon Male
#okleader
#goodmagicleader
#poorundeadleader
#end


-- UNIQUE HEROES

--The Golden One
#newmonster 3226
#name "Golden One"
#descr "The Golden One was originally crafted as public monument honoring a fallen Mistican military hero, and as such depicts said hero in a striking pose astride a valiant warhorse. In order to provide a more lifelike representation, the mage-craftsman responsible decided to animate the figure; this would also serve as a protective measure, allowing the statue to defend itself from any miscreants attempting to remove the gilt plating (as has unfortunately been known to happen.) Unfortunately for the mage an unusual confluence of magical energies at the exact location where the monument was to be placed caused the magics to go awry. The statue indeed became animated, but also became sentient and instead of placidly serving as a public memorial, it wishes to resume the former hero's activities. The military establishment have enthusiastically requested additional incarnations of other past leaders, but attempts to replicate the mishap in a controlled setting have so far been unsuccessful."
#spr1 "./MISTICA/golden.tga"
#spr2 "./MISTICA/golden_atk.tga"
#ap 24
#mapmove 3
#size 3
#hp 25
#prot 20
#str 15
#enc 0
#att 12
#def 12
#prec 10
#mr 15
#mor 30
#gcost 0
#rcost 1
#weapon 10 --Falchion
--weapon 56 --warhorse hoof
#weapon 710 --CBM warhorse hoof
#armor "Full Scale Mail" --not the magical version, as it was only a statue
#armor "Kite Shield"
#armor "Crested Helmet"
#eyes 2
--mounted --not really mounted as it's the whole statue...enc 0 anyway
#holy
#magicbeing
#stonebeing
#pooramphibian
#poisonres 100
#darkvision 100
#startage -1 -- -1 == startage 0
#noheal --requires lab to heal (construct)
#neednoteat --doesn't consume supplies
#standard 15
#itemslots 13446 --all but feet (e.g. mounted) = 13446
#nametype 114 --Marignon Male
#goodleader --80
#okmagicleader --40
#end


-- The former governor
#newmonster 3227
#copystats 680 --Wraith Senator
#name "Patron Spirit"
#copyspr 680 --Wraith Senator
#descr "Originally the Ermorian provincial governor, the Patron was responsible for encouraging the immigration of diverse mages under his governance.  Eventually, after taking steps to ensure that his magical patronage policies would continue, he decided to step down to pursue his own magical ambitions.  He has returned now, perhaps awakened by the events in Ermor, but still in opposition to the annihilation it brings, in order to pledge his services to the arising deity."
#itemslots 31878 --CBM uses this for standard hero slots, +1 misc
#magicskill 4 2 --2S
#magicskill 5 3 --3D
#magicskill 0 1 --1F
#magicskill 1 1 --1A
#okmagicleader
#nametype 106 --No explicit Ermorian?  Use Pythium.  Otherwise, it sometimes chooses undead names
#end

--The Formless One
#newmonster 3228
#name "The Formless One"
#spr1 "./MISTICA/formless.tga"
#spr2 "./MISTICA/formless_atk.tga"
#descr "The Formless One is an ancient being, so old and twisted by dark rituals to sustain it that it has forgotten its own true name and kin, though it has taken many names of convenience over the years.  Its features, though roughly humanoid, are fluid-- a constantly changing palette growing over its body; from minute to minute, it might grow hair, skin, feathers, open sores, or scales where none were before.  It is impossible to gaze upon its horrid countenance without biting back a sense of dread and disgust.  It is said that the Formless One cannot be slain, that its very body will ooze and crawl back together if it is cut apart, and it is also said that the Formless One has horrible appetites and hungers for human flesh.  It has come now to see if the rumors that magical beings of all sorts are venerated here are true, and to pledge its support for the new deity who is at its heart."
#ap 11
#mapmove 2
#hp 20
#prot 5
#size 2
#ressize 2
#str 18
#enc 3
#att 13
#def 13
#prec 10
#mr 18
#mor 18
#gcost 0
#rcost 1
#weapon 29 --claw
#armor "Nothing"
#eyes 2
#female --Don't have a sexless tag...
#magicbeing
#immortal
#pooramphibian
#coldres 25
#fireres 25
#poisonres 100
#shockres 25
#darkvision 25
#supplybonus -25 --Glutton, accounting for supply bonus from Nature magic
#startage 400 --should be slightly old, even with lots of nature magic
#maxage 100
#fear 0
#regeneration 10
#douse 3 -- blood hunt bonus, sanguine rod = +1
#incunrest 3 --number, + or - applied to province unrest
#itemslots 31878 --CBM uses this for standard hero slots, +1 misc
#magicskill 4 2 --2S
#magicskill 6 2 --2N
#magicskill 7 4 --4B
#makemonster1 467 --summon allies -> Foul Beast
#nametype 140 --Demon
#poorleader --10
#poormagicleader --10
#poorundeadleader --10
#end

-------- New Spells

-- Priestly version of "Charm" vs. magic beings, (1H/1S)
#newspell
#copyspell "Control"
#name "Release the Ties That Bind"
#descr "With this spell, a Mistican priest attempts to release the targeted magical being from the unholy bonds of servitude imposed upon it so that it may join the righteous cause of Mistica, where it will be venerated with the respect and admiration it deserves."
#school 7 --holy
#researchlevel 0
#path 0 8 --Holy
#pathlevel 1 1
#path 1 4 --Astral
#pathlevel 0 1 --astral component to keep generic priests from using
#effect 29 -- charm
#fatiguecost 0
#restricted 84
#end

-- Arcane Ascendance (3S, 3H, 15 pearls) : like Ritual of Rebirth, but resulting form is an Ascended One, not a mummy.
#newspell
--copyspell "Ritual of Rebirth"
#name "Arcane Ascendance"
#descr "This spell allows the holiest of heroes to be recalled from beyond the veil and embodied in a new, magically constructed sacred form, ready to serve their god once again."
#school 0 --Conjuration
--researchlevel 7
#researchlevel 0
#path 0 4 --Astral
#pathlevel 0 3
#path 1 8 --Holy
#pathlevel 1 3 --only prophet or rebirthed/ascended ex prophet (or perhaps a captured/wished unit) can do it
#effect 10026
#damage 2 --Multi-hero unit type
#fatiguecost 1500 --15 pearls
#restricted 84
#end

-- Summon Flying Eyeball (1S, 1pearl)
#newspell
#name "Summon Flying Eyeball"
#descr "Summons a flying eyeball from a distant nether region for scouting or observation duties."
#school 0 --Conjuration
#researchlevel 0
#path 0 4 --astral
#pathlevel 0 1
#damage 3224 --flying eyeball
#effect 10021 --summon commander ritual
#fatiguecost 100 --1 gem
#nreff 1 --1 unit summoned
#restricted 84
#end

--Transform Ragelings (1B/1D, 3 bloodslaves) 
#newspell
#name "Rageling Transformation"
#descr "Long ago, a particularly cunning graduate of the Grand Academy of the Occult was saddled with the responsibility for managing the prison system. He came up with an approach that at once boosted military strength, decreased prison costs, and reduced the crime rate. His method involved the creation of a spell and strange glowing potion that could be administered to convicts via a specially constructed mask- designed both to force open the recipients mouth and to look imposing and frightful. The potion imposes a state similar to, yet horrifically not quite, undeath, and destroys the imbibers mind, driving them senseless with pain and rage, yet rendering them extremely suggestive to commands delivered by magi. Their digestion also slows until the need for food and drink is minimal. Ironically the mage was later convicted of embezzlement and subjected to the transformation himself, his name forgotten to the sands of time."
#school 4 --Enchantment
#researchlevel 0
#path 0 7 --blood
#pathlevel 0 1
#path 1 5 --death
#pathlevel 1 1
#damage 3214 --rageling
#effect 10001 --summon unit ritual
#fatiguecost 300 --3 blood slaves
#nreff 6 --6 units
#restricted 84
#end

-------- New / updated sites (TODO: renumber)

--Reusing Temple of the Land (EA Mictlan)
--selectsite 30 
#selectsite 780
#clear
#name "High Temple of Mana"
#path 4
#level 4
#rarity 5
#gems 4 1 -- +1S
#homemon 3215 --temple guard
#end

-- Reusing Temple of the Rain (EA Mictlan)
--selectsite 31 
#selectsite 781
#clear
#name "Grand Academy of Essence"
#path 6
#level 2
#rarity 5
#gems 6 1 -- +1N
#homecom 3219 --Master of Essence
#end

-- Reusing The Dark Crystal (EA Atlantis)
--selectsite 129 
#selectsite 782
#clear
#name "Grand Academy of Destruction"
#path 0
#level 2
#rarity 5
#gems 0 1 -- +1F
#homecom 3218 --Master of Destruction
#end

-- Reusing Temple of the Moon (EA Mictlan)
--selectsite 32 
#selectsite 783
#clear
#name "Grand Academy of the Occult"
#path 5
#level 2
#rarity 5
#gems 5 1 -- +1D
#homecom 3220 --Master of the Occult
#end

-------- New Namepools (none)


-------- New nations 

#selectnation 84
#clearnation
#clearsites
#clearrec
#name "Mistica"
#epithet "Cult of Mana"
#era 3
--brief "A nation of mages who encourage the worship of magic."
#brief "As various magical sects and orders lost favor in Ermor's decline due to the rise of the death cult, and various other mystical groups were forced to emigrate due to waves of advancing barbarians, the remote vassal province of Mistica became a haven for persecuted mages seeking sanctuary (perhaps due to the sponsorship of rulers with arcane interests.) Over time, the various arcane societies banded to form a Mana Cult extolling the virtues of magic in all forms."
#descr "Since the era of Ermor's collapse, the Mistican government has become a magocracy while the populace has embraced the new religion with unexpected fervor; magi and magical beings are venerated by all. Arcane pursuits are organized under three main Schools - Destruction, Essence, and Occult, with a central emphasis on astral magics as central to all.  Mistica's military has evolved from its original imperial structure under the influence of various waves of invading khans and warlords who have been coopted by Mistican ensorcellment. That, along with general lack of interest in things military by Mistican leadership, has led to a somewhat unfocused approach to the organization of the army, and corresponding lack of morale.  This has changed somewhat with the more outward facing approach the nation has taken under the leadership of their new pretender- it has become clear that a divine presence has coalesced from the magical energies- one who now blesses powerful magi with strange gifts."
--With the departure of the Pantokrator, Misticans and their magical masters, whether they will it or not, are caught up in the struggle for divine omnipotence currently underway." 
#summary "Race: Humans

Military: Average, but with morale issues.  Expensive castles.

Magic: Strong Astral, access to all paths.

Priests: Weak, but all are mages.  Expensive temples."
#flag "./MISTICA/flag.tga"
#templepic 17 --Crystal
#templecost 500
#color 0.5 0.0 0.7 --purple


------- Soldiers

#addrecunit 3210 -- Spearman
#addrecunit 3211 -- Bowman
#addrecunit 3212 -- Heavy Infantry (1)
#addrecunit 3208 -- Heavy Infantry (2)
#addrecunit 3213 -- Cavalry

--debug summons
--addrecunit 3214 -- Rageling

------- Leaders

#addreccom 3216 -- Mistican Commander
#addreccom 3217 -- Initiate of Concordance
#addreccom 3221 -- Initiate of Destruction
#addreccom 3222 -- Initiate of Essence
#addreccom 3223 -- Initiate of the Occult

--debug heroes below here
--addreccom 2 --Ascended one
--addreccom 3226 --Golden One
--addreccom 3227 --Patron Spirit
--addreccom 3228 --Formless One

------- Province Defence

--Sets the units to be used in province defense.

#defcom1 3216 -- Mistican Commander
#defcom2 3217 -- Initiate of Concordance
#defunit1 3210 -- Spearmen
#defunit1b 3211 -- Bowmen
#defunit2 3212 -- Heavy Infantry (1)
#defunit2b 3213 -- Cavalry


--Sets how many of the units to appear per point.

#defmult1 15 -- 20 is default multiple, and = 2 units/PD point
#defmult1b 15
#defmult2 12
#defmult2b 8

------- Hero Settings

#hero1 3226 --Golden One
#hero2 3227 --Patron Spirit
#hero3 3228 --Formless One
#multihero1 2 --Ascended One

------- Preferred environment, sites, and forts

#idealcold 0
#startsite "High Temple of Mana"
#startsite "Grand Academy of Destruction"
#startsite "Grand Academy of Essence"
#startsite "Grand Academy of the Occult"
#startfort 43 --Jewelled City
#defaultfort 14 --Dark Citadel
#farmfort 43 --Jewelled City
#mountainfort 37 --Hill Fortress
#forestfort 14 --Dark Citadel
#swampfort 24 --Crystal Citadel

------- Starting units

#startcom 3216
#startunittype1 3212
#startunitnbrs1 10
#startunittype2 3211
#startunitnbrs2 15
#startscout 3224
#end

