-- SHANGRI-LA, Hidden City of the Secret Masters (MA)
-- Version 2.05 (Feb. 16, 2011)

-- Original and Primary Author: Nounours
-- Current Revising Author and Maintainer: Globu
-- Past Revising Author/Contributor: Pyg





------------------------------------------------------------------------------
-- GLOBU'S NOTES
------------------------------------------------------------------------------

-- Given that this mod was of high quality, but still needed some work, and
-- that Nounours has not been around for a while, I have adopted the mod and
-- revised it extensively with the intent of making it a full-fledged,
-- polished and MP-balanced nation.

-- ID numbers have been overhauled for compatibility with CBM v1.81 and other
-- major mods.

-- This release will not invalidate savegames created using the 2.02 release.
-- Anything before that will be invalidated by this version.

-- See the readme for more information.


------------------------------------------------------------------------------
-- NOUNOURS'S ORIGINAL NOTES
------------------------------------------------------------------------------

-- First a few credits :


-- Thanks to HoneyBadger, Sombre, Aezeal and Edratman for their help and their
-- advices.

-- Thanks to Psientist for his PretenderCalculator and to EricM for his work
-- on standard units' sprites.

------------------------------------------------------------------------------

---- [To avoid confusion, I have removed his statement of the ID number
---- resources used, since these have changed completely and the current IDs
---- used are stated with specificity in the readme. --Globu]


------------------------------------------------------------------------------
-- MOD INFO
------------------------------------------------------------------------------

#modname "Shangri-La, Hidden City of the Secret Masters"
#domversion 3.26

#description "An MA nation loosely based on Tibetan myth, legends about the hidden Himalayan city of Shangri-La, conspiracy theories about the Ascended Masters and hidden leaders of the world, and a few science-fiction B-movies. Oh, and yetis, too. You never can have too much yetis..."
#icon "./Shangri_La/Banner.tga"



------------------------------------------------------------------------------
-- WEAPONS
------------------------------------------------------------------------------


#newweapon 693
#name "Phurba" -- ritual dagger with blade made from human bone
#dmg 2
#att 1
#def 0
#len 0
#nratt 1
#sound 7
#magic
#dt_demon
#rcost 4
#end


#newweapon 694
#name "Ice Cudgel"
#dmg 8
#att 0
#def 0
#len 3
#nratt 1
#twohanded
#sound 10
#magic
#secondaryeffect 222
#explspr 10108
#rcost 5
#end


#newweapon 695
#name "Kukri"
#dmg 3
#att 1
#def 0
#len 0
#nratt 1
#rcost 2
#sound 7
#end


#newweapon 696
#name "Great Kukri" -- Except for supposed Iberian origin, Falcata would be a better term
-- Toned down to be equivalent to Falchion
#dmg 7
#att 0
#def 0
#len 2
#nratt 1
#sound 7
#rcost 5
#end


-newweapon 697 -- Great Magic Kukri of the demon-kings and their kind
-- unused, so commented out in v2.0
-name "Dmu Great Kukri"
-dmg 9
-att 3
-def 0
-len 3
-nratt 1
-sound 8
-armorpiercing
-magic
-rcost 12
-end


-newweapon 698 -- Hook-curved knife
 -- unused, so commented out in v2.0
-name "Hasiya"
-dmg 4
-att 2
-def 0
-len 3
-nratt 1
-sound 8
-flail
-rcost 3
-end


------------------------------------------------------------------------------
-- ARMOR
------------------------------------------------------------------------------

#newarmor 310
#name "Crude Breastplate"
#type 5
#prot 8
#def 0
#enc 1
#rcost 7
#end


#newarmor 311 -- Rta Pa armor renamed to Lamellar Armor in v2.0
#name "Lamellar Armor"
#type 5
#prot 19
#def -3
#enc 3
#rcost 21
#end

#newarmor 312 -- http://www.metmuseum.org/toah/works-of-art/2001.55
#name "Cane Shield"
#type 4
#prot 12
#def 4
#enc 1
#rcost 1
#end


------------------------------------------------------------------------------
-- UNITS
------------------------------------------------------------------------------

-- Bhdpa Spearman
#newmonster 3702
#name "Bhdpa Spearman"
#spr1 "./Shangri_La/Bhodpa_spearman_1.tga"
#spr2 "./Shangri_La/Bhodpa_spearman_2.tga"

#descr "Drawn from the Bhdpa tribesmen of the mountain kingdom of Bhd, Bhdpa mountaineers serve as light infantry for their masters. Some use spears or swords with javelins, while others favor shortbows and wield the traditional kukri knife. They are adept hunters and scouts, able to move stealthily through enemy lands. Bhdpa have adapted to the harsh climate of their mountain realm and are resistant to cold."

#ap 12
#mapmove 2
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 10
#prec 9
#mr 10
#mor 10
#gcost 10
#rcost 1
#nametype 161
#itemslots 15494
#weapon 1 -- Spear
#weapon 21 -- Javelin
#armor "Leather hauberk"
#armor "Cane Shield"
#armor "Reinforced leather cap"
#mountainsurvival
#coldres 75
#stealthy 0
#end



-- Bhdpa Archer
#newmonster 3703
#name "Bhdpa Archer"
#spr1 "./Shangri_La/Bhodpa_archer_1.tga"
#spr2 "./Shangri_La/Bhodpa_archer_2.tga"

#descr "Drawn from the Bhdpa tribesmen of the mountain kingdom of Bhd, Bhdpa mountaineers serve as light infantry for their masters. Some use spears or swords with javelins, while others favor shortbows and wield the traditional kukri knife. They are adept hunters and scouts, able to move stealthily through enemy lands. Bhdpa have adapted to the harsh climate of their mountain realm and are resistant to cold."

#ap 12
#mapmove 2
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 9
#prec 10
#mr 10
#mor 10
#gcost 10
#rcost 1
#nametype 161
#itemslots 15494
#weapon "kukri" -- Changed from stock dagger to Kukri, as per unit description, in v2.0
#weapon 23 -- Short bow
#armor "Leather hauberk"
#armor "Reinforced leather cap"
#mountainsurvival
#coldres 75
#stealthy 0
#end



-- Bhdpa Warrior
#newmonster 3704
#name "Bhdpa Warrior"
#spr1 "./Shangri_La/Bhodpa_Warrior_1.tga"
#spr2 "./Shangri_La/Bhodpa_Warrior_2.tga"

#descr "Drawn from the Bhdpa tribesmen of the mountain kingdom of Bhd, Bhdpa mountaineers serve as light infantry for their masters. Some use spears or swords with javelins, while others favor shortbows and wield the traditional kukri knife. They are adept hunters and scouts, able to move stealthily through enemy lands. Bhdpa have adapted to the harsh climate of their mountain realm and are resistant to cold."

#ap 12
#mapmove 2
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 10
#prec 9
#mr 10
#mor 10
#gcost 10
#rcost 1
#nametype 161
#itemslots 15494
#weapon 8
#weapon 21
#armor "Leather hauberk"
#armor "Cane Shield"
#armor "Reinforced leather cap"
#mountainsurvival
#coldres 75
#stealthy 0
#end



-- Bhdpa yak rider
#newmonster 3705
#name "Bhdpa Yak Rider"
#spr1 "./Shangri_La/GL_Yak_Rider_1.tga"
#spr2 "./Shangri_La/GL_Yak_Rider_2.tga"

#descr "Sturdy and strong, yaks are well-suited to the harsh climate of the Hidden Valley, and see use by the Bhdpa use yaks as pack and traction animals. Some Bhdpa tribesmen train these hardy animals for use as mounts, and ride them into battle with lances and shortbows. A yak can kill a lightly-armored man with its gore attack."

#ap 18
#mapmove 3
#hp 12
#prot 0
#size 3
#str 10
#enc 3
#att 11
#def 10
#prec 9
#mr 10
#mor 10
#gcost 27
#rcost 5
#ressize 2
#nametype 161
#itemslots 13446
#weapon 357
#weapon 352
#weapon 23
#armor "Leather hauberk"
#armor "Buckler"
#armor "Reinforced leather cap"
#mountainsurvival
#coldres 75
#mounted
#supplybonus 2
#secondtmpshape 3735
#end


-- Bhdpa Horseman
#newmonster 3706
#name "Bhdpa Horseman"
#spr1 "./Shangri_La/GL_Bhodpa_horseman_1.tga"
#spr2 "./Shangri_La/GL_Bhodpa_horseman_2.tga"
-spr1 "./Shangri_La/Bhodpa_horseman_1.tga" -- Replaced with sprite that looks Bhodpa
-spr2 "./Shangri_La/Bhodpa_horseman_2.tga"

#descr "Though horses are not as well-adapted to the cold, mountainous terrain of Bhd as are yaks, some Bhdpa tribesmen nevertheless use them as mounts. Bhdpa Horsemen are armed with lance and shortbow and wear light armor."

#ap 25
#mapmove 3
#hp 12
#prot 0
#size 3
#str 10
#enc 3
#att 11
#def 10
#prec 10
#mr 10
#mor 11
#gcost 24
#rcost 5
#ressize 2
#nametype 161
#itemslots 13446
#weapon 357
#weapon 56
#weapon 23
#armor "Leather hauberk"
#armor "Buckler"
#armor "Reinforced leather cap"
#coldres 75
#mounted
#end



-- Shangrilan archer -- Renamed from Mda Pa to Shangrilan Bowman in v2.0 for uniformity of naming scheme
#newmonster 3707
#name "Shangrilan Bowman"
#spr1 "./Shangri_La/Shangrilan_archer_1.tga"
#spr2 "./Shangri_La/Shangrilan_archer_2.tga"

#descr "The Shangrilans are descended from the servants of the great mages who exiled themselves in the high mountains of Bhd and founded the hidden city of Shangri-La. Some of them now serve in the armies of their masters. Shangrilan soldiers uses sophisticated weapons and are much more disciplined than the warriors of the Bhdpa clans. Mda Pa are Shangrilan archers who use composite bows and don leather armor."

#ap 12
#mapmove 2
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 9
#prec 10
#mr 11
#mor 12
#gcost 13
#rcost 1
#nametype 161
#itemslots 15494
#weapon 6
#weapon 264
#armor "Full Leather Armor"
#armor "Half Helmet"
#startage 22
#mountainsurvival
#coldres 50
#end



-- Shangrilan Crossbowman
#newmonster 3708
#name "Shangrilan Crossbowman"
#spr1 "./Shangri_La/Shangrilan_crossbowman_1.tga"
#spr2 "./Shangri_La/Shangrilan_crossbowman_2.tga"

#descr "The Shangrilans are descended from the servants of the great mages who exiled themselves in the high mountains of Bhd and founded the hidden city of Shangri-La. Some of them now serve in the armies of their masters. Shangrilan soldiers uses sophisticated weapons and are much more disciplined than the warriors of the Bhdpa clans. Shangrilan crossbowmen don heavy scale and leather armor."


#ap 12
#mapmove 1
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 9
#prec 12
#mr 11
#mor 12
#gcost 13
#rcost 1
#nametype 123
#itemslots 15494
#weapon 6
#weapon 25
#armor "Scale Mail Hauberk"
--armor "Full Leather Armor"
#armor "Shield"
#armor "Half Helmet"
#startage 22
#mountainsurvival
#coldres 50
#end



-- Shangrilan Heavy Infantry (Polearm)
#newmonster 3709
#name "Shangrilan Heavy Infantry"
#spr1 "./Shangri_La/Shangrilan_Heavy_Infantry_1.tga"
#spr2 "./Shangri_La/Shangrilan_Heavy_Infantry_2.tga"

#descr "The Shangrilans are descended from the servants of the great mages who exiled themselves in the high mountains of Bhd and founded the hidden city of Shangri-La. Some of them now serve in the armies of their masters. Shangrilan soldiers uses sophisticated weapons and are much more disciplined than the warriors of the Bhdpa clans. Shangrilan heavy infantry are armed with polearms or with swords and great shields, and wear heavy suits of scale armor adorned with brass studs."

#ap 12
#mapmove 1
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 11
#def 10
#prec 9
#mr 11
#mor 12
#gcost 13
#rcost 1
#nametype 161
#itemslots 15494
#weapon 308 -- Glaive
#armor "Full Scale Mail"
#armor "Half Helmet"
#startage 22
#mountainsurvival
#coldres 50
#end



-- Shangrilan Heavy Infantry (Sword and Shield)
#newmonster 3710
#name "Shangrilan Heavy Infantry"
#spr1 "./Shangri_La/Shangrilan_Heavy_Infantry2_1.tga"
#spr2 "./Shangri_La/Shangrilan_Heavy_Infantry2_2.tga"

#descr "The Shangrilans are descended from the servants of the great mages who exiled themselves in the high mountains of Bhd and founded the hidden city of Shangri-La. Some of them now serve in the armies of their masters. Shangrilan soldiers uses sophisticated weapons and are much more disciplined than the warriors of the Bhdpa clans. Shangrilan heavy infantry are armed with polearms or with swords and great shields, and wear heavy suits of scale armor adorned with brass studs."

#ap 12
#mapmove 1
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 11
#def 10
#prec 9
#mr 11
#mor 12
#gcost 13
#rcost 1
#nametype 161
#itemslots 15494
#weapon 8
#armor "Full Scale Mail"
#armor "Half Helmet"
#armor "Tower Shield"
#startage 22
#mountainsurvival
#coldres 50
#end


Bhdpa Spearman
Bhdpa Archer
Bhdpa Warrior
Bhdpa Yak Rider
Yak
Bhdpa Horseman

Shangrilan Bowman
Shangrilan Crossbowman
Shangrilan Heavy Infantry (Glaive)
Shangrilan Heavy Infantry (Sword/Shield)


-- Shangrilan Banner-Bearer / Standard-Bearer -- renamed from Dmag Dar to Shangrilan Dmag Dar in v2.0
#newmonster 3711
#name "Shangrilan Dmag Dar"
#spr1 "./Shangri_La/Dmag_Dar_1.tga"
#spr2 "./Shangri_La/Dmag_Dar_2.tga"

#descr "In the Shangrilan army, soldiers who show bravery and high morale on the battlefield are sometimes appointed as Dmag Dar, or banner-bearers. In battle, they carry a banner which helps Shangrilan officers coordinate their troops, and which inspire the troops to take fresh heart during battles."

#ap 12
#mapmove 1
#hp 12
#prot 0
#size 2
#str 10
#enc 3
#att 11
#def 10
#prec 10
#mr 11
#mor 14
#gcost 20
#rcost 1
#nametype 161
#itemslots 15494
#weapon 8
#armor "Scale Mail Hauberk"
#armor "Half Helmet"
#startage 22
#mountainsurvival
#coldres 50
#standard 5
#end



-- Shangrilan Elite Infantry
#newmonster 3712
#name "Shangrilan Dmag Hrag" -- renamed from Dmag Hrag to Shangrilan Dmag Hrag in v2.0
#spr1 "./Shangri_La/Dmag_Hrag_1.tga"
#spr2 "./Shangri_La/Dmag_Hrag_2.tga"

#descr "Dmag Hrag are veteran soldiers of the Shangrilan army. These seasoned soldiers don heavy chain mail armor and fight with swords and shields. Their morale is excellent, and they are very skilled fighters. Trained to endure great adversity and grueling forced marches, they can move more swiftly than many other heavy infantry troops."

#ap 12
#mapmove 2
#hp 14
#prot 0
#size 2
#str 11
#enc 3
#att 13
#def 13
#prec 9
#mr 11
#mor 14
#gcost 20
#rcost 1
#nametype 161
#itemslots 15494
#weapon 10
#armor "Full Chain Mail"
#armor "Half Helmet"
#armor "Shield"
#startage 22
#mountainsurvival
#coldres 50
#end



-- Shangrilan Heavy Horseman
#newmonster 3713
#name "Shangrilan Rta Pa"
#spr1 "./Shangri_La/Rta_Pa_1.tga"
#spr2 "./Shangri_La/Rta_Pa_2.tga"

#descr "Rta Pa are Shangrilan heavy cavalry, armed with lance and composite bow. They wear a complex, heavy lamellar armor made of leather and steel scales and reinforced with chain mail. Like their riders, the horses of the Rta Pa are clad in heavy armor."

#ap 23
#mapmove 2
#hp 11
#prot 0
#size 3
#str 11
#enc 4
#att 12 -- Increased from 11 to 12 in v2.0
#def 12
#prec 10
#mr 11
#mor 12
#gcost 40
#rcost 10
#ressize 2
#nametype 161
#itemslots 13446
#weapon 4
#weapon 8
#weapon 264
#weapon 56
#armor "Lamellar Armor"
#armor "Shield"
#armor "Half Helmet"
#coldres 50
#mounted
#end



-- Shangrilan Guardian of the Hidden Valley
#newmonster 3714
#name "Guardian of the Hidden Valley"
#spr1 "./Shangri_La/Guardian_of_the_Hidden_Valley_1.tga"
#spr2 "./Shangri_La/Guardian_of_the_Hidden_Valley_2.tga"

#descr "The most loyal among of the servants of the exiled masters of Shangri-La following were charged with keeping the Hidden Valley safe and concealed from outsiders, as well as rooting out resistance among the population. The direct descendants of these first guards have since inherited this task. Rigorously instilled with an extreme devotion to duty, these seasoned warriors specially trained to defend fortresses and perform police duties, and are adept at spotting spies or sneaking enemies. Called Gsang Rong Skyob Pa, or Guardians of the Hidden Valley, they enjoy a special sacred status in Shangrilan society and answer only to the highest authorities."

#ap 12
#mapmove 1
#hp 15
#prot 0
#size 2
#str 11
#enc 2
#att 13
#def 14
#prec 10
#mr 12
#mor 15
#gcost 60
#rcost 2
#nametype 161
#itemslots 15494
#weapon 10 -- Falchion
#armor "Full Scale Mail"
#armor "Half Helmet"
#armor "Shield"
#startage 22
#mountainsurvival
#coldres 50
#castledef 1
#patrolbonus 1
#holy
#end



-- Mi G (Basic Ape-Man)
#newmonster 3715
#name "Mi G"
#spr1 "./Shangri_La/Mi_Go_1.tga"
#spr2 "./Shangri_La/Mi_Go_2.tga"

#descr "When the Hidden Masters settled in Shangri-La, they discovered in the icy caverns there the ruins of an advanced, forgotten race they simply call the Ancient Ones. Living in these ruins were the descendents of the Ancient Ones, a peaceful ape-like race called the Mi G, or wild men, by the local Bhdpa tribesmen. Deeply respected by the Bhdpa and Shangrilans, the Mi G now live among them in the Hidden Valley.

Some scholars believe that the Ancient Ones are related to the Bandar ape-men of Kailasa, but many think this unlikely, because, unlike the Bandar, Mi G have a much longer lifespan, tend to prefer cold climates, and have been civilized from time immemorial. Though the Mi G are a calm and peaceful people, their great strength makes them dangerous foes, and some fight in the armies of Shangri-La."

#ap 14
#mapmove 2
#hp 20
#prot 5
#size 3
#str 16
#enc 3
#att 11
#def 10
#prec 9
#mr 11
#mor 13
#gcost 25
#rcost 2
#nametype 161
#itemslots 15494
#weapon 265 -- Spiked Club
#maxage 100
#mountainsurvival
#coldres 100
#coldpower 1
#end



-- Mi G Hunter
#newmonster 3716
#name "Mi G Rngon Pa"
#spr1 "./Shangri_La/Mi_Go_Hunter_1.tga"
#spr2 "./Shangri_La/Mi_Go_Hunter_2.tga"

#descr "When the Hidden Masters settled in Shangri-La, they discovered in the icy caverns there the ruins of an advanced, forgotten race they simply call the Ancient Ones. Living in these ruins were the descendents of the Ancient Ones, a peaceful ape-like race called the Mi G, or wild men, by the local Bhdpa tribesmen. Deeply respected by the Bhdpa and Shangrilans, the Mi G now live among them in the Hidden Valley.

Some scholars believe that the Ancient Ones are related to the Bandar ape-men of Kailasa, but many think this unlikely, because, unlike the Bandar, Mi G have a much longer lifespan, tend to prefer cold climates, and have been civilized from time immemorial. Though the Mi G are a calm and peaceful people, their great strength makes them dangerous foes, and some fight in the armies of Shangri-La.

Rngon Pa are Mi G hunters, able to pass unseen through enemy territories. They often venture into the wooded lowlands."

#ap 14
#mapmove 2
#hp 20
#prot 5
#size 3
#str 16
#enc 3
#att 11
#def 10
#prec 11
#mr 11
#mor 13
#gcost 30
#rcost 2
#nametype 161
#itemslots 15494
#weapon 1 -- Spear
#weapon 21 -- Javelin
#maxage 100
#mountainsurvival
#forestsurvival
#coldres 100
#coldpower 1
#stealthy 5
#end



-- Mi Dred
#newmonster 3717
#name "Mi Dred"
#spr1 "./Shangri_La/Mi_Dred_1.tga"
#spr2 "./Shangri_La/Mi_Dred_2.tga"

#descr "Among the peaceful Mi G, warfare is seen as a task that burdens the soul with anger, fear and regret, and which consequently prevents enlightenment and spiritual elevation. The Mi Dred, which means 'Terribles Ones' or 'Ferocious People', are sacred warriors instructed in the art of making war without tainting the purity of their souls. In combat, they wield magical cudgels made of enchanted ice that resemble huge icicles. Those struck by these cudgels are frozen by the cold of the high mountains. It is said that these weapons were once far more common, but now only the Mi Dred are entrusted with carrying them."

#ap 14
#mapmove 2
#hp 25
#prot 5
#size 3
#str 17
#enc 3
#att 12
#def 11
#prec 10
#mr 12
#mor 15
#gcost 70
#rcost 2
#nametype 161
#itemslots 15494
#weapon "ice cudgel"
#weapon 21  -- Javelin
#armor "Scale Mail Cuirass"
#armor "Bronze Cap"
#maxage 100
#mountainsurvival
#coldres 100
#coldpower 1
#holy
#end


------------------------------------------------------------------------------
-- COMMANDERS
------------------------------------------------------------------------------


-- Bhdpa Scout
#newmonster 3718
#name "Bhdpa Scout"
#spr1 "./Shangri_La/Bhodpa_scout_1.tga"
#spr2 "./Shangri_La/Bhodpa_scout_2.tga"

#descr "Drawn from the Bhdpa tribesmen of the mountain kingdom of Bhd, Bhdpa mountaineers serve as light infantry for their masters. Some use spears or swords with javelins, while others favor shortbows and wield the traditional kukri knife. Many of them are adept hunters, able to move stealthily through enemy lands. Bhdpa have adapted to the harsh climate of their mountain realm and are resistant to cold.

Bhdpa scouts are able to travel far and fast without being noticed, and they are sent to gather informations about distant territories."

#ap 12
#mapmove 2
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 9
#prec 10
#mr 10
#mor 10
#gcost 10
#rcost 1
#nametype 161
#itemslots 15494
#weapon 1
#weapon 21
#armor "Furs"
#armor "Cane Shield"
#armor "Reinforced leather cap"
#mountainsurvival
#coldres 75
#noleader
#stealthy 10
#end



-- Bhdpa Clan Chief
#newmonster 3719
#name "Bhdpa Sde Pa"
#spr1 "./Shangri_La/Bhodpa_Sde_Pa_1.tga"
#spr2 "./Shangri_La/Bhodpa_Sde_Pa_2.tga"

#descr "When the Shangrilan masters exiled themselves to the mountains, they found and conquered the Bhdpa tribesmen from the isolated kingdom of Bhd, slaying the shaman kings of old. Though they have converted the Bhdpa, by force or persuasion, and have stripped the Bhdpa rulers of all religious influence, the Bhdpa still practice the Bn ancestor worship cult of their forefathers. Indeed, the Bhdpa clans still live in their traditional ways, and are divided between semi-nomadic pastoral tribesman and sedentary agricultural peasants.

The Sde Pa is the chief of a clan or territory, ruling over his tribe in war and peace. Sde Pa often serve their masters by leading their tribes in battle."

#ap 12
#mapmove 2
#hp 12
#prot 0
#size 2
#str 11
#enc 3
#att 11
#def 11
#prec 10
#mr 10
#mor 10
#gcost 40
#rcost 1
#nametype 161
#itemslots 15494
#weapon 8
#weapon 21
#armor "Scale Mail Cuirass"
#armor "Shield"
#armor "Reinforced leather cap"
#startage 25
#mountainsurvival
#coldres 75
#stealthy 0
#end



-- Shangrilan Officer
#newmonster 3720
#name "Shangrilan Dmag Dpon"
#spr1 "./Shangri_La/Dmag_Dpon_1.tga"
#spr2 "./Shangri_La/Dmag_Dpon_2.tga"

#descr "A Dmag Dpon is a Shangrilan officer who leads the armies of the Hidden Masters. The position of Dmag Dpon is gained through competence and loyalty, not by birthright, contrary to the practice of many other nations. For this reason, Dmag Dpon are very apt leaders and tend to be popular among their troops."

#ap 12
#mapmove 2
#hp 14
#prot 0
#size 2
#str 11
#enc 2
#att 11
#def 13
#prec 10
#mr 11
#mor 12
#gcost 60
#rcost 1
#nametype 161
#itemslots 15494
#weapon 8
#armor "Full Scale Mail"
#armor "Half Helmet"
#armor "Shield"
#startage 27
#mountainsurvival
#coldres 50
#standard 5
#end


-- Shangrilan Cavalry Commander
#newmonster 3721
#name "Shangrilan Rta Dmag Go"
#spr1 "./Shangri_La/Rta_Dmag_Go_1.tga"
#spr2 "./Shangri_La/Rta_Dmag_Go_2.tga"

#descr "Rta Dmag Go are Shangrilan mounted commanders armed with lance and falchion. They wear the same lamellar armor as that worn by the Rta Pa, and their horses are likewise clad in heavy armor."

#ap 23
#mapmove 2
#hp 13
#prot 0
#size 3
#str 12
#enc 4
#att 12
#def 13
#prec 10
#mr 11
#mor 13
#gcost 80
#rcost 10
#ressize 2
#nametype 161
#itemslots 13446
#weapon 4
#weapon 10
#weapon 56
#armor "Lamellar Armor"
#armor "Shield"
#armor "Half Helmet"
#coldres 50
#goodleader
#standard 5
#mounted
#end



-- Shangrilan King
#newmonster 3722
#name "Rje"
#spr1 "./Shangri_La/Rje_1.tga"
#spr2 "./Shangri_La/Rje_2.tga"

--GLOBU CHANGE: Gave Rje a level of Holy magic to justify that hefty 140 gcost.

#descr "A Rje is a Shangrilan king invested with great authority over the people of the Hidden Valley, exercising temporal power in the name of the Hidden Masters. His authority is substantial, but, in practice, it is rather limited and extends only to mundane matters; indeed, in matters of interest to the clergy, Rje defer to the Gelug, the spokesmen for the Hidden Masters. Often given command of large forces, Rje are invested with sacred status by the Hidden Masters, and are revered by their troops, their mere presence inspiring soldiers to great deeds of bravery."

#ap 12
#mapmove 2
#hp 16
#prot 0
#size 2
#str 13
#enc 2
#att 13
#def 16
#prec 11
#mr 12
#mor 15
#gcost 140
#rcost 1
#nametype 161
#itemslots 15494
#weapon 10
#armor "Full Scale Mail"
#armor "Half Helmet"
#armor "Shield"
#startage 30
#magicskill 8 1
#goodleader
#mountainsurvival
#coldres 50
#standard 15
#holy
#end





-- Shangrilan Monk
#newmonster 3723
#name "Drapa"
#spr1 "./Shangri_La/Drapa_1.tga"
#spr2 "./Shangri_La/Drapa_2.tga"

#descr "Drapas are Shangrilan monks clothed in saffron robes. In the monasteries of the valley of Shangri-La, they study the religious teachings of spiritual masters in old and sacred texts. Drapas usually spend most of their time praying, meditating and chanting mantras, but they are sometimes sent to foreign lands to serve as spies and preach their faith."

#ap 12
#mapmove 2
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 11
#def 10
#prec 10
#mr 13
#mor 11
#gcost 100
#rcost 1
#nametype 161
#itemslots 15494
#weapon 92 -- Fist
#armor "Robes"
#startage 33
#mountainsurvival
#coldres 50
#magicskill 8 1
#magicskill 4 1
#custommagic 3328 10
#poorleader
#stealthy
#spy
#holy
#end


-- Ngagspa Sorcerer
#newmonster 3724
#name "Ngagspa"
#spr1 "./Shangri_La/Ngagspa_1.tga"
#spr2 "./Shangri_La/Ngagspa_2.tga"

#descr "With the coming of the new religion, Bhdpa people have turned away from the traditional Bn religion. Bn Pos and Dmu Bns have lost their spiritual and religious influence, and have become Ngagspa, reclusive sorcerers who live in the mountains and practice dark magics. Many of them bind demons or malevolent spirits of the mountains to harm those who offend them, and dabble in the devious ways of necromancy. They are very secretive, and do not share their secrets easily, a fact which makes them ill-suited at magical research."

#ap 12
#mapmove 2
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 10
#prec 10
#mr 13
#mor 11
#gcost 180
#rcost 1
#nametype 161
#itemslots 15494
#weapon "kukri"
#armor "Robes"
#magicskill 3 1
#magicskill 5 1
#magicskill 7 1
#custommagic 21760 100
#researchbonus -3
#poorleader
#mountainsurvival
#coldres 50
#end



-- Ragyapa Priests
#newmonster 3725
#name "Ragyapa"
#spr1 "./Shangri_La/Ragyapa_1.tga"
#spr2 "./Shangri_La/Ragyapa_2.tga"

#descr "Bhdpa believe that after death, an evil spirit may possess the corpse of the deceased. Shangrilans, on the other hand, believe in reincarnation and regard corpses as empty vessels, and thus find no need to preserve the body. In the mountains of Shangri-La where the rocky ground and scarcity of timber make burial difficult, the dead are disposed of by cutting them into small pieces and leaving them exposed to birds and the elements, a practice called bya gtor, or sky burial. Ragyapa are priests that perform the duties of disposing of corpses and dismembering them. Their duties give them some insight into death magic, and they often have some knowledge about air magic as well."

#ap 12
#mapmove 2
#hp 11
#prot 0
#size 2
#str 10
#enc 3
#att 11
#def 10
#prec 10
#mr 12
#mor 13
#gcost 160
#rcost 1
#nametype 161
#itemslots 15494
#weapon "kukri"
#armor "Robes"
#holy
#magicskill 5 1
#magicskill 8 1
#custommagic 4352 50

#poorleader
#mountainsurvival
#coldres 50
#end


-- Demon Hunter
#newmonster 3726
#name "Demon Hunter"
#spr1 "./Shangri_La/Demon_Hunter_1.tga"
#spr2 "./Shangri_La/Demon_Hunter_2.tga"

#descr "Demon Hunters are mage-priests charged with hunting down the last Dmu demons and Dmu Bns, occasionally performing exorcisms. They wield phurba, magical daggers that destroy demons and evil spirits. Skilled primarily in fire and astral magic, they dabble in a variety of other magics. Some study air magic, and others learn a few tricks of the sorcerers they hunt, thus acquiring a practical knowledge of dark magics."

#ap 12
#mapmove 2
#hp 11
#prot 0
#size 2
#str 10
#enc 3
#att 11
#def 11
#prec 10
#mr 12
#mor 15
#gcost 170
#rcost 1
#nametype 161
#itemslots 15494
#weapon "phurba"
#armor "Robes"
#holy
#magicskill 0 1
#magicskill 4 1
#magicskill 8 1
#custommagic 6528 20
#poorleader
#mountainsurvival
#coldres 50
#end






-- Wise One (Ape-Man Mage)
#newmonster 3727
#name "Wise One"
#spr1 "./Shangri_La/Mi_Go_Wise_One_1.tga"
#spr2 "./Shangri_La/Mi_Go_Wise_One_2.tga"

#descr "The Wise Ones are Mi G who study the ways of their ancestors. Mi G are descended from a ancient and very advanced race, whose civilization was nearly destroyed by a great cataclysm many centuries ago. Though they have lost much of their knowledge, the Wise Ones are skilled mages and have some mastery over nature and the elements of earth and water. Their study of magic, natural laws, and medicine makes them able healers, and they are also skillful ice crafters. It is they who make the cudgels wielded by the Mi Dreds."

#ap 13
#mapmove 2
#hp 20
#prot 0
#size 3
#str 15
#enc 3
#att 11
#def 10
#prec 10
#mr 13
#mor 12
#gcost 240
#rcost 2
#nametype 161
#itemslots 15494
#weapon 124
#magicskill 2 1
#magicskill 3 1
#magicskill 6 1
#custommagic 9728 50
#poorleader
#maxage 100
#mountainsurvival
#coldres 100
#healer 30
#coldpower 1
#end



-- Red-Hat Lama
#newmonster 3728
#name "Nyingmapa"
#spr1 "./Shangri_La/Lama_Nyingmapa_1.tga"
#spr2 "./Shangri_La/Lama_Nyingmapa_2.tga"

#descr "Lamas are the mage-priests who form the majority of Shangri-La's clergy and who administer the city. The Lamas are divided into three different sects, each sect following a different sphere of practice within the religion. The Nyingmapa, or Red-Hat Sect, are the most traditionalist, and are the most learned in magics and occult lore. They are poorly-versed in politics and do not wield much temporal power, but these mystics know many ancient secrets and long lost lore. The Lamas of the Red-Hat Sect have a long tradition of secrecy, and therefore are able to move and act without being noticed if necessary. Lamas practice lung-gom-pa, a kind of psychic training that allows them to run at an extraordinary speed across vast distances for days without stopping."

#ap 14
#mapmove 3
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 11
#prec 10
#mr 13
#mor 16
#gcost 290
#rcost 1
#nametype 161
#itemslots 15494
#weapon "phurba"
#armor "Robes"
#magicskill 1 1
#magicskill 3 2
#magicskill 4 2
#magicskill 8 2
#custommagic 3456 100
#custommagic 3456 10
#poorleader
#mountainsurvival
#coldres 50
#stealthy 0
#holy
#end




-- Yellow-Hat Lama
#newmonster 3729
#name "Gelug"
#spr1 "./Shangri_La/Lama_Gelug_1.tga"
#spr2 "./Shangri_La/Lama_Gelug_2.tga"

#descr "Lamas are the mage-priests who form the majority of Shangri-La's clergy and who administer the city. The Lamas are divided into three different sects, each sect following a different sphere of practice within the religion. The Gelug, or Yellow-Hat Sect, follow a strict monastic tradition that emphasizes self-discipline and progression through sequential stages of initiation. Gelugs are not as skilled in magic as the other sects, but they are the true administrators of Shangri-La, and wield much more influence than others Lamas, making the important day-to-day decisions in matters beneath the attention of the Hidden Masters. Lamas practice lung-gom-pa, a kind of psychic training that allows them to run at an extraordinary speed across vast distances for days without stopping."

#ap 14
#mapmove 3
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 11
#prec 10
#mr 13
#mor 16
#gcost 220
#rcost 1
#nametype 161
#itemslots 15494
#weapon "phurba"
#armor "Robes"
#magicskill 1 1
#magicskill 3 1
#magicskill 4 1
#magicskill 8 2
#custommagic 3328 100
#custommagic 3328 10
#okleader
#mountainsurvival
#coldres 50
#holy
#end



-- Black-Hat Lama
#newmonster 3730
#name "Karmapa"
#spr1 "./Shangri_La/Lama_Karmapa_1.tga"
#spr2 "./Shangri_La/Lama_Karmapa_2.tga"

#descr "Lamas are the mage-priests who form the majority of Shangri-La's clergy and who administer the city. The Lamas are divided into three different sects, each sect following a different sphere of practice within the religion. The Karmapa, or Black-Hat Sect, follow a very old shamanistic tradition in which they seek enlightenment through ordeals and trance. Karmapa have learned to foretell the future by interpreting oracles. They also study death magic in order to commune with ancestors. Lamas practice lung-gom-pa, a kind of psychic training that allows them to run at an extraordinary speed across vast distances for days without stopping."

#ap 14
#mapmove 3
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 11
#prec 10
#mr 16
#mor 12
#gcost 280
#rcost 1
#nametype 161
#itemslots 15494
#weapon "phurba"
#armor "Robes"
#magicskill 1 1
#magicskill 4 2
#magicskill 5 1
#magicskill 8 2
#custommagic 7424 100
#custommagic 7424 20
#poorleader
#mountainsurvival
#coldres 50
#nobadevents 10
#holy
#end




-- Hidden Master
#newmonster 3731
#name "Hidden Master"
#spr1 "./Shangri_La/Hidden_Master_1.tga"
#spr2 "./Shangri_La/Hidden_Master_2.tga"

#descr "Hidden Masters are mage-priests of great power and ability, and the secret rulers of Shangri-La. Forced into exile many centuries ago, they founded their secret city in a secluded valley in the mountain kingdom of Bhd. Here, they use their power to attain enlightenment and spiritual ascension. They are the religious and temporal supreme leaders of the nation, and represent the pinnacle of spiritual enlightenment in Shangrilan religion. As a result of their high state of enlightenment, they have mastered their own metabolisms and have begun to transcend human needs, gaining incredibly long lifespans and needing to eat only once a month. Masters of lung-gom-pa and levitation, they are able to fly. Few mortals outside of Shangri-La know about the Hidden Masters, and they can travel through enemy territories without being noticed. Hidden Masters rarely use weapons, except for the magical drje, a magical weapon of great power that allows them strike their foes with lightning."


#ap 14
#mapmove 3
#hp 12
#prot 0
#size 2
#str 10
#enc 3
#att 11
#def 11
#prec 12
#mr 16
#mor 14
#gcost 400
#rcost 1
#nametype 161
#itemslots 15494
#weapon 92 -- Fist
#weapon 243 -- Lightning
#armor "Robes"
#magicskill 1 2
#magicskill 3 2
#magicskill 4 2
#magicskill 8 3
#custommagic 3328 100
#custommagic 3328 10
#mountainsurvival
#coldres 75
#neednoteat
#flying
#stealthy 0
#maxage 200
#startage 180
#holy
#end



------------------------------------------------------------------------------
-- NATIONAL HEROES
------------------------------------------------------------------------------


-- Tlku
#newmonster 3732
#name "Tlku"
#spr1 "./Shangri_La/Tulku_Child_1.tga"
#spr2 "./Shangri_La/Tulku_Child_2A.tga" -- Nice boy Tlku
--spr2 "./Shangri_La/Tulku_Child_2B.tga" -- Tlku with Attitude

--spr1 "./Shangri_La/Tulku_Adult_1.tga" -- Grown-up Tlku
--spr2 "./Shangri_La/Tulku_Adult_2A.tga"
--spr2 "./Shangri_La/Tulku_Adult_2B.tga" -- Grown-up Tlku, but only physically ^_^


#descr "Tlku are the reincarnated spirits of ancient sages and spiritual teachers who chose to reincarnate instead of leaving this world. Usually born the son of a poor peasant or shepherd, a Tlku starts preaching when just a young boy. Over the years, word of his wisdom spreads through the valleys, until some Lamas are sent to investigate. The Lamas quickly find that the young boy is, in fact, the spirit of a very respected Hidden Master who attained spiritual enlightenment, but chose to reincarnate in a mortal body to guide mortals toward spiritual ascension."

#ap 12
#mapmove 3
#hp 9
--hp 12 -- More appropriate if you use adult Tlku sprite
#prot 0
#size 1
--size 2 -- More appropriate if you use adult Tlku sprite
#str 7
--str 10 -- More appropriate if you use adult Tlku sprite
#enc 3
#att 11
#def 11
#prec 12
#mr 17
#mor 14
#gcost 0
#rcost 1
#nametype 161
#itemslots 15494
#weapon 92 -- Fist
#weapon 243 -- Lightning
#armor "Robes"
#magicskill 1 3
#magicskill 3 3
#magicskill 4 4
#magicskill 8 3
#mountainsurvival
#coldres 75
#neednoteat
#stealthy 0
#maxage 200
#startage 8
#holy
#poorleader

#end






-- Ascended One
#newmonster 3733
#name "Ascended One"
#spr1 "./Shangri_La/Ascended_One_1.tga"
#spr2 "./Shangri_La/Ascended_One_2.tga"

#descr "Truly enlightened Hidden Masters do not die, but instead reach a new level of existence and become Ascended Ones. Ascended Ones have completely transcended human needs, and do not eat. They have mastered their own mortality to such an extent that, if killed, they may be reborn by reforming a new body out of their own essence. They can levitate, and recover from injuries that would cripple mere mortals."


#ap 12
#mapmove 3
#hp 16
#prot 0
#size 2
#str 10
#enc 3
#att 11
#def 11
#prec 12
#mr 17
#mor 16
#gcost 0
#rcost 1
#nametype 161
#itemslots 13446
#weapon 92 -- Fist
#weapon 243 -- Lightning
#armor "Robes"
#magicskill 1 2
#magicskill 3 2
#magicskill 4 4
#magicskill 8 4
#custommagic 3328 100
#okmagicleader
#mountainsurvival
#coldres 75
#neednoteat
#flying
#stealthy 0
#immortal
#magicbeing
#heal
#maxage 300
#startage 200
#holy
#end



-- Demon Slayer
#newmonster 3734
#name "Demon Slayer"
#spr1 "./Shangri_La/Demon_Slayer_1.tga"
#spr2 "./Shangri_La/Demon_Slayer_2.tga"

#descr "The Demon Slayer is a highly-experienced and skilled Demon Hunter. Well-trained in fire and astral magics, the Demon Slayer also has also learned some of the lore of the Ngagspa sorcerers and heretical mages he hunts down."

#ap 12
#mapmove 2
#hp 11
#prot 0
#size 2
#str 10
#enc 3
#att 11
#def 11
#prec 10
#mr 12
#mor 15
#gcost 0
--gcost 170
#rcost 1
#nametype 161
#itemslots 15494
#weapon "phurba"
#armor "Robes"
#holy
#magicskill 0 2 -- Fire 2
#magicskill 4 2 -- Astral 2
#magicskill 5 1 -- Death 1
#magicskill 7 1 -- Blood 1
#magicskill 8 2 -- Holy 2
#custommagic 20736 30
#custommagic 20736 30
#poorleader
#mountainsurvival
#coldres 50
#end



------------------------------------------------------------------------------
-- TEMPORARY UNITS
------------------------------------------------------------------------------

-- Yak (with rider killed)
#newmonster 3735
#name "Yak"
#spr1 "./Shangri_La/GL_Yak_1.tga"
#spr2 "./Shangri_La/GL_Yak_2.tga"
-- Nounours's original Yak Rider did not have an alternate riderless form.

#descr "Sturdy and strong, yaks are well-suited to the harsh climate of the Hidden Valley, and see use by the Bhdpa use yaks as pack and traction animals. Some Bhdpa tribesmen train these hardy animals for use as mounts, and ride them into battle with lances and shortbows. A yak can kill a lightly-armored man with its gore attack. Bhdpa yak mounts whose riders have been killed during battle may continue fighting, though they are likely to panic, and tend to run off in the aftermath of the battle."

#ap 20
#mapmove 3
#hp 32
#prot 5
#size 3
#str 18
#enc 3
#att 10
#def 8
#prec 5
#mr 5
#mor 7
#gcost 25
#rcost 5
#ressize 2
#nametype 161
#itemslots 13446
#weapon 352
#mountainsurvival
#animal
#coldres 75
#mounted
#startage 8
#maxage 32
#itemslots 12288
#end



------------------------------------------------------------------------------
-- SUMMONS
------------------------------------------------------------------------------

-- Yeti
#newmonster 3736
#name "Yeti"
#spr1 "./Shangri_La/Yeti_1.tga"
#spr2 "./Shangri_La/Yeti_2.tga"

#descr "Yetis are giant, degenerate cousins of the Mi G who live in the mountains of Shangri-La. On occasion, a mage manages to contact a small group of these savage creatures and binds them into service. Strong, tough, fast and fearless, a yeti can dismember a human being with its bare hands and quarter him without effort. Few can withstand the mere sight of an angry yeti without fleeing in terror. Born in the frozen heights of Shangri-La, Yeti have thick hides and fur, and grow stronger and more resilient in the cold. Even where it is warmer, they radiate the cold of their mountains."

#ap 15
#mapmove 2
#hp 36
#prot 7
#size 4
#str 24
#enc 3
#att 13
#def 12
#prec 8
#mr 11
#mor 16
#gcost 0
#rcost 2
#nametype 161
#itemslots 15494
#weapon 29 -- Claw/Claw/Bite
#weapon 29
#weapon 20
#maxage 50
#mountainsurvival
#coldres 100
#coldpower 2
#cold 3
#iceprot 1
#fear 0
#stealthy
#end




-- Btsan
#newmonster 3737
#name "Btsan"
#spr1 "./Shangri_La/Btsan_1.tga"
#spr2 "./Shangri_La/Btsan_2.tga"

#descr "Malevolent spirits from the high mountains of Shangri-La, these black-skinned demons are master archers. Sometimes, a Dmu Bn Ngagspa sorcerer summons Btsan with blood sacrifice and sends them against an enemy. Btsan bring death and spread diseases, and revel in human blood."

#ap 13
#mapmove 2
#hp 25
#prot 8
#size 3
#str 15
#enc 3
#att 13
#def 12
#prec 15
#mr 14
#mor 14
#gcost 0
--gcost 45
#rcost 2
#nametype 161
#itemslots 15494
#weapon 29 -- Claw
#weapon 29 -- Claw
#weapon 438 -- Plague Bow
#armor "Skull Necklace"
--magicskill 5 1
-- Death magic skill removed since it was making them effectively not archers
-- with the Send Btsan spell (under which they cannot be given orders, since
-- it is a farsummon).
#poorundeadleader
#demon
#neednoteat
#poisonres 75
#coldres 50
#end




-- Bdud -- relationship to Lhamayin?

-- Lhamayin lha ma yin (Tibetan) Non-deity, not a deity; equivalent to the Sanskrit asura. A class of elemental beings or nature spirits corresponding to the various elemental sprites of the lower planes, such as the terrestrial. The lhamayins in popular Tibetan folklore are considered demons and devils, but esoterically they are a class of beings one step higher than the terrestrial sphere.

#newmonster 3738
#name "Bdud"
#spr1 "./Shangri_La/Bdud_1.tga"
#spr2 "./Shangri_La/Bdud_2.tga"

#descr "Once benign spirits of the Bhdpa, the Bdud of the lands of Shangri-La are now brutal and ruthless lhamayin, earthly demons of the wooded hills and valleys. These ugly creatures have three eyes, long fangs and thick reddish skin. Though cruel, violent and short-tempered, they are not completely malevolent, and sometimes do not kill or eat humans who cross their path. Bdud use great clubs, hammers or axes in battle, wear ornaments made of human skulls or bones, and some even use crude armor. Fearless in battle, they may become overwhelmed by bloodlust and anger when wounded. Bdud are demons of the land and mountains, and are not summoned by blood sacrifice."

#ap 13
#mapmove 2
#hp 28
#prot 6
#size 3
#str 17
#enc 3
#att 13
#def 9
#prec 9
#mr 13
#mor 16
#gcost 0
--gcost 35
#rcost 2
#nametype 161
#itemslots 15494
#weapon 165 -- Great Club
#demon
#eyes 3
#neednoteat
#mountainsurvival
#coldres 75
#berserk 1
#end


-- Bdud Warrior with battleaxe and armor
#newmonster 3739
#name "Bdud Warrior"
#spr1 "./Shangri_La/Bdud_Warrior_Axe_1.tga"
#spr2 "./Shangri_La/Bdud_Warrior_Axe_2.tga"

--Original broken sprite links
--spr1 "./Shambalha/Bdud_Warrior_Maul_1.tga"
--spr2 "./Shambalha/Bdud_Warrior_Maul_2.tga"

#descr "Once benign spirits of the Bhdpa, the Bdud of the lands of Shangri-La are now brutal and ruthless lhamayin, earthly demons of the wooded hills and valleys. These ugly creatures have three eyes, long fangs and thick reddish skin. Though cruel, violent and short-tempered, they are not completely malevolent, and sometimes do not kill or eat humans who cross their path. Bdud use great clubs, hammers or axes in battle, wear ornaments made of human skulls or bones, and some even use crude armor. Fearless in battle, they may become overwhelmed by bloodlust and anger when wounded. Bdud are demons of the land and mountains, and are not summoned by blood sacrifice."


#ap 13
#mapmove 2
#hp 28
#prot 6
#size 3
#str 17
#enc 3
#att 14
#def 10
#prec 9
#mr 13
#mor 16
#gcost 0
--gcost 40
#rcost 2
#nametype 161
#itemslots 15494
#weapon 18 -- Battleaxe -- Nounours's original description provides for great clubs, hammers and axes. I decided to change this to go with an axe instead of a maul.
--weapon 14 -- Maul
#armor "Skull Necklace"
#armor "Crude Breastplate"
#demon
#eyes 3
#neednoteat
#mountainsurvival
#coldres 75
#berserk 1
#end



-- Srin Po
#newmonster 3740
#name "Srin Po"
#spr1 "./Shangri_La/Srin_Po_1.tga"
#spr2 "./Shangri_La/Srin_Po_2.tga"

#descr "The dreadful Srin Po are cruel and bloodthirsty man-eating demons with three eyes. Ill-tempered and vicious, these demons are among the most cruel of the Dmu. Savage and barbarous, Srin Po have an insatiable lust for human flesh and blood, and sometimes a Ngagspa sorcerer may summon and bind them with blood sacrifice and dark rites. Srin Po often fight with huge, crude bone clubs crudely, and most of them do not wear armor aside from necklaces made of human skulls and bones, often taken from the remains of the poor wretches devoured by the demon. Srin Po are good at destroying things, and have some minor magic power over earth and rocks."

#ap 14
#mapmove 2
#hp 33
#prot 6
#size 3
#str 18
#enc 3
#att 15
#def 11
#prec 9
#mr 14
#mor 15
#gcost 0
--gcost 50
#rcost 3
#nametype 161
#itemslots 15494
#weapon 165 -- Great Club
#weapon 20 -- Bite
#armor "Skull Necklace"
#custommagic 21504 100
#demon
#eyes 3
#neednoteat
#supplybonus -2
#mountainsurvival
#coldres 75
#fear 0
#siegebonus 2
#end




-- Srin Po Swordsman
#newmonster 3741
#name "Srin Po Swordsman"
#spr1 "./Shangri_La/Srin_Po_Swordsman_1.tga"
#spr2 "./Shangri_La/Srin_Po_Swordsman_2.tga"

#descr "The dreadful Srin Po are cruel and bloodthirsty man-eating demons with three eyes. Ill-tempered and vicious, these demons are among the most cruel of the Dmu. Savage and barbarous, Srin Po have an insatiable lust for human flesh and blood, and sometimes a Ngagspa sorcerer may summon and bind them with blood sacrifice and dark rites. Some Srin Po wield large kukri swords instead of bone clubs, and wear chainmail armor forged by human slaves or by Lha craftmen. Srin Po are good at destroying things, and have some minor magic power over earth and rocks."


#ap 14
#mapmove 2
#hp 35
#prot 6
#size 3
#str 18
#enc 3
#att 15
#def 12
#prec 9
#mr 14
#mor 16
#gcost 0
--gcost 60
#rcost 3
#nametype 161
#itemslots 15494
#weapon "great kukri"
#weapon 20 -- Bite
#armor "Skull Necklace"
#armor "Chain Mail Cuirass"
#armor "Shield"
#custommagic 21504 100
#demon
#eyes 3
#neednoteat
#supplybonus -2
#mountainsurvival
#coldres 75
#fear 0
#siegebonus 2
#end



-- Theurang Spirit
#newmonster 3742
#name "Theurang"
#spr1 "./Shangri_La/Theurang_1.tga"
#spr2 "./Shangri_La/Theurang_2.tga"

#descr "Theurang are spirits from the mountains around Shangri-La. Theurang appears as brutish one-footed creatures with webbed fingers and tongues so large they can cover their faces. Being spirits of mountaintops and heights, they have some power over air, but they also are master smiths who, it is said, taught humans to craft metals. Often seen as deities by smiths, they carry huge hammers, and may have some power over fire and earth, as well as knowledge in dark magics. Though Theurang are not generally malevolent, they are mischievous creatures and may attack humans without real reason. Often believed to be demons by superstitious folks, Theurang are actually spirits of the land and belong to the hierarchy of Lha spirits."

#clearmagic
#ap 10 -- changed to 10 to reflect one-leggedness to a degree
#mapmove 2
#hp 22
#prot 8
#size 3
#str 16
#enc 3
#att 12
#def 11
#prec 7
#mr 13
#mor 14
#gcost 0
--gcost 170
#rcost 1
#nametype 161
#weapon 13 -- Hammer
#weapon 29 -- Claw
#magicskill 1 1
#magicskill 3 1
#custommagic 1408 50
#itemslots 13446
#magicbeing
#eyes 1
#maxage 500
#fear 0
#neednoteat
#fireres 25
#coldres 75
#forgebonus 10
#end




-- Lha
#newmonster 3743
#name "Lha"
#spr1 "./Shangri_La/Lha_1.tga"
#spr2 "./Shangri_La/Lha_2.tga"


#descr "Lha are high spirits of the mountains and valleys. Unlike the Dmu demons, Lha tend to consider humans as allies or trusted servants, not slaves or food. Though they are not truly benevolent, they are less ruthless than their Dmu kin, and the people of Shangri-La often ask them protection. Their attitude toward humans has made them sacred to the people of the mountain kingdom. Lha are very skilled smiths, and have sometimes taught humans to work tempered steel. The most powerful Lha are skilled nature mages with some skill in earth magic, and some are skilled in water magic as well."

-- GLOBU CONTENT CHANGE: Nounours's original description referred to "the people of Shambalha" asking for protection. Shambhala is referenced in no other part of this mod, and seems to just bring in an obscure reference with nothing to ground it.  I've changed it to Shangri-La for now, but it would be a good idea to work it in, in general, since it is a proper name that adds both flavor and authenticity.

#ap 12
#mapmove 2
#hp 33
#prot 0
#size 3
#str 15
#enc 3
#att 15
#def 14
#prec 10
#mr 17 -- Improved from 15 in v2.05
#mor 15
#gcost 0
--gcost 150
#rcost 2
#nametype 161
#itemslots 15494
#weapon 202 -- Magic Sword
#armor "Chain Mail Hauberk"
#armor "Half Helmet"
#armor "Enchanted Shield" -- Changed from normal shield as of v2.05
#magicskill 6 2 -- Nature 2
#magicskill 3 1 -- Earth 1
#magicskill 8 1 -- Holy 1
#custommagic 1280 100 -- 100% chance of AE
#custommagic 1792 80 -- 80% chance of AWE
#custommagic 8960 50 -- 50% chance of AWN
-- Magic has been altered as of v2.05 to make Lha more interesting.  As it
-- stands, they now, with the right randoms, can come with up to 3 in N, E
-- and A, and up to 2 in W.
#maxage 500
#magicbeing
#neednoteat
#mountainsurvival
#forestsurvival
#coldres 75
#castledef 2
#holy
#end



-- Lha Dummy Summon (for saving a spell slot using Sombre's firstshape method)
#newmonster 3701
#name "Lha"
#spr1 "./Shangri_La/Lha_1.tga"
#spr2 "./Shangri_La/Lha_2.tga"


#descr "If you see this unit, I have screwed something up.  It should be transparently summoned, produce 6 Dgra Lha as well, and revert to 3743 above."

#ap 12
#mapmove 2
#hp 33
#prot 0
#size 3
#str 15
#enc 3
#att 15
#def 14
#prec 10
#mr 17
#mor 15
#gcost 0
--gcost 150
#rcost 2
#nametype 161
#itemslots 15494
#weapon 202 -- Magic Sword
#armor "Chain Mail Hauberk"
#armor "Half Helmet"
#armor "Enchanted Shield"
#magicskill 6 2 -- Nature 2
#magicskill 3 1 -- Earth 1
#magicskill 8 1 -- Holy 1
#custommagic 1280 100 -- 100% chance of AE
#custommagic 1792 80 -- 80% chance of AWE
#custommagic 8960 50 -- 50% chance of AWN
-- Magic has been altered as of v2.05 to make Lha more interesting.  As it
-- stands, they now, with the right randoms, can come with up to 3 in N, E
-- and A, and up to 2 in W.
#maxage 500
#magicbeing
#neednoteat
#mountainsurvival
#forestsurvival
#coldres 75
#castledef 2
#holy
#summon1 3744 -- Bring 1 Dgra Lha with
#summon5 3744 -- Bring 5 more
#firstshape 3743 -- Revert to normal Lha, never having been seen
#end


-- Dgra Lha (Lha Warrior)
-- The G is silent, sand it's often written as Drala.  "Foe god" or "warrior protective god."  "In many Tibetan houses, a white dgra lha mask is always hung to insure good luck and prosperity for the family. A thangka showing the nine dgra lha is also hung."
#newmonster 3744
#name "Dgra Lha"
#spr1 "./Shangri_La/Dgra_Lha_1.tga"
#spr2 "./Shangri_La/Dgra_Lha_2.tga"

#descr "Lha are spirits of the mountains and valleys. Unlike the Dmu demons, Lha tend to consider humans as allies or trusted servants, not slaves or food. Though they are not truly benevolent, they are less ruthless than their Dmu kin, and the people of the Hidden Valley often ask them for protection. Their attitude toward humans has made them sacred to the people of the mountain kingdom. Dgra Lha (pronounced 'Drala') are Lha warriors, spirits of war and battle who fight with magic swords and armor made of fine crafted steel."

#ap 12
#mapmove 2
#hp 22
#prot 0
#size 3
#str 14
#enc 3
#att 15
#def 13
#prec 10
#mr 15
#mor 14
#gcost 0
--gcost 50
#rcost 2
#itemslots 15494
#weapon 202 -- Magic Sword
#armor "Chain Mail Cuirass"
#armor "Half Helmet"
#armor "Shield"
#maxage 500
#magicbeing
#neednoteat
#mountainsurvival
#forestsurvival
#coldres 75
#castledef 2
#holy
#end




-- Snow Lion
#newmonster 3745
#name "Snow Lion"
#spr1 "./Shangri_La/Snow_Lion_1.tga"
#spr2 "./Shangri_La/Snow_Lion_2.tga"

#descr "Snow Lions, or Gangs Senge, are magnificent and ferocious celestial creatures who look like white lions with turquoise manes. These fearsome beings are symbols of bravery in Shangri-La, and their roar is so powerful that it is said to frighten dragons. The feet of Snow Lions never touch the ground, and they spend their existence leaping from mountain peak to mountain peak."

#ap 20
#mapmove 3
#hp 30
#prot 7
#size 3
#str 18
#enc 1
#att 14
#def 10
#prec 5
#mr 14
#mor 15
#gcost 0
#rcost 1
#nametype 161
#itemslots 12288
#weapon 20 -- Bite
#weapon 29 -- Claw
#magicbeing
#animal
#maxage 300
#flying
#neednoteat
#mountainsurvival
#coldres 100
#fear 2
#holy
#end




-- Klu (Naga/Nagini), serpent shape
#newmonster 3746
#copystats 1322
#name "Klu"
#spr1 "./Shangri_La/Klu_serpent_shape_1.tga"
#spr2 "./Shangri_La/Klu_serpent_shape_2.tga"

-- GLOBU CONTENT CHANGE
-- Nounours's original version used a male naga along the lines of a Patalan
-- Nagaraja with no armor and W3N1 but no Holy magic. However, the
-- stats were pretty generic and incomplete (for example, there was no
-- difference between the stats for human form and naga form).

-- I've taken a slight bit of liberty and changed it to a modified Patalan
-- Nagini (female with seduction ability), with W3N1, a 30% random ESN pick,
-- and a few other minor changes, and used the copystats command instead of
-- building it from scratch.

#descr "Klu are guardian spirits of the waters and rivers who dwell in springs and punish those who pollute the water, and are sometimes summoned into service by Water and Nature mages. Serpent-like in their normal form, they are able to change their shape and wander the lands unnoticed. Klu in their human form are strikingly beautiful, and can often seduce men into abandoning all ties and loyalties. They sometimes travel very far from Shangri-La, and have even had some contacts with the monkeys of Bandar Log, who call them Nagas. Klu are powerful Water mages with some skill in Nature, and occasionally in Earth and Astral magic as well. Their skill in Water magic is stronger when they are in serpent form."

#ap 8
#mapmove 2
#hp 18
#prot 5
#size 3
#str 12
#enc 4
#att 11
#def 13
#prec 12
#mr 17
#mor 15
#gcost 0
#rcost 1
--nametype 161 -- Better perhaps to leave this at the original Indian naming scheme, which occurs by default since we used copystats
#itemslots 13446
--weapon 92 -- Fist (should be applied by default)
--weapon 10 -- Falchion
--weapon 30 -- Venomous Bite (should be applied by default)
#clearmagic
#magicskill 2 2 -- Water 2
#magicskill 6 1 -- Nature 1
#magicboost 2 1 -- Serpent form boosts water by 1, as standard for Nagini
#custommagic 11264 30 -- Earth/Astral/Nature random
--maxage 300
#magicbeing
#coldblood
#shapechange 3747
#pooramphibian
#swampsurvival
#forestsurvival
#darkvision 75
#poisonres 100
#holy
#end




-- Klu, human shape
#newmonster 3747
#copystats 1325
#name "Klu"
#spr1 "./Shangri_La/Klu_human_shape_1.tga"
#spr2 "./Shangri_La/Klu_human_shape_2.tga"
--spr1 "./Shangri_La/Klu_human_shape_Alt2.tga" -- Dark skinned version
--spr2 "./Shangri_La/Klu_human_shape_Alt1.tga"

#descr "Klu are guardian spirits of the waters and rivers who dwell in springs and punish those who pollute the water, and are sometimes summoned into service by Water and Nature mages. Serpent-like in their normal form, they are able to change their shape and wander the lands unnoticed. Klu in their human form are strikingly beautiful, and can often seduce men into abandoning all ties and loyalties. They sometimes travel very far from Shangri-La, and have even had some contacts with the monkeys of Bandar Log, who call them Nagas. Klu are powerful Water mages with some skill in Nature, and occasionally in Earth and Astral magic as well. Their skill in Water magic is stronger when they are in serpent form."


#ap 14
#mapmove 2
#hp 16
#prot 3
#size 3
#str 12
#enc 4
#att 11
#def 12
#prec 12
#mr 17
#mor 15
#gcost 0
#rcost 1
-- nametype 161 -- Default Indian names more thematically appropriate
#itemslots 15494
--weapon 10 -- Falchion
#clearmagic
#magicskill 2 2 -- Water 2
#magicskill 6 1 -- Nature 1
#custommagic 11264 30 -- Earth/Astral/Nature random
--maxage 300
#magicbeing
#shapechange 3746
--firstshape 3746 -- unnecessary?
--watershape 3746 -- removed because of intended consequences with being hidden in underwater provinces
#pooramphibian
#forestsurvival
#swampsurvival
#darkvision 75
#poisonres 100
#stealthy 10
#seduce 12 -- Standard Nagini is 10, but I'm going with CBM style here
#holy
#end




-- Citipati
#newmonster 3748
#name "Citipati"
#spr1 "./Shangri_La/Citipati_1.tga"
#spr2 "./Shangri_La/Citipati_2.tga"

#descr "Citipati, or Lords of the Cemetery, are a peculiar kind of skeletons who dance in graveyards, their mouths parted in a large grin showing all their teeth. According to a Shangrilan legend, in a former existence the Citipatis were ascetics who were murdered, and still wear the tattered robes of a Shangrilan Drapa. They are known to be ferocious enemies of thieves, relentlessly roaming their lands for wrongdoers. Their touch drains the life force of their foes, and they are surrounded by the cold of grave."

#ap 12
#mapmove 2
#hp 18
#prot 0
#size 2
#str 12
#enc 0
#att 12
#def 12
#prec 8
#mr 15
#mor 18
#gcost 0
#rcost 1
#nametype 161
#itemslots 15494
#weapon 63 -- Life Drain
#undead
--demon -- Unprecedented and unnecessary
#inanimate
#neednoteat
#pooramphibian
#cold 3
--darkvision 75 -- Unnecessary and duplicative
#poisonres 100
#coldres 100
#fear 0
#patrolbonus 2
#holy
#end







------------------------------------------------------------------------------
-- NEW PRETENDERS
------------------------------------------------------------------------------




-- Ascended Master
#newmonster 3749
#name "Ascended Master"
#spr1 "./Shangri_La/Ascended_Master_1.tga"
#spr2 "./Shangri_La/Ascended_Master_2.tga"

#descr "After studying for centuries, the Ascended Master has not only mastered his own mortality, but has achieved such an enlightened state that he has almost reached divinity. With the Pantokrator has gone, nothing will stop the Ascended Master on his road to true spiritual ascension. Though he is not as physically powerful as many other pretenders, and is less magically-skilled than archmages and other magicians, he is essentially a spiritual being, near-immortal and difficult to destroy. He has mastered the powers of spirit and mind, and wields the power of the vajra, the force of lightning."

#ap 12
#mapmove 3
#hp 12
#prot 0
#size 2
#str 10
#enc 3
#att 11
#def 11
#prec 12
#mr 18
#mor 30
#gcost 60
#rcost 1
#pathcost 30
#startdom 1
#nametype 161
#restrictedgod 88
#itemslots 13446
#weapon 92 -- FIst
#weapon 243 -- Lightning
#magicskill 3 1
#magicskill 4 1
#coldres 75
#neednoteat
#flying
#immortal
#magicbeing
#maxage 500
#startage 300
#end





-- Bodhisattva
#newmonster 3750
#name "Bodhisattva"
#spr1 "./Shangri_La/Bodhisattva_1.tga"
#spr2 "./Shangri_La/Bodhisattva_2.tga"

#descr "The Bodhisattva is a being of semi-divine origin who has achieved such a state of spiritual enlightenment that he has transcended his own mortality and all mortal needs. With the old Pantokrator alive, he could not ascend to true godhood and complete his enlightenment, and had to retire in a secret place to meditate. But now, with the Pantokrator gone, the Bodhisattva is ready to resume his quest for ascension and to bring hope and solace to human kind. Though he is not physically as powerful as other divine beings, the Bodhisattva has a strong dominion and is a powerful Astral mage because of his spiritual perfection. Furthermore, he is so enlightened that few would dare to strike him, and that his mere presence instill serenity in the hearts of mortals."

#ap 12
#mapmove 3
#hp 36
#prot 5
#size 3
#str 14
#enc 1
#att 13
#def 13
#prec 14
#mr 18
#mor 30
#gcost 80
#rcost 1
#pathcost 40
#startdom 3
#nametype 161
#restrictedgod 88
#itemslots 13446
#weapon 92 -- Fist
#magicskill 4 3
#coldres 50
#poisonres 50
#neednoteat
#awe 3
#incunrest 5
#magicbeing
#maxage 500
#end



-- Mother of Mountains
#newmonster 3751
#name "Mother of Mountains"
#copyspr 601

#descr "The Mother of Mountains is a giant of divine heritage who claims dominion over mountains and heights. The powers of earth, air and water are hers to claim, and she is constantly surrounded by the cold of her native mountains. With the Pantokrator gone, the Mother of mountains will soon rule all of creation."



#ap 16
#mapmove 3
#hp 85
#prot 6
#size 6
#str 22
#enc 2
#att 12
#def 12
#prec 12
#mr 18
#mor 30
#gcost 125
#rcost 1
#pathcost 50
#startdom 3
#nametype 161
#restrictedgod 88
#itemslots 15494
#weapon 92
#armor "Crown"
#magicskill 1 1
#magicskill 2 1
#magicskill 3 1
#expertleader
#coldres 100
#cold 2
#mountainsurvival
#maxage 1000
#end



-- Frozen Lama
#newmonster 3752
#name "Lama of the Frozen Heights"
#spr1 "./Shangri_La/Frozen_Lama_1.tga"
#spr2 "./Shangri_La/Frozen_Lama_2.tga"

#descr "Having attained to spiritual ascension, the Lama of the Frozen Heights has become something of an Ascended Master himself. The Frozen Lama, as he is sometimes reverently called, keeps the former color of his hat a secret, as it is now the ice blue of the element which he has taken into his very nature. With the Pantokrator gone, he now comes to throw that very hat into the ring in his bid for complete divinity. The Lama of the Frozen Heights is a highly-skilled mage, and is nearly immortal. He exudes an aury of icy cold said to aid the spiritual improvement of those around him by sheer ascetic glory."


#ap 12
#mapmove 2
#hp 12
#prot 0
#size 3
#str 11
#enc 3
#att 10
#def 11
#prec 12
#mr 18
#mor 30
#gcost 80
#rcost 1
#pathcost 10
#startdom 1
#nametype 161
#restrictedgod 88
#itemslots 13446
#weapon "phurba"; replace with dagger (9) if you use the pretender without the weapon definition for Phurba
#armor "Robes"
#magicskill 2 2
#magicskill 4 1
#coldres 200
#neednoteat
#mountainsurvival
#flying
#immortal
#magicbeing
#maxage 500
#startage 300
#cold
#end


------------------------------------------------------------------------------
-- EXISTING PRETENDERS
------------------------------------------------------------------------------

#newmonster 3753
#name "Celestial General"
#copystats 1345
#copyspr 1345
#restrictedgod 88
#end


#newmonster 3754
#name "Mother of Rivers"
#copystats 1342
#copyspr 1342
#restrictedgod 88
#end


#newmonster 3755
#name "Lord of Plenty"
#copystats 1339
#copyspr 1339
#restrictedgod 88
#end


#newmonster 3756
#name "Lady of Fortune"
#copystats 1344
#copyspr 1344
#restrictedgod 88
#end


#newmonster 3757
#name "Nataraja"
#copystats 499
#copyspr 499
#restrictedgod 88
#end


#newmonster 3758
#name "Destroyer of Worlds"
#copystats 1096
#copyspr 1096
#restrictedgod 88
#end


#newmonster 3759
#name "Deva"
#copystats 1341
#copyspr 1341
#restrictedgod 88
#end



------------------------------------------------------------------------------
-- SPELLS
------------------------------------------------------------------------------


#newspell
#name "Call Yeti"
#descr "Shangrilan mages have learned to contact the savage yetis from the frozen heights and bind them into service of the ascendant god of Shangri-La. More powerful mages may be able to summon more than one."
#school 0
#researchlevel 4
#path 0 2
#pathlevel 0 2
#path 1 3
#pathlevel 1 1
#effect 10001
#nreff 1001
#fatiguecost 2500
#damage 3736
#restricted 88
#end


#newspell
#name "Contact Klu"
#descr "Klu are serpent-like guardian spirits of springs and water who can be summoned and coaxed into service."
#school 0
#researchlevel 5
#path 0 2
#pathlevel 0 2
#path 1 6
#pathlevel 1 2
#effect 10021
#nreff 1
#fatiguecost 2000
#damage 3746
#restricted 88
#end




#newspell
#name "Contact Theurang"
#descr "Theurangs are mischievous spirits of the mountains. By chanting appropriate mantras and making offerings, a mage can attract one and convince it to serve."
#school 0
#researchlevel 6
#path 0 3
#pathlevel 0 3
#path 1 1
#pathlevel 1 1
#effect 10021
#nreff 1
#fatiguecost 1500
#damage 3742
#restricted 88
#end



#newspell
#name "Call Btsan"
#descr "By offering them human blood, a mage can call forth some of the black-skinned demons called Btsan and bind them into service. Btsan are demons of hunting who, it is said, made the first bows. They hunt down humans who venture into the mountains, and spread diseases if angered."
#school 6
#researchlevel 3
#path 0 7
#pathlevel 0 2
#path 1 5
#pathlevel 1 2
#effect 10001
#nreff 5
#fatiguecost 3000
#damage 3737
#restricted 88
#end



#newspell
#name "Send Btsan"
#descr "By offering him human blood, a mage can induce a Btsan, a black-skinned demon archer, to hunt down and kill an enemy. Btsan are demons of hunting who, it is said, made the first bows. They hunt down humans who venture into the mountains, and spread diseases if angered."
#school 6
#researchlevel 5
#path 0 7
#pathlevel 0 2
#path 1 5
#pathlevel 1 1
#effect 10050
#nreff 1
#fatiguecost 800
#damage 3737
#restricted 88
#end



#newspell
#name "Summon Bdud"
#descr "Bdud are ruthless and violent demons who haunt the valleys and mountains near Shangri-La. Despite their demonic nature, they are of this world and do not require blood sacrifice to be summoned. Ngagspa sorcerers sometimes summon them to wreak havoc on those who have offended them, or to destroy their enemies."
#school 0
#researchlevel 4
#path 0 3
#pathlevel 0 1
#path 1 5
#pathlevel 1 2
#effect 10001
#nreff 4
#fatiguecost 1000
#damage 3738
#restricted 88
#end



#newspell
#name "Summon Bdud Warriors"
#descr "Bdud are ruthless and violent demons who haunt the valleys and mountains near Shangri-La. Despite their demonic nature, they are of this world and do not require blood sacrifice to be summoned. Ngagspa sorcerers sometimes summon them to wreak havoc on those who have offended them, or to destroy their enemies. The better-equipped Bdud warriors are known to use battle axes and crude armor adapted from a foreign style."
#school 0
#researchlevel 6
#path 0 3
#pathlevel 0 1
#path 1 5
#pathlevel 1 2
#effect 10001
#nreff 3
#fatiguecost 1200
#damage 3739
#restricted 88
#end



#newspell
#name "Feast of Cannibal Demons"
#descr "By offering them blood and human flesh in a gruesome banquet, a mage can attract the attention of a few Srin Po, or cannibal demons. Then, he can let them satisfy their craving for human flesh in exchange for their service, and convince them to do his bidding. Though Srin Po lack subtlety, they are cruel and fierce warriors."
#school 6
#researchlevel 4
#path 0 7
#pathlevel 0 3
#path 1 5
#pathlevel 1 1
#effect 10001
#nreff 5
#fatiguecost 2800
#damage 3740
#restricted 88
#end


#newspell
#name "Great Banquet of Cannibal Demons"
#descr "By offering them blood and human flesh in a gruesome banquet, a mage can attract the attention of a few Srin Po, or cannibal demons. Then, he can let them satisfy their craving for human flesh in exchange for their service, and convince them to do his bidding and wage war. Though Srin Po lack subtlety, they are cruel and fierce warriors. The better-armed of them will only respond to the most enticing ritual banquets, involving a great many choice human offerings."
#school 6
#researchlevel 6
#path 0 7
#pathlevel 0 4
#path 1 5
#pathlevel 1 2
#effect 10001
#nreff 8
#fatiguecost 6600
#damage 3741
#restricted 88
#end



#newspell
#name "Contact the Lords of Cemetery"
#descr "Venturing into a burial ground, the mage chants mantras to call the Citipati, the Lords of the Cemetery, to his aid. Citipati appear as horridly-grinning skeletons who dance upon graves."

#school 0
#researchlevel 3
#path 0 5
#pathlevel 0 2
#path 1 8
#pathlevel 1 1
#effect 10001
#nreff 3
#fatiguecost 600
#damage 3748
#restricted 88
#end


#newspell
#name "Contact Lha"
#descr "Lha are ancient spirits of the land who retired from the Hidden Valley when the new religion spread in the mountain kingdom of Bhd. Once worshipped as gods and protectors, these powerful and sacred beings are skilled warriors and smiths, and are said to be the ones who taught humans to work metal and temper steel. Sometimes, a Shangrilan mage contacts a high Lha spirit and convinces it to return with its retinue of Dgra Lha guardians to serve the masters of Shangri-La."

#school 0
#researchlevel 7
#path 0 6
#pathlevel 0 2
#path 1 3
#pathlevel 1 2
#effect 10021
#nreff 1
#fatiguecost 5300
#damage 3701 -- Dummy unit that summons 6 Dgra Lha then reverts to 3743
#restricted 88
#end


--GLOBU CHANGE: Spell merged with Contact Lha as of v2.05.
--newspell
--name "Call Lha Warriors"
--descr "Lha are ancient spirits of the land who retired from the Hidden Valley when the new religion spread in the mountain kingdom of Bhd. Once worshipped as gods and protectors, these powerful beings are skilled warriors and smiths, and are said to be the ones who taught humans to work metal and temper steel. Sometimes, a mage contacts a small group of Lha warriors, or Dgra Lha, and convinces them to return and serve the masters of Shangri-La."

--school 0
--researchlevel 5
--path 0 6
--pathlevel 0 2
--path 1 3
--pathlevel 1 2
--effect 10001
--nreff 5
--fatiguecost 1800
--damage 3744
--restricted 88
--end



#newspell
#name "Call Snow Lions"
#descr "Snow Lions are sacred celestial creatures from the mountains of Shangri-La, resembling white lions with blue manes. These fearsome beings are symbols of bravery in Shangri-La and emit a terrible roar."

#school 0
#researchlevel 6
#path 0 4
#pathlevel 0 4
#path 1 3
#pathlevel 1 2
#effect 10001
#nreff 2
#fatiguecost 1500
#damage 3745
#restricted 88
#end




#newspell
#name "Debt of Karma"
#descr "Normally, in the beliefs of the Shangrilan religion, the suffering and hindrance of spiritual progress brought about by one's bad Karma occurs indirectly. However, a mage-priest of the Shangrilan faith can bring the process around more quickly in battle, making his foes pay the price for their misdeeds in this life or in past lives, hindering them and making them unsure of what to do as a consequence of all their faults."

-- GLOBU CHANGE: Removed explanation of Karma; seemed to be too much.  It is kept here just in case: "According to Shangrilan religion, each person is responsible for his own actions, and for the pain and joy brought to him and others. The Karma is the result of all good and bad deeds that aid or hinder a person's spiritual progression towards enlightenment, forcing people to face the consequences of their actions and thus improve their behavior, or suffer if they do not."

#school 5
#researchlevel 0
#path 0 4
#pathlevel 0 2
#path 1 8
#pathlevel 1 1
#effect 11
#damage 160
#aoe 2
#range 5020
#nreff 1
#precision 0
#fatiguecost 50
#flightspr 149 4
#explspr 10008
#sound 30
#restricted 88
#end




#newspell
#name "Restore the Dharma"
#descr "According to Shangrilan religion, the Dharma is the teachings of the enlightened ones, passed on by spiritual masters. It expresses what must be done to free one's soul from the cycle of reincarnations and attain total spiritual ascension. The Dharma must be experienced directly, not only preached. Through this spell, a Shangrilan priest is able to share his own experience of enlightenment with some persons. Those who do not resist this spiritual experience often leave their former lives to follow the priest and serve in the Shangrilan forces."

#school 5
#researchlevel 0
#path 0 4
#pathlevel 0 3
#path 1 8
#pathlevel 1 2
#effect 29
#aoe 2
#range 25
#nreff 1
#precision 100
#fatiguecost 90
#flightspr 141 8
#explspr 10001
#sound 47
#spec 4096
#restricted 88
#end



------------------------------------------------------------------------------
-- NAMETYPES
------------------------------------------------------------------------------

#selectnametype 161 -- Custom Name List (151-200 open)
#clear
#addname "Lobsang"
#addname "Ngorchen"
#addname "Geshe"
#addname "Khyentse"
#addname "Khandro"
#addname "Pachen"
#addname "Amdo"
#addname "Gendun"
#addname "Nenang"
#addname "Lorsal"
#addname "Dorjepel"
#addname "Thrangu"
#addname "Sangdrol"
#addname "Lhundub"
#addname "Getse"
#addname "Dzongsar"
#addname "Dzogchen"
#addname "Dhardo"
#addname "Dromtn"
#addname "Drodupchen"
#addname "Tsewang"
#addname "Tsugtor"
#addname "Thubten"
#addname "Chetsun"
#addname "Norbu"
#addname "Tsemo"
#addname "Gyantsen"
#addname "Dezhung"
#addname "Dorje"
#addname "Tegchen"
#addname "Choseng"
#addname "Tsering"
#addname "Deden"
#addname "Thutob"
#addname "Kelsang"
#addname "Kwetsang"
#addname "Lhundrup"
#addname "Lotsawa"
#addname "Machig"
#addname "Trinle"
#addname "Dilgo"
#addname "Ponlop"
#addname "Patrul"
#addname "Chatral"
#addname "Chamtrul"
#addname "Gyaltsab"
#addname "Pabongka"
#addname "Gedhun"
#addname "Khugpa"
#addname "Mindrolling"
#addname "Marpa"
#addname "Labdrn"
#addname "Kongtrul"
#addname "Katok"
#addname "Wangchug"
#addname "Tashi"
#addname "Sachen"
#addname "Dudul"
#addname "Dzamling"
#addname "Chegu"
#addname "Dragshul"
#addname "Ngawang"
#addname "Sakyong"
#addname "Mipham "
#addname "Rangdrl"
#addname "Mukpo"
#addname "Sakyong"
#addname "Jamgol"
#addname "sel"
#addname "Jampal"
#addname "Shakabpa"
#addname "Lopon"
#addname "Tsechu"
#addname "Jampa"
#addname "Tempa"
#addname "Samdhong"
#addname "Yatong"
#addname "Takna"
#addname "Jigme"
#addname "Sangpo"
#addname "Tarthang"
#addname "Trijang"
#addname "Khenchen"
#addname "Khensur"
#addname "Khyabje"
#addname "Penor"
#addname "Chagdud"
#addname "Shabdrung"
#addname "Namgyal"
#addname "Shechen"
#addname "Taktser"
#addname "Traleg"
#addname "Trulshik"
#addname "Kyagbon"
#addname "Ngok"
#addname "Loden"
#addname "Namkhai"
#addname "Drenpa"
#addname "Legpa"
#addname "Kushri"
#addname "Palbar"
#addname "Samphel"
#addname "Wanggi"
#addname "Apong"
#addname "Orgyen"
#addname "Thrinley"
#addname "Lingpa"
#addname "Kyabgon"
#addname "Dhagtshul"
#addname "Rinchen"
#addname "Srungwa"
#addname "Yontan"
#addname "Gekyab"
#addname "Getong"
#addname "Balpo"
#addname "Tsultrim"
#addname "Drag"
#addname "Namgyal"
#addname "Chophel"
#addname "Phuntsog"
#addname "Nyidron"
#addname "Rwa-sgreng"
#addname "Rinchen"
#addname "Buton"
#addname "Drub"
#addname "Runggye"
#addname "Sachen"
#addname "Kunga"
#addname "Nyingpo"
#addname "Dakpa"
#addname "Konchog"
#addname "Jekundag"
#addname "Ngaglo"
#addname "Khenpo"
#addname "Dndrup"
#addname "Ensapa"
#addname "Gehlek"
#addname "Kyabje"
#addname "Jamyang"
#addname "Nawang"
#addname "Kechog"
#addname "Dolma Kyab"
#addname "Legqog"
#addname "Lopn"
#addname "Namdak"
#addname "Loten"
#addname "Namling"
#addname "Dakpo"
#addname "Chungdrag"
#addname "Shenphen"
#addname "Trungpa"
#addname "Chogyam"
#addname "Yeshe"
#addname "Nyantsen"
#addname "Tagbu"
#addname "Dgu-gri"
#addname "Nyasig"
#addname "Yumtn"
#addname "'Od-srung"
#addname "Thrikhyiding"
#addname "Kyide Nyign"
#addname "Byang Chub"
#addname "Phagpa"
#addname "Drogn"
#addname "Bzangpo"
#addname "Sherab"
#addname "Jungnay"
#addname "Rigdzing"
#addname "Desi"
#addname "Sangye"
#addname "Choga"
#addname "Drigum"
#addname "Songtsn"
#addname "Gampo"
#addname "Nyatri"
#addname "Drengen"
#addname "Changchop"
#addname "Simpa"
#addname "Khri-lde-srong-brtsan"
#addname "Relpachen"
#addname "Lhasras"
#addname "gTsangma"
#addname "Zhang 'Bro sTag"
#addname "Tride"
#addname "Sadnalegs"
#addname "Trisong Detsen"
#addname "Mune"
#addname "Mutik"
#addname "Namri"
#addname "Songzen"
#addname "Lntsen"
#addname "Thnmi"
#addname "Sambhota"
#addname "Dus-rong"
#addname "Mang-po-rje"
#addname "Tridu"
#addname "Mangsong"
#addname "Mangtsen"
#addname "Trimang"
#addname "Lntsn"
#addname "Myang"
#addname "Gung-srong"
#addname "Gungtsen"
#addname "Mutri"
#addname "Dsum"
#addname "Snam"
#addname "Dudjom"
#addname "Lungshar"
#addname "Lhalu"
#addname "mGar stong-btsan"
#addname "Tsangyang"
#addname "Khedrub Je"
#addname "Deshin Shekpa"
#addname "Gongkar"
#addname "Pelzang"
#addname "Thekchok"
#addname "Chdrag"
#addname "Dnden"
#addname "Goshir Paljor Dndrub"
#addname "Dromtnpa"
#addname "Djang Jup"
#addname "Pema"
#addname "Depa Deyrab"
#addname "Reting"
#addname "Bardor"
#addname "Goshir"
#addname "Ringu"
#addname "Tsem"
#addname "Naro Bonchung"
#end





------------------------------------------------------------------------------
-- MAGIC SITES
------------------------------------------------------------------------------


#newsite 821
#name "Mount Yung-Drung"
#path 1
#level 4
#rarity 5
#gems 1 1
#gems 3 1
#homemon 3717
#homecom 3727
#end


#newsite 822
#name "Hidden City of Shangri-La"
#path 4
#level 4
#rarity 5
#gems 4 2
#gems 3 1
#homemon 3714
#homecom 3722
#homecom 3731
#end




------------------------------------------------------------------------------
-- NATION
------------------------------------------------------------------------------


#selectnation 88
#name "Shangri-La"
#epithet "Hidden City of the Secret Masters"
#era 2
#descr "In a hidden valley in the high mountains of the Bhd kingdom, a secret order of enlightened priest-mages, exiled from their old home, have arrived with their servants, conquering the Bhd tribes and gaining the cooperation of the ape-like Mi G. Having found the ancient records and secret knowledge of a long-dead people, these Hidden Masters rule over the secret city of Shangri-La, where they use manipulation and deceit to control the Bhdpa and to keep outsiders away from their refuge. Meanwhile, they study arcane and mystical secrets to achieve enlightenment and transcend mortality itself. Now, with the rise of the new religion, the Hidden Masters of Shangri-La use their knowledge, power and military might to fight their ascendant god's enemies."

#summary "Race: Humans and ape-like Mi G. Prefers cold 2.


Military: Stealthy Bhdpa light infantry, Shangrilan heavy infantry, heavy horse and light yak cavalry, and Mi G warriors.

Magic: Access to all paths. Very strong in Astral, and strong in Air and Earth as well.  Weakest in Fire, Water, and Nature.  A variety of summonable creatures, demons and spirits of the mountains.

Priests: Very powerful; all priests are also mages."


#brief "Shangri-La is a nation centered around a hidden mountain city ruled by a powerful and secretive order of priest-mages who seek spiritual ascension. The tribesmen of the Bhd mountain kingdom and the Mi G, descendants of a very old race, fight along with the Shangrilans."
#flag "./Shangri_La/Shangri_La_flag.tga"

-- scoregraph color --
#color 1 0.8 0.1

#clearrec
#clearsites


#addrecunit 3702 -- Bhdpa Spearman
#addrecunit 3703 -- Bhdpa Archer
#addrecunit 3704 -- Bhdpa Warrior
#addrecunit 3705 -- Bhdpa Yak Rider
#addrecunit 3706 -- Bhdpa Horseman
#addrecunit 3707 -- Shangrilan Archer
#addrecunit 3708 -- Shangrilan Crossbowmen
#addrecunit 3709 -- Shangrilan Heavy Infantry (Polearm)
#addrecunit 3710 -- Shangrilan Heavy Infantry (Sword/Shield)
#addrecunit 3711 -- Dmag Dar (Shangrilan Banner-Bearer)
#addrecunit 3712 -- Dmag Hrag (Shangrilan Elite Infantry)
#addrecunit 3713 -- Rta Pa (Shangrilan Heavy Cavalry)
#addrecunit 3715 -- Mi G
#addrecunit 3716 -- Mi G Hunter

-- Capital-only
-- 3714 -- Guardian of the Hidden Valley (Shangrilan Sacred)
-- 3717 -- Mi Dred (Mi G Sacred)

#addreccom 3718 -- Bhdpa Scout
#addreccom 3719 -- Bhdpa Sde Pa (Clan Chief)
#addreccom 3720 -- Dmag Dpon (Shangrilan Officer)
#addreccom 3721 -- Rta Dmag Go (Shangrilan Cavalry Commander)
#addreccom 3723 -- Drapa (Shangrilan Monk)
#addreccom 3724 -- Ngagspa (Sorcerer)
#addreccom 3725 -- Ragyapa (Priest)
#addreccom 3728 -- Nyingmapa (Red-Hat Lama)
#addreccom 3729 -- Gelug (Yellow-Hat Lama)
#addreccom 3730 -- Karmapa (Black-Hat Lama)

-- Capital-only
-- 3722 -- Rje (Shangrilan King)
-- 3727 -- Wise One (Mi G Sacred Mage/Healer)
-- 3731 -- Hidden Master (Top-Tier Mage/Priest)


------------------------------------------------------------------------------
TESTING SECTION
------------------------------------------------------------------------------

Heroes

-addreccom 3732 -- Tlku (Boy Mage-Priest Multihero)
-addreccom 3733 -- Ascended One (Multihero)
-addreccom 3734 -- Demon Slayer (Demon Hunter Hero)


Temporary Units

-addrecunit 3735 -- Yak (temporary riderless Yak Rider)


Summons

-addrecunit 3736 -- Yeti

-addreccom 3737 -- Btsan (Demon Archer)

-addrecunit 3738 -- Bdud (Earth Demon Warrior with Great Club)
-addrecunit 3739 -- Bdud Warrior (Earth Demon Warrior with Armor and Battleaxe)

-addreccom 3740 -- Srin Po (Man-Eating Demon Mage)
-addreccom 3741 -- Srin Po Swordsman (Man-Eating Demon Mage with Sword)

-addreccom 3742 -- Theurang (Lesser Lha Spirit Mage -- Sacred)
-addreccom 3743 -- Lha (Lha Spirit Mage -- Sacred)
-addrecunit 3744 -- Dgra Lha (Lha Warrior -- Sacred)

-addrecunit 3745 -- Snow Lion

-addreccom 3746 -- Klu (Naga) in Serpent Form
-addreccom 3747 -- Klu (Naga) in Human Form

-addrecunit 3748 -- Citipati (Undead)


------------------------------------------------------------------------------
END TESTING SECTION
------------------------------------------------------------------------------


#defcom1 3719 -- Bhdpa Sde Pa (Clan Chief)
#defcom2 3723 -- Shangrilan Monk

#defunit1 3702 -- Bhdpa Spearman
#defmult1 20

#defunit1b 3703 -- Bhdpa Archer
#defmult1b 15
-- defmult1b 20 does not work properly (Johan K verified this in the forums)

#defunit2 3705 -- Bhdpa Yak Rider
#defmult2 10

#defunit2b 3715 -- Mi G
#defmult2b 10

#hero1 3732 -- Tlku (Boy Mage-Priest Hero)
#multihero1 3734 -- Demon Slayer (Demon Hunter Multi-Hero)
#multihero2 3733 -- Ascended One Multihero

#idealcold 2

#startcom 3720 -- Shangrilan Dmag Dpon
#startscout 3718 -- Bhdpa Scout

#startsite "Hidden City of Shangri-La"
#startsite "Mount Yung-Drung"

#startunittype1 3707 -- Shangrilan Archer
#startunitnbrs1 12
#startunittype2 3709 -- Shangrilan Heavy Infantry (Polearm)
#startunitnbrs2 12

#templepic 18
#startfort 42 -- Mountain City (1400g, admin 30)
#defaultfort 20 -- River Fortress (800g, admin 20)
#farmfort 3 -- Fortified City (1200g, admin 50)
#mountainfort 9 -- Mountain Citadel (1200g, admin 20)
#forestfort 34 -- Forest Fortress (1000g, admin 15)
#swampfort 11 -- Swamp Fort (800g, admin 0)
-- swampfort 17 -- Wizard's Tower (600g, admin 30)

-- GLOBU'S CHANGE:

-- Wizard's Tower doesn't seem right; these guys have no reason to be better
-- at swamp fortress building than anyone else, and Wizard's Towers are
-- highly advantageous for *any* terrain.

#end
