/*
 * Decompiled with CFR 0.152.
 */
package org.larz.dom3.dm.validation;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.larz.dom3.dm.dm.AbstractElement;
import org.larz.dom3.dm.dm.DmPackage;
import org.larz.dom3.dm.dm.Dom3Mod;
import org.larz.dom3.dm.dm.NewArmor;
import org.larz.dom3.dm.dm.NewMonster;
import org.larz.dom3.dm.dm.NewSite;
import org.larz.dom3.dm.dm.NewWeapon;
import org.larz.dom3.dm.dm.SelectArmorById;
import org.larz.dom3.dm.dm.SelectArmorByName;
import org.larz.dom3.dm.dm.SelectMonsterById;
import org.larz.dom3.dm.dm.SelectMonsterByName;
import org.larz.dom3.dm.dm.SelectName;
import org.larz.dom3.dm.dm.SelectNation;
import org.larz.dom3.dm.dm.SelectSiteById;
import org.larz.dom3.dm.dm.SelectSiteByName;
import org.larz.dom3.dm.dm.SelectWeaponById;
import org.larz.dom3.dm.dm.SelectWeaponByName;
import org.larz.dom3.dm.validation.AbstractDmJavaValidator;
import org.larz.dom3.dm.validation.Messages;

public class DmJavaValidator
extends AbstractDmJavaValidator {
    public static final int MIN_ARMOR_ID = 200;
    public static final int MAX_ARMOR_ID = 399;
    public static final int MIN_WEAPON_ID = 600;
    public static final int MAX_WEAPON_ID = 999;
    public static final int MIN_MONSTER_ID = 2200;
    public static final int MAX_MONSTER_ID = 2999;
    public static final int MIN_NAME_ID = 100;
    public static final int MAX_NAME_ID = 200;
    public static final int MIN_SITE_ID = 750;
    public static final int MAX_SITE_ID = 999;
    public static final int MIN_NATION_ID = 0;
    public static final int MAX_NATION_ID = 94;

    @Check(value=CheckType.EXPENSIVE)
    public void checkNewArmorIds(NewArmor armor) {
        if (armor.getValue() < 200 || armor.getValue() > 399) {
            this.warning(Messages.format("ArmorRangeWarning.fmt", 200, 399), (EStructuralFeature)DmPackage.eINSTANCE.getNewArmor_Value());
            return;
        }
        if (this.getContext().containsKey("NewArmorId")) {
            if (((Set)this.getContext().get("NewArmorId")).contains(armor.getValue())) {
                this.warning(Messages.format("DuplicateNewArmor.fmt", armor.getValue()), (EStructuralFeature)DmPackage.eINSTANCE.getNewArmor_Value());
            }
            return;
        }
        HashSet<Integer> armorIds = new HashSet<Integer>();
        HashSet<Integer> dupArmorIds = new HashSet<Integer>();
        Dom3Mod mod = (Dom3Mod)armor.eContainer();
        EList<AbstractElement> elements = mod.getElements();
        for (AbstractElement element : elements) {
            if (!(element instanceof NewArmor)) continue;
            NewArmor newArmor = (NewArmor)element;
            if (armorIds.contains(newArmor.getValue())) {
                dupArmorIds.add(newArmor.getValue());
            } else {
                armorIds.add(newArmor.getValue());
            }
            if (armor.equals(newArmor) || armor.getValue() != newArmor.getValue()) continue;
            this.warning(Messages.format("DuplicateNewArmor.fmt", armor.getValue()), (EStructuralFeature)DmPackage.eINSTANCE.getNewArmor_Value());
        }
        this.getContext().put("NewArmorId", dupArmorIds);
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkSelectArmorIds(SelectArmorById armor) {
        if (this.getContext().containsKey("SelectArmorId")) {
            if (((Set)this.getContext().get("SelectArmorId")).contains(armor.getValue())) {
                this.warning(Messages.format("DuplicateSelectArmor.fmt", armor.getValue()), (EStructuralFeature)DmPackage.eINSTANCE.getSelectArmorById_Value());
            }
            return;
        }
        HashSet<Integer> armorIds = new HashSet<Integer>();
        HashSet<Integer> dupArmorIds = new HashSet<Integer>();
        Dom3Mod mod = (Dom3Mod)armor.eContainer();
        EList<AbstractElement> elements = mod.getElements();
        for (AbstractElement element : elements) {
            if (!(element instanceof SelectArmorById)) continue;
            SelectArmorById newArmor = (SelectArmorById)element;
            if (armorIds.contains(newArmor.getValue())) {
                dupArmorIds.add(newArmor.getValue());
            } else {
                armorIds.add(newArmor.getValue());
            }
            if (armor.equals(newArmor) || armor.getValue() != newArmor.getValue()) continue;
            this.warning(Messages.format("DuplicateSelectArmor.fmt", armor.getValue()), (EStructuralFeature)DmPackage.eINSTANCE.getSelectArmorById_Value());
        }
        this.getContext().put("SelectArmorId", dupArmorIds);
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkSelectArmorNames(SelectArmorByName armor) {
        if (this.getContext().containsKey("SelectArmorName")) {
            if (((Set)this.getContext().get("SelectArmorName")).contains(armor.getValue())) {
                this.warning(Messages.format("DuplicateSelectArmorName.fmt", armor.getValue()), (EStructuralFeature)DmPackage.eINSTANCE.getSelectArmorByName_Value());
            }
            return;
        }
        HashSet<String> armorNames = new HashSet<String>();
        HashSet<String> dupArmorNames = new HashSet<String>();
        Dom3Mod mod = (Dom3Mod)armor.eContainer();
        EList<AbstractElement> elements = mod.getElements();
        for (AbstractElement element : elements) {
            if (!(element instanceof SelectArmorByName)) continue;
            SelectArmorByName newArmor = (SelectArmorByName)element;
            if (armorNames.contains(newArmor.getValue())) {
                dupArmorNames.add(newArmor.getValue());
            } else {
                armorNames.add(newArmor.getValue());
            }
            if (armor.equals(newArmor) || !armor.getValue().equals(newArmor.getValue())) continue;
            this.warning(Messages.format("DuplicateSelectArmorName.fmt", armor.getValue()), (EStructuralFeature)DmPackage.eINSTANCE.getSelectArmorByName_Value());
        }
        this.getContext().put("SelectArmorName", dupArmorNames);
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkWeaponIds(NewWeapon weapon) {
        if (weapon.getValue() < 600 || weapon.getValue() > 999) {
            this.warning(Messages.format("WeaponRangeWarning.fmt", 600, 999), (EStructuralFeature)DmPackage.eINSTANCE.getNewWeapon_Value());
            return;
        }
        if (this.getContext().containsKey("NewWeaponId")) {
            if (((Set)this.getContext().get("NewWeaponId")).contains(weapon.getValue())) {
                this.warning(Messages.format("DuplicateNewWeapon.fmt", weapon.getValue()), (EStructuralFeature)DmPackage.eINSTANCE.getNewWeapon_Value());
            }
            return;
        }
        HashSet<Integer> weaponIds = new HashSet<Integer>();
        HashSet<Integer> dupWeaponIds = new HashSet<Integer>();
        Dom3Mod mod = (Dom3Mod)weapon.eContainer();
        EList<AbstractElement> elements = mod.getElements();
        for (AbstractElement element : elements) {
            if (!(element instanceof NewWeapon)) continue;
            NewWeapon newWeapon = (NewWeapon)element;
            if (weaponIds.contains(newWeapon.getValue())) {
                dupWeaponIds.add(newWeapon.getValue());
            } else {
                weaponIds.add(newWeapon.getValue());
            }
            if (weapon.equals(newWeapon) || weapon.getValue() != newWeapon.getValue()) continue;
            this.warning(Messages.format("DuplicateNewWeapon.fmt", weapon.getValue()), (EStructuralFeature)DmPackage.eINSTANCE.getNewWeapon_Value());
        }
        this.getContext().put("NewWeaponId", dupWeaponIds);
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkSelectWeaponIds(SelectWeaponById weapon) {
        if (this.getContext().containsKey("SelectWeaponId")) {
            if (((Set)this.getContext().get("SelectWeaponId")).contains(weapon.getValue())) {
                this.warning(Messages.format("DuplicateSelectWeapon.fmt", weapon.getValue()), (EStructuralFeature)DmPackage.eINSTANCE.getSelectWeaponById_Value());
            }
            return;
        }
        HashSet<Integer> weaponIds = new HashSet<Integer>();
        HashSet<Integer> dupWeaponIds = new HashSet<Integer>();
        Dom3Mod mod = (Dom3Mod)weapon.eContainer();
        EList<AbstractElement> elements = mod.getElements();
        for (AbstractElement element : elements) {
            if (!(element instanceof SelectWeaponById)) continue;
            SelectWeaponById newWeapon = (SelectWeaponById)element;
            if (weaponIds.contains(newWeapon.getValue())) {
                dupWeaponIds.add(newWeapon.getValue());
            } else {
                weaponIds.add(newWeapon.getValue());
            }
            if (weapon.equals(newWeapon) || weapon.getValue() != newWeapon.getValue()) continue;
            this.warning(Messages.format("DuplicateSelectWeapon.fmt", weapon.getValue()), (EStructuralFeature)DmPackage.eINSTANCE.getSelectWeaponById_Value());
        }
        this.getContext().put("SelectWeaponId", dupWeaponIds);
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkSelectWeaponNames(SelectWeaponByName weapon) {
        if (this.getContext().containsKey("SelectWeaponName")) {
            if (((Set)this.getContext().get("SelectWeaponName")).contains(weapon.getValue())) {
                this.warning(Messages.format("DuplicateSelectWeaponName.fmt", weapon.getValue()), (EStructuralFeature)DmPackage.eINSTANCE.getSelectWeaponByName_Value());
            }
            return;
        }
        HashSet<String> weaponIds = new HashSet<String>();
        HashSet<String> dupWeaponIds = new HashSet<String>();
        Dom3Mod mod = (Dom3Mod)weapon.eContainer();
        EList<AbstractElement> elements = mod.getElements();
        for (AbstractElement element : elements) {
            if (!(element instanceof SelectWeaponByName)) continue;
            SelectWeaponByName newWeapon = (SelectWeaponByName)element;
            if (weaponIds.contains(newWeapon.getValue())) {
                dupWeaponIds.add(newWeapon.getValue());
            } else {
                weaponIds.add(newWeapon.getValue());
            }
            if (weapon.equals(newWeapon) || !weapon.getValue().equals(newWeapon.getValue())) continue;
            this.warning(Messages.format("DuplicateSelectWeaponName.fmt", weapon.getValue()), (EStructuralFeature)DmPackage.eINSTANCE.getSelectWeaponByName_Value());
        }
        this.getContext().put("SelectWeaponName", dupWeaponIds);
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkMonsterIds(NewMonster monster) {
        if (monster.getValue() < 2200 || monster.getValue() > 2999) {
            this.warning(Messages.format("UnitRangeWarning.fmt", 2200, 2999), (EStructuralFeature)DmPackage.eINSTANCE.getNewMonster_Value());
            return;
        }
        if (this.getContext().containsKey("NewMonsterId")) {
            if (((Set)this.getContext().get("NewMonsterId")).contains(monster.getValue())) {
                this.warning(Messages.format("DuplicateNewUnit.fmt", monster.getValue()), (EStructuralFeature)DmPackage.eINSTANCE.getNewMonster_Value());
            }
            return;
        }
        HashSet<Integer> monsterIds = new HashSet<Integer>();
        HashSet<Integer> dupMonsterIds = new HashSet<Integer>();
        Dom3Mod mod = (Dom3Mod)monster.eContainer();
        EList<AbstractElement> elements = mod.getElements();
        for (AbstractElement element : elements) {
            if (!(element instanceof NewMonster)) continue;
            NewMonster newMonster = (NewMonster)element;
            if (monsterIds.contains(newMonster.getValue())) {
                dupMonsterIds.add(newMonster.getValue());
            } else {
                monsterIds.add(newMonster.getValue());
            }
            if (monster.equals(newMonster) || monster.getValue() != newMonster.getValue()) continue;
            this.warning(Messages.format("DuplicateNewUnit.fmt", monster.getValue()), (EStructuralFeature)DmPackage.eINSTANCE.getNewMonster_Value());
        }
        this.getContext().put("NewMonsterId", dupMonsterIds);
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkSelectMonsterIds(SelectMonsterById monster) {
        if (this.getContext().containsKey("SelectMonsterId")) {
            if (((Set)this.getContext().get("SelectMonsterId")).contains(monster.getValue())) {
                this.warning(Messages.format("DuplicateSelectUnit.fmt", monster.getValue()), (EStructuralFeature)DmPackage.eINSTANCE.getSelectMonsterById_Value());
            }
            return;
        }
        HashSet<Integer> monsterIds = new HashSet<Integer>();
        HashSet<Integer> dupMonsterIds = new HashSet<Integer>();
        Dom3Mod mod = (Dom3Mod)monster.eContainer();
        EList<AbstractElement> elements = mod.getElements();
        for (AbstractElement element : elements) {
            if (!(element instanceof SelectMonsterById)) continue;
            SelectMonsterById newMonster = (SelectMonsterById)element;
            if (monsterIds.contains(newMonster.getValue())) {
                dupMonsterIds.add(newMonster.getValue());
            } else {
                monsterIds.add(newMonster.getValue());
            }
            if (monster.equals(newMonster) || monster.getValue() != newMonster.getValue()) continue;
            this.warning(Messages.format("DuplicateSelectUnit.fmt", monster.getValue()), (EStructuralFeature)DmPackage.eINSTANCE.getSelectMonsterById_Value());
        }
        this.getContext().put("SelectMonsterId", dupMonsterIds);
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkSelectMonsterNames(SelectMonsterByName monster) {
        if (this.getContext().containsKey("SelectMonsterName")) {
            if (((Set)this.getContext().get("SelectMonsterName")).contains(monster.getValue())) {
                this.warning(Messages.format("DuplicateSelectUnitName.fmt", monster.getValue()), (EStructuralFeature)DmPackage.eINSTANCE.getSelectMonsterByName_Value());
            }
            return;
        }
        HashSet<String> monsterIds = new HashSet<String>();
        HashSet<String> dupMonsterIds = new HashSet<String>();
        Dom3Mod mod = (Dom3Mod)monster.eContainer();
        EList<AbstractElement> elements = mod.getElements();
        for (AbstractElement element : elements) {
            if (!(element instanceof SelectMonsterByName)) continue;
            SelectMonsterByName newMonster = (SelectMonsterByName)element;
            if (monsterIds.contains(newMonster.getValue())) {
                dupMonsterIds.add(newMonster.getValue());
            } else {
                monsterIds.add(newMonster.getValue());
            }
            if (monster.equals(newMonster) || !monster.getValue().equals(newMonster.getValue())) continue;
            this.warning(Messages.format("DuplicateSelectUnitName.fmt", monster.getValue()), (EStructuralFeature)DmPackage.eINSTANCE.getSelectMonsterByName_Value());
        }
        this.getContext().put("SelectMonsterName", dupMonsterIds);
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkNameIds(SelectName name) {
        if (name.getValue() < 100 || name.getValue() > 200) {
            this.warning(Messages.format("NametypeRangeWarning.fmt", 100, 200), (EStructuralFeature)DmPackage.eINSTANCE.getSelectName_Value());
            return;
        }
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkSiteIds(NewSite site) {
        if (site.getValue() < 750 || site.getValue() > 999) {
            this.warning(Messages.format("SiteRangeWarning.fmt", 750, 999), (EStructuralFeature)DmPackage.eINSTANCE.getNewSite_Value());
            return;
        }
        if (this.getContext().containsKey("NewSiteId")) {
            if (((Set)this.getContext().get("NewSiteId")).contains(site.getValue())) {
                this.warning(Messages.format("DuplicateNewSite.fmt", site.getValue()), (EStructuralFeature)DmPackage.eINSTANCE.getNewSite_Value());
            }
            return;
        }
        HashSet<Integer> siteIds = new HashSet<Integer>();
        HashSet<Integer> dupSiteIds = new HashSet<Integer>();
        Dom3Mod mod = (Dom3Mod)site.eContainer();
        EList<AbstractElement> elements = mod.getElements();
        for (AbstractElement element : elements) {
            if (!(element instanceof NewSite)) continue;
            NewSite newSite = (NewSite)element;
            if (siteIds.contains(newSite.getValue())) {
                dupSiteIds.add(newSite.getValue());
            } else {
                siteIds.add(newSite.getValue());
            }
            if (site.equals(newSite) || site.getValue() != newSite.getValue()) continue;
            this.warning(Messages.format("DuplicateNewSite.fmt", site.getValue()), (EStructuralFeature)DmPackage.eINSTANCE.getNewSite_Value());
        }
        this.getContext().put("NewSiteId", dupSiteIds);
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkSelectSiteIds(SelectSiteById site) {
        if (this.getContext().containsKey("SelectSiteId")) {
            if (((Set)this.getContext().get("SelectSiteId")).contains(site.getValue())) {
                this.warning(Messages.format("DuplicateSelectSite.fmt", site.getValue()), (EStructuralFeature)DmPackage.eINSTANCE.getSelectSiteById_Value());
            }
            return;
        }
        HashSet<Integer> siteIds = new HashSet<Integer>();
        HashSet<Integer> dupSiteIds = new HashSet<Integer>();
        Dom3Mod mod = (Dom3Mod)site.eContainer();
        EList<AbstractElement> elements = mod.getElements();
        for (AbstractElement element : elements) {
            if (!(element instanceof SelectSiteById)) continue;
            SelectSiteById newSite = (SelectSiteById)element;
            if (siteIds.contains(newSite.getValue())) {
                dupSiteIds.add(newSite.getValue());
            } else {
                siteIds.add(newSite.getValue());
            }
            if (site.equals(newSite) || site.getValue() != newSite.getValue()) continue;
            this.warning(Messages.format("DuplicateSelectSite.fmt", site.getValue()), (EStructuralFeature)DmPackage.eINSTANCE.getSelectSiteById_Value());
        }
        this.getContext().put("SelectSiteId", dupSiteIds);
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkSelectSiteNames(SelectSiteByName site) {
        if (this.getContext().containsKey("SelectSiteName")) {
            if (((Set)this.getContext().get("SelectSiteName")).contains(site.getValue())) {
                this.warning(Messages.format("DuplicateSelectSiteName.fmt", site.getValue()), (EStructuralFeature)DmPackage.eINSTANCE.getSelectSiteByName_Value());
            }
            return;
        }
        HashSet<String> siteIds = new HashSet<String>();
        HashSet<String> dupSiteIds = new HashSet<String>();
        Dom3Mod mod = (Dom3Mod)site.eContainer();
        EList<AbstractElement> elements = mod.getElements();
        for (AbstractElement element : elements) {
            if (!(element instanceof SelectSiteByName)) continue;
            SelectSiteByName newSite = (SelectSiteByName)element;
            if (siteIds.contains(newSite.getValue())) {
                dupSiteIds.add(newSite.getValue());
            } else {
                siteIds.add(newSite.getValue());
            }
            if (site.equals(newSite) || !site.getValue().equals(newSite.getValue())) continue;
            this.warning(Messages.format("DuplicateSelectSiteName.fmt", site.getValue()), (EStructuralFeature)DmPackage.eINSTANCE.getSelectSiteByName_Value());
        }
        this.getContext().put("SelectSiteName", dupSiteIds);
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkNationIds(SelectNation nation) {
        if (nation.getValue() < 0 || nation.getValue() > 94) {
            this.warning(Messages.format("NationRangeWarning.fmt", 0, 94), (EStructuralFeature)DmPackage.eINSTANCE.getSelectNation_Value());
            return;
        }
        if (this.getContext().containsKey("SelectNationId")) {
            if (((Set)this.getContext().get("SelectNationId")).contains(nation.getValue())) {
                this.warning(Messages.format("DuplicateSelectNation.fmt", nation.getValue()), (EStructuralFeature)DmPackage.eINSTANCE.getSelectNation_Value());
            }
            return;
        }
        HashSet<Integer> nationIds = new HashSet<Integer>();
        HashSet<Integer> dupNationIds = new HashSet<Integer>();
        Dom3Mod mod = (Dom3Mod)nation.eContainer();
        EList<AbstractElement> elements = mod.getElements();
        for (AbstractElement element : elements) {
            if (!(element instanceof SelectNation)) continue;
            SelectNation newNation = (SelectNation)element;
            if (nationIds.contains(newNation.getValue())) {
                dupNationIds.add(newNation.getValue());
            } else {
                nationIds.add(newNation.getValue());
            }
            if (nation.equals(newNation) || nation.getValue() != newNation.getValue()) continue;
            this.warning(Messages.format("DuplicateSelectNation.fmt", nation.getValue()), (EStructuralFeature)DmPackage.eINSTANCE.getSelectNation_Value());
        }
        this.getContext().put("SelectNationId", dupNationIds);
    }
}

