/*
 * Decompiled with CFR 0.152.
 */
package templatizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import templatizer.Field;
import templatizer.Function;
import templatizer.NumberRange;
import templatizer.Record;
import templatizer.TechGridArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainForm
extends JFrame {
    private String superGlobals = "";
    private ArrayList<Function> functions = new ArrayList();
    private String outFileName = null;
    private DataOutputStream outFile = null;
    private boolean allDone = false;
    private String calcPath = "calc";
    private String[] args = new String[0];
    private JLabel lblRecordStatus;
    private JLabel lblStatus;
    private JProgressBar pbProgress;
    private JProgressBar pbRecordProgress;
    private JPanel pnlStatus;

    public MainForm() {
        this.initComponents();
    }

    public MainForm(String[] args) {
        this.initComponents();
        this.args = args;
    }

    private void initComponents() {
        this.pbRecordProgress = new JProgressBar();
        this.pbProgress = new JProgressBar();
        this.pnlStatus = new JPanel();
        this.lblRecordStatus = new JLabel();
        this.lblStatus = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("SE4 Templatizer v3.0.3");
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent evt) {
                MainForm.this.formWindowOpened(evt);
            }
        });
        this.pbRecordProgress.setMinimumSize(new Dimension(320, 16));
        this.pbRecordProgress.setPreferredSize(new Dimension(480, 16));
        this.getContentPane().add((Component)this.pbRecordProgress, "North");
        this.pbProgress.setMinimumSize(new Dimension(320, 16));
        this.pbProgress.setPreferredSize(new Dimension(480, 16));
        this.getContentPane().add((Component)this.pbProgress, "Center");
        this.pnlStatus.setLayout(new BorderLayout());
        this.pnlStatus.setMinimumSize(new Dimension(320, 16));
        this.pnlStatus.setPreferredSize(new Dimension(480, 16));
        this.lblRecordStatus.setHorizontalAlignment(0);
        this.lblRecordStatus.setText("Record Status");
        this.lblRecordStatus.setAlignmentX(0.5f);
        this.lblRecordStatus.setHorizontalTextPosition(0);
        this.lblRecordStatus.setMinimumSize(new Dimension(240, 16));
        this.lblRecordStatus.setPreferredSize(new Dimension(240, 16));
        this.pnlStatus.add((Component)this.lblRecordStatus, "West");
        this.lblStatus.setHorizontalAlignment(0);
        this.lblStatus.setText("Templatizer Status");
        this.lblStatus.setAlignmentX(0.5f);
        this.lblStatus.setHorizontalTextPosition(0);
        this.lblStatus.setMinimumSize(new Dimension(240, 16));
        this.lblStatus.setPreferredSize(new Dimension(240, 16));
        this.pnlStatus.add((Component)this.lblStatus, "East");
        this.getContentPane().add((Component)this.pnlStatus, "South");
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
        String inFileName;
        try {
            DataInputStream inFile = new DataInputStream(new FileInputStream("calc-path.txt"));
            this.calcPath = inFile.readLine();
            inFile.close();
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this, "Could not load calc-path.txt. Using default calc path of \"calc\".\n" + ex.getStackTrace()[0]);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Could not load calc-path.txt. Using default calc path of \"calc\".\n" + ex.getStackTrace()[0]);
        }
        this.lblStatus.setText("Awaiting user input...");
        if (this.args.length > 0) {
            inFileName = this.args[0];
        } else {
            FileDialog dlg1 = new FileDialog((Frame)this, "Please select a template file", 0);
            dlg1.setVisible(true);
            inFileName = dlg1.getDirectory() + dlg1.getFile();
            if (dlg1.getFile() == null) {
                Runtime.getRuntime().exit(1);
            }
        }
        this.lblStatus.setText("Reading input file...");
        ArrayList<String> input = new ArrayList<String>();
        try {
            DataInputStream inFile = new DataInputStream(new FileInputStream(inFileName));
            boolean done = false;
            do {
                String line;
                if ((line = inFile.readLine()) == null) {
                    done = true;
                    continue;
                }
                input.add(line);
            } while (!done);
            inFile.close();
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage() + "\n" + ex.getStackTrace()[0]);
            Runtime.getRuntime().exit(1);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage() + "\n" + ex.getStackTrace()[0]);
            Runtime.getRuntime().exit(1);
        }
        this.lblStatus.setText("Awaiting user input...");
        FileDialog dlg2 = new FileDialog((Frame)this, "Please select an output file", 1);
        dlg2.setDirectory(new File(inFileName).getParent());
        dlg2.setVisible(true);
        this.outFileName = dlg2.getDirectory() + dlg2.getFile();
        if (dlg2.getFile() == null) {
            Runtime.getRuntime().exit(1);
        }
        if (new File(this.outFileName).exists() && JOptionPane.showConfirmDialog(this, "Really overwrite " + this.outFileName + "?") != 0) {
            Runtime.getRuntime().exit(1);
        }
        new File(this.outFileName).delete();
        this.lblStatus.setText("Converting input file to records...");
        ArrayList<Record> records = new ArrayList<Record>();
        Record curRecord = new Record();
        for (String line : input) {
            if (line.equals("") || line == null) {
                records.add(curRecord);
                curRecord = new Record();
                continue;
            }
            if (!line.contains(":=") || line.length() < 2 || line.trim().substring(0, 1) == "//") continue;
            int separatorPos = line.indexOf(":=");
            String key = line.substring(0, separatorPos - 1).trim();
            String value = line.substring(separatorPos + 2, line.length()).trim();
            try {
                curRecord.add(new Field(line));
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage() + "\n" + ex.getStackTrace()[0]);
            }
        }
        if (curRecord.size() > 0) {
            records.add(curRecord);
        }
        this.pbProgress.setMaximum(records.size());
        int recNum = 0;
        try {
            this.outFile = new DataOutputStream(new FileOutputStream(this.outFileName));
            this.outFile.writeBytes("*BEGIN*\r\n\r\n\r\n");
            for (Record record : records) {
                int i;
                this.lblStatus.setText("Processing template " + (recNum + 1) + " of " + records.size());
                this.pbProgress.setValue(recNum);
                this.paintEverything();
                boolean hasFields = false;
                for (i = 0; i < record.size(); ++i) {
                    Field field = (Field)record.get(i);
                    String key = field.getKey();
                    String value = this.removeComment(field.getValue());
                    if (key.length() >= 1 && key.charAt(0) == '*') {
                        this.functions.add(new Function(Function.Type.GLOBAL, new Field(field.getKey().substring(1), this.removeComment(field.getValue()))));
                        record.remove(field);
                        --i;
                        continue;
                    }
                    if (key.length() >= 1 && key.charAt(0) == '@') {
                        this.functions.add(new Function(Function.Type.LOCAL, new Field(field.getKey().substring(1), this.removeComment(field.getValue()))));
                        record.remove(field);
                        --i;
                        continue;
                    }
                    if (key.length() >= 1 && key.charAt(0) == '#') {
                        if (!value.contains("..")) {
                            JOptionPane.showMessageDialog(this, "Tech grid area value " + value + " does not contain two consecutive periods.");
                            Runtime.getRuntime().exit(1);
                        }
                        int periodPos = value.indexOf("..");
                        Integer min = Integer.parseInt(this.evaluate(value.substring(0, periodPos), false, 0));
                        Integer max = Integer.parseInt(this.evaluate(this.removeComment(value.substring(periodPos + 2, value.length())), false, 0));
                        this.functions.add(new Function(Function.Type.GRID, new TechGridArea(key.substring(1), min.toString(), max.toString(), min)));
                        record.remove(field);
                        --i;
                        continue;
                    }
                    hasFields = true;
                }
                if (hasFields) {
                    this.gridRecord(record);
                }
                ++recNum;
                for (i = 0; i < this.functions.size(); ++i) {
                    Function function = this.functions.get(i);
                    if (function.getType() == Function.Type.GLOBAL) continue;
                    this.functions.remove(function);
                    --i;
                }
            }
            this.outFile.writeBytes("*END*");
            this.outFile.close();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage() + "\n");
            try {
                this.outFile.close();
            }
            catch (IOException ex2) {
                JOptionPane.showMessageDialog(this, ex2.getMessage() + "\n");
                Runtime.getRuntime().exit(1);
            }
            Runtime.getRuntime().exit(1);
        }
        Runtime.getRuntime().exit(0);
    }

    private String getAllFunctions() {
        String result = "";
        for (Function function : this.functions) {
            if (function.getType() == Function.Type.GRID) {
                TechGridArea grid = (TechGridArea)function.getField();
                result = result + grid.getName() + " = " + grid.getCurrent() + ";";
                continue;
            }
            Field field = (Field)function.getField();
            if (field.getKey().contains("(")) {
                result = result + "define " + field.getKey() + " = " + field.getValue() + ";";
                continue;
            }
            result = result + field.getKey() + " = " + field.getValue() + ";";
        }
        return result;
    }

    private String evaluate(String value, boolean isWeaponDamage, int range) {
        boolean inExpression = false;
        String result = "";
        String text = "";
        int bracketsLevel = 0;
        boolean lastWasBackslash = false;
        for (char c : value.toCharArray()) {
            if (c == '[') {
                if (bracketsLevel == 0 && !lastWasBackslash) {
                    result = result + text;
                    text = "";
                    inExpression = true;
                } else {
                    text = text + c;
                }
                ++bracketsLevel;
                lastWasBackslash = false;
                continue;
            }
            if (c == ']' && inExpression) {
                if (bracketsLevel == 1) {
                    boolean loopMin = false;
                    boolean loopMax = false;
                    String args = isWeaponDamage ? this.getAllFunctions() + "range = " + range + ";" + text : this.getAllFunctions() + text;
                    String littleResult = "";
                    try {
                        ProcessBuilder pb = new ProcessBuilder(this.calcPath, "-c", "-d", "read", "templatizer-functions.txt", "\n", args);
                        pb.redirectErrorStream(true);
                        Process p = pb.start();
                        DataInputStream resultStream = new DataInputStream(p.getInputStream());
                        littleResult = resultStream.readLine().trim();
                        p.destroy();
                        if (littleResult != null && littleResult.length() > 0 && littleResult.charAt(0) == '\"') {
                            littleResult = littleResult.substring(1, littleResult.length() - 1);
                        }
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(this, ex.getMessage());
                        Runtime.getRuntime().exit(1);
                    }
                    result = isWeaponDamage && result.charAt(0) == '-' ? result + "0" : result + littleResult;
                    text = "";
                    inExpression = false;
                } else {
                    text = text + c;
                }
                --bracketsLevel;
                lastWasBackslash = false;
                continue;
            }
            if (c == '\\' && !lastWasBackslash) {
                lastWasBackslash = true;
                continue;
            }
            text = text + c;
            lastWasBackslash = false;
        }
        result = result + text;
        return result;
    }

    private String removeComment(String text) {
        String result = "";
        int bracketsLevel = 0;
        boolean lastWasSlash = false;
        for (char c : text.toCharArray()) {
            if (c == '[') {
                ++bracketsLevel;
                lastWasSlash = false;
            } else if (c == ']') {
                --bracketsLevel;
                lastWasSlash = false;
            }
            if (c == '/' && bracketsLevel <= 0) {
                if (lastWasSlash) {
                    result = result.substring(0, text.length() - 2);
                    break;
                }
                lastWasSlash = true;
                break;
            }
            result = result + c;
            lastWasSlash = false;
        }
        return result;
    }

    private void gridRecord(Record record) throws IOException {
        int iterations = 1;
        ArrayList<TechGridArea> techGrids = this.getGrids();
        for (TechGridArea grid : techGrids) {
            int max = Integer.parseInt(this.evaluate(grid.getMaximum(), false, 0));
            int min = Integer.parseInt(this.evaluate(grid.getMinimum(), false, 0));
            int levels = max - min + 1;
            iterations *= levels;
        }
        this.pbRecordProgress.setMaximum(iterations);
        for (int i = 0; i < iterations; ++i) {
            this.pbRecordProgress.setValue(i);
            this.lblRecordStatus.setText("Generating record " + (i + 1) + " of " + iterations + " for this template");
            this.paintEverything();
            NumberRange weaponRange = new NumberRange("1", "20");
            for (Field field : record) {
                String key = field.getKey();
                String value = this.removeComment(field.getValue());
                if (key.length() >= 1 && key.charAt(0) == '~') {
                    if (!value.contains("..")) {
                        JOptionPane.showMessageDialog(this, "Weapon range value " + value + " does not contain two consecutive periods.");
                        Runtime.getRuntime().exit(1);
                    }
                    int periodPos = value.indexOf("..");
                    weaponRange = new NumberRange(value.substring(0, periodPos), value.substring(periodPos + 2, value.length() - 1));
                    continue;
                }
                if (key.equals("Weapon Damage At Rng")) {
                    int range;
                    this.outFile.writeBytes(key + " := ");
                    int minRange = Integer.parseInt(this.evaluate(weaponRange.getMinimum(), false, 0));
                    int maxRange = Integer.parseInt(this.evaluate(weaponRange.getMaximum(), false, 0));
                    for (range = 1; range < minRange; ++range) {
                        this.outFile.writeBytes("0 ");
                    }
                    for (range = minRange; range <= maxRange; ++range) {
                        this.outFile.writeBytes(this.evaluate(value, true, range) + " ");
                    }
                    for (range = maxRange + 1; range < (minRange > 20 ? 21 : 20); ++range) {
                        this.outFile.writeBytes("0 ");
                    }
                    this.outFile.writeBytes("\r\n");
                    continue;
                }
                this.outFile.writeBytes(key + " := " + this.evaluate(value, false, 0) + "\r\n");
            }
            this.outFile.writeBytes("\r\n");
            try {
                this.incrementGrid(techGrids.size() - 1);
                continue;
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
        }
    }

    private void incrementGrid(int num) throws IllegalArgumentException {
        if (num < 0) {
            throw new IllegalArgumentException("Tried to increment the first tech grid area past its maximum.");
        }
        ArrayList<TechGridArea> grids = this.getGrids();
        TechGridArea grid = grids.get(num);
        if (grid.getCurrent() >= Integer.parseInt(this.evaluate(grid.getMaximum(), false, 0))) {
            for (int i = num; i < grids.size(); ++i) {
                TechGridArea otherGrid = grids.get(i);
                otherGrid.setCurrent(Integer.parseInt(this.evaluate(otherGrid.getMinimum(), false, 0)));
            }
            this.incrementGrid(num - 1);
        } else {
            grid.setCurrent(grid.getCurrent() + 1);
        }
    }

    private void paintEverything() {
        this.paint(this.getGraphics());
        this.pnlStatus.paint(this.pnlStatus.getGraphics());
        this.lblStatus.paint(this.lblStatus.getGraphics());
        this.lblRecordStatus.paint(this.lblRecordStatus.getGraphics());
    }

    private ArrayList<TechGridArea> getGrids() {
        ArrayList<TechGridArea> techGrids = new ArrayList<TechGridArea>();
        for (Function function : this.functions) {
            if (function.getType() != Function.Type.GRID) continue;
            techGrids.add((TechGridArea)function.getField());
        }
        return techGrids;
    }

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new MainForm(args).setVisible(true);
            }
        });
    }
}

