/* LICENSED UNDER THE TERMS OF THE LGPL
 * http://www.gnu.org/copyleft/lesser.html
 */

/*
 * Record.java
 * A record in a Malfador data file, consisting of a list of fields separated by
 * newlines; records in turn are separated by double newlines.
 * Created on February 18, 2005, 8:14 PM
 */

package templatizer;

import java.util.Enumeration;
import java.util.ArrayList;

/**
 *
 * @author koliset
 */
public class Record extends ArrayList<Field> {
	
	/** Creates a new instance of Record */
	public Record() {
	}
	
	public String toString() {
		// concatenate all fields
		String result = "";
		for (Field field : this) {
			result += field.toString();
			result += "\r\n";
		}
		return result;
	}
}
