//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include <stdio.h>
#include <clipbrd.hpp>

#include "WW2Map1.h"
#include "ReadShp.h"
#include "HexEdit.h"
#include "Import.h"
#include "Copy.h"
#include "Strat.h"
#include "Transfer.h"
#include "Jpeg.h"
#include "Contour.h"
#include "SDTS1.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TMainForm *MainForm;

#define SECTION2_SIZE 16000
#define SECTION28_SIZE 104000
#define SP2_S8_REC 12
#define SP3_S8_REC 19
#define WAW_S8_REC 20

#define  V1_1_START 0x14

#define MAX_VERT 200
#define MAX_HORI 160

#define MAX_TILES 204         //in file 25 most are less
//#define MAX_MAP 500000       //the map info for SP2 is 399082 bytes
                             //for SP3 461482 bytes
//section 17 is all 0xFF
//section 48 is all 0
//section 8  96000 for SP2 it holds altitude and is 12 long
//section 8 for sp3 is variable between 152000 &152115? 19 bytes/hex
//section 8 is 20 bytes for SPWAW
//SP2 Alt is byte 0; SP3 alt is byte 4;

//we will store all of the map info in one large buffer
//keeping offsets to each section in an array and
//the size of blocks in another
unsigned char mb[MAX_MAP];   //this hold all the map data
int moff[MAX_SECTIONS],ssz[MAX_SECTIONS];
int saddress;     //we use this to keep track of bytes as we load
boolean sexists[MAX_SECTIONS]; //we set this to read the sections that are
                     //present in the map file... set under FormCreate
//section 2 is the main tile
//section 28 is additional tiles in 13 byte records ... 14 bytes for waw
//byte 1 indicates how many tiles (up tp 6). If 0 bytes in
//record are ignored.
int edit_type;     //This defines whether sp2, sp3 or other

char tilespath[128];
AnsiString StartPath;

char Button='L';    //if left button down else 'R'
int MouseX,MouseY;  //mouse position of the map image
int WhereX,WhereY;  // x,y coordinates of current hex
int OldX=-1,OldY=-1;      //coordinates of last click
int tile_width=52;
int tile_height=44; //this is not actual but is 1/2 of 2 rows
int tile_half_width=26; //offset for odd rows
int fx0=-27,fy0=-12;   //offset coordinates for drawing tiles
int tiles_high=12,tiles_wide=14; //size of display area
int hexx0,hexy0;    //the coordinates of the top left hex

TColor HexColor= (TColor)0xFF8080;
TColor clOrange=(TColor)0x00080FF;
int OldPix[10][10];
boolean strat_change =true;
boolean transfer_function=false; //when calling read tile from the
                                 //transfer function... load the tiles
                                 //as separate bitmaps... not in the
                                 //image list

Graphics :: TBitmap *mbmp;  //for screem
Graphics :: TBitmap *qbmp;  //for saving a quad to jpg
struct ICON tiles[MAX_TERRAIN_FILES][MAX_TILES];

//the tiles used for slopes around hills are stored in S28
//there are a max of 3 tiles indicating slopes and these are
//stored in stiles as s1 s2 and s3. The index is found by numbering
//around a tile starting in the east  clockwise as 1,2,4,8,16,32
//like the roads.....alitide_code(x,y,offset) in Hexedit returns
//the proper index
struct SLOPE_TILES stiles[64]= {
      {-1,-1,-1},{4,-1,-1}, {5,-1,-1}, {11,-1,-1}, {0,-1,-1}, //0-4
      {4,-1,-1}, {6,-1,-1}, {17,-1,-1},{1,-1,-1}, {4,1,-1},  //5-9
      {5,1,-1},  {11,1,-1}, {7,-1,-1}, {7,4,-1},  {2,12,-1}, //10-14
      {23,-1,-1},{2,-1,-1}, {4,2,-1},  {5,2,-1},  {11,2,-1}, //15-19
      {0,2,-1},  {4,2,-1},  {6,2,-1},  {17,2,-1}, {8,-1,-1}, //20-24
      {8,4,-1},  {8,5,-1},  {11,8,-1}, {13,-1,-1},{13,4,-1}, //25-29
      {18,-1,-1},{24,-1,-1},{3,-1,-1}, {10,-1,-1},{3,5,-1},  //30-34
      {16,-1,-1},{3,0,-1},  {10,0,-1}, {6,3,-1},  {22,-1,-1}, //35-39
      {3,1,-1},  {10,1,-1}, {5,3,1},   {16,1,-1}, {7,3,-1},   //40-44
      {10,7,-1}, {12,3,-1}, {29,-1,-1},{9,-1,-1}, {15,-1,-1}, //45-49
      {9,5,-1},  {21,-1,-1},{9,0,-1},  {15,0,-1}, {9,6,-1},   //50-54
      {28,-1,-1},{14,-1,-1},{20,-1,-1},{14,5,-1}, {27,-1,-1}, //55-59
      {19,-1,-1},{26,-1,-1},{25,-1,-1},{30,-1,-1} };    //60-63
;

//these are for moving tiles from the transfer window to the map
boolean tile_transfer;
int transfer_file,transfer_inum;
extern struct ICON transfer_icons[MAX_TILES];
int transfer_startx[MAX_TILES]; //the start x coordinate in the
                                //transfer image bitmap of each icon
int jpeg_quality=30;
enum ROAD_EDIT {none,secondary} road_edit;
int ClickNumber;
int Click1X,Click1Y;
int mapsize=200;   //the max y demision for spww2
int MapSizeX;    //map X size
int MapSizeY;
unsigned char roadtiles[38]= {   //this array holds translation
   9,36,45,54,40,                //from sp2 road tile number
  10, 5,17,34,20,                //to connection used by sp3
  25,52,37,11,21,
  42,18,27,34,20,
  41,13,25,11,43,
  29,63,19,44,26,
  13,50,41,38,23,
  53,58,46};

// here we have a structure to store info which is unsed by the undo
struct {
  int x,y;
  unsigned char s2[2],s3[2],s4[2],s5[2],s6[2],s7[2];
  short int s29;
  unsigned char s8[WW2_S8_RECORD_SIZE];
  unsigned char s28[WW2_S28_RECORD_SIZE];
} undo;
//-----------------------------------------------------------------
void _fastcall set_gnum(byte *m, int gnum)
{
   m[0]=(byte)(gnum&255);
   m[1]=(byte)(gnum/256);
}

//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
        : TForm(Owner)
{
}
//-------------------------------------------------------------------
void __fastcall TMainForm :: SaveUndo(int x, int y) //where saved
{
  undo.x=x; undo.y=y;

  int offs=S2Addr(x,y);

  undo.s2[0]=mb[moff[2]+offs]; undo.s2[1]=mb[moff[2]+offs+1];
  undo.s3[0]=mb[moff[3]+offs]; undo.s3[1]=mb[moff[3]+offs+1];
  undo.s4[0]=mb[moff[4]+offs]; undo.s4[1]=mb[moff[4]+offs+1];
  undo.s5[0]=mb[moff[5]+offs]; undo.s5[1]=mb[moff[5]+offs+1];
  undo.s6[0]=mb[moff[6]+offs]; undo.s6[1]=mb[moff[6]+offs+1];
  undo.s7[0]=mb[moff[7]+offs]; undo.s7[1]=mb[moff[7]+offs+1];

  offs=S29Addr(x,y);
  undo.s29=mb[moff[29]+offs];

  offs=S8Addr(x,y);
  for (int i=0; i<20; ++i)
    undo.s8[i]=mb[moff[8]+offs+i];

  offs=S28Addr(x,y);
  for (int i=0; i<WW2_S28_RECORD_SIZE; ++i)
    undo.s28[i]=mb[moff[28]+offs+i];
  UndoBtn->Enabled=true;
}
void __fastcall TMainForm :: RestoreUndo()
{
  int offs=S2Addr(undo.x,undo.y);

  mb[moff[2]+offs]=undo.s2[0]; mb[moff[2]+offs+1]=undo.s2[1];
  mb[moff[3]+offs]=undo.s3[0]; mb[moff[3]+offs+1]=undo.s3[1];
  mb[moff[4]+offs]=undo.s4[0]; mb[moff[4]+offs+1]=undo.s4[1];
  mb[moff[5]+offs]=undo.s5[0]; mb[moff[5]+offs+1]=undo.s5[1];
  mb[moff[6]+offs]=undo.s6[0]; mb[moff[6]+offs+1]=undo.s6[1];
  mb[moff[7]+offs]=undo.s7[0]; mb[moff[7]+offs+1]=undo.s7[1];

  offs=S29Addr(undo.x,undo.y);
  mb[moff[29]+offs]=undo.s29;

  offs=S8Addr(undo.x,undo.y);
  for (int i=0; i<WW2_S8_RECORD_SIZE; ++i)
    mb[moff[8]+offs+i]=undo.s8[i];

  offs=S28Addr(undo.x,undo.y);
  for (int i=0; i<WW2_S28_RECORD_SIZE; ++i)
    mb[moff[28]+offs+i]=undo.s28[i];
  UndoBtn->Enabled=false;
}
//-------------------------------------------------------------------
void __fastcall TMainForm :: paste_from_file(int x0, int y0)
{
  FILE *inf;
  int x,y,w,h,t,i,v[47];
  int addr,xs,ys;
  char line[256];

  inf=fopen(OpenDialog1->FileName.c_str(),"rt");
  if (!inf)
  {
     Application->MessageBox("Can't open Paste file","Error",MB_OK);
     return;
  }
  fgets(line,255,inf);
  sscanf(line,"%d %d %d",&t,&w,&h);
  xs=x0+w; ys=y0+h;

  for (y=y0; y<ys; ++y)
    for (x=x0; x<xs; ++x)
    {
      fgets(line,255,inf);
      if (x<MapSizeX && y<MapSizeY)     // if (x<100 && y<80)
      {
        for (i=0; i<47; ++i) //47 fields per line...each 4 columns
          sscanf(&(line[4*i]),"%d",&(v[i]));

        addr=S29Addr(x,y)+moff[29];
        mb[addr]=(byte)v[0];

        addr=S2Addr(x,y)+moff[2];
        mb[addr]=(byte)v[1];
        mb[addr+1]=(byte)v[2];

        addr=S2Addr(x,y)+moff[3];
        mb[addr]=(byte)v[3];
        mb[addr+1]=(byte)v[4];

        addr=S2Addr(x,y)+moff[4];
        mb[addr]=(byte)v[5];
        mb[addr+1]=(byte)v[6];

        addr=S2Addr(x,y)+moff[5];
        mb[addr]=(byte)v[7];
        mb[addr+1]=(byte)v[8];

        addr=S2Addr(x,y)+moff[6];
        mb[addr]=(byte)v[9];
        mb[addr+1]=(byte)v[10];

        addr=S2Addr(x,y)+moff[7];
        mb[addr]=(byte)v[11];
        mb[addr+1]=(byte)v[12];

        addr=S8Addr(x,y)+moff[8];
        for (i=0; i<WW2_S8_RECORD_SIZE; ++i)
          mb[addr+i]=(byte)v[13+i];

        addr=S28Addr(x,y)+moff[28];
        for (i=0; i<WW2_S28_RECORD_SIZE; ++i)
          mb[addr+i]=(byte)v[27+i];

      }
    }

  fclose(inf);
}
//-------------------------------------------------------------------
void __fastcall TMainForm :: copy_to_file(int x0, int y0, int x1, int y1)
{
   FILE *outf;
   int x,y,xs,ys,i;
   int addr;

   xs=x1-x0+1;
   ys=y1-y0+1;
   if (xs<1 || ys<1) return;

   outf=fopen(SaveDialog1->FileName.c_str(),"wt");

   if (!outf)
   {
      Application->MessageBox("Could not open copy file.",
        "Error",MB_OK);
      return;

   }
   fprintf(outf,"%3d %3d %3d\n",edit_type,xs,ys); //type and the size
   for (y=y0; y<=y1; ++y)
    for (x=x0; x<=x1; ++x)
    {
      addr=S29Addr(x,y)+moff[29];
      fprintf(outf,"%3d ",mb[addr]);

      addr=S2Addr(x,y)+moff[2];
      fprintf(outf,"%3d ",mb[addr]);
      fprintf(outf,"%3d ",mb[addr+1]);

      addr=S2Addr(x,y)+moff[3];
      fprintf(outf,"%3d ",mb[addr]);
      fprintf(outf,"%3d ",mb[addr+1]);

      addr=S2Addr(x,y)+moff[4];
      fprintf(outf,"%3d ",mb[addr]);
      fprintf(outf,"%3d ",mb[addr+1]);

      addr=S2Addr(x,y)+moff[5];
      fprintf(outf,"%3d ",mb[addr]);
      fprintf(outf,"%3d ",mb[addr+1]);

      addr=S2Addr(x,y)+moff[6];
      fprintf(outf,"%3d ",mb[addr]);
      fprintf(outf,"%3d ",mb[addr+1]);

      addr=S2Addr(x,y)+moff[7];
      fprintf(outf,"%3d ",mb[addr]);
      fprintf(outf,"%3d ",mb[addr+1]);

      addr=S8Addr(x,y)+moff[8];
      for (i=0; i<20; ++i)
        fprintf(outf,"%3d ",mb[addr+i]);

      addr=S28Addr(x,y)+moff[28];
      for (i=0; i<14; ++i)
        fprintf(outf,"%3d ",mb[addr+i]);

      fprintf(outf,"\n");
    }

  fclose(outf);

}
//------------------------------------------------------------------
int  __fastcall TMainForm::load_section(FILE *inf, int sec, unsigned char *b)
{
    int sect_num,b1,b2,i;
    int section,bytes_to_read,section_bytes,start;
    char compressed;

   //go to the start of the file and read sections
   //until we come to the right one
   fseek(inf,V1_1_START,0);

   if (sec>MAX_SECTIONS) return sec;
   start=saddress;

   for (sect_num=0; sect_num<=MAX_SECTIONS; ++sect_num)
   {
    fread(&section,4,1,inf);
    fread(&bytes_to_read,4,1,inf);

    //------ SPww2 has - bytes to read
    if (bytes_to_read<0) bytes_to_read=-bytes_to_read;
    //-------------------------------------------------------
    fread(&compressed,1,1,inf);
    section_bytes=0;
// we will read the section and exit if it is the right section
// otherwise we will skip over it and go to the next one
  if (section==sec)
  {
    if (compressed)
    {
      moff[sec]=saddress;  //set the pointer to this data
      while (bytes_to_read>0)
      {
        b1=fgetc(inf); --bytes_to_read;
        if (b1>0x80)  //repeat next byte
        {
           b1-=0x80;
           b2=fgetc(inf); --bytes_to_read;
           for (i=0; i<b1; ++i, ++section_bytes)
           {
             b[section_bytes]=(byte)b2;
             ++saddress;
           }
        } //end repeat byte
        else //read and write b1 bytes
        {
         for (i=0; i<b1; ++i,++section_bytes,--bytes_to_read)
         {
           b[section_bytes]=(byte)fgetc(inf);
           ++saddress;
         }
        } //end read consecutive bytes
      }//end of while bytes..
     } //end of read compressed
     if (!compressed) //read and write? non-compressed
     {
       moff[sec]=saddress;  //set the pointer to this data
       while (bytes_to_read>0)
       {
         b[section_bytes]=(byte)fgetc(inf);
         --bytes_to_read;
         ++section_bytes;
         ++saddress;
       }
     } //end of not compressed
     ssz[sec]=saddress-start; //the end of the data less the begining
   } // this is the end of process of the right section
   else
   {
     //skip ahead
     fseek(inf,bytes_to_read,SEEK_CUR);
   }
  } //end of the for sect_num loop
  return 0;
}
//---------------------------------------------------------------------------
// a ww2 section has a one byte compressed flag and may have a negative
// bytes to read. we load the section into a portion of mb without
//changing size and offset of sections
int  __fastcall TMainForm::load_ww2_section(FILE *inf, int sec, unsigned char *b)
{
    int sect_num,b1,b2,i;
    int section,bytes_to_read,section_bytes,start;
    int compressed;

   //go to the start of the file and read sections
   //until we come to the right one
   fseek(inf,V1_1_START,0);

   if (sec>0x30) return sec;
   start=0; saddress=0;

   for (sect_num=0; sect_num<0x30; ++sect_num)
   {
    compressed=0;
    fread(&section,4,1,inf);
    fread(&bytes_to_read,4,1,inf);

    //------ SPww2 has - bytes to read
    if (bytes_to_read<0) bytes_to_read=-bytes_to_read;
    //-------------------------------------------------------
    fread(&compressed,1,1,inf);
    section_bytes=0;
// we will read the section and exit if it is the right section
// otherwise we will skip over it and go to the next one
  if (section==sec)
  {
    if (compressed)
    {
      //moff[sec]=saddress;  //set the pointer to this data
      while (bytes_to_read>0)
      {
        b1=fgetc(inf); --bytes_to_read;
        if (b1>0x80)  //repeat next byte
        {
           b1-=0x80;
           b2=fgetc(inf); --bytes_to_read;
           for (i=0; i<b1; ++i, ++section_bytes)
           {
             b[section_bytes]=(byte)b2;
             ++saddress;
           }
        } //end repeat byte
        else //read and write b1 bytes
        {
         for (i=0; i<b1; ++i,++section_bytes,--bytes_to_read)
         {
           b[section_bytes]=(byte)fgetc(inf);
           ++saddress;
         }
        } //end read consecutive bytes
      }//end of while bytes..
     } //end of read compressed
     if (!compressed) //read and write? non-compressed
     {
      // moff[sec]=saddress;  //set the pointer to this data
       while (bytes_to_read>0)
       {
         b[section_bytes]=(byte)fgetc(inf);
         --bytes_to_read;
         ++section_bytes;
         ++saddress;
       }
     } //end of not compressed
    // ssz[sec]=saddress-start; //the end of the data less the begining
   } // this is the end of process of the right section
   else
   {
     //skip ahead
     fseek(inf,bytes_to_read,SEEK_CUR);
   }
  } //end of the for sect_num loop
  return 0;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::LoadMapFile1Click(TObject *Sender)
{
   FILE *inf;
   TMsgDlgButtons db;
   char ID[32];
   int error,i;

   db<<mbOK;

   OpenDialog1->Filter="Maps (*.dat)|*.dat|All Files (*.*)| *.*";
   if (!OpenDialog1->Execute()) return;

   inf=fopen(OpenDialog1->FileName.c_str(),"rb");
   if (!inf)
   {
     MessageDlg("Could not open "+OpenDialog1->FileName,
                  mtError,db,0);
     return;
   }

   OpenDialog1->InitialDir=
     OpenDialog1->FileName.SubString(1,OpenDialog1->FileName.LastDelimiter("\\"));
   fgets(ID,31,inf);
   if (strcmp(ID,"STEEL2_SAVE_V100"))
   {
     Application->MessageBox(
       "This is not a SP2 version 1.1 file!","Fatal Error",MB_OK);
     return;
   }

   MainForm->Caption="SP2 : "+OpenDialog1->FileName;

   //load each of the needed sections
   saddress=0; //initaialize the pointer to the map buffer
   sexists[47]=false; //don't load for SP2
   for (i=2; i<=48; ++i)
   {
     if (sexists[i])
       error=load_section(inf,i,&(mb[saddress]));
     else error=0;
     if (error)
     {
       fclose(inf);
       MessageDlg("Could not find section "+IntToStr(error),
                  mtError,db,0);
       return;
     }
   }
   fclose(inf);
   hexx0=0; hexy0=0;
   edit_type=SP2;
   VMapSB->Position=0; HMapSB->Position=0;
   DrawMap();
   OldX=-1;

   strat_change=true;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormCreate(TObject *Sender)
{
   OpenDialog1->InitialDir=
     ParamStr(0).SubString(1,ParamStr(0).LastDelimiter("\\"));
   StartPath=OpenDialog1->InitialDir;
   strcpy(tilespath,OpenDialog1->InitialDir.c_str());
   strcat(tilespath,"\\Shp\\");

   MapImg->Width=tiles_wide*tile_width-tile_half_width;
   MapImg->Height=tile_height*tiles_high-11;

   HMapSB->LargeChange=tiles_wide-1;
   HMapSB->Max=MAX_HORI-tiles_wide;
   //VMapSB->Width=25;
   VMapSB->LargeChange=tiles_high-2;
   VMapSB->Max=MAX_VERT-tiles_high;

   HexColor=0x8080FF;

   //Initialize the array that controls which sections are read
   //Note section 47 is set to false for SP2 and true for sp3
   sexists[2]=true;  sexists[3]=true;  sexists[4]=true;
   sexists[5]=true;  sexists[6]=true;  sexists[7]=true;
   sexists[8]=true;  sexists[16]=true; sexists[17]=true;
   sexists[20]=true; sexists[28]=true; sexists[29]=true;
   sexists[38]=true; sexists[39]=true; sexists[48]=true;
   sexists[54]=true;  //for SPWW2

   for (int x=0; x<MAX_TERRAIN_FILES; ++x)
     for (int y=0; y<MAX_TILES; ++y)
       tiles[x][y].inum=-1;

  //here we add on a hello screen
  mbmp=new Graphics :: TBitmap;
  mbmp->Width=650;
  mbmp->Height=500;

  TRect rect;
  rect.Top=0; rect.Left=0;
  rect.Bottom=500; rect.Right=649;
  mbmp->Canvas->Brush->Color=(TColor)0x005080;
  mbmp->Canvas->FillRect(rect);

  //signon screen
  mbmp->Canvas->Font->Name="Arial";
  mbmp->Canvas->Font->Size=26;

  mbmp->Canvas->Font->Color=(TColor)0xC0ffff;
  mbmp->Canvas->TextOut(120,100,"World War 2 Map Editor");

  mbmp->Canvas->Font->Size=20;
  mbmp->Canvas->TextOut(220,210,"Version 0.12e");

  mbmp->Canvas->Font->Size=14;
  mbmp->Canvas->TextOut(130,380,"Copyright by Fred Chlanda November 2007");

  mbmp->Canvas->Font->Name="Fixedsys";
  mbmp->Canvas->Font->Color=clBlack;
  mbmp->Canvas->Font->Size=10;

  MapImg->Picture->Graphic=mbmp;
  MapImg->Show();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::MouseHex()
{

   WhereY=(MouseY-fy0)/tile_height+hexy0;
   if (WhereY&1)
     WhereX=(MouseX-fx0-tile_half_width)/tile_width+hexx0;
   else
     WhereX=(MouseX-fx0)/tile_width+hexx0;
   if (WhereX<0) WhereX=0;
   if (WhereY<0) WhereY=0;
   if (WhereX>MAX_HORI) WhereX=MAX_HORI;
   if (WhereY>MAX_VERT) WhereY=MAX_VERT;
}
//-----------------------------------------------------------------
int __fastcall TMainForm :: V2S2Addr(int x,int y)
{

  return 2*80*x+2*y;
}
//-------------------------------------------------------
int __fastcall TMainForm :: S2Addr(int x, int y)
{

   return 2*mapsize*x+2*y;

}
//---------------------------------------------------------
int __fastcall TMainForm :: V2S8Addr(int x, int y)
{
   return x*80*12+y*12;
}
//---------------------------------------------------------
int __fastcall TMainForm :: S8Addr(int x, int y)
{
   return x*mapsize*WW2_S8_RECORD_SIZE+y*WW2_S8_RECORD_SIZE;
}
//----------------------------------------------------
int __fastcall TMainForm :: V2S29Addr(int x, int y)
{

  return 80*x+y;
}
//--------------------------------------------------
int __fastcall TMainForm :: S29Addr(int x, int y)
{

   return mapsize*x*2+2*y;

}
//--------------------------------------------------------------
int __fastcall TMainForm ::V2S28Addr(int x,int y)
{
 return 13*80*x+13*y;

}
int __fastcall TMainForm :: S28Addr(int x, int y)
{

   return WW2_S28_RECORD_SIZE*mapsize*x+WW2_S28_RECORD_SIZE*y;

}
//----------------------------------------------------------------

//-----------------------------------------------------------------
void __fastcall TMainForm::MapImgMouseMove(TObject *Sender,
      TShiftState Shift, int X, int Y)
{
   char cstr[128];
   int addr;

   if (X>MouseX+5 || X<MouseX-5 || Y>MouseY+5 || Y<MouseY-5)
   {
     MouseX=X;
     MouseY=Y;
     MouseHex(); //set new WhereX,Wherey based on MouseX and MouseY
     addr=S2Addr(WhereX,WhereY);
     int b1=mb[moff[2]+addr];
     int b2=mb[moff[2]+addr+1];
     int gnum=256*b2+b1;

     if (ClickNumber==0)
      sprintf(cstr,"%2d,%2d  f%2d i%2d",
          WhereX,WhereY,gnum/250,gnum%250);
     else
       sprintf(cstr,"%2d,%2d  Click %2d",
          WhereX,WhereY,ClickNumber);
     AnsiString Astr(cstr);
     WhereLbl->Caption=Astr;
   }
}
//-------------------------------------------------------------------
// Draw the tile at map coordinates x,y. If the tile is not
// loaded... load it
int debug_file,debug_ico;
void __fastcall TMainForm :: TileAt(int x, int  y, int file, int ico)
{
  char fname[16],fullname[256];
  int framex,framey;

  debug_file=file; debug_ico=ico;

  if (file>MAX_TERRAIN_FILES)
  return;

  //load if needed  ... into tbmp ot TileIL ...inum is initialized to -1
  if (tiles[file][ico].tbmp==0 && tiles[file][ico].inum<0)
  {
     sprintf(fname,"Ter%02dz4.shp",file);
     strcpy(fullname,tilespath);
     strcat(fullname,fname);
     //LoadTile returns non-zero if an error
     if (LoadShp->LoadTile(ico,fullname,&(tiles[file][ico]))) return;
  }

  framex=fx0+tiles[file][ico].ogx+tile_width*x;
  framey=fy0+tiles[file][ico].ogy+tile_height*y;
  if (y&1) framex+=(tile_half_width);

  //if the tile is not in TileIL just draw it
  if (tiles[file][ico].inum<0)
  {
    
     mbmp->Canvas->Draw(framex,framey,tiles[file][ico].tbmp);
  }
  else
  {
      TileIL->Draw(mbmp->Canvas,framex,framey,tiles[file][ico].inum,true);
    /*  Graphics :: TBitmap *temp =new Graphics::TBitmap;
      temp->Height=TILE_LIST_HEIGHT;
      temp->Width=TILE_LIST_WIDTH;
      temp->Transparent=true;
      temp->TransparentColor=
       (TColor)(bkcolor.R+256*bkcolor.G+256*256*bkcolor.B);
      //ImageList1->Draw(pCanvas,Rect.Left,Rect.Top, Panel->Index);
      TileIL->Draw(temp->Canvas,0,0,tiles[file][ico].inum,true);
     // temp->TransparentColor=temp->Canvas->Pixels[0][TILE_LIST_HEIGHT-1];
      mbmp->Canvas->Draw(framex,framey,temp);
      delete temp;     */
  }

}
//----------------------------------------------------------------
void __fastcall TMainForm :: QTileAt(int x, int  y, int file, int ico)
{
  char fname[16],fullname[256];
  int framex,framey;

  debug_file=file; debug_ico=ico;

  if (file>MAX_TERRAIN_FILES)
  return;

  //load if needed  ... into tbmp ot TileIL ...inum is initialized to -1
  if (tiles[file][ico].tbmp==0 && tiles[file][ico].inum<0)
  {
     sprintf(fname,"Ter%02dz4.shp",file);
     strcpy(fullname,tilespath);
     strcat(fullname,fname);
     //LoadTile returns non-zero if an error
     if (LoadShp->LoadTile(ico,fullname,&(tiles[file][ico]))) return;
  }

  framex=fx0+tiles[file][ico].ogx+tile_width*x;
  framey=fy0+tiles[file][ico].ogy+tile_height*y;
  if (y&1) framex+=(tile_half_width);

  //if the tile is not in TileIL just draw it
  if (tiles[file][ico].inum<0)
  {

     qbmp->Canvas->Draw(framex,framey,tiles[file][ico].tbmp);
  }
  else
  {
      TileIL->Draw(qbmp->Canvas,framex,framey,tiles[file][ico].inum,true);

  }

}

//----------------------------------------------
void __fastcall TMainForm :: DrawHexes()
{
  int x,y;
  int xs0,xs1,ys0,ys1;

  MapImg->Picture->Bitmap->Canvas->Pen->Color=HexColor;
  for (y=0; y<tiles_high; ++y)
    for (x=0; x<tiles_wide; ++x)
    {
      //verticals
      xs0=x*tile_width+fx0;
      if (y&1) xs0+=tile_half_width;
      xs1=xs0;
      ys0=y*tile_height+13+fy0;
      ys1=ys0+30;
      MapImg->Picture->Bitmap->Canvas->MoveTo(xs0,ys0);
      MapImg->Picture->Bitmap->Canvas->LineTo(xs1,ys1);

      //and up right
      MapImg->Picture->Bitmap->Canvas->MoveTo(xs0,ys0);
      MapImg->Picture->Bitmap->Canvas->LineTo(xs0+tile_half_width,ys0-13);
      //and down right
      MapImg->Picture->Bitmap->Canvas->MoveTo(xs1,ys1);
      MapImg->Picture->Bitmap->Canvas->LineTo(xs1+tile_half_width,ys1+13);
    }

}
//-----------------------------------------------------------------
void __fastcall TMainForm :: QDrawHexes()
{
  int x,y;
  int xs0,xs1,ys0,ys1;

  qbmp->Canvas->Pen->Color=HexColor;
  for (y=0; y<40; ++y)
    for (x=0; x<50; ++x)
    {
      //verticals
      xs0=x*tile_width+fx0;
      if (y&1) xs0+=tile_half_width;
      xs1=xs0;
      ys0=y*tile_height+13+fy0;
      ys1=ys0+30;
      qbmp->Canvas->MoveTo(xs0,ys0);
      qbmp->Canvas->LineTo(xs1,ys1);

      //and up right
      qbmp->Canvas->MoveTo(xs0,ys0);
      qbmp->Canvas->LineTo(xs0+tile_half_width,ys0-13);
      //and down right
      qbmp->Canvas->MoveTo(xs1,ys1);
      qbmp->Canvas->LineTo(xs1+tile_half_width,ys1+13);
    }

}

//--------------------------------------------------------------
/*
void __fastcall TMainForm :: QTileAt(int x, int  y, int file, int ico)
{
  char fname[16],fullname[256];
  int framex,framey;

  //load if needed
  if (tiles[file][ico].tbmp==0)
  {
     sprintf(fname,"Ter%02dz4.shp",file);
     strcpy(fullname,tilespath);
     strcat(fullname,fname);
     //if an error reported by LoadTile abort
     if (LoadShp->LoadTile(ico,fullname,&(tiles[file][ico]))) return;
  }
  framex=fx0+tiles[file][ico].ogx+tile_width*x;
  framey=fy0+tiles[file][ico].ogy+tile_height*y;
  if (y&1) framex+=tile_half_width;
  qbmp->Canvas->Draw(framex,framey,tiles[file][ico].tbmp);

}
*/
//----------------------------------------------------------------
// return the number of bits set
int __fastcall BitsSet(int v)
{
   int count=0;

   for (int i=0; i<8; ++i)
   {
      if (v&1) ++count;
      v=v/2;
   }
   return count;
}
//-------------------------------------------------------------------
void __fastcall TMainForm :: DrawRoads(int to,int x,int y,int x0,int y0)
{
  int addr,v;

  //XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
   return; //we don't need this for spww2
  //XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

  addr=S8Addr(x,y);
  if (to==0) v=mb[moff[8]+addr+12]; //the icon position in file 24
                                    //indicates whether road or rr
  else if (to==21) v=mb[moff[8]+addr+13]; //paved
  else v=mb[moff[8]+addr+14];

  while (BitsSet(v)>=2)  //ie connected on both sides
  {
    if ((v&1) && (v&8))
    {
       v=v^9;
       TileAt(x-x0,y-y0,24,7+to);
    }

    if ((v&1) && (v&4))
    {
       v=v^5;
       TileAt(x-x0,y-y0,24,4+to);
    }
    if ((v&1) && (v&16))
    {
       v=v^17;
       TileAt(x-x0,y-y0,24,11+to);
    }
    if ((v&2) && (v&4))
    {
       v=v^6;
       TileAt(x-x0,y-y0,24,5+to);
    }
    if ((v&2) && (v&8))
    {
       v=v^10;
       TileAt(x-x0,y-y0,24,8+to);
    }
    if ((v&2) && (v&16))
    {
       v=v^18;
       TileAt(x-x0,y-y0,24,12+to);
    }
    if ((v&2) && (v&32))
    {
       v=v^34;
       TileAt(x-x0,y-y0,24,18+to);
    }

    if ((v&4) && (v&16))
    {
       v=v^20;
       TileAt(x-x0,y-y0,24,13+to);
    }
    if ((v&4) && (v&32))
    {
       v=v^36;
       TileAt(x-x0,y-y0,24,19+to);
    }

    if ((v&8) && (v&32))
    {
       v=v^40;
       TileAt(x-x0,y-y0,24,17+to);
    }
    if ((v&16) && (v&32))
    {
       v=v^48;
       TileAt(x-x0,y-y0,24,20+to);
    }

    // these don't really have tiles so do last
    if ((v&1) && (v&2))
    {
       v=v^3;
       TileAt(x-x0,y-y0,24,2+to);
    }
    if ((v&8) && (v&16))
    {
       v=v^24;
       TileAt(x-x0,y-y0,24,14+to);
    }
    if ((v&4) && (v&8))
    {
       v=v^12;
       TileAt(x-x0,y-y0,24,9+to);
    }
    if ((v&1) && (v&32))
    {
       v=v^33;
       TileAt(x-x0,y-y0,24,16+to);
    }
    

  }// end while at least 2 set
  if (!BitsSet(v)) return;
  //do the one bit left
  if (v&1) TileAt(x-x0,y-y0,24,0+to);
  else
  if (v&2) TileAt(x-x0,y-y0,24,1+to);
  else
  if (v&4) TileAt(x-x0,y-y0,24,4+to);
  else
  if (v&8) TileAt(x-x0,y-y0,24,6+to);
  else
  if (v&16) TileAt(x-x0,y-y0,24,10+to);
  else
  if (v&32) TileAt(x-x0,y-y0,24,15+to);

}
//--------------------------------------------------------------------
//draw complete map window
void __fastcall TMainForm :: DrawMap()
{
    TRect drect;
    int x,y,i;
    int gnum,addr,b1,b2,n;
    int file,ico;


    Screen->Cursor=crHourGlass;

    //delete mbmp;
    mbmp=new Graphics :: TBitmap;

    mbmp->Width=MapImg->Width;
    mbmp->Height=MapImg->Height;

    mbmp->Canvas->Brush->Color=clBlue;

    //blank image
    drect.top=0; drect.Left=0;
    drect.Right=mbmp->Width; drect.Bottom=mbmp->Height;
    mbmp->Canvas->FillRect(drect);

    //draw the map from the origin hex
    //main tiles    Section 2
    for (y=hexy0; y<hexy0+tiles_high; ++y)
      for (x=hexx0; x<hexx0+tiles_wide; ++x)
      {
        //primary tile
        addr=S2Addr(x,y);
        b1=mb[moff[2]+addr];
        b2=mb[moff[2]+addr+1];
        gnum=256*b2+b1;
        file=gnum/250;
        ico =gnum%250;
        TileAt(x-hexx0,y-hexy0,file,ico);
      }
       //secondary tiles
    for (y=hexy0; y<hexy0+tiles_high; ++y)
      for (x=hexx0; x<hexx0+tiles_wide; ++x)
      {
        addr=S28Addr(x,y);
        n=mb[moff[28]+addr];
        for (i=0; i<n; ++i)
        {
          b1=mb[moff[28]+addr+1+2*i];
          b2=mb[moff[28]+addr+2+2*i];
          gnum=256*b2+b1;
          file=gnum/250;
          ico =gnum%250;
          TileAt(x-hexx0,y-hexy0,file,ico);
        }
      }

    //other tiles    Section 3
    for (y=hexy0; y<hexy0+tiles_high; ++y)
      for (x=hexx0; x<hexx0+tiles_wide; ++x)
      {
        addr=S2Addr(x,y);
        b1=mb[moff[3]+addr];
        b2=mb[moff[3]+addr+1];
        gnum=256*b2+b1; //if 2 bytes are ffff we get 0xFFFF for gnum
        file=gnum/250;
        ico =gnum%250;
        if (file<MAX_TERRAIN_FILES && CB3->Checked)
          TileAt(x-hexx0,y-hexy0,file,ico);
      }
      //other tiles    Section 4
    for (y=hexy0; y<hexy0+tiles_high; ++y)
      for (x=hexx0; x<hexx0+tiles_wide; ++x)
      {
        addr=S2Addr(x,y);
        b1=mb[moff[4]+addr];
        b2=mb[moff[4]+addr+1];
        gnum=256*b2+b1; //if 2 bytes are ffff we get 0xFFFF for gnum
        file=gnum/250;
        ico =gnum%250;
        if (file<MAX_TERRAIN_FILES && CB4->Checked)
          TileAt(x-hexx0,y-hexy0,file,ico);
      }
    //other tiles    Section 5
    for (y=hexy0; y<hexy0+tiles_high; ++y)
      for (x=hexx0; x<hexx0+tiles_wide; ++x)
      {
        addr=S2Addr(x,y);
        b1=mb[moff[5]+addr];
        b2=mb[moff[5]+addr+1];
        gnum=256*b2+b1; //if 2 bytes are ffff we get 0xFFFF for gnum
        file=gnum/250;
        ico =gnum%250;
        if (file<MAX_TERRAIN_FILES && CB5->Checked)
          TileAt(x-hexx0,y-hexy0,file,ico);
      }
    //other tiles    Section 6
    for (y=hexy0; y<hexy0+tiles_high; ++y)
      for (x=hexx0; x<hexx0+tiles_wide; ++x)
      {
        addr=S2Addr(x,y);
        b1=mb[moff[6]+addr];
        b2=mb[moff[6]+addr+1];
        gnum=256*b2+b1; //if 2 bytes are ffff we get 0xFFFF for gnum
        file=gnum/250;
        ico =gnum%250;
        if (file<MAX_TERRAIN_FILES && CB6->Checked)
          TileAt(x-hexx0,y-hexy0,file,ico);
      }
    //other tiles    Section 7
    for (y=hexy0; y<hexy0+tiles_high; ++y)
      for (x=hexx0; x<hexx0+tiles_wide; ++x)
      {
        addr=S2Addr(x,y);
        b1=mb[moff[7]+addr];
        b2=mb[moff[7]+addr+1];
        gnum=256*b2+b1; //if 2 bytes are ffff we get 0xFFFF for gnum
        file=gnum/250;
        ico =gnum%250;
        if (file<MAX_TERRAIN_FILES && CB7->Checked)
          TileAt(x-hexx0,y-hexy0,file,ico);
      }



    // ----------- New for WAW -------------------------
    // dirt road tiles are in terrain file 24 starting at 0
    // the tile used depends on the connections byte 0 of
    // s8 has 6 (64) set for dirt roads. For paved roads byte 0
    // has but bit 7 (128) set. Paved road tiles are in
    // file 24 starting at 21. Both have the connectivity at
    // byte 12 with 1=east 2=se 4=sw etc.
    // RR are indicated at byte 2 bit 0 (1). Connectivity for
    // RR are at byte 14. RR icons start at 42 in file 24
    for (y=hexy0; y<hexy0+tiles_high; ++y)
      for (x=hexx0; x<hexx0+tiles_wide; ++x)
      {
        addr=S8Addr(x,y);
        // we will draw tiles as follows... there are specific
        // tiles that are used when a road connects on both sides
        // of the hex. There are also tiles used when only one
        // side is connected. We will use up all of the 2 bit
        //combinations then draw the last bit if there is one

        // do the two kinds of roads
        //this is a bit shoddy but we will use the tile
        //offset to determine whe connectivity  and value
        //are. We are also not going to check what kind
        //of road we connect to so the paved road will
        //make a cross when intersecting an dirt road.
        if (mb[moff[8]+addr]&64) DrawRoads(0,x,y,hexx0,hexy0);  //dirt roads
        if (mb[moff[8]+addr]&128) DrawRoads(21,x,y,hexx0,hexy0);  //paved roads
        if (mb[moff[8]+addr+2]&1) DrawRoads(42,x,y,hexx0,hexy0); //railroad
    }
    //------ draw lines for road connections ----------
    if (ShowRoadConnections1->Checked || ShowAllRoadConnections1->Checked)
    {
      // road tiles and others?? are not shown
      // we will draw lines on the map to indicate  these
      int dx,dy;
      int centerx,centery;
      int rc,offs;
      mbmp->Canvas->Pen->Width=3;
      mbmp->Canvas->Pen->Color=clRed;

      for (y=hexy0; y<hexy0+tiles_high; ++y)
        for (x=hexx0; x<hexx0+tiles_wide; ++x)
        {
          addr=S8Addr(x,y);

          if (PavedRoad1->Checked) offs=13;
          else if (Railroad1->Checked) offs=14;
          else
          {
            offs=12;    //default=secondary road
            SecondaryRoad1->Checked=true;
          }
          //-------- check for road connections even if not a road-----
          if (true || mb[moff[8]+addr]&64)
          {
            if (ShowAllRoadConnections1->Checked)
            {
              rc=mb[moff[8]+addr+12];
              rc|=mb[moff[8]+addr+13];
              rc|=mb[moff[8]+addr+14];
            }
            else
            rc=mb[moff[8]+addr+offs];
            centerx=tile_width*(x-hexx0);
            centery=tile_height*(y-hexy0)+tile_height/2-5;
            if (y&1) centerx+=tile_half_width;
            if (rc&1)   // connected east
            {
              dx=24; dy=0;
              mbmp->Canvas->MoveTo(centerx,centery);
              mbmp->Canvas->LineTo(centerx+dx,centery+dy);
            }
            if (rc&8)  //connected west
            {
              dx=-24; dy=0;
              mbmp->Canvas->MoveTo(centerx,centery);
              mbmp->Canvas->LineTo(centerx+dx,centery+dy);
            }
            if (rc&2)  //connected se
            {
              dx=13; dy=20;
              mbmp->Canvas->MoveTo(centerx,centery);
              mbmp->Canvas->LineTo(centerx+dx,centery+dy);
            }
            if (rc&16)  //connected nw
            {
              dx=-13; dy=-20;
              mbmp->Canvas->MoveTo(centerx,centery);
              mbmp->Canvas->LineTo(centerx+dx,centery+dy);
            }
            if (rc&32)  //connected ne
            {
              dx=13; dy=-20;
              mbmp->Canvas->MoveTo(centerx,centery);
              mbmp->Canvas->LineTo(centerx+dx,centery+dy);
            }
            if (rc&4)  //connected sw
            {
              dx=-13; dy=20;
              mbmp->Canvas->MoveTo(centerx,centery);
              mbmp->Canvas->LineTo(centerx+dx,centery+dy);
            }

          }
     }

    }//-------------- End Lines -------------------------
    //END draw road connections

    //----------------- Show road hexes -----------------
    if (ToggleRoad1->Checked || ToggleRoadConnection1->Checked ||
       ShowAllRoadConnections1->Checked)
    {
      mbmp->Canvas->Pen->Width=1;
      mbmp->Canvas->Pen->Color=clBlack;

      int centerx;
      int centery;

      for (y=hexy0; y<hexy0+tiles_high; ++y)
       for (x=hexx0; x<hexx0+tiles_wide; ++x)
       {
         addr=S8Addr(x,y);
         if (mb[moff[8]+addr]&64 && (SecondaryRoad1->Checked
             || ShowAllRoadConnections1->Checked) )
         {
            mbmp->Canvas->Brush->Color=clOrange;
            centerx=tile_width*(x-hexx0);
            centery=tile_height*(y-hexy0)+tile_height/2-5;
            if (y&1) centerx+=tile_half_width;
            mbmp->Canvas->Ellipse(centerx-6,centery-6,centerx+6,centery+6);
         }
         if (mb[moff[8]+addr]&128 && (PavedRoad1->Checked
             || ShowAllRoadConnections1->Checked))
         {
            mbmp->Canvas->Brush->Color=clGray;
            centerx=tile_width*(x-hexx0);
            centery=tile_height*(y-hexy0)+tile_height/2-5;
            if (y&1) centerx+=tile_half_width;
            mbmp->Canvas->Ellipse(centerx-6,centery-6,centerx+6,centery+6);
         }
         if (mb[moff[8]+addr+2]&1 && (Railroad1->Checked
             || ShowAllRoadConnections1->Checked))
         {
            mbmp->Canvas->Brush->Color=clBlue;
            centerx=tile_width*(x-hexx0);
            centery=tile_height*(y-hexy0)+tile_height/2-5;
            if (y&1) centerx+=tile_half_width;
            mbmp->Canvas->Ellipse(centerx-6,centery-6,centerx+6,centery+6);
         }
       }
    }
    //------ end show road hexes

    MapImg->Picture->Bitmap=mbmp;
    MapImg->Show();
    if (ShowHexes1->Checked) DrawHexes();
    Screen->Cursor=crDefault;
    delete mbmp;

}
//-------------------------------------------------------------------------
//saves about 1/4 of map from current position
void __fastcall TMainForm :: SaveMapImg()
{
    TRect drect;
    int x,y,i,qhexxf,qhexyf,qhexy0,qhexx0;
    int gnum,addr,b1,b2,n;
    int file,ico;

    SaveDialog1->DefaultExt="jpg";
    SaveDialog1->Filter=
      "JPEG file (*.jpg)|*.jpg|All Files (*.*)|*.*";
    SaveDialog1->Title="Save Map Quadrant As JPEG Image";
    if (!SaveDialog1->Execute()) return;

    Screen->Cursor=crHourGlass;

    qbmp=new Graphics :: TBitmap;

    qbmp->Width=53*51;
    qbmp->Height=44*41;

    qbmp->Canvas->Brush->Color=clBlue;

    //blank image
    drect.top=0; drect.Left=0;
    drect.Right=qbmp->Width; drect.Bottom=qbmp->Height;
    qbmp->Canvas->FillRect(drect);

    qhexy0=hexy0; qhexx0=hexx0;
    qhexyf=qhexy0+40; if (qhexyf>200)  qhexyf=200; //changed here
    qhexxf=qhexx0+50; if (qhexxf>160) qhexxf=160;
    //draw the map from the origin hex of the quad
    //main tiles    Section 2
    for (y=qhexy0; y<qhexyf; ++y)
      for (x=qhexx0; x<qhexxf; ++x)
      {
        //primary tile
        addr=S2Addr(x,y);
        b1=mb[moff[2]+addr];
        b2=mb[moff[2]+addr+1];
        gnum=256*b2+b1;
        file=gnum/250;
        ico =gnum%250;
        QTileAt(x-qhexx0,y-qhexy0,file,ico);
      }
       //secondary tiles
    for (y=qhexy0; y<qhexyf; ++y)
      for (x=hexx0; x<qhexxf; ++x)
      {
        addr=S28Addr(x,y);
        n=mb[moff[28]+addr];
        for (i=0; i<n; ++i)
        {
          b1=mb[moff[28]+addr+1+2*i];
          b2=mb[moff[28]+addr+2+2*i];
          gnum=256*b2+b1;
          file=gnum/250;
          ico =gnum%250;
          QTileAt(x-qhexx0,y-qhexy0,file,ico);
        }
      }

    //other tiles    Section 3
    for (y=qhexy0; y<qhexyf; ++y)
      for (x=qhexx0; x<qhexxf; ++x)
      {
        addr=S2Addr(x,y);
        b1=mb[moff[3]+addr];
        b2=mb[moff[3]+addr+1];
        gnum=256*b2+b1; //if 2 bytes are ffff we get 0xFFFF for gnum
        file=gnum/250;
        ico =gnum%250;
        if (file<MAX_TERRAIN_FILES && CB3->Checked)
          QTileAt(x-qhexx0,y-qhexy0,file,ico);
      }
      //other tiles    Section 4
    for (y=qhexy0; y<qhexyf; ++y)
      for (x=qhexx0; x<qhexxf; ++x)
      {
        addr=S2Addr(x,y);
        b1=mb[moff[4]+addr];
        b2=mb[moff[4]+addr+1];
        gnum=256*b2+b1; //if 2 bytes are ffff we get 0xFFFF for gnum
        file=gnum/250;
        ico =gnum%250;
        if (file<MAX_TERRAIN_FILES && CB4->Checked)
          QTileAt(x-qhexx0,y-qhexy0,file,ico);
      }
    //other tiles    Section 5
    for (y=qhexy0; y<qhexyf; ++y)
      for (x=qhexx0; x<qhexxf; ++x)
      {
        addr=S2Addr(x,y);
        b1=mb[moff[5]+addr];
        b2=mb[moff[5]+addr+1];
        gnum=256*b2+b1; //if 2 bytes are ffff we get 0xFFFF for gnum
        file=gnum/250;
        ico =gnum%250;
        if (file<MAX_TERRAIN_FILES && CB5->Checked)
          QTileAt(x-qhexx0,y-qhexy0,file,ico);
      }
    //other tiles    Section 6
    for (y=qhexy0; y<qhexyf; ++y)
      for (x=qhexx0; x<qhexxf; ++x)
      {
        addr=S2Addr(x,y);
        b1=mb[moff[6]+addr];
        b2=mb[moff[6]+addr+1];
        gnum=256*b2+b1; //if 2 bytes are ffff we get 0xFFFF for gnum
        file=gnum/250;
        ico =gnum%250;
        if (file<MAX_TERRAIN_FILES && CB6->Checked)
          QTileAt(x-qhexx0,y-qhexy0,file,ico);
      }
    //other tiles    Section 7
    for (y=qhexy0; y<qhexyf; ++y)
      for (x=qhexx0; x<qhexxf; ++x)
      {
        addr=S2Addr(x,y);
        b1=mb[moff[7]+addr];
        b2=mb[moff[7]+addr+1];
        gnum=256*b2+b1; //if 2 bytes are ffff we get 0xFFFF for gnum
        file=gnum/250;
        ico =gnum%250;
        if (file<MAX_TERRAIN_FILES && CB7->Checked)
          QTileAt(x-qhexx0,y-qhexy0,file,ico);
      }
    if (ShowHexes1->Checked) QDrawHexes();

    //Save the bitmap and get rid of it
    TJPEGImage *jpgImg;
    jpgImg=new TJPEGImage;

    TFileStream *outf;
    outf=new TFileStream(SaveDialog1->FileName.c_str(), fmCreate);
    if (!outf)
    {
      delete jpgImg;
      delete qbmp;
      Application->MessageBox("Could not open output file","Error",MB_OK);
      return;
    }
    jpgImg->CompressionQuality=jpeg_quality;
    jpgImg->Assign(qbmp);
    jpgImg->SaveToStream(outf);

    delete jpgImg;
    delete outf;


    Screen->Cursor=crDefault;

    delete qbmp;

}

//---------------------------------------------------------------------------

void __fastcall TMainForm::TestBtnClick(TObject *Sender)
{
   DrawMap();

   //LoadShp->Show();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::HMapSBChange(TObject *Sender)
{
   hexx0=HMapSB->Position;
   DrawMap();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ShowHexes1Click(TObject *Sender)
{
  if (ShowHexes1->Checked) ShowHexes1->Checked=false;
  else ShowHexes1->Checked=true;
  DrawMap();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::VMapSBChange(TObject *Sender)
{
   hexy0=VMapSB->Position;
   if (hexy0&1)
   {
     ++hexy0;
     VMapSB->Position=hexy0;
   }
   DrawMap();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::MapImgClick(TObject *Sender)
{
   int x,y,addr,gnum;


   //this puts an mark where the mouse is clicked
   if (OldX<0)    //the first click
   {
     OldX=MouseX; OldY=MouseY;
   }
   else
   {
     for (x=-3; x<4; ++x)
       for (y=-3; y<4; ++y)
         MapImg->Picture->Bitmap->Canvas->Pixels[x+OldX][y+OldY]=
                (TColor)OldPix[x+5][y+5];
   }
   OldX=MouseX; OldY=MouseY;
   for (x=-3; x<4; ++x)
       for (y=-3; y<4; ++y)
       {
         OldPix[x+5][y+5]=MapImg->Picture->Bitmap->Canvas->Pixels[x+OldX][y+OldY];
         MapImg->Picture->Bitmap->Canvas->Pixels[x+OldX][y+OldY]=clYellow;
       }
   //here we transfer an image from the tranfer window to the map
   if (TileTransfer1->Checked && Button=='R')
   {
      SaveUndo(WhereX,WhereY);
      addr=S2Addr(WhereX,WhereY)+
               moff[TransferForm->SectionNumberUD->Position];
      gnum=250*TransferForm->FileNumberUD->Position+
              atoi(TransferForm->IconNumberLbl->Caption.c_str()+1);
      set_gnum(&(mb[addr]),gnum);
      DrawMap();
   }
   if (InspectionMode1->Checked) HexEditForm->Show();
   //--------- Toggle Road Terrain ---------------------
   if (ToggleRoad1->Checked)
   {
      addr=S8Addr(WhereX,WhereY);
      if (PavedRoad1->Checked) mb[moff[8]+addr]^=128;
      if (SecondaryRoad1->Checked) mb[moff[8]+addr]^=64;
      if (Railroad1->Checked) mb[moff[8]+addr+2]^=1;
      DrawMap();
   }
   //-------- end toggle road ---------------------------

   //------ Change Road Connections -----------------------
   if (ToggleRoadConnection1->Checked)
   {
      if (ClickNumber==1)
      {
        ClickNumber=2;
        Click1X=WhereX;
        Click1Y=WhereY;
      }
      else
      {
        ClickNumber=1;
        //unmake or make the connection
        //the original Y is odd
        int Click2X=WhereX;
        int Click2Y=WhereY;
        int offs=12;  //for 2 road

        if (PavedRoad1->Checked) offs=13;
        if (Railroad1->Checked) offs=14;
        addr=S8Addr(Click1X,Click1Y)+offs;
        if (Click1Y%2)
        {
          if (Click2X==Click1X-1 && Click2Y==Click1Y) //west
            mb[moff[8]+addr]^=8;
          if (Click2X==Click1X+1 && Click2Y==Click1Y) //east
            mb[moff[8]+addr]^=1;
          if (Click2X==Click1X+1 && Click2Y==Click1Y+1) //southeast
            mb[moff[8]+addr]^=2;
          if (Click2X==Click1X && Click2Y==Click1Y+1) //southwest
            mb[moff[8]+addr]^=4;
          if (Click2X==Click1X && Click2Y==Click1Y-1) //northwest
            mb[moff[8]+addr]^=16;
          if (Click2X==Click1X+1 && Click2Y==Click1Y-1) //northeast
            mb[moff[8]+addr]^=32;
          DrawMap();
        }
        else //started at even hex
        {
          if (Click2X==Click1X-1 && Click2Y==Click1Y) //west
            mb[moff[8]+addr]^=8;
          if (Click2X==Click1X+1 && Click2Y==Click1Y) //east
            mb[moff[8]+addr]^=1;
          if (Click2X==Click1X && Click2Y==Click1Y+1) //southeast
            mb[moff[8]+addr]^=2;
          if (Click2X==Click1X-1 && Click2Y==Click1Y+1) //southwest
            mb[moff[8]+addr]^=4;
          if (Click2X==Click1X-1 && Click2Y==Click1Y-1) //northwest
            mb[moff[8]+addr]^=16;
          if (Click2X==Click1X && Click2Y==Click1Y-1) //northeast
            mb[moff[8]+addr]^=32;
          DrawMap();
        }

      }

   }//------------ end change road connection --------

}
//---------------------------------------------------------------------------

void __fastcall TMainForm::InspectionMode1Click(TObject *Sender)
{
   //we will answer clicks by updating a window that shows
   //relavant data about the hex... editable later
   //if (edit_type !=SPWAW) return;
   if (InspectionMode1->Checked)
   {
     InspectionMode1->Checked=false;
     HexEditForm->Hide();
   }
   else
   {
     HexEditForm->Show();
     InspectionMode1->Checked=true;
   }
}
//---------------------------------------------------------------------------


void __fastcall TMainForm::LoadSP3Map1Click(TObject *Sender)
{
   FILE *inf;
   TMsgDlgButtons db;
   char ID[32];
   int error,i;

   db<<mbOK;

   OpenDialog1->Filter="Maps (*.dat)|*.dat|All Files (*.*)| *.*";
   if (!OpenDialog1->Execute()) return;

   inf=fopen(OpenDialog1->FileName.c_str(),"rb");
   if (!inf)
   {
     MessageDlg("Could not open "+OpenDialog1->FileName,
                  mtError,db,0);
     return;
   }
   OpenDialog1->InitialDir=
     OpenDialog1->FileName.SubString(1,OpenDialog1->FileName.LastDelimiter("\\"));
   fgets(ID,31,inf);
   if (strcmp(ID,"STEEL3_SAVE_V100"))
   {
     Application->MessageBox(
       "This is not a SP 3 file!","Fatal Error",MB_OK);
     return;
   }

   MainForm->Caption="SP3 : "+OpenDialog1->FileName;
   //load each of the needed sections
   saddress=0; //initaialize the pointer to the map buffer
   sexists[47]=true; //don't load for SP3
   for (i=2; i<=48; ++i)
   {
     if (sexists[i])
       error=load_section(inf,i,&(mb[saddress]));
     else error=0;
     if (error)
     {
       fclose(inf);
       MessageDlg("Could not find section "+IntToStr(error),
                  mtError,db,0);
       return;
     }
   }
   fclose(inf);
   hexx0=0; hexy0=0;
   edit_type=SP3;
   VMapSB->Position=0; HMapSB->Position=0;
   DrawMap();
   strat_change=true;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::SetShpDirectory1Click(TObject *Sender)
{
   OpenDialog1->Filter="shp Files (*.shp)|*.shp|All files (*.*)|*.*";
   if (!OpenDialog1->Execute()) return;
   AnsiString Astr=OpenDialog1->FileName.SubString(
                     1,OpenDialog1->FileName.LastDelimiter("\\"));
   strcpy(tilespath,Astr.c_str());
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::About1Click(TObject *Sender)
{
  Application->MessageBox(
  "WW2 Map Version 0.12b\nCopyright Fred Chlanda\nFebruary 2006\nchlanda@hotmail.com",
  "About Fred's Steel Panthers World War 2 Map",MB_OK);
}
//-----------------------------------------------------------------------
// -------------------------------------------------------------
void __fastcall TMainForm :: SaveSection(int section,FILE *outf)
{
   int bytes_to_write=0,offs,size;  //size is the uncompressed size
                                    //offs is the start offset in mb
   int count,p,ch,i;
   int compressed;

   // on entering outf should point to where header etc
   //should be written
    //if (section==47) return;
   //we need to make a pass thru to find how long the compressed
   //section will be
   p=0;  size=ssz[section]; offs=moff[section];
   while (p<size)
   {
     if (mb[offs+p]==mb[offs+p+1] && mb[offs+p]==mb[offs+p+2]) //compressible
     {
       count=0x80; ch=mb[p+offs];
       bytes_to_write+=2;
       while (mb[offs+p]==ch && count<255 && p<size)
       {
        ++p; ++count;
       }
       //write when writing
     } //end of consective run of bytes
     else
     {
      count=0;
      ++bytes_to_write;
      while (count<127
        && !(mb[p+offs]==mb[offs+p+1] && mb[p+offs]==mb[offs+p+2])
        && p<size)
      {
        ++p;
        ++count;
        ++bytes_to_write;
      }
      // here write string of non identical bytes
     }
   }

   //here we should have size of block in bytes_to_write;
   if (size<=bytes_to_write)
   {
     compressed=0;
     bytes_to_write=size;
   }
   else compressed=1;
   fwrite(&section,4,1,outf);

   fwrite(&bytes_to_write,4,1,outf);
   
   fwrite(&compressed,1,1,outf);
   if (compressed==0) //bigger compressed, don't compress it
   {
    //fputc(0,outf); //not compressed flag

    for (i=0; i<size; ++i)
     fputc(mb[offs+i],outf);
    return;
   }

   //now write to the file
   p=0;
   while (p<size)
   {
     if (mb[p+offs]==mb[offs+p+1] && mb[p+offs]==mb[p+offs+2]) //compressible
     {
       count=0x80; ch=mb[p+offs];
       bytes_to_write+=2;
       while (mb[p+offs]==ch && count<255 && p<size)
       {
        ++p; ++count;
       }
       fputc(count,outf);
       fputc(ch,outf);
     } //end of consective run of bytes
     else
     {
      count=0;
      ++bytes_to_write;
      while (count<127
        && !(mb[p+offs]==mb[offs+p+1] && mb[p+offs]==mb[offs+p+2])
        &&p<size)
      {
        ++p;
        ++count;
        ++bytes_to_write;
      }
      fputc(count,outf);
      for (i=p-count; i<p; ++i)
        fputc(mb[offs+i],outf);

     }
   }
}
//---------------------------------------------------------------------
int __fastcall TMainForm :: RoadConnection(int x, int y, int t)
{
   //t=type
   //a primary is 128 and sec is 64 at offs 7
   // looks like offs 0 for WAW
   int r=0;

   if (y&1) //odd row
   {
     if (mb[S8Addr(x-1,y)+0+moff[8]]&t) r+=8;
     if (mb[S8Addr(x,y-1)+0+moff[8]]&t)
       r+=16;
     if (mb[S8Addr(x+1,y-1)+0+moff[8]]&t) r+=32;
     if (mb[S8Addr(x+1,y)+0+moff[8]]&t) r+=1;
     if (mb[S8Addr(x+1,y+1)+0+moff[8]]&t) r+=2;
     if (mb[S8Addr(x,y+1)+0+moff[8]]&t) r+=4;
   }
   else //even row
   {
     if (mb[S8Addr(x-1,y)+0+moff[8]]&t) r+=8;
     if (mb[S8Addr(x-1,y-1)+0+moff[8]]&t) r+=16;
     if (mb[S8Addr(x,y-1)+0+moff[8]]&t) r+=32;
     if (mb[S8Addr(x+1,y)+0+moff[8]]&t) r+=1;
     if (mb[S8Addr(x,y+1)+0+moff[8]]&t) r+=2;
     if (mb[S8Addr(x-1,y+1)+0+moff[8]]&t) r+=4;
   }
   return r;
}

//----------------------------------------------------------------------

// we use this when converting to add in bridges and connection between
// different types of roads;
int __fastcall TMainForm :: NewRoadConnection(int x, int y, int t)
{
   //t=type
   //a primary is 128 and sec is 64 at offs 7

   int r=0;
   int bt;

   // we don't care what kind of a bridge ore road
   //we connect to so we include both type in the
   //bitfield mask

   t=192; // 64|| 128
   bt=3;  // 1 || 2
   if (y&1) //odd row
   {
     if (mb[S8Addr(x-1,y)+0+moff[8]]&t ||
         mb[S8Addr(x-1,y)+0+moff[8]+1]&bt)
         r+=8;
     if (mb[S8Addr(x,y-1)+0+moff[8]]&t ||
         mb[S8Addr(x,y-1)+0+moff[8]+1]&bt)
         r+=16;
     if (mb[S8Addr(x+1,y-1)+0+moff[8]]&t ||
         mb[S8Addr(x+1,y-1)+0+moff[8]+1]&bt)
         r+=32;
     if (mb[S8Addr(x+1,y)+0+moff[8]]&t ||
         mb[S8Addr(x+1,y)+0+moff[8]+1]&bt)
         r+=1;
     if (mb[S8Addr(x+1,y+1)+0+moff[8]]&t ||
         mb[S8Addr(x+1,y+1)+0+moff[8]+1]&bt)
         r+=2;
     if (mb[S8Addr(x,y+1)+0+moff[8]]&t ||
         mb[S8Addr(x,y+1)+0+moff[8]+1]&bt)
         r+=4;
   }
   else //even row
   {
     if (mb[S8Addr(x-1,y)+0+moff[8]]&t ||
         mb[S8Addr(x-1,y)+0+moff[8]+1]&bt)
         r+=8;
     if (mb[S8Addr(x-1,y-1)+0+moff[8]]&t ||
         mb[S8Addr(x-1,y-1)+0+moff[8]+1]&bt)
         r+=16;
     if (mb[S8Addr(x,y-1)+0+moff[8]]&t ||
         mb[S8Addr(x,y-1)+0+moff[8]+1]&bt)
         r+=32;
     if (mb[S8Addr(x+1,y)+0+moff[8]]&t ||
         mb[S8Addr(x+1,y)+0+moff[8]+1]&bt)
         r+=1;
     if (mb[S8Addr(x,y+1)+0+moff[8]]&t ||
         mb[S8Addr(x,y+1)+0+moff[8]+1]&bt)
         r+=2;
     if (mb[S8Addr(x-1,y+1)+0+moff[8]]&t ||
         mb[S8Addr(x-1,y+1)+0+moff[8]+1]&bt)
         r+=4;
   }
   return r;
}

//----------------------------------------------------------------------
//when converting from sp2 to sp3 we need to change section 8
void __fastcall TMainForm :: SaveSection8sp3(FILE *outf)
{
   int bytes_to_write=0,offs,size;  //size is the uncompressed size
                                    //offs is the start offset in mb
   int count,p,ch,i,x,y;
   int compressed,addr,sp3addr;
   unsigned char mbt[152000]; //this is a temporary buffer to hold one sp3 record
   int section=8;


   // on entering outf should point to where header etc
   //should be written

   //in this section we construct a new buffer mbt which holds the
   //data converted from sp2

   for (x=0; x<100; ++x)
     for (y=0; y<80; ++y)
     {
         sp3addr=x*19*80+y*19;
         for (i=0; i<WAW_S8_REC; ++i)
           mbt[sp3addr+i]=0;
         addr=12*80*x+12*y;
         mbt[sp3addr+0]=mb[moff[8]+addr+7];  //terrain?
         mbt[sp3addr+4]=mb[moff[8]+addr+0];  //alt
         mbt[sp3addr+5]=mb[moff[8]+addr+1];   //alt
         mbt[sp3addr+6]=mb[moff[8]+addr+2];
         mbt[sp3addr+8]=mb[moff[8]+addr+4];

         //here we do road connectivity
         if (mb[moff[8]+addr+0]&128)
           mbt[sp3addr+13]=(byte)RoadConnection(x,y,128);
         if (mb[moff[8]+addr+0]&64)
           mbt[sp3addr+12]=(byte)RoadConnection(x,y,64);

         //here are some terrain conversions
         if (mb[moff[29]+80*x+y]==10) mbt[sp3addr+1]=4; //swamp
         if (mb[moff[29]+80*x+y]&4) mbt[sp3addr+1]=16; //rough
       //  if (mb[moff[29]+80*x+y]==36) mbt[sp3addr+1]=1; //wood bridge
     }

   //we need to make a pass thru to find how long the compressed
   //section will be
   p=0;  size=152000; offs=0;
   while (p<size)
   {
     if (mbt[offs+p]==mbt[offs+p+1] && mbt[offs+p]==mbt[offs+p+2]) //compressible
     {
       count=0x80; ch=mbt[p+offs];
       bytes_to_write+=2;
       while (mbt[offs+p]==ch && count<255 && p<size)
       {
        ++p; ++count;
       }
       //write when writing
     } //end of consective run of bytes
     else
     {
      count=0;
      ++bytes_to_write;
      while (count<127
        && !(mbt[p+offs]==mbt[offs+p+1] && mbt[p+offs]==mbt[offs+p+2])
        && p<size)
      {
        ++p;
        ++count;
        ++bytes_to_write;
      }
      // here write string of non identical bytes
     }
   }

   //here we should have size of block in bytes_to_write;
   if (size<=bytes_to_write)
   {
     compressed=0;
     bytes_to_write=size;
   }
   else compressed=1;
   fwrite(&section,4,1,outf);
   if (edit_type==SPWW2) bytes_to_write=-bytes_to_write;
   fwrite(&bytes_to_write,4,1,outf);
   if (edit_type==SPWW2) bytes_to_write=-bytes_to_write;
   if (compressed==0) //bigger compressed, don't compress it
   {
    fputc(0,outf); //not compressed flag
    for (i=0; i<size; ++i)
     fputc(mbt[offs+i],outf);
    return;
   }
   fputc(1,outf);

   //now write compressed to the file
   p=0;
   while (p<size)
   {
     if (mbt[p+offs]==mbt[offs+p+1] && mbt[p+offs]==mbt[p+offs+2]) //compressible
     {
       count=0x80; ch=mbt[p+offs];
       bytes_to_write+=2;
       while (mbt[p+offs]==ch && count<255 && p<size)
       {
        ++p; ++count;
       }
       fputc(count,outf);
       fputc(ch,outf);
     } //end of consective run of bytes
     else
     {
      count=0;
      ++bytes_to_write;
      while (count<127
        && !(mbt[p+offs]==mbt[offs+p+1] && mbt[p+offs]==mbt[offs+p+2])
        &&p<size)
      {
        ++p;
        ++count;
        ++bytes_to_write;
      }
      fputc(count,outf);
      for (i=p-count; i<p; ++i)
        fputc(mbt[offs+i],outf);

     }
   }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::SaveMapFile1Click(TObject *Sender)
{
   int sec,dummy=0;
   FILE *outf;
   char msg[128];

   SaveDialog1->DefaultExt="dat";
   SaveDialog1->Filter="Map Files (*.dat)|*.dat|All Files (*.*)|*.*";
   SaveDialog1->InitialDir=OpenDialog1->InitialDir;
   if (!SaveDialog1->Execute()) return;
   outf=fopen(SaveDialog1->FileName.c_str(),"wb");
   if (!outf)
   {
     sprintf(msg,"Could not open output map file %s.",
       SaveDialog1->FileName.c_str());

     Application->MessageBox("File Error",msg,MB_OK);
     return;
   }
   //we need to write a header

   fputs("SPCTS_SAVE_V100",outf);

   fwrite(&dummy,4,1,outf); fputc(0,outf);


   //we need to write each of the appropriate sections...
   //first checking if the section should be compressed
   for (sec=2; sec<=54; ++sec)
   {
     if (!sexists[sec]) continue;
     SaveSection(sec,outf);

   }
   fclose(outf);
}
/*
//---------------------------------------------------------------------------
void __fastcall TMainForm::ConvertSP2toSP31Click(TObject *Sender)
{
   int sec,dummy=0,i;
   FILE *outf;
   char msg[128];

   SaveDialog1->DefaultExt="dat";
   SaveDialog1->InitialDir=OpenDialog1->InitialDir;
   if (!SaveDialog1->Execute()) return;
   outf=fopen(SaveDialog1->FileName.c_str(),"wb");
   if (!outf)
   {
     sprintf(msg,"Could not open output map file %s.",
       SaveDialog1->FileName.c_str());

     Application->MessageBox("File Error",msg,MB_OK);
     return;
   }
   //we need to write a header  for SP3
   fputs("STEEL3_SAVE_V100",outf);
   fwrite(&dummy,4,1,outf);


   //we need to write each of the appropriate sections...
   //first checking if the section should be compressed
   for (sec=2; sec<8; ++sec) //sectors 2-7 are the same... roads? in 4&5
     SaveSection(sec,outf);

   //section 8 requires conversion
   SaveSection8sp3(outf);

   //we will do a sloppy thing and steal part of the mb[] array
   //to hold a fake section 47 and fudge the sexists array
   sexists[47]=true; ssz[47]=6400; moff[47]=MAX_MAP-6400;
   for (i=moff[47]; i<moff[47]+6400; ++i)
     mb[i]=0;
   for (sec=9; sec<=48; ++sec) //finish the rest with the faked s47
     if (sexists[sec]) SaveSection(sec,outf);
   //fix up the fake s47
   sexists[47]=false; ssz[47]=0;
   fclose(outf);

}
*/
//---------------------------------------------------------------------------

void __fastcall TMainForm::Tools1Click(TObject *Sender)
{
   ImportForm->Show();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::CopyToFile1Click(TObject *Sender)
{
    int x0,y0,x1,y1;
    int result;

    //fix up the dialog for copy input
    CopyForm->Caption="Copy->File";
    CopyForm->CopyBtn->Caption="Copy";
    CopyForm->X1Edit->Visible=true;
    CopyForm->Y1Edit->Visible=true;
    CopyForm->BRLbl->Visible=true;

    result=CopyForm->ShowModal();

    if (result!=1) return;
    x0=StrToInt(CopyForm->X0Edit->Text);
    x1=StrToInt(CopyForm->X1Edit->Text);
    y0=StrToInt(CopyForm->Y0Edit->Text);
    y1=StrToInt(CopyForm->Y1Edit->Text);

    if (!SaveDialog1->Execute()) return;
    copy_to_file(x0,y0,x1,y1);
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::PasteFromFile1Click(TObject *Sender)
{
  int x0,y0;
    int result;

    //adapt dialog for paste input
    CopyForm->Caption="Paste";
    CopyForm->CopyBtn->Caption="Paste";
    CopyForm->X1Edit->Visible=false;
    CopyForm->Y1Edit->Visible=false;
    CopyForm->BRLbl->Visible=false;

    result=CopyForm->ShowModal();

    if (result!=1) return;
    x0=StrToInt(CopyForm->X0Edit->Text);
    y0=StrToInt(CopyForm->Y0Edit->Text);

    if (!OpenDialog1->Execute()) return;
    paste_from_file(x0,y0);


}
//-------------------------------------------------------------------
void __fastcall TMainForm::copy_to_clipboard(int x0,int y0,int x1,int y1)
{
  char *buffer;
  int size,pos=0;
  int x,y,xs,ys,i;
  int addr;

   xs=x1-x0+1;
   ys=y1-y0+1;
   if (xs<1 || ys<1) return;

   size=xs*ys*200;

   buffer=new char[size];
   if (!buffer)
   {
     Application->MessageBox("Could not allocate buffer",
                              "Copy Aborted", MB_OK);
     return;
   }

   pos+=sprintf(buffer+pos,"%3d %3d %3d\r\n",edit_type,xs,ys); //type and the size
   for (y=y0; y<=y1; ++y)
    for (x=x0; x<=x1; ++x)
    {
      addr=S29Addr(x,y)+moff[29];
      pos+=sprintf(buffer+pos,"%3d ",mb[addr]);

      addr=S2Addr(x,y)+moff[2];
      pos+=sprintf(buffer+pos,"%3d ",mb[addr]);
      pos+=sprintf(buffer+pos,"%3d ",mb[addr+1]);

      addr=S2Addr(x,y)+moff[3];
      pos+=sprintf(buffer+pos,"%3d ",mb[addr]);
      pos+=sprintf(buffer+pos,"%3d ",mb[addr+1]);

      addr=S2Addr(x,y)+moff[4];
      pos+=sprintf(buffer+pos,"%3d ",mb[addr]);
      pos+=sprintf(buffer+pos,"%3d ",mb[addr+1]);

      addr=S2Addr(x,y)+moff[5];
      pos+=sprintf(buffer+pos,"%3d ",mb[addr]);
      pos+=sprintf(buffer+pos,"%3d ",mb[addr+1]);

      addr=S2Addr(x,y)+moff[6];
      pos+=sprintf(buffer+pos,"%3d ",mb[addr]);
      pos+=sprintf(buffer+pos,"%3d ",mb[addr+1]);

      addr=S2Addr(x,y)+moff[7];
      pos+=sprintf(buffer+pos,"%3d ",mb[addr]);
      pos+=sprintf(buffer+pos,"%3d ",mb[addr+1]);

      addr=S8Addr(x,y)+moff[8];
      for (i=0; i<14; ++i)
        pos+=sprintf(buffer+pos,"%3d ",mb[addr+i]);

      addr=S28Addr(x,y)+moff[28];
      for (i=0; i<20; ++i)
        pos+=sprintf(buffer+pos,"%3d ",mb[addr+i]);

      pos+=sprintf(buffer+pos,"\r\n");
    }

    Clipboard()->SetTextBuf(buffer);
    delete[] buffer;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::CopyToClipboard1Click(TObject *Sender)
{
    int x0,y0,x1,y1;
    int result;

    //fix up the dialog for copy input
    CopyForm->Caption="Copy->File";
    CopyForm->CopyBtn->Caption="Copy";
    CopyForm->X1Edit->Visible=true;
    CopyForm->Y1Edit->Visible=true;
    CopyForm->BRLbl->Visible=true;

    result=CopyForm->ShowModal();

    if (result!=1) return;
    x0=StrToInt(CopyForm->X0Edit->Text);
    x1=StrToInt(CopyForm->X1Edit->Text);
    y0=StrToInt(CopyForm->Y0Edit->Text);
    y1=StrToInt(CopyForm->Y1Edit->Text);

    copy_to_clipboard(x0,y0,x1,y1);


}
int get_line(char *dest,int max, char *src)
{
   int count=0;

   //starting at src read untill max characters are
   //read or 2 <32 characters are encountered that
   //terminate a line ... returb how many are read


   while (src[count]>=32 && count<max)
   {
     dest[count]=src[count];
     ++count;
   }

   dest[count]=src[count];
   ++count;
   dest[count]=src[count];
   ++count;
   dest[count]=0;
   return count;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::PasteFromClipboard1Click(TObject *Sender)
{
   char buffer[256];
   char *clipb;
   int  t,w,h,size,result;
   int  i,v[47],pos;
   int  addr,xs,ys,x,y,x0,y0;


   //check to see if clipboard might be valid
   if (!(Clipboard()->HasFormat(CF_TEXT)))
   {
     Application->MessageBox("The clipboard does not contain text.",
     "ClipBoard Paste Error", MB_OK);
     return;
   }
   //get origin to paste to
   //adapt dialog for paste input
    CopyForm->Caption="Paste";
    CopyForm->CopyBtn->Caption="Paste";
    CopyForm->X1Edit->Visible=false;
    CopyForm->Y1Edit->Visible=false;
    CopyForm->BRLbl->Visible=false;

    result=CopyForm->ShowModal();

    if (result!=1) return;
    x0=StrToInt(CopyForm->X0Edit->Text);
    y0=StrToInt(CopyForm->Y0Edit->Text);


   //read the type and dimensions
   Clipboard()->GetTextBuf(buffer,127);
   sscanf(buffer,"%d %d %d",&t,&w,&h);


   if (t!=4 || w<1 || w>159 || h<1 || h>199) //changed
   {
      Application->MessageBox("Data on clipboard is invalid",
                              "Clipboard Paste Error",MB_OK);
      return;
   }
   // get the clipboard here
   size=200*w*h;
   clipb= new char[size];
   if (!clipb)
   {
     Application->MessageBox(
                      "Could not copy from clipboard to buffer",
                      "Clipboard Paste Error",MB_OK);
      return;

   }
   Clipboard()->GetTextBuf(clipb,size);

   //now read in a line at a time and parse it
   pos=0;
   pos+=get_line(buffer,255,clipb+pos);
   sscanf(buffer,"%d %d %d",&t,&w,&h);

   xs=x0+w; ys=y0+h;

    for (y=y0; y<ys; ++y)
      for (x=x0; x<xs; ++x)
      {
        pos+=get_line(buffer,255,clipb+pos);
        if (x<100 && y<80)
        {
          for (i=0; i<47; ++i) //47 fields per line...each 4 columns
            sscanf(&(buffer[4*i]),"%d",&(v[i]));

          addr=S29Addr(x,y)+moff[29];
          mb[addr]=(byte)v[0];

          addr=S2Addr(x,y)+moff[2];
          mb[addr]=(byte)v[1];
          mb[addr+1]=(byte)v[2];

          addr=S2Addr(x,y)+moff[3];
          mb[addr]=(byte)v[3];
          mb[addr+1]=(byte)v[4];

          addr=S2Addr(x,y)+moff[4];
          mb[addr]=(byte)v[5];
          mb[addr+1]=(byte)v[6];

          addr=S2Addr(x,y)+moff[5];
          mb[addr]=(byte)v[7];
          mb[addr+1]=(byte)v[8];

          addr=S2Addr(x,y)+moff[6];
          mb[addr]=(byte)v[9];
          mb[addr+1]=(byte)v[10];

          addr=S2Addr(x,y)+moff[7];
          mb[addr]=(byte)v[11];
          mb[addr+1]=(byte)v[12];

          addr=S8Addr(x,y)+moff[8];
          for (i=0; i<14; ++i)
            mb[addr+i]=(byte)v[13+i];

          addr=S28Addr(x,y)+moff[28];
          for (i=0; i<20; ++i)
            mb[addr+i]=(byte)v[27+i];

        }
    }

    delete[] clipb;


}

//---------------------------------------------------------------------------

void __fastcall TMainForm::StratMap1Click(TObject *Sender)
{
    StratForm->Show();    
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::TileTransfer1Click(TObject *Sender)
{
    //if (edit_type!=SPWAW) return;
    if (tile_transfer)
    {
       tile_transfer=false;
       TransferForm->Hide();
       TileTransfer1->Checked=false;
    }
    else
    {
       tile_transfer=true;
       TransferForm->Show();
       TileTransfer1->Checked=true;
    }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::SpeedButton1Click(TObject *Sender)
{
  TileTransfer1Click(Sender);
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::RedrawBtnClick(TObject *Sender)
{
   DrawMap();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::MapImgMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
   int addr,gnum;

   if (Button==mbLeft) Button='L';
     else Button='R';
   //here we transfer an image from the tranfer window to the map
   if (TileTransfer1->Checked && Button=='R')
   {
      SaveUndo(WhereX,WhereY);
      addr=S2Addr(WhereX,WhereY)+
               moff[TransferForm->SectionNumberUD->Position];
      gnum=250*TransferForm->FileNumberUD->Position+
              atoi(TransferForm->IconNumberLbl->Caption.c_str()+1);
      set_gnum(&(mb[addr]),gnum);
      DrawMap();
   }
   else return;
   if (InspectionMode1->Checked) HexEditForm->Show();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ShowHexesBtnClick(TObject *Sender)
{
  ShowHexes1Click(Sender);

}
//---------------------------------------------------------------------------

void __fastcall TMainForm::SaveMapImage1Click(TObject *Sender)
{
  SaveMapImg();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Exit1Click(TObject *Sender)
{
  MainForm->Close();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ImageQuality1Click(TObject *Sender)
{
    QualityForm->Show();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ContourMap1Click(TObject *Sender)
{
  ContourForm->Show();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::LoadSPWW2v3Map1Click(TObject *Sender)
{
   FILE *inf;
   TMsgDlgButtons db;
   char ID[32];
   int error,i;

   db<<mbOK;

   OpenDialog1->Filter="Maps (*.dat)|*.dat|All Files (*.*)| *.*";
   if (!OpenDialog1->Execute()) return;

   inf=fopen(OpenDialog1->FileName.c_str(),"rb");
   if (!inf)
   {
     MessageDlg("Could not open "+OpenDialog1->FileName,
                  mtError,db,0);
     return;
   }
   OpenDialog1->InitialDir=
     OpenDialog1->FileName.SubString(1,OpenDialog1->FileName.LastDelimiter("\\"));
   fgets(ID,31,inf);
   if (strcmp(ID,"SPCTS_SAVE_V100") )
   {
     Application->MessageBox(
       "This is not a SPWW2 file!","Fatal Error",MB_OK);
     return;
   }

   MainForm->Caption="WW2 : "+OpenDialog1->FileName;
   //load each of the needed sections
   saddress=0; //initaialize the pointer to the map buffer
   sexists[47]=false; //don't load for SP3 and WWSP
   for (i=2; i<=MAX_SECTIONS; ++i)
   {
     if (sexists[i])
       error=load_section(inf,i,&(mb[saddress]));
     else error=0;
     if (error)
     {
       fclose(inf);
       MessageDlg("Could not find section "+IntToStr(error),
                  mtError,db,0);
       return;
     }
   }
   fclose(inf);
   hexx0=0; hexy0=0;
   edit_type=SP2;

   //temp--------
   //this works...I don't why
     moff[54]=moff[54]-6400;
   //---- end temp


   MapSizeX=mb[moff[38]]; MapSizeY=mb[moff[39]];
   VMapSB->Position=0; HMapSB->Position=0;
   HMapSB->Max=MapSizeX-14;
   VMapSB->Max=MapSizeY-12;
   MaxXST->Caption=MapSizeX;
   MaxYST->Caption=MapSizeY;
   
   DrawMap();
   strat_change=true;
   //if (ssz[2]>16000) mapsize=200; else mapsize=80;

   ConvertWW22toWW23->Enabled=true;
   //SP3Map1->Enabled=true;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ImportSDTSDEM1Click(TObject *Sender)
{
   SDTS->Show();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ShowRoadConnections1Click(TObject *Sender)
{
/*  if (ShowRoadConnections1->Checked)
  {
    ShowRoadConnections1->Checked=false;
    DrawMap();
  }
  else
  {
    ShowRoadConnections1->Checked=true;
    ShowAllRoadConnections1->Checked=false;
    DrawMap();
  }
  */
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ToggleRoadConnection1Click(TObject *Sender)
{
 /*  if (ToggleRoadConnection1->Checked)
   {
     ToggleRoadConnection1->Checked=false;
     ClickNumber=0;
     DrawMap();
   }
   else
   {
     ToggleRoadConnection1->Checked=true;
     ShowRoadConnections1->Checked=true;
     ShowAllRoadConnections1->Checked=false;
     ToggleRoad1->Checked=false;
     ClickNumber=1;
     DrawMap();
   } */
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ToggleRoad1Click(TObject *Sender)
{
 /* if (ToggleRoad1->Checked)
   {
     ToggleRoad1->Checked=false;
     ClickNumber=0;

   }
   else
   {
     ToggleRoad1->Checked=true;
     ShowRoadConnections1->Checked=true;
     ShowAllRoadConnections1->Checked=false;
     ToggleRoadConnection1->Checked=false;
     ClickNumber=1;
   }
   DrawMap();   */
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::PavedRoad1Click(TObject *Sender)
{
  /* if (PavedRoad1->Checked) PavedRoad1->Checked=false;
    else
    {
      PavedRoad1->Checked=true;
      Railroad1->Checked=false;
      SecondaryRoad1->Checked=false;
      ShowAllRoadConnections1->Checked=false;

    }
    DrawMap(); */
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::SecondaryRoad1Click(TObject *Sender)
{
  /* if (SecondaryRoad1->Checked) SecondaryRoad1->Checked=false;
    else
    {
      PavedRoad1->Checked=false;
      Railroad1->Checked=false;
      SecondaryRoad1->Checked=true;
      ShowAllRoadConnections1->Checked=false;
    }
    DrawMap();
    */
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Railroad1Click(TObject *Sender)
{
  /*  if (Railroad1->Checked) SecondaryRoad1->Checked=false;
    else
    {
      PavedRoad1->Checked=false;
      Railroad1->Checked=true;
      SecondaryRoad1->Checked=false;
      ShowAllRoadConnections1->Checked=false;
    }
    DrawMap();
    */
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ShowAllRoadConnections1Click(TObject *Sender)
{
  /*if (ShowAllRoadConnections1->Checked)
  {
    ShowAllRoadConnections1->Checked=false;
    DrawMap();
  }
  else
  {
    ShowAllRoadConnections1->Checked=true;
    ShowRoadConnections1->Checked=false;
    Railroad1->Checked=false;
    SecondaryRoad1->Checked=false;
    PavedRoad1->Checked=false;
    DrawMap();
  }
  */
}

void __fastcall TMainForm::CopyHex(int destx,int desty,int srcx,int srcy)
{
  int soffs=S2Addr(srcx,srcy);
  int doffs=S2Addr(destx,desty);

  mb[moff[2]+doffs]=mb[moff[2]+soffs];      //the tile
  mb[moff[2]+doffs+1]=mb[moff[2]+soffs+1];

  soffs=S8Addr(srcx,srcy);       //terrain features
  doffs=S8Addr(destx,desty);
  for (int i=0; i<20; ++i)
    mb[moff[8]+doffs+i]=mb[moff[8]+soffs+i];

}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ConvertWW2toWAW1xClick(TObject *Sender)
{
   //a clear SPWW2 V3 map should be in mb  before we come here
   FILE *inf;
   char msg[128];
   unsigned char buffer[550000]; //to hold V2 map sections
   int v2addr,v3addr;

   OpenDialog1->DefaultExt="dat";
   OpenDialog1->Title="Pick SPWW2 V2 Map to Convert";
   if (!OpenDialog1->Execute()) return;
   inf=fopen(OpenDialog1->FileName.c_str(),"rb");
   if (!inf)
   {
     sprintf(msg,"Could not open V2 SPWW2 map file %s.",
       OpenDialog1->FileName.c_str());

     Application->MessageBox("File Error",msg,MB_OK);
     return;
   }
   fgets(msg,20,inf);
   if (strcmp(msg,"STEEL2_SAVE_V100"))
   {
     fclose(inf);
     Application->MessageBox(
       "This is not a SP2 version 1.1 or SPWW2 file!","Fatal Error",MB_OK);
     return;
   }

   //we need to read each of the appropriate sections...
   //and fix up as necessary



   //2-7 these sections need to be expanded
   for (int sec=2; sec<8; ++sec) //sectors 2-7 are the same... roads? in 4&5
     load_ww2_section(inf,sec,&(buffer[V2_S2_ADDR+(sec-2)*V2_S2_SIZE]));


   //read sections 8,16,17 20 28 29 38 39 48
   load_ww2_section(inf,8,&(buffer[V2_S8_ADDR]));
   load_ww2_section(inf,16,&(buffer[V2_S16_ADDR]));
   load_ww2_section(inf,17,&(buffer[V2_S17_ADDR]));
   load_ww2_section(inf,20,&(buffer[V2_S20_ADDR]));
   load_ww2_section(inf,28,&(buffer[V2_S28_ADDR]));
   load_ww2_section(inf,29,&(buffer[V2_S29_ADDR]));
   load_ww2_section(inf,38,&(buffer[V2_S38_ADDR]));
   load_ww2_section(inf,39,&(buffer[V2_S39_ADDR]));
   load_ww2_section(inf,48,&(buffer[V2_S48_ADDR]));


   fclose(inf);
   // these sections do not need to be adjusted
   mb[moff[16]]=buffer[V2_S16_ADDR];

   //s17 is formation info which should be blank for a map
   mb[moff[20]]=buffer[V2_S20_ADDR];

   for (int i=0; i<4; ++i)
   {
     mb[moff[38]+i]=buffer[V2_S38_ADDR+i];
     mb[moff[39]+i]=buffer[V2_S39_ADDR+i];
   }

   //----- fix up some conversion problems -----------
   //sections 2-7 need to go from 100x80 maps to 100x200
   for (int s=2; s<8; ++s)
     for (int y=0; y<80; ++y)
       for (int x=0; x<100; ++x)
       {
         v2addr=(s-2)*V2_S2_SIZE+V2_S2_ADDR+V2S2Addr(x,y);
         v3addr=moff[s]+S2Addr(x,y);
         mb[v3addr]=buffer[v2addr];
         mb[v3addr+1]=buffer[v2addr+1];
       }
   //section 8 records need to go from 12 to 15 bytes and larger map
   //only the first 9 bytes will be copied since i never see the
   //others being used ... byte 9&10 are now part of terrain which is 32bits
   for (int y=0; y<80; ++y)
     for (int x=0; x<100; ++x)
     {
       v2addr=V2_S8_ADDR+V2S8Addr(x,y);
       v3addr=moff[8]+S8Addr(x,y);
       for (int i=0; i<9; ++i)
         mb[v3addr+i]=buffer[v2addr+i];
     }


   //section 28 needs to go from 100x80 to 100x200
   //each record is 13 bytes long
   for (int y=0; y<80; ++y)
     for (int x=0; x<100; ++x)
     {
       v2addr=V2_S28_ADDR+V2S28Addr(x,y);
       v3addr=moff[28]+S28Addr(x,y);
       for (int i=0; i<13; ++i)
         mb[v3addr+i]=buffer[v2addr+i];
     }

   //section 29 goes from 1 to 2 bytes  and bigger map
   for (int y=0; y<80; ++y)
     for (int x=0; x<100; ++x)
     {
       v2addr=V2_S29_ADDR+V2S29Addr(x,y);
       v3addr=moff[29]+S29Addr(x,y);
       mb[v3addr]=buffer[v2addr];
     }

   DrawMap();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::RetainMinesClick(TObject *Sender)
{
   if (RetainMines->Checked) RetainMines->Checked=false;
   else RetainMines->Checked=true;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::UndoBtnClick(TObject *Sender)
{
   RestoreUndo();
   UndoBtn->Enabled=false;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::SP3Map1Click(TObject *Sender)
{
   // the blank version 1 map should be loaded
   int sec,i;
   int sp2addr,wawaddr;
   FILE *inf;
   char msg[128];
   unsigned char buff[152000]; //to hold s8 and s28

   OpenDialog1->DefaultExt="dat";
   OpenDialog1->Title="Pick SP3 Map to Convert";
   if (!OpenDialog1->Execute()) return;
   inf=fopen(OpenDialog1->FileName.c_str(),"rb");
   if (!inf)
   {
     sprintf(msg,"Could not open SP3 map file %s.",
       OpenDialog1->FileName.c_str());

     Application->MessageBox("File Error",msg,MB_OK);
     return;
   }
   fgets(msg,20,inf);
   if (strcmp(msg,"STEEL3_SAVE_V100"))
   {
     fclose(inf);
     Application->MessageBox(
       "This is not a SP3 file!","Fatal Error",MB_OK);
     return;
   }

   //we need to read each of the appropriate sections...
   //and fix up as necessary

   //these sections don't need to be converted
   for (sec=2; sec<8; ++sec) //sectors 2-7 are the same... roads? in 4&5
     load_ww2_section(inf,sec,&(mb[moff[sec]]));


   //read sections 16 20 29 38 39
   load_ww2_section(inf,16,&(mb[moff[16]]));
   load_ww2_section(inf,20,&(mb[moff[20]]));
   load_ww2_section(inf,29,&(mb[moff[29]]));
   load_ww2_section(inf,38,&(mb[moff[38]]));
   load_ww2_section(inf,39,&(mb[moff[39]]));

   //section 8 requires conversion to 20 byte records with different structure
   // and road connections
   load_ww2_section(inf,8,buff);
   for (int rec=0; rec<8000; ++rec)
   {
     int sp3addr=rec*19;
     int wawaddr=rec*20;

     for (int i=0; i<19; ++i)
      mb[moff[8]+wawaddr+i]=buff[sp3addr+i];
   }


   //section 28 needs to be expanded from 13 to 14 byte records
   load_ww2_section(inf,28,buff);
   for (int rec=0; rec<8000; ++rec)
   {
     int sp3addr=rec*13;
     int wawaddr=rec*14;
     mb[moff[28]+wawaddr]=buff[sp3addr];
     for (int i=2; i<14; ++i)
       mb[moff[28]+wawaddr+i]=buff[sp3addr+i-1];
   }
   fclose(inf);

   //----- fix up some conversion problems -----------
   //fix top edge...replace pavement by repeating row down  if needed
   if ( ((mb[moff[2]]+mb[moff[2]+1])/250)==28)   //section 2 start be a pavement hex
   {
     for (int x=1; x<99; ++x)
       CopyHex(x,0,x,1);
     //fix bottom
     int bottomy=mb[moff[39]]+256*mb[moff[39]+1];
     for (int x=1; x<99; ++x)
       CopyHex(x,bottomy-1,x,bottomy-2);
     //fix left
     for (int y=0; y<bottomy; ++y)
       CopyHex(0,y,1,y);
     for (int y=0; y<bottomy; ++y)
       CopyHex(99,y,98,y);
    }

     //fix up roads drawn through houses
    for (int y=0; y<80; ++y)
     for (int x=0; x<100; ++x)
     {
       int s8addr=S8Addr(x,y);

       if ((mb[moff[8]+s8addr+12] || mb[moff[8]+s8addr+13])&& //a road
           (mb[moff[8]+s8addr]&48)) //a building
       {
          mb[moff[8]+s8addr]&=207; //no building
          mb[moff[8]+s8addr+6]=0;   //no cover
          mb[moff[8]+s8addr+8]=0;
          int s5addr=S2Addr(x,y);
          mb[moff[5]+s5addr]=0xFF;
          mb[moff[5]+s5addr+1]=0xFF;
       }

     }
   DrawMap();

}
//---------------------------------------------------------------------------

void __fastcall TMainForm::SaveCompleteImage1Click(TObject *Sender)
{
    TRect drect;
    int x,y,i,qhexxf,qhexyf,qhexy0,qhexx0;
    int gnum,addr,b1,b2,n;
    int file,ico;
    int finish=0;
    int JpgAmt=2;
    
    SaveDialog1->DefaultExt="jpg";
    SaveDialog1->Filter=
      "JPEG file (*.jpg)|*.jpg|All Files (*.*)|*.*";
    SaveDialog1->Title="Save All Map As JPEG Image";
    if (!SaveDialog1->Execute()) return;

    Screen->Cursor=crHourGlass;
    //added
    Graphics :: TBitmap *tmpbmp;
    tmpbmp=new Graphics :: TBitmap;
    tmpbmp->Width=(53*(MapSizeX+1))/JpgAmt;   //trial
    tmpbmp->Height=(44*(MapSizeY+1))/JpgAmt;  //trial
    tmpbmp->Canvas->Brush->Color=clBlue;
     //blank image
    drect.top=0; drect.Left=0;
    drect.Right=tmpbmp->Width; drect.Bottom=tmpbmp->Height;
    tmpbmp->Canvas->FillRect(drect);
    //done addition

    qbmp=new Graphics :: TBitmap;
    qbmp->Width=53*(MapSizeX+1);
    qbmp->Height=44*2;
    qbmp->Canvas->Brush->Color=clMaroon;

    //blank image
    drect.top=0; drect.Left=0;
    drect.Right=qbmp->Width; drect.Bottom=qbmp->Height;
    qbmp->Canvas->FillRect(drect);

    qhexx0=hexx0;
    qhexxf=MapSizeX;
    qhexy0=0;
    qhexyf=3;

    //draw the map from the origin hex of the quad
    //main tiles    Section 2
   do {
    for (y=qhexy0; y<qhexyf; ++y)
      for (x=qhexx0; x<qhexxf; ++x)
      {
        //primary tile
        addr=S2Addr(x,y);
        b1=mb[moff[2]+addr];
        b2=mb[moff[2]+addr+1];
        gnum=256*b2+b1;
        file=gnum/250;
        ico =gnum%250;
        QTileAt(x-qhexx0,y-qhexy0,file,ico);
      }
       //secondary tiles
    for (y=qhexy0; y<qhexyf; ++y)
      for (x=hexx0; x<qhexxf; ++x)
      {
        addr=S28Addr(x,y);
        n=mb[moff[28]+addr];
        for (i=0; i<n; ++i)
        {
          b1=mb[moff[28]+addr+2+2*i];
          b2=mb[moff[28]+addr+3+2*i];
          gnum=256*b2+b1;
          file=gnum/250;
          ico =gnum%250;
          QTileAt(x-qhexx0,y-qhexy0,file,ico);
        }
      }

    //other tiles    Section 3
    for (y=qhexy0; y<qhexyf; ++y)
      for (x=qhexx0; x<qhexxf; ++x)
      {
        addr=S2Addr(x,y);
        b1=mb[moff[3]+addr];
        b2=mb[moff[3]+addr+1];
        gnum=256*b2+b1; //if 2 bytes are ffff we get 0xFFFF for gnum
        file=gnum/250;
        ico =gnum%250;
        if (file<MAX_TERRAIN_FILES && CB3->Checked)
          QTileAt(x-qhexx0,y-qhexy0,file,ico);
      }
      //other tiles    Section 4
    for (y=qhexy0; y<qhexyf; ++y)
      for (x=qhexx0; x<qhexxf; ++x)
      {
        addr=S2Addr(x,y);
        b1=mb[moff[4]+addr];
        b2=mb[moff[4]+addr+1];
        gnum=256*b2+b1; //if 2 bytes are ffff we get 0xFFFF for gnum
        file=gnum/250;
        ico =gnum%250;
        if (file<MAX_TERRAIN_FILES && CB4->Checked)
          QTileAt(x-qhexx0,y-qhexy0,file,ico);
      }
    //other tiles    Section 5
    for (y=qhexy0; y<qhexyf; ++y)
      for (x=qhexx0; x<qhexxf; ++x)
      {
        addr=S2Addr(x,y);
        b1=mb[moff[5]+addr];
        b2=mb[moff[5]+addr+1];
        gnum=256*b2+b1; //if 2 bytes are ffff we get 0xFFFF for gnum
        file=gnum/250;
        ico =gnum%250;
        if (file<MAX_TERRAIN_FILES && CB5->Checked)
          QTileAt(x-qhexx0,y-qhexy0,file,ico);
      }
    //other tiles    Section 6
    for (y=qhexy0; y<qhexyf; ++y)
      for (x=qhexx0; x<qhexxf; ++x)
      {
        addr=S2Addr(x,y);
        b1=mb[moff[6]+addr];
        b2=mb[moff[6]+addr+1];
        gnum=256*b2+b1; //if 2 bytes are ffff we get 0xFFFF for gnum
        file=gnum/250;
        ico =gnum%250;
        if (file<MAX_TERRAIN_FILES && CB6->Checked)
          QTileAt(x-qhexx0,y-qhexy0,file,ico);
      }
    //other tiles    Section 7
    for (y=qhexy0; y<qhexyf; ++y)
      for (x=qhexx0; x<qhexxf; ++x)
      {
        addr=S2Addr(x,y);
        b1=mb[moff[7]+addr];
        b2=mb[moff[7]+addr+1];
        gnum=256*b2+b1; //if 2 bytes are ffff we get 0xFFFF for gnum
        file=gnum/250;
        ico =gnum%250;
        if (file<MAX_TERRAIN_FILES && CB7->Checked)
          QTileAt(x-qhexx0,y-qhexy0,file,ico);
      }
    if (ShowHexes1->Checked) QDrawHexes();

   //   for (y=0; y<(44*41); y+=2)
   //    for (x=0; x<(101*53); x+=2)
   //      tmpbmp->Canvas->Pixels[x/2][2*594+(y/2)]=
   //         qbmp->Canvas->Pixels[x][y];
    //added   ======

    //for (y=88*qhexy0; y<88*qhexyf; y+=2)
     for (y=0; y<88; y+=JpgAmt)                //trial
      for (x=0; x<(MapSizeX+1)*53; x+=JpgAmt)         //trial
        tmpbmp->Canvas->Pixels[x/JpgAmt][(44*qhexy0+y)/JpgAmt]=  //trial
             qbmp->Canvas->Pixels[x][y];

      qhexy0+=2;
      qhexyf+=2;
      if (qhexy0>MapSizeY) finish=1; else finish=0;
    } while (finish==0);
    //Save the bitmap and get rid of it
    TJPEGImage *jpgImg;
    jpgImg=new TJPEGImage;

    TFileStream *outf;
    outf=new TFileStream(SaveDialog1->FileName.c_str(), fmCreate);
    if (!outf)
    {
      delete jpgImg;
      Application->MessageBox("Could not open output file","Error",MB_OK);
      return;
    }
    jpgImg->CompressionQuality=(short int)jpeg_quality;
    jpgImg->Assign(tmpbmp);
    jpgImg->SaveToStream(outf);
    //jpgImg->Assign(qbmp);
    //jpgImg->SaveToStream(outf);

    delete jpgImg;
    delete outf;


    Screen->Cursor=crDefault;
    delete tmpbmp;
    delete qbmp;

}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Savebmp1Click(TObject *Sender)
{
 //entire image as a bmp
  SaveDialog1->Title="Save a Map bmp";
  SaveDialog1->Filter="bmp files (*.bmp)|*.bmp| All files (*.*) |*.*";
  SaveDialog1->DefaultExt="bmp";

  if (!SaveDialog1->Execute()) return;

    int x,y,i;
    int gnum,addr,b1,b2,n;
    int file,ico;


    Screen->Cursor=crHourGlass;

    //delete mbmp;
    mbmp=new Graphics :: TBitmap;

    mbmp->Width=MapSizeX*52;
    mbmp->Height=MapSizeY*44;

    for (y=0; y<MapSizeY; ++y)
      for (x=0; x<MapSizeX; ++x)
      {
        //primary tile
        addr=S2Addr(x,y);
        b1=mb[moff[2]+addr];
        b2=mb[moff[2]+addr+1];
        gnum=256*b2+b1;
        file=gnum/250;
        ico =gnum%250;
        TileAt(x-hexx0,y-hexy0,file,ico);
      }
    //secondary tiles
    for (y=0; y<MapSizeY; ++y)
      for (x=0; x<MapSizeX; ++x)
      {
        addr=S28Addr(x,y);
        n=mb[moff[28]+addr];
        for (i=0; i<n; ++i)
        {
          b1=mb[moff[28]+addr+1+2*i];
          b2=mb[moff[28]+addr+2+2*i];
          gnum=256*b2+b1;
          file=gnum/250;
          ico =gnum%250;
          TileAt(x-hexx0,y-hexy0,file,ico);
        }
      }
    //other tiles    Section 3
    for (y=0; y<MapSizeY; ++y)
      for (x=0; x<MapSizeX; ++x)
      {
        addr=S2Addr(x,y);
        b1=mb[moff[3]+addr];
        b2=mb[moff[3]+addr+1];
        gnum=256*b2+b1; //if 2 bytes are ffff we get 0xFFFF for gnum
        file=gnum/250;
        ico =gnum%250;
        if (file<MAX_TERRAIN_FILES && CB3->Checked)
          TileAt(x-hexx0,y-hexy0,file,ico);
      }
      //other tiles    Section 4
    for (y=0; y<MapSizeY; ++y)
      for (x=0; x<MapSizeX; ++x)
      {
        addr=S2Addr(x,y);
        b1=mb[moff[4]+addr];
        b2=mb[moff[4]+addr+1];
        gnum=256*b2+b1; //if 2 bytes are ffff we get 0xFFFF for gnum
        file=gnum/250;
        ico =gnum%250;
        if (file<MAX_TERRAIN_FILES && CB4->Checked)
          TileAt(x-hexx0,y-hexy0,file,ico);
      }
    //other tiles    Section 5
    for (y=0; y<MapSizeY; ++y)
      for (x=0; x<MapSizeX; ++x)
      {
        addr=S2Addr(x,y);
        b1=mb[moff[5]+addr];
        b2=mb[moff[5]+addr+1];
        gnum=256*b2+b1; //if 2 bytes are ffff we get 0xFFFF for gnum
        file=gnum/250;
        ico =gnum%250;
        if (file<MAX_TERRAIN_FILES && CB5->Checked)
          TileAt(x-hexx0,y-hexy0,file,ico);
      }
    //other tiles    Section 6
    for (y=0; y<MapSizeY; ++y)
      for (x=0; x<MapSizeX; ++x)
      {
        addr=S2Addr(x,y);
        b1=mb[moff[6]+addr];
        b2=mb[moff[6]+addr+1];
        gnum=256*b2+b1; //if 2 bytes are ffff we get 0xFFFF for gnum
        file=gnum/250;
        ico =gnum%250;
        if (file<MAX_TERRAIN_FILES && CB6->Checked)
          TileAt(x-hexx0,y-hexy0,file,ico);
      }
    //other tiles    Section 7
    for (y=0; y<MapSizeY; ++y)
      for (x=0; x<MapSizeX; ++x)
      {
        addr=S2Addr(x,y);
        b1=mb[moff[7]+addr];
        b2=mb[moff[7]+addr+1];
        gnum=256*b2+b1; //if 2 bytes are ffff we get 0xFFFF for gnum
        file=gnum/250;
        ico =gnum%250;
        if (file<MAX_TERRAIN_FILES && CB7->Checked)
          TileAt(x-hexx0,y-hexy0,file,ico);
      }


  int xs0,xs1,ys0,ys1;
  //fx0=0; fy0=0;
  if (ShowHexes1->Checked)
  {
   mbmp->Canvas->Pen->Color=HexColor;
   for (y=0; y<MapSizeY; ++y)
    for (x=0; x<MapSizeX; ++x)
    {
      //verticals
      xs0=x*tile_width+fx0;
      if (y&1) xs0+=tile_half_width;
      xs1=xs0;
      ys0=y*tile_height+13+fy0;
      ys1=ys0+30;
      mbmp->Canvas->MoveTo(xs0,ys0);
      mbmp->Canvas->LineTo(xs1,ys1);

      //and up right
      mbmp->Canvas->MoveTo(xs0,ys0);
      mbmp->Canvas->LineTo(xs0+tile_half_width,ys0-13);
      //and down right
      mbmp->Canvas->MoveTo(xs1,ys1);
      mbmp->Canvas->LineTo(xs1+tile_half_width,ys1+13);
    }
   }

  mbmp->SaveToFile(SaveDialog1->FileName);
  delete mbmp;
  Screen->Cursor=crDefault;

}
//---------------------------------------------------------------------------

void __fastcall TMainForm::SaveTopHalf1Click(TObject *Sender)
{
  //entire image as a bmp
  SaveDialog1->Title="Save a Map bmp Top Half";
  SaveDialog1->Filter="bmp files (*.bmp)|*.bmp| All files (*.*) |*.*";
  SaveDialog1->DefaultExt="bmp";

  if (!SaveDialog1->Execute()) return;

    int x,y,i;
    int gnum,addr,b1,b2,n;
    int file,ico;


    Screen->Cursor=crHourGlass;

    //delete mbmp;
    mbmp=new Graphics :: TBitmap;

    mbmp->Width=MapSizeX*52;
    mbmp->Height=MapSizeY*44/2;

    for (y=0; y<MapSizeY/2; ++y)
      for (x=0; x<MapSizeX; ++x)
      {
        //primary tile
        addr=S2Addr(x,y);
        b1=mb[moff[2]+addr];
        b2=mb[moff[2]+addr+1];
        gnum=256*b2+b1;
        file=gnum/250;
        ico =gnum%250;
        TileAt(x-hexx0,y-hexy0,file,ico);
      }
    //secondary tiles
    for (y=0; y<MapSizeY/2; ++y)
      for (x=0; x<MapSizeX; ++x)
      {
        addr=S28Addr(x,y);
        n=mb[moff[28]+addr];
        for (i=0; i<n; ++i)
        {
          b1=mb[moff[28]+addr+1+2*i];
          b2=mb[moff[28]+addr+2+2*i];
          gnum=256*b2+b1;
          file=gnum/250;
          ico =gnum%250;
          TileAt(x-hexx0,y-hexy0,file,ico);
        }
      }
    //other tiles    Section 3
    for (y=0; y<MapSizeY/2; ++y)
      for (x=0; x<MapSizeX; ++x)
      {
        addr=S2Addr(x,y);
        b1=mb[moff[3]+addr];
        b2=mb[moff[3]+addr+1];
        gnum=256*b2+b1; //if 2 bytes are ffff we get 0xFFFF for gnum
        file=gnum/250;
        ico =gnum%250;
        if (file<MAX_TERRAIN_FILES && CB3->Checked)
          TileAt(x-hexx0,y-hexy0,file,ico);
      }
      //other tiles    Section 4
    for (y=0; y<MapSizeY/2; ++y)
      for (x=0; x<MapSizeX; ++x)
      {
        addr=S2Addr(x,y);
        b1=mb[moff[4]+addr];
        b2=mb[moff[4]+addr+1];
        gnum=256*b2+b1; //if 2 bytes are ffff we get 0xFFFF for gnum
        file=gnum/250;
        ico =gnum%250;
        if (file<MAX_TERRAIN_FILES && CB4->Checked)
          TileAt(x-hexx0,y-hexy0,file,ico);
      }
    //other tiles    Section 5
    for (y=0; y<MapSizeY/2; ++y)
      for (x=0; x<MapSizeX; ++x)
      {
        addr=S2Addr(x,y);
        b1=mb[moff[5]+addr];
        b2=mb[moff[5]+addr+1];
        gnum=256*b2+b1; //if 2 bytes are ffff we get 0xFFFF for gnum
        file=gnum/250;
        ico =gnum%250;
        if (file<MAX_TERRAIN_FILES && CB5->Checked)
          TileAt(x-hexx0,y-hexy0,file,ico);
      }
    //other tiles    Section 6
    for (y=0; y<MapSizeY/2; ++y)
      for (x=0; x<MapSizeX; ++x)
      {
        addr=S2Addr(x,y);
        b1=mb[moff[6]+addr];
        b2=mb[moff[6]+addr+1];
        gnum=256*b2+b1; //if 2 bytes are ffff we get 0xFFFF for gnum
        file=gnum/250;
        ico =gnum%250;
        if (file<MAX_TERRAIN_FILES && CB6->Checked)
          TileAt(x-hexx0,y-hexy0,file,ico);
      }
    //other tiles    Section 7
    for (y=0; y<MapSizeY/2; ++y)
      for (x=0; x<MapSizeX; ++x)
      {
        addr=S2Addr(x,y);
        b1=mb[moff[7]+addr];
        b2=mb[moff[7]+addr+1];
        gnum=256*b2+b1; //if 2 bytes are ffff we get 0xFFFF for gnum
        file=gnum/250;
        ico =gnum%250;
        if (file<MAX_TERRAIN_FILES && CB7->Checked)
          TileAt(x-hexx0,y-hexy0,file,ico);
      }


  int xs0,xs1,ys0,ys1;
  //fx0=0; fy0=0;
  if (ShowHexes1->Checked)
  {
   mbmp->Canvas->Pen->Color=HexColor;
   for (y=0; y<MapSizeY/2; ++y)
    for (x=0; x<MapSizeX; ++x)
    {
      //verticals
      xs0=x*tile_width+fx0;
      if (y&1) xs0+=tile_half_width;
      xs1=xs0;
      ys0=y*tile_height+13+fy0;
      ys1=ys0+30;
      mbmp->Canvas->MoveTo(xs0,ys0);
      mbmp->Canvas->LineTo(xs1,ys1);

      //and up right
      mbmp->Canvas->MoveTo(xs0,ys0);
      mbmp->Canvas->LineTo(xs0+tile_half_width,ys0-13);
      //and down right
      mbmp->Canvas->MoveTo(xs1,ys1);
      mbmp->Canvas->LineTo(xs1+tile_half_width,ys1+13);
    }
   }

  mbmp->SaveToFile(SaveDialog1->FileName);
  delete mbmp;
  Screen->Cursor=crDefault;

}
//---------------------------------------------------------------------------

void __fastcall TMainForm::SaveBottomHalf1Click(TObject *Sender)
{
 //entire image as a bmp
  SaveDialog1->Title="Save a Map bmp Bottom Half";
  SaveDialog1->Filter="bmp files (*.bmp)|*.bmp| All files (*.*) |*.*";
  SaveDialog1->DefaultExt="bmp";

  if (!SaveDialog1->Execute()) return;

    int x,y,i;
    int gnum,addr,b1,b2,n;
    int file,ico;


    Screen->Cursor=crHourGlass;

    mbmp=new Graphics :: TBitmap;

    int halfway=MapSizeY/2;
    mbmp->Width=MapSizeX*52;
    mbmp->Height=(MapSizeY*44)/2;

    //hexy0=(MapSizeY*44)/2;
    //hexx0=0;

    for (y=halfway; y<MapSizeY; ++y)
      for (x=0; x<MapSizeX; ++x)
      {
        //primary tile
        addr=S2Addr(x,y);
        b1=mb[moff[2]+addr];
        b2=mb[moff[2]+addr+1];
        gnum=256*b2+b1;
        file=gnum/250;
        ico =gnum%250;
        TileAt(x-hexx0,y-hexy0,file,ico);
      }
    //secondary tiles
    for (y=halfway; y<MapSizeY; ++y)
      for (x=0; x<MapSizeX; ++x)
      {
        addr=S28Addr(x,y);
        n=mb[moff[28]+addr];
        for (i=0; i<n; ++i)
        {
          b1=mb[moff[28]+addr+1+2*i];
          b2=mb[moff[28]+addr+2+2*i];
          gnum=256*b2+b1;
          file=gnum/250;
          ico =gnum%250;
          TileAt(x-hexx0,y-hexy0,file,ico);
        }
      }
    //other tiles    Section 3
    for (y=halfway; y<MapSizeY; ++y)
      for (x=0; x<MapSizeX; ++x)
      {
        addr=S2Addr(x,y);
        b1=mb[moff[3]+addr];
        b2=mb[moff[3]+addr+1];
        gnum=256*b2+b1; //if 2 bytes are ffff we get 0xFFFF for gnum
        file=gnum/250;
        ico =gnum%250;
        if (file<MAX_TERRAIN_FILES && CB3->Checked)
          TileAt(x-hexx0,y-hexy0,file,ico);
      }
      //other tiles    Section 4
    for (y=halfway; y<MapSizeY; ++y)
      for (x=0; x<MapSizeX; ++x)
      {
        addr=S2Addr(x,y);
        b1=mb[moff[4]+addr];
        b2=mb[moff[4]+addr+1];
        gnum=256*b2+b1; //if 2 bytes are ffff we get 0xFFFF for gnum
        file=gnum/250;
        ico =gnum%250;
        if (file<MAX_TERRAIN_FILES && CB4->Checked)
          TileAt(x-hexx0,y-hexy0,file,ico);
      }
    //other tiles    Section 5
    for (y=halfway; y<MapSizeY; ++y)
      for (x=0; x<MapSizeX; ++x)
      {
        addr=S2Addr(x,y);
        b1=mb[moff[5]+addr];
        b2=mb[moff[5]+addr+1];
        gnum=256*b2+b1; //if 2 bytes are ffff we get 0xFFFF for gnum
        file=gnum/250;
        ico =gnum%250;
        if (file<MAX_TERRAIN_FILES && CB5->Checked)
          TileAt(x-hexx0,y-hexy0,file,ico);
      }
    //other tiles    Section 6
    for (y=halfway; y<MapSizeY; ++y)
      for (x=0; x<MapSizeX; ++x)
      {
        addr=S2Addr(x,y);
        b1=mb[moff[6]+addr];
        b2=mb[moff[6]+addr+1];
        gnum=256*b2+b1; //if 2 bytes are ffff we get 0xFFFF for gnum
        file=gnum/250;
        ico =gnum%250;
        if (file<MAX_TERRAIN_FILES && CB6->Checked)
          TileAt(x-hexx0,y-hexy0,file,ico);
      }
    //other tiles    Section 7
    for (y=halfway; y<MapSizeY; ++y)
      for (x=0; x<MapSizeX; ++x)
      {
        addr=S2Addr(x,y);
        b1=mb[moff[7]+addr];
        b2=mb[moff[7]+addr+1];
        gnum=256*b2+b1; //if 2 bytes are ffff we get 0xFFFF for gnum
        file=gnum/250;
        ico =gnum%250;
        if (file<MAX_TERRAIN_FILES && CB7->Checked)
          TileAt(x-hexx0,y-hexy0,file,ico);
      }


  int xs0,xs1,ys0,ys1;
  //fx0=0; fy0=0;
  if (ShowHexes1->Checked)
  {
   mbmp->Canvas->Pen->Color=HexColor;
   for (y=halfway; y<MapSizeY; ++y)
    for (x=0; x<MapSizeX; ++x)
    {
      //verticals
      xs0=x*tile_width+fx0;
      if (y&1) xs0+=tile_half_width;
      xs1=xs0;
      ys0=y*tile_height+13+fy0;
      ys1=ys0+30;
      mbmp->Canvas->MoveTo(xs0,ys0);
      mbmp->Canvas->LineTo(xs1,ys1);

      //and up right
      mbmp->Canvas->MoveTo(xs0,ys0);
      mbmp->Canvas->LineTo(xs0+tile_half_width,ys0-13);
      //and down right
      mbmp->Canvas->MoveTo(xs1,ys1);
      mbmp->Canvas->LineTo(xs1+tile_half_width,ys1+13);
    }
   }

  mbmp->SaveToFile(SaveDialog1->FileName);
  delete mbmp;
  Screen->Cursor=crDefault;

}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ChangeHexColor1Click(TObject *Sender)
{
   if (ColorDialog1->Execute())
   {
     HexColor=ColorDialog1->Color;
     DrawMap();
   }
}
//---------------------------------------------------------------------------


