//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include <stdio.h>

#include "HexEdit.h"
#include "WW2Map1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
THexEditForm *HexEditForm;

int EditX,EditY;
int S8Copy[19];

//---------------------------------------------------------------------------
__fastcall THexEditForm::THexEditForm(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall THexEditForm::FormCreate(TObject *Sender)
{
   HexGrid->Cells[0][0]="Sec.";
   HexGrid->Cells[1][0]="File";
   HexGrid->Cells[2][0]="Icon";
   HexGrid->Cells[0][1]="Main";
   HexGrid->Cells[0][2]="Sec3";
   HexGrid->Cells[0][3]="Sec4";
   HexGrid->Cells[0][4]="Sec5";
   HexGrid->Cells[0][5]="Sec6";
   HexGrid->Cells[0][6]="Sec7";                           

   S28Grid->Cells[0][0]="File";
   S28Grid->Cells[1][0]="Icon";

   S8Grid->Cells[0][0]="Byte";
   S8Grid->Cells[1][0]="Val.";
}
/*
int __fastcall THexEditForm :: altitude_code(int x, int y, int t)
{
   //t=offset fot type ie 0 for sp2 and 4 for sp3 of altitude in s8
   //number as for roads but altitude > is a connection
   int r=0;
   int alt_lvl;

   if (altitude(x,y,t)<0) return 0;
   alt_lvl=altitude(x,y,t)/10;
   if (y&1) //odd row
   {
     if ((altitude(x-1,y,  t)/10)>alt_lvl) r+=8;
     if ((altitude(x  ,y-1,t)/10)>alt_lvl) r+=16;
     if ((altitude(x+1,y-1,t)/10)>alt_lvl) r+=32;
     if ((altitude(x+1,y  ,t)/10)>alt_lvl) r+=1;
     if ((altitude(x+1,y+1,t)/10)>alt_lvl) r+=2;
     if ((altitude(x  ,y+1,t)/10)>alt_lvl) r+=4;
   }
   else //even row
   {
     if ((altitude(x-1,y  ,t)/10)>alt_lvl) r+=8;
     if ((altitude(x-1,y-1,t)/10)>alt_lvl) r+=16;
     if ((altitude(x  ,y-1,t)/10)>alt_lvl) r+=32;
     if ((altitude(x+1,y  ,t)/10)>alt_lvl) r+=1;
     if ((altitude(x  ,y+1,t)/10)>alt_lvl) r+=2;
     if ((altitude(x-1,y+1,t)/10)>alt_lvl) r+=4;
   }
   return r;
}
*/
//---------------------------------------------------------------------------
int __fastcall THexEditForm :: altitude_code(int x, int y, int t)
{
   //t=offset fot type ie 0 for sp2 and 4 for sp3 of altitude in s8
   //number as for roads but altitude > is a connection
   int r=0;
   int alt;

   alt=(mb[MainForm->S8Addr(x,y)+t+moff[8]])/10;
   if (y&1) //odd row
   {
     if ((mb[MainForm->S8Addr(x-1,y  )+t+moff[8]]/10)>alt) r+=8;
     if ((mb[MainForm->S8Addr(x  ,y-1)+t+moff[8]]/10)>alt) r+=16;
     if ((mb[MainForm->S8Addr(x+1,y-1)+t+moff[8]]/10)>alt) r+=32;
     if ((mb[MainForm->S8Addr(x+1,y  )+t+moff[8]]/10)>alt) r+=1;
     if ((mb[MainForm->S8Addr(x+1,y+1)+t+moff[8]]/10)>alt) r+=2;
     if ((mb[MainForm->S8Addr(x  ,y+1)+t+moff[8]]/10)>alt) r+=4;
   }
   else //even row
   {
     if ((mb[MainForm->S8Addr(x-1,y  )+t+moff[8]]/10)>alt) r+=8;
     if ((mb[MainForm->S8Addr(x-1,y-1)+t+moff[8]]/10)>alt) r+=16;
     if ((mb[MainForm->S8Addr(x  ,y-1)+t+moff[8]]/10)>alt) r+=32;
     if ((mb[MainForm->S8Addr(x+1,y  )+t+moff[8]]/10)>alt) r+=1;
     if ((mb[MainForm->S8Addr(x  ,y+1)+t+moff[8]]/10)>alt) r+=2;
     if ((mb[MainForm->S8Addr(x-1,y+1)+t+moff[8]]/10)>alt) r+=4;
   }
   return r;
}

//-------------------------------------------------------------------------
// return the altitude using a signed value of
int __fastcall THexEditForm :: altitude(int x, int y, int t)
{
  int b1,b2,i,addr;

  addr=MainForm->S8Addr(x,y);
  b1=mb[addr+t+moff[8]];
  b2=mb[addr+t+moff[8]+1];
  i=b1+256*b2;
  if (i>32767) return (i-65536);
  else return i;
}
//---------------------------------------------------------------------------
int __fastcall THexEditForm :: altitude_max(int x, int y, int t)
{
   //t=offset fot type ie 0 for sp2 and 4 for sp3 of altitude in s8
   //returns the highest neighbor altitude
   int malt,a;

   malt=-100;
   if (y&1) //odd row
   {
     a=altitude(x-1,y,t);
     if (a>malt) malt=a;

     a=altitude(x  ,y-1,t);
     if (a>malt) malt=a;

     a=altitude(x+1,y-1,t);
     if (a>malt) malt=a;

     a=altitude(x+1,y,t  );
     if (a>malt) malt=a;

     a=altitude(x+1,y+1,t);
     if (a>malt) malt=a;

     a=altitude(x  ,y+1,t);
     if (a>malt) malt=a;
   }
   else //even row
   {
     a=altitude(x-1,y,t);

     if (a>malt) malt=a;
     a=altitude(x-1,y-1,t);

     if (a>malt) malt=a;
     a=altitude(x  ,y-1,t);

     if (a>malt) malt=a;
     a=altitude(x+1,y,t  );

     if (a>malt) malt=a;
     a=altitude(x  ,y+1,t);

     if (a>malt) malt=a;
     a=altitude(x-1,y+1,t);

   }

   return malt;
}


//-----------------------------------------------------------------
void __fastcall THexEditForm::FormActivate(TObject *Sender)
{
   int gnum,addr;
   int f,icon,i,n,code;
   AnsiString NoTile=" -";      //if chane here ... change in RetainBtnClick

   EditX=WhereX; EditY=WhereY;
   XYLbl->Caption=IntToStr(EditX)+","+IntToStr(EditY)+"   ";
   addr=MainForm->S2Addr(EditX,EditY);
   //Main tile
   gnum=mb[moff[2]+addr]+256*mb[moff[2]+addr+1];
   f=gnum/250; icon=gnum%250;
   HexGrid->Cells[1][1]=IntToStr(f);
   HexGrid->Cells[2][1]=IntToStr(icon);
   //section 3
   gnum=mb[moff[3]+addr]+256*mb[moff[3]+addr+1];
   f=gnum/250; icon=gnum%250;
   if (f>MAX_TERRAIN_FILES) //ff ff for no tile
   {
     HexGrid->Cells[1][2]=NoTile;
     HexGrid->Cells[2][2]=NoTile;

   }
   else
   {
     HexGrid->Cells[1][2]=IntToStr(f);
     HexGrid->Cells[2][2]=IntToStr(icon);
   }
   //section 4
   gnum=mb[moff[4]+addr]+256*mb[moff[4]+addr+1];
   f=gnum/250; icon=gnum%250;
   if (f>MAX_TERRAIN_FILES) //ff ff for no tile
   {
     HexGrid->Cells[1][3]=NoTile;
     HexGrid->Cells[2][3]=NoTile;
   }
   else
   {
     HexGrid->Cells[1][3]=IntToStr(f);
     HexGrid->Cells[2][3]=IntToStr(icon);
   }
   //section 5
   gnum=mb[moff[5]+addr]+256*mb[moff[5]+addr+1];
   f=gnum/250; icon=gnum%250;
   if (f>MAX_TERRAIN_FILES) //ff ff for no tile
   {
     HexGrid->Cells[1][4]=NoTile;
     HexGrid->Cells[2][4]=NoTile;
   }
   else
   {
     HexGrid->Cells[1][4]=IntToStr(f);
     HexGrid->Cells[2][4]=IntToStr(icon);
   }
   //section 6
   gnum=mb[moff[6]+addr]+256*mb[moff[6]+addr+1];
   f=gnum/250; icon=gnum%250;
   if (f>MAX_TERRAIN_FILES) //ff ff for no tile
   {
     HexGrid->Cells[1][5]=NoTile;
     HexGrid->Cells[2][5]=NoTile;
   }
   else
   {
     HexGrid->Cells[1][5]=IntToStr(f);
     HexGrid->Cells[2][5]=IntToStr(icon);
   }
   //section 7
   gnum=mb[moff[7]+addr]+256*mb[moff[7]+addr+1];
   f=gnum/250; icon=gnum%250;
   if (f>MAX_TERRAIN_FILES) //ff ff for no tile
   {
     HexGrid->Cells[1][6]=NoTile;
     HexGrid->Cells[2][6]=NoTile;
   }
   else
   {
     HexGrid->Cells[1][6]=IntToStr(f);
     HexGrid->Cells[2][6]=IntToStr(icon);
   }
   WidthEdit->Text=IntToStr(mb[moff[38]]);
   HeightEdit->Text=IntToStr(mb[moff[39]]);

   S29Edit->Text=StrToInt(mb[moff[29]+MainForm->S29Addr(EditX,EditY)]
    +256*mb[moff[29]+MainForm->S29Addr(EditX,EditY)+1]);

   //section 29 the slope or aux tiles
   addr=MainForm->S28Addr(EditX,EditY);
   S28Edit->Text=IntToStr(mb[moff[28]+addr]);
   for (i=0; i<6; ++i)
   {
     gnum=mb[moff[28]+addr+2*i+1]+256*mb[moff[28]+addr+2*i+2];
     f=gnum/250; icon=gnum%250;
     S28Grid->Cells[0][i+1]=IntToStr(f);
     S28Grid->Cells[1][i+1]=IntToStr(icon);
   }

   //section 8 is 12 bytes for sp2 19 bytes for sp3
   addr=MainForm->S8Addr(EditX,EditY);
   n=WW2_S8_RECORD_SIZE;  //record length for Ww2 in s8
   for (i=0; i<n; ++i)
   {
     S8Grid->Cells[0][i+1]=IntToStr(i);
     S8Grid->Cells[1][i+1]=IntToStr(mb[moff[8]+addr+i]);
   }

   //show the altitude code ... this is 6 bit digit
   //describing the neighboring altitude levels i.e.
   //alt/10   a higher tile is coded as 1 and an equal
   //or lower with 0 bits are east=0 se=1 sw=2 etc so
   //there are 64 possibles... 0 to 63. the slope tiles
   //will be determined by the code. We display here to
   //help set up a table
   if (edit_type==SP3) code=altitude_code(EditX,EditY,4);
   else code=altitude_code(EditX,EditY,0);
   //ACodeLbl->Caption=IntToStr(code);

   /* if (stiles[code].s1>=0)TilesLbl->Caption=
       IntToStr(stiles[code].s1);
   else TilesLbl->Caption="         ";
   if (stiles[code].s2>=0)TilesLbl->Caption=TilesLbl->Caption+
       ","+IntToStr(stiles[code].s2);
   else TilesLbl->Caption=TilesLbl->Caption+"      ";
   if (stiles[code].s3>=0)TilesLbl->Caption=TilesLbl->Caption+
       ","+IntToStr(stiles[code].s3);
   else TilesLbl->Caption=TilesLbl->Caption+"   ";
   */

}
//---------------------------------------------------------------------------
void __fastcall THexEditForm::RetainBtnClick(TObject *Sender)
{
   int gnum,addr;
   int i,n;
   AnsiString NoTile=" -";

   MainForm->SaveUndo(EditX,EditY);
   
   addr=MainForm->S2Addr(EditX,EditY);

   //Main tile
   gnum=250*StrToInt(HexGrid->Cells[1][1])
     +StrToInt(HexGrid->Cells[2][1]);
   set_gnum(&(mb[moff[2]+addr]),gnum);
   //mb[moff[2]+addr+1]=(byte)(gnum/256);

   //section 3
   if (HexGrid->Cells[1][2]==NoTile) //ff ff for no tile
   {
     mb[moff[3]+addr]=255;
     mb[moff[3]+addr+1]=255;
   }
   else
   {
     gnum=250*StrToInt(HexGrid->Cells[1][2])
         +StrToInt(HexGrid->Cells[2][2]);
     set_gnum(&(mb[moff[3]+addr]),256);
     //mb[moff[3]+addr+1]=(byte)(gnum/256);
   }

   //section 4
   if (HexGrid->Cells[1][3]==NoTile) //ff ff for no tile
   {
     mb[moff[4]+addr]=255;
     mb[moff[4]+addr+1]=255;
   }
   else
   {
     gnum=250*StrToInt(HexGrid->Cells[1][3])
         +StrToInt(HexGrid->Cells[2][3]);
     set_gnum(&(mb[moff[4]+addr]),gnum);
     //mb[moff[4]+addr+1]=(byte)(gnum/256);
   }

   //section 5
   if (HexGrid->Cells[1][4]==NoTile) //ff ff for no tile
   {
     mb[moff[5]+addr]=255;
     mb[moff[5]+addr+1]=255;
   }
   else
   {
     gnum=250*StrToInt(HexGrid->Cells[1][4])
         +StrToInt(HexGrid->Cells[2][4]);
     set_gnum(&(mb[moff[5]+addr]),gnum);
     //mb[moff[5]+addr+1]=(byte)(gnum/256);
   }

   //section 6
   if (HexGrid->Cells[1][5]==NoTile) //ff ff for no tile
   {
     mb[moff[6]+addr]=255;
     mb[moff[6]+addr+1]=255;
   }
   else
   {
     gnum=250*StrToInt(HexGrid->Cells[1][5])
         +StrToInt(HexGrid->Cells[2][5]);
     set_gnum(&(mb[moff[6]+addr]),gnum);
     //mb[moff[6]+addr+1]=(byte)(gnum/256);
   }

   //section 7
   if (HexGrid->Cells[1][6]==NoTile) //ff ff for no tile
   {
     mb[moff[7]+addr]=255;
     mb[moff[7]+addr+1]=255;
   }
   else
   {
     gnum=250*StrToInt(HexGrid->Cells[1][6])
         +StrToInt(HexGrid->Cells[2][6]);
     set_gnum(&(mb[moff[7]+addr]),gnum);
     //mb[moff[7]+addr+1]=(byte)(gnum/256);
   }

   // size
   mb[moff[38]]=(byte)StrToInt(WidthEdit->Text);
   mb[moff[38]+1]=0;
   mb[moff[38]+2]=0;
   mb[moff[38]+3]=0;
   mb[moff[39]]=(byte)StrToInt(HeightEdit->Text);
   mb[moff[39]+1]=0;
   mb[moff[39]+2]=0;
   mb[moff[39]+3]=0;
   // section 29 terrain?
   mb[moff[29]+MainForm->S29Addr(EditX,EditY)]=
       (byte)StrToInt(S29Edit->Text)&255;
   mb[moff[29]+MainForm->S29Addr(EditX,EditY)+1]=
       (byte)StrToInt(S29Edit->Text)/256;

   //section 28 the slope or aux tiles
   addr=MainForm->S28Addr(EditX,EditY);
   mb[moff[28]+addr]=(byte)StrToInt(S28Edit->Text);
   for (i=0; i<6; ++i)
   {
     gnum=250*StrToInt(S28Grid->Cells[0][i+1])+
              StrToInt(S28Grid->Cells[1][i+1]);
     set_gnum(&(mb[moff[28]+addr+2*i+1]),gnum);
     //mb[moff[28]+addr+2*i+2]=(byte)(gnum/256);
   }

   //section 8 is 12 bytes for sp2 19 bytes for sp3 20 for WAW
   addr=MainForm->S8Addr(EditX,EditY);
   //if (edit_type==SP3) n=19; else n=15;
   n=WW2_S8_RECORD_SIZE;
   for (i=0; i<n; ++i)
   {
     mb[moff[8]+addr+i]=(byte)StrToInt(S8Grid->Cells[1][i+1]);
   }



}
//---------------------------------------------------------------------------

void __fastcall THexEditForm::CopyS8BtnClick(TObject *Sender)
{
   int i,n,addr;

   //section 8 is 12 bytes for sp2 19 bytes for sp3
   addr=MainForm->S8Addr(EditX,EditY);
   //if (edit_type==SP3) n=19; else n=12;
   for (i=0; i<WW2_S8_RECORD_SIZE; ++i)
   {
     S8Copy[i]=mb[moff[8]+addr+i];
   }
}
//---------------------------------------------------------------------------

void __fastcall THexEditForm::PasteS8BtnClick(TObject *Sender)
{
   int i,n,addr;

   //section 8 is 12 bytes for sp2 19 bytes for sp3
   addr=MainForm->S8Addr(EditX,EditY);
   //if (edit_type==SP3) n=19; else n=12;
   for (i=0; i<WW2_S8_RECORD_SIZE; ++i)
   {
     mb[moff[8]+addr+i]=S8Copy[i];
     S8Grid->Cells[0][i+1]=IntToStr(i);
     S8Grid->Cells[1][i+1]=IntToStr(mb[moff[8]+addr+i]);
   }
}
//---------------------------------------------------------------------------

void __fastcall THexEditForm::CancelS3BtnClick(TObject *Sender)
{

   if (Sender==CancelS3Btn)
   {
     HexGrid->Cells[1][2]=" -";
     HexGrid->Cells[2][2]=" -";
     RetainBtnClick(Sender);
   }
   else if (Sender==CancelS4Btn)
   {
     HexGrid->Cells[1][3]=" -";
     HexGrid->Cells[2][3]=" -";
     RetainBtnClick(Sender);
   }
   else if (Sender==CancelS5Btn)
   {
     HexGrid->Cells[1][4]=" -";
     HexGrid->Cells[2][4]=" -";
     RetainBtnClick(Sender);
   }
   else if (Sender==CancelS6Btn)
   {
     HexGrid->Cells[1][5]=" -";
     HexGrid->Cells[2][5]=" -";
     RetainBtnClick(Sender);
   }
   else if (Sender==CancelS7Btn)
   {
     HexGrid->Cells[1][6]=" -";
     HexGrid->Cells[2][6]=" -";
     RetainBtnClick(Sender);
   }
}
//---------------------------------------------------------------------------

void __fastcall THexEditForm::S8GridSelectCell(TObject *Sender, int ACol,
      int ARow, bool &CanSelect)
{
   if (ARow>7 && ARow<12)
   {
     TerrainCB->Enabled=true;
     TerrainCB->Clear();
     if (ARow==8) //byte 7;
     {
       TerrainCB->Items->Add("  1 Field");
       TerrainCB->Items->Add("  2 Slope");
       TerrainCB->Items->Add("  4 Trees");
       TerrainCB->Items->Add("  8 Stream");
       TerrainCB->Items->Add(" 16 Stone Bldg");
       TerrainCB->Items->Add(" 32 Wood Bldg");
       TerrainCB->Items->Add(" 64 Dirt Road");
       TerrainCB->Items->Add("128 Paved Road");
     }
     if (ARow==9) //byte 8;
     {
       TerrainCB->Items->Add("  1 Wood Bridge");
       TerrainCB->Items->Add("  2 Stone Bridge");
       TerrainCB->Items->Add("  4 Swamp");
       TerrainCB->Items->Add("  8 Water");
       TerrainCB->Items->Add(" 16 Rough");
       TerrainCB->Items->Add(" 32 Hole");
       TerrainCB->Items->Add(" 64 Trench 1");
       TerrainCB->Items->Add("128 Trench 2");
     }
     if (ARow==10) //byte 9;
     {
       TerrainCB->Items->Add("  1 Mud");
       TerrainCB->Items->Add("  2 Hedgerow");
       TerrainCB->Items->Add("  4 Snow Drift");
       TerrainCB->Items->Add("  8 Soft Sand");
       TerrainCB->Items->Add(" 16 Ditch");
       TerrainCB->Items->Add(" 32 Bit 5");
       TerrainCB->Items->Add(" 64 Bit 6");
       TerrainCB->Items->Add("128 Bit 7");
     }
     if (ARow==11) //byte 10;
     {
       TerrainCB->Items->Add("  1 Bit 0");
       TerrainCB->Items->Add("  2 Bit 1");
       TerrainCB->Items->Add("  4 Bit 2");
       TerrainCB->Items->Add("  8 Bit 3");
       TerrainCB->Items->Add(" 16 Bit 4");
       TerrainCB->Items->Add(" 32 Bit 5");
       TerrainCB->Items->Add(" 64 Bit 6");
       TerrainCB->Items->Add("128 Impassable");
     }
     TerrainCB->ItemIndex=0;
   }
   else TerrainCB->Enabled=false;

}
//---------------------------------------------------------------------------

void __fastcall THexEditForm::ToggleBtnClick(TObject *Sender)
{


    int row=S8Grid->Selection.Top;
   //this does terrain bytes... we may add road connections
   if (row>7 && row<12)
   {
     int mask=1<<TerrainCB->ItemIndex;
     int v=StrToInt(S8Grid->Cells[1][row])^mask;
     S8Grid->Cells[1][row]=IntToStr(v);
     RetainBtnClick(Sender);
   }
}
//---------------------------------------------------------------------------

