//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "SDTS1.h"
#include <stdio.h>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TSDTS *SDTS;

#define DATA_STARTS  0xBA

#define MAX_MAP_WIDTH    450
#define MAX_MAP_HEIGHT   600

short int alt[MAX_MAP_WIDTH][MAX_MAP_HEIGHT];
int max_alt=0,min_alt=32000;
int map_height,map_width;
Boolean make_lake;
AnsiString SDTSPath;
TColor clLake=(TColor) 0x780000;
TColor clLvl0=(TColor) 0x646464;
TColor clLvl1=(TColor) 0x8C8C8C;
TColor clLvl2=(TColor) 0xB4B4B4;
TColor clLvl3=(TColor) 0xDCDCDC;

struct BitmapHeader{
//  WORD  bfType;    // we have to omit this because
                     // compiler uses double word alignment adding 2
                     // extra bytes here when turned off by -a2
                     // everythin crashes. Neat.
  DWORD bfSize;
  WORD  bfRes1;
  WORD  bfRes2;
  DWORD bfOffbytes; // where data starts
  DWORD biSize;     // DIB Header size
  DWORD biWidth;    // width of image
  DWORD biHeight;   // height of image
  WORD  biPlanes;   // color planes (1)
  WORD  biBitCount; // bits/pixel (24 for us)
  DWORD biCompress; // compression
  DWORD biImageSize; // the size of image 0x36+this = bfSize
  DWORD biXPels;     // not used
  DWORD biYPels;     // not used
  DWORD biClrUsed;   // not used
  DWORD biClrImport;  // not used
 } ;

struct BitmapHeader bmpheader={ 0,  // size (the BM signature hadled separately
                                0,0,        // reserved
                                0x36,       // where data starts
                                0x28,       // DIB header size
                                0,0,        // width and height
                                1,24,       // planes and bpp
                                0,0         // compression, data size


                               };

//---------------------------------------------------------------------------
__fastcall TSDTS::TSDTS(TComponent* Owner)
        : TForm(Owner)
{

}
//-------------------------------------------------------------
void __fastcall TSDTS::DrawAltMap()
{
  Graphics :: TBitmap *mbmp;

    mbmp=new Graphics :: TBitmap;
    mbmp->Width=map_width;
    mbmp->Height=map_height;
    mbmp->Canvas->Brush->Color=clBlue;

    //blank image
    TRect drect;
    drect.top=0; drect.Left=0;
    drect.Right=mbmp->Width; drect.Bottom=mbmp->Height;
    mbmp->Canvas->FillRect(drect);
    AltMapImg->Width=mbmp->Width;
    AltMapImg->Height=mbmp->Height;
    int scalef=((max_alt-min_alt)/256)+1;
    for (int y=0; y<map_height; ++y)
      for (int x=0; x<map_width; ++x)
      {
        int delta=(alt[x][y]-min_alt)/scalef;
        mbmp->Canvas->Pixels[x][y]=(TColor)((delta<<16)+(delta<<8)+delta);

      }
      AltMapImg->Picture->Bitmap=mbmp;
      delete mbmp;
}
//---------------------------------------------------------------------------
void __fastcall TSDTS::LoadDDFBtnClick(TObject *Sender)
{
FILE *inf;
   int msb,lsb,v;
   int line,count,x,y;
   int bytes_to_read,bytes_read;
   char buffer[256]; //read the header bytes into this
   char *addr;

   OpenDialog1->InitialDir=SDTSPath;
   OpenDialog1->Filter="Elevation files (*cel0.ddf)|*cel0.ddf|All files (*.*)|*.*";
   if (!OpenDialog1->Execute()) return;
   inf=fopen(OpenDialog1->FileName.c_str(),"rb");
   if (!inf)
   {
     Application->MessageBox("Error",
                             "Could not open DDF file",
                             MB_OK);
     return;
   }
   SDTSPath=ExtractFilePath(OpenDialog1->FileName);
   fread(buffer,DATA_STARTS,1,inf); //this is stuff we don't use

   //the header at the start of a line is of variable length
   //it starts with 1E the has a 5 digit ascii field giving the
   //number of bytes in the entire record including the header
   //there are then 6 1E of 1F bytes scattered before the data
   //starts. The elevations are in feet as 2-byte words with MSB
   //then LSB. They are signed. Negative values are used as
   //delimeters and for missing data
   line=0;
   while ( fgetc(inf)!=EOF && line<MAX_MAP_HEIGHT) //get the 1e
   {
     bytes_read=1;  //number of bytes we read in the record so far
     fread(buffer,6,1,inf); //read the 5 bytes giving the line length
     bytes_read+=6;
     sscanf(buffer,"%d",&bytes_to_read);
     //now find the 6 bytes <32 that come before the data starts
     count=0;
     while (count<6)
     {
       v=fgetc(inf);
       ++bytes_read;
       if (v<32) ++count;
     }
     x=0;
     while (bytes_read<bytes_to_read)
     {
        msb=fgetc(inf);
        lsb=fgetc(inf);
        bytes_read+=2;
        addr=(char*)(&alt[x][line]);
        *addr=lsb;
        ++addr;
        *addr=msb;
        ++x;
     }
     //done with this line;
     ++line;
   } //have read all the data
   map_height=line; map_width=x;
   fclose(inf);
   //done wit reading the file
   //find min an max altitude
   max_alt=0,min_alt=32000;
   for (y=0; y<map_height; ++y)
     for (x=0; x<map_width; ++x)
     {
        if (alt[x][y]>0 && alt[x][y]<min_alt) min_alt=alt[x][y];
        if (alt[x][y]>max_alt) max_alt=alt[x][y];
     }
   MaxAltLbl->Caption="Max "+IntToStr(max_alt);
   MinAltLbl->Caption="Min "+IntToStr(min_alt);
   int delta=(max_alt-min_alt)/4;
   Lvl0Edit->Text=IntToStr(min_alt+delta);
   Lvl1Edit->Text=IntToStr(min_alt+2*delta);
   Lvl2Edit->Text=IntToStr(min_alt+3*delta);
   DrawAltMap();
}
//---------------------------------------------------------------------------

void __fastcall TSDTS::FormCreate(TObject *Sender)
{
     SDTSPath=ExtractFilePath(ParamStr(0));
}
//---------------------------------------------------------------------------

void __fastcall TSDTS::AltMapImgMouseMove(TObject *Sender,
      TShiftState Shift, int X, int Y)
{
    AltitudeLbl->Caption=IntToStr(alt[X][Y]);
    XLbl->Caption=IntToStr(X);
    YLbl->Caption=IntToStr(Y);
}
//---------------------------------------------------------------------------

void __fastcall TSDTS::LakeBtnClick(TObject *Sender)
{
   make_lake=true;
   StatusLbl->Caption="Click Lake";
}
//---------------------------------------------------------------------------
Boolean __fastcall TSDTS::NearBlue(int x, int y)
{
   TColor color;
   //int r,g,b;

   //if a pixel is still gray but a neighbor is blue return true
   color=AltMapImg->Picture->Bitmap->Canvas->Pixels[x][y];
   if (color==clLake) return false; //already lake can't change
   //r=(int)color&0xFF;
   //g=((int)color>>8)&0xFF;
   //b=((int)color>>16)&0xFF;

   if (AltMapImg->Picture->Bitmap->Canvas->Pixels[x-1][y]==clLake) return true;
   if (AltMapImg->Picture->Bitmap->Canvas->Pixels[x+1][y]==clLake) return true;
   if (AltMapImg->Picture->Bitmap->Canvas->Pixels[x][y+1]==clLake) return true;
   if (AltMapImg->Picture->Bitmap->Canvas->Pixels[x][y+1]==clLake) return true;
   if (AltMapImg->Picture->Bitmap->Canvas->Pixels[x+1][y+1]==clLake) return true;
   if (AltMapImg->Picture->Bitmap->Canvas->Pixels[x+1][y-1]==clLake) return true;
   if (AltMapImg->Picture->Bitmap->Canvas->Pixels[x-1][y+1]==clLake) return true;
   if (AltMapImg->Picture->Bitmap->Canvas->Pixels[x-1][y-1]==clLake) return true;

   return false;
}
//------------------------------------------------------
void __fastcall TSDTS::AltMapImgMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
    int target=alt[X][Y];

    if (make_lake)
    {
       StatusLbl->Caption="Making Lake ";
       TCursor OldCur=Screen->Cursor;
       Screen->Cursor=crHourGlass;

       AltMapImg->Picture->Bitmap->Canvas->Pixels[X][Y]=clLake;
       Boolean Switch=true;
       while (Switch)
       {
         Switch=false;
         for (int y=0; y<map_height; ++y)
           for (int x=0; x<map_width; ++x)
           {
             if (alt[x][y]==target && NearBlue(x,y))
             {
               AltMapImg->Picture->Bitmap->Canvas->Pixels[x][y]=clLake;
               Switch=true;
             }

           }
       }
       StatusLbl->Caption="             ";
       make_lake=false;
       Screen->Cursor=OldCur;
    }
}
//---------------------------------------------------------------------------

void __fastcall TSDTS::ConvertBtnClick(TObject *Sender)
{
  int lvl0,lvl1,lvl2;

  TCursor OldCur=Screen->Cursor;

  Screen->Cursor=crHourGlass;
  lvl0=StrToInt(Lvl0Edit->Text);
  lvl1=StrToInt(Lvl1Edit->Text);
  lvl2=StrToInt(Lvl2Edit->Text);

  for (int y=0; y<map_height; ++y)
    for (int x=0; x<map_width; ++x)
    {
       if (AltMapImg->Picture->Bitmap->Canvas->Pixels[x][y]==clLake)
       ; // do nothing
       else
       if (alt[x][y]<lvl0)
         AltMapImg->Picture->Bitmap->Canvas->Pixels[x][y]=clLvl0;
       else
       if (alt[x][y]<lvl1)
         AltMapImg->Picture->Bitmap->Canvas->Pixels[x][y]=clLvl1;
       else
       if (alt[x][y]<lvl2)
         AltMapImg->Picture->Bitmap->Canvas->Pixels[x][y]=clLvl2;
       else
         AltMapImg->Picture->Bitmap->Canvas->Pixels[x][y]=clLvl3;
    }
    Screen->Cursor=OldCur;
}
//---------------------------------------------------------------------------

void __fastcall TSDTS::SaveBtnClick(TObject *Sender)
{
  //SaveDialog1->InitialDir=HomePath;
   //if (!SaveDialog1->Execute()) return;
   //AltMapImg->Picture->SaveToFile(SaveDialog1->FileName);
  WriteBmp();
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void __fastcall TSDTS::WriteBmp()
{
   FILE *outf;
   long datasize,x,y;
   int linebyte,pixcount;
   int color,r,g,b;
   char str[256];

   SaveDialog1->InitialDir=SDTSPath;
   SaveDialog1->Filter="Bitmaps (*.bmp)|*.BMP|All files (*.*)|*.*";
   SaveDialog1->DefaultExt="bmp";
   SaveDialog1->Title="Save Windows Bitmap";
   if (!SaveDialog1->Execute()) return;
  // bmp_path=SaveDialog1->FileName.
  //  SubString(1,SaveDialog1->FileName.LastDelimiter("\\"));

   outf=fopen(SaveDialog1->FileName.c_str(),"wb");
   if (!outf)
   {
     sprintf(str,"Could not open bmp file %s",
          SaveDialog1->FileName.c_str());
     Application->MessageBox("Error",str,MB_OK);
     return; // add some error
   }
   // put sizes into the header
   // a line must have bytes ending on 4 byte boundary
   linebyte=3*map_width;
   while (linebyte%4) ++linebyte;
   datasize=linebyte*map_height;
   bmpheader.bfSize=datasize+0x36;
   bmpheader.biImageSize=datasize;
   bmpheader.biHeight=map_height;
   bmpheader.biWidth=map_width;
   fputc('B',outf);
   fputc('M',outf);
   fwrite(&bmpheader,sizeof(bmpheader),1,outf);
   for (y=map_height; y>=0; --y) // write from the bottom
   {
     pixcount=0;
     for (x=0; x<map_width; ++x)
     {
        color=(int)AltMapImg->Picture->Bitmap->Canvas->Pixels[x][y];
        r=color&0xFF;
        g=(color>>8)&0xFF;
        b=(color>>16)&0xFF;
        fputc(b,outf);
        fputc(g,outf);
        fputc(r,outf);
     }
      pixcount+=3;
     // add bytes at end of line
     while (pixcount%4) { fputc(0,outf); ++pixcount;}
   }
   fclose(outf);
}

