#!/usr/bin/perl
# Author Yosi Izaq
# Description. save dom2 games

use File::Copy;
use strict;

my @params = ();
my @params = @ARGV;
my $configuration_file = ".save_dom_conf";
my $dom_path_param = "dominions_path";
my $save_path_param = "save_game_path";
my $dom_path = "/cygdrive/d/temp/dom/";
my $save_path = "/cygdrive/d/temp/temp/";

#print "there are " . @params . " parameters\n";

if (@params == 1)
  {
    if ($params[0] eq "v"){
      print_conf();
    }
    elsif ($params[0] eq "c"){
      set_conf();
    }
  }

elsif (@params == 3){
    if ($params[0] eq "s"){
      save_game(@params);
    }
    elsif ($params[0] eq "l"){
      load_game(@params);
    }
}
else{
  help();
#Consider making this an interactive mode...
#  @params = get_params();
}


sub save_game{
  my  $game = $params[1];
  my  $turn = $params[2];

  my @paths = load_conf();
  $dom_path = $paths[0];
  $save_path = $paths[1];
  
  my  $game_path = $dom_path.$game ;
  my  $save_game_path = $save_path.$game."/".$turn;
  print "game path $game_path.\nsave game path $save_game_path\n";

  if (! -e $game_path) {die "game doesn't exist: $game_path.\n";}

  if (! -e $save_game_path){
    print" creating save game directory for turn $turn.\n";
    if ( ! -e $save_path.$game){
          mkdir ($save_path.$game) || die "can't create dir $save_path.$game $!";
    }
    mkdir ($save_game_path) || die "can't create dir $save_game_path $!";
  }

  opendir(DIR, $game_path) || die "can't read dir $!\n"; 
my  @files = readdir(DIR);

  for (@files){
 
#   print "file $_\n";
#    if ($_ =~ /^\.\.*/ ){
#      print "match $& \n";
#    }

#don't want to copy . and .. ;)
    if (! /^\.\.*/){
      print "copying file $game_path/$_ to $save_game_path\n";
      copy($game_path."/".$_, $save_game_path) || die "failed copying file $game_path/$_ . $!";
  }
  }

}


sub load_game{
  my  $game = $params[1];
  my  $turn = $params[2];

  my @paths = load_conf();
  $dom_path = $paths[0];
  $save_path = $paths[1];

  my  $game_path = $dom_path.$game;
  my  $save_game_path = $save_path.$game."/".$turn;
  print "game path $game_path.\nsave game path $save_game_path\n";

  if (! -e $game_path) {die "game doesn't exist: $game_path.\n";}

  if (! -e $save_game_path){die "save game doesn't exist. $save_game_path. \n"; }

  opendir(DIR, $save_game_path) || die "can't open dir $!";
  my  @files = readdir(DIR);

  for (@files){

    if (! /^\.\.*/){
      print "copying file $save_game_path/$_ to $game_path\n";
      copy($save_game_path."/".$_, $game_path) || die "failed copying file $game_path/$_ . $!";
  }
  }
}

sub get_params{
  my @params = ();
  print "please enter game name\n";
  my $game = <STDIN>;
  chomp $game;

  print "please enter turn number\n";
  my $turn = <STDIN>;
  chomp $turn;
  
  push (@params, $game);
  push (@params, $turn);

#  print "params @params";

  return @params;
}

sub help{
print "This small utility will save and load dominions II turns.\n";
print "Usage save_dom.pl [v|c|s|l] [game name] [turn number].\n";
print "Examples.\n";
print "\t1 To save turn 14 of game named \"ermor\" do:\n";
print "\t  save_dom.pl s ermor 14.\n";
print "\t2 To load turn 14 of game named \"ermor\" do:\n";
print "\t  save_dom.pl l ermor 14.\n";
print "\t3 To configure values of dominions II path and save game root path do:\n";
print "\t  save_dom.pl c.\n";
print "\t4 To view configuration parameters values do:\n";
print "\t  save_dom.pl v\n";
}

sub load_conf{
my @return_vals;
if (! -e $configuration_file){ #configuration file doesn't exist
    die "empty configuration. run with c option to create a new configuration file\n";
}
else{
  open(CONF_FILE, "<$configuration_file") || die "Open failed $!";
  
  for (<CONF_FILE>){

    if (/^$dom_path_param=(.+)/){
#    print "Path of dominions II games: $1.\n";
      $return_vals[0] = $1;
  }
    if ( /^$save_path_param=(.+)/){
#    print "Path of saved games is: $1.\n";
      $return_vals[1] = $1;
  }
}

  close CONF_FILE || die "Close failed $!";
}
return @return_vals;
}

sub print_conf{

my @params = load_conf();
    print "Path of dominions II games: $params[0].\n";
    print "Path of saved games is: $params[1].\n";
}

sub set_conf{
  if (! -e $configuration_file){ #configuration file doesn't exist
    print "configuration file doesn't exist. creating an empty one\n";
    open (CONF_FILE, ">$configuration_file") or die "Open failed $!";
    close (CONF_FILE);
  }
#  else{ #configuration file exists.
#  }

$dom_path = " ";
$save_path = " ";
open (CONF_FILE, "+<$configuration_file") or die "Open failed $!";

my @lines  = <CONF_FILE>;

for (@lines){
  my $ans;

#This block can later on move to a sub routine, I'm too lazy now :)
  if (/^$dom_path_param=(.+)/){
    $dom_path = $1;
    print "current value of ${dom_path_param} is $dom_path.\n";
    print "Do you wish to change it[y|n]?\n";
    $ans = <STDIN>;
    chomp $ans;
    if ($ans =~ /y/i){
      print "Please enter new dominoins path.\n";
      $dom_path = <STDIN>;
      chomp $dom_path;
      $_ =~ s/^${dom_path_param}=(.+)/${dom_path_param}=$dom_path/ ;
    }
    else{
      print "Keeping old value.\n";
    }
  }

#Copy paste of above that handles 2nd param.
  if (/^$save_path_param=(.+)/){
    $save_path = $1;
    print "current value of ${save_path_param} is $save_path.\n";
    print "Do you wish to change it[y|n]?\n";
    $ans = <STDIN>;
    chomp $ans;
    if ($ans =~ /y/i){
      print "Please enter new save game path.\n";
      $save_path = <STDIN>;
      chomp $save_path;
      $_ =~ s/^${save_path_param}=(.+)/${save_path_param}=$save_path/ ;
    }
    else{
      print "Keeping old value.\n";
    }
  }

}

#This block can later on move to a sub routine, I'm too lazy now :)
if ($dom_path eq " "){
    print"param $dom_path_param not found.\n";
    print "please enter value of $dom_path_param for example /cygdrive/d/temp/dom/ \n";
    $dom_path = <STDIN>;
    chomp $dom_path;
    push (@lines, "$dom_path_param=$dom_path\n");
  }

#Copy paste of above that handles 2nd param.
if ($save_path eq " "){
    print"param $save_path_param not found.\n";
    print "please enter value of $save_path_param for example /cygdrive/d/temp/temp/ \n";
    $save_path = <STDIN>;
    chomp $save_path;
    push (@lines, "$save_path_param=$save_path\n");
  }

seek(CONF_FILE,0,0)                        or die "Seeking: $!";
print CONF_FILE @lines                     or die "Printing: $!";
truncate(CONF_FILE,tell(CONF_FILE))               or die "Truncating: $!";

close(CONF_FILE) or die "closing $!";
}
#TODO


# make l restore the turn from saved game path
