//============================================================================
// CUSTOM RIGHT CLICK ACTIONS WHEN OVER A CANVAS CHILD
//============================================================================

// Disable the default right-click menu
document.getElementById('canvasContainer').addEventListener('contextmenu', function(event) {
  event.preventDefault();  // Prevent the default context menu
});

// Event listener to show custom context menu on right-click on a canvas
document.getElementById('canvasContainer').addEventListener('contextmenu', function(event) {
  const target = event.target;

  // Check if the right-clicked element is a canvas (canvas child)
  if (target.tagName === 'CANVAS') {
    // Show the custom context menu
    const contextMenu = document.getElementById('customContextMenu');
    contextMenu.style.display = 'block';
    contextMenu.style.left = `${event.pageX}px`;
    contextMenu.style.top = `${event.pageY}px`;

    // Store the clicked canvas element for later use (e.g., saving the image)
    contextMenu.currentCanvas = target;
  }
});

// Hide the context menu if clicked outside
document.addEventListener('click', function(event) {
  const contextMenu = document.getElementById('customContextMenu');
  contextMenu.style.display = 'none';
});

// Handle "Save Image" action
document.getElementById('saveImage').addEventListener('click', function() {
  const contextMenu = document.getElementById('customContextMenu');
  const canvas = contextMenu.currentCanvas;

  if (canvas) {
    const canvasContainer = document.getElementById('canvasContainer');
    const canvases = Array.from(canvasContainer.getElementsByTagName('canvas'));
    const index = canvases.indexOf(canvas) + 1;  // Get the index of the clicked canvas (+1 to make it 1-based)

    // Generate the file name using the original SHP file name and image index
    const fileName = `${originalFileName}-${String(index).padStart(4, '0')}.png`;

    const link = document.createElement('a');
    link.href = canvas.toDataURL();  // Convert canvas to image data URL
    link.download = fileName;  // Dynamic file name based on original filename and index
    link.click();
  }
  document.getElementById('customContextMenu').style.display = 'none';  // Hide the menu
});

// Handle "Image Info" action
document.getElementById('infoImage').addEventListener('click', function() {
  const contextMenu = document.getElementById('customContextMenu');
  const canvas = contextMenu.currentCanvas;
  if (canvas) {
    alert(`Canvas Info: Width = ${canvas.width}, Height = ${canvas.height}`);
  }
  document.getElementById('customContextMenu').style.display = 'none';  // Hide the menu
});

//=======================================================================
//Add replace image option in context menu
//=======================================================================

/* 
// Handle "Replace Image" action
document.getElementById('replaceImage').addEventListener('click', function() {
  const contextMenu = document.getElementById('customContextMenu');
  const canvas = contextMenu.currentCanvas;

  if (canvas) {
    // Create an input element to upload a new image
    const fileInput = document.createElement('input');
    fileInput.type = 'file';
    fileInput.accept = 'image/*'; // Accept any image type

    fileInput.onchange = function(event) {
      const file = event.target.files[0];
      if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
          const img = new Image();
          img.onload = function() {
            const ctx = canvas.getContext('2d');
            // Clear the existing canvas
            ctx.clearRect(0, 0, canvas.width, canvas.height);

            // Draw the new image on the canvas, resizing it to fit the canvas dimensions
            ctx.drawImage(img, 0, 0, canvas.width, canvas.height);
          };
          img.src = e.target.result;  // Set the new image source
        };
        reader.readAsDataURL(file);  // Read the new image as data URL
      }
    };

    // Simulate a click on the file input to open the file dialog
    fileInput.click();
  }
  
  document.getElementById('customContextMenu').style.display = 'none';  // Hide the menu
}); 
*/