document.getElementById('exportSHPButton').addEventListener('click', function () {
  const zip = new JSZip();
  const csvContent = [];
  const canvasContainer = document.getElementById('canvasContainer');
  const canvases = canvasContainer.getElementsByTagName('canvas');
  const palette = document.getElementById('paletteSelect').value;

  Array.from(canvases).forEach((canvas, index) => {
    const ctx = canvas.getContext('2d');
    const dataURL = canvas.toDataURL('image/png');

    // Retrieve the original filename from the canvas dataset
    const originalFilename = canvas.dataset.filename?.replace('.shp', '').replace('.SHP', '') || 'unknown';
    const imageIndex = canvas.dataset.index || index + 1; // Use dataset index if available, otherwise fallback to array index

    const imageFilename = `${originalFilename}-${String(imageIndex).padStart(4, '0')}.png`;

    // Save the canvas as an image in the ZIP
    zip.file(imageFilename, dataURL.split(',')[1], { base64: true });

    // Extract header data from global arrays
    const csvRow = [
      imageIndex, // SHP_Slot
      imageFilename,
      palette,
      imageHeights[imageIndex - 1],
      imageWidths[imageIndex - 1],
      imageVar1s[imageIndex - 1],
      imageXStarts[imageIndex - 1],
      imageYStarts[imageIndex - 1],
      imageXEnds[imageIndex - 1],
      imageYEnds[imageIndex - 1],
    ].join(',');

    csvContent.push(csvRow);
  });

  // Create CSV content with header
  const csvHeader = 'SHP_Slot,imagefilename,palette,height,width,var1,xStart,yStart,xEnd,yEnd\n';
  const csvBlob = new Blob([csvHeader + csvContent.join('\n')], { type: 'text/csv' });
  zip.file(`SHP_metadata.csv`, csvBlob);

  // Generate the ZIP and trigger download
  zip.generateAsync({ type: 'blob' }).then(function (content) {
    const link = document.createElement('a');
    link.href = URL.createObjectURL(content);
    link.download = `SHP_Export.zip`; // Use generic name or modify as needed
    link.click();
  });
});
