//============================================================================
//============================================================================

// Main Logging Function

function logMessage(message, type = 'log', alignment = 'left') {
    const logContainer = document.getElementById('logContainer');
    const logEntry = document.createElement('div');
    
    // Set the message text
    logEntry.textContent = message;

    // Set the color based on the log type
    if (type === 'warn') {
        logEntry.style.color = 'orange';
    } else if (type === 'error') {
        logEntry.style.color = 'red';
    } else {
        logEntry.style.color = 'black'; // Default color for log messages
    }

    // Set the alignment based on the provided parameter
    if (alignment === 'center') {
        logEntry.style.textAlign = 'center';
    } else if (alignment === 'right') {
        logEntry.style.textAlign = 'right';
    } else {
        logEntry.style.textAlign = 'left'; // Default alignment
    }

    logContainer.appendChild(logEntry); // Append the log entry to the container
    logContainer.scrollTop = logContainer.scrollHeight; // Auto-scroll to bottom
}


//============================================================================
//============================================================================

// Helper function for conditional logging -- i.e. we only show this if VERBOSE checkbox
// is checked.

	function conditionalLog(message) 
	{
	  const verboseLog = document.getElementById('verboseConsole').checked;
	  if (verboseLog) {
		logMessage(message);
	  }
	}
	
//============================================================================
//============================================================================
