; script-fu-blur-random-map-batch
; By Jeff Kelly
; kellyjw@rose-hulman.edu
; February 8th, 2004

; Edited by Leif Roar Moldskred, Feb 24th

; A script for blurring and bump-mapping random maps created by
; Gandalf Parker's random map generator for the Dominions II game
; engine.  Now supports GIMP batch mode, although the color values has
; to be hard-coded into the script.

; Place in $GIMP_HOME/scripts/ folder, and select
; Xtns/Script-Fu/Refresh from in GIMP to install.

; Feel free to distribute.

; In:
; (not listed in args) 1/0 for interactive/not
; filename - STRING ("C:\...\"), quotes are important. Expects TGA.
; color1-3 - RGB triples specifying which colors to ignore
;            when blurring (defaults to white, red and blue)

; Out:
; filename - will contain modified TGA picture, will overwrite old data.

(define (script_fu_blur_random_map_batch filename)
  
  (gimp-message-set-handler 1)
  (gimp-message "in")
  
					; Load the picture and grab necessary attributes.
  (set! image (car (file-tga-load RUN-NONINTERACTIVE filename filename)))
  
					; Do normal script stuff
  (gimp-image-undo-disable image)
  (set! bglayer (car (gimp-image-get-active-layer image)))
  
					; Make a copy of the background layer
  (set! prettylayer (car (gimp-layer-copy bglayer 1)))
  (gimp-image-add-layer image prettylayer -1)
  (gimp-image-set-active-layer image prettylayer)
  (set! prettydrawable (car (gimp-image-active-drawable image)))
  
					; Make a new layer with plasma
  (gimp-message "plasma")
  (set! plasmalayer (car (gimp-layer-new image (car (gimp-image-width image)) (car (gimp-image-height image)) RGB_IMAGE "plasma" 100 NORMAL)))
  (gimp-image-add-layer image plasmalayer -1)
  (gimp-image-set-active-layer image plasmalayer)
  (set! plasmadrawable (car (gimp-image-active-drawable image)))
					; Don't know if there's a way to actually make a random number for the seed here
  (plug-in-plasma RUN-NONINTERACTIVE image plasmadrawable 11234 1.5) 
  
					; Blur the pretty map
  (plug-in-gauss-iir RUN-NONINTERACTIVE image prettydrawable 5.0 1 1)
  
					; Apply a bump-map to the pretty may
					; The parameters can be toyed around with a great deal
  (plug-in-bump-map RUN-NONINTERACTIVE image prettydrawable plasmadrawable 135.0 45.0 3 9 0 0 0 0 0 LINEAR)
  
					; We don't need the plasma layer any more
  (gimp-message "delete-layer")    
  (gimp-image-remove-layer image plasmalayer)
     
  (gimp-message "active")
  (gimp-image-set-active-layer image bglayer)
  (set! drawable (car (gimp-image-active-drawable image)))

  
  (set! capital-color '(255 255 255))
  (set! land-border-color '(195 87 44))
  (set! sea-border-color '(44 135 195))
  (set! sea-color '(78 114 131))
					; Create floating layer for first color
  (gimp-by-color-select drawable capital-color 0 REPLACE 0 0 0 FALSE)
  (gimp-by-color-select drawable land-border-color 15 ADD 1 0 0 FALSE)
  (gimp-by-color-select drawable sea-border-color 15 ADD 1 0 0 FALSE)
  (gimp-by-color-select drawable sea-color 15 ADD 1 0 0 FALSE)

  (set! floating (car (gimp-selection-float drawable 0 0) ))
  (gimp-floating-sel-to-layer floating)
  
					; Merge it down
  (gimp-image-merge-visible-layers image CLIP-TO-BOTTOM-LAYER)

  ; Regrab the drawable, as it has changed since we remerged everything.
  (set! drawable (car (gimp-image-active-drawable image)))
					; Save it back out!
  (file-tga-save 1 image drawable filename filename 1 1)
  ; Turn undo-tracking back on
  (gimp-image-undo-enable image)

  (gimp-quit 0))
  ; Uncomment next line out if you want to see the image when its done.
  ; (gimp-display-new image))


; Register the script with GIMP.
(script-fu-register
 "script_fu_blur_random_map_batch"
 "<Toolbox>/Xtns/Script-Fu/Utils/Dominions II Blur Batch"
 "Blurs .tga images without modify three user-defined colors."
 "Jeff Kelly: kellyjw@rose-hulman.edu"
 "February 8th 2004"
 "2/8/2004"
 "RGB RGBA"
 SF-VALUE "File name: " "\"/home/leifm/random.tga\"")



