#!/usr/bin/perl

#
# A script to use dommap to create a number of maps (all with the same
# settings), and then prettify them with the Gimp script
# script_fu_blur_random_map_batch
#

$height = 550;
$width = 750;
$baseName = "random";
$randomSeed = 0;
#$rugged = 1.5;
$rugged = 2.5;
$dither = 0.08;
$water = 35;
$trees = 60;
$mountain = 80;
$poverty = 20;
$rich = 80;
$no_sea = 10;
$no_land = 90;
$special = 20;
#$sea_avoid = 30;
$sea_avoid = 8;
$land_avoid = 8;
#$sea_spread = 60;
$sea_spread = 100;
#$land_spread = 25;
$land_spread = 40;
$sea_cost = 1000000;
#$terrain_cost = 10;
$terrain_cost = 100;
#$smooth = 1;
$smooth = 2;

$no_map_to_generate = 3;
$thumbnail_size = 50;
$make_webpage = 1;

$new_line = "\n";


# Clumsy code to read the command-line arguments
$no_arguments = scalar( @ARGV );

for( $i = 0; $i < $no_arguments; ++$i ) {
  print "Argument $i is $ARGV[$i]" . $new_line;

  if( $ARGV[$i] eq "-h" ) {
    $height = $ARGV[++$i];
  }
  elsif ( $ARGV[$i] eq "-w" ) {
    $width = $ARGV[++$i]
  }
  elsif ( $ARGV[$i] eq "-n" ) {
    $baseName = $ARGV[++$i]
  }
  elsif ( $ARGV[$i] eq "-s" ) {
    $randomSeed = $ARGV[++$i]
  }
  elsif ( $ARGV[$i] eq "-r" ) {
    $rugged = $ARGV[++$i]
  }
  elsif ( $ARGV[$i] eq "-d" ) {
    $dither = $ARGV[++$i]
  }
  elsif ( $ARGV[$i] eq "-wl" ) {
    $water = $ARGV[++$i]
  }
  elsif ( $ARGV[$i] eq "-tl" ) {
    $trees = $ARGV[++$i]
  }
  elsif ( $ARGV[$i] eq "-ml" ) {
    $mountain = $ARGV[++$i]
  }
  elsif ( $ARGV[$i] eq "-pl" ) {
    $poverty = $ARGV[++$i]
  }
  elsif ( $ARGV[$i] eq "-rl" ) {
    $rich = $ARGV[++$i]
  }
  elsif ( $ARGV[$i] eq "-nl" ) {
    $no_land = $ARGV[++$i]
  }
  elsif ( $ARGV[$i] eq "-ns" ) {
    $no_sea = $ARGV[++$i]
  }
  elsif ( $ARGV[$i] eq "-ps" ) {
    $special = $ARGV[++$i]
  }
  elsif ( $ARGV[$i] eq "-sa" ) {
    $sea_avoid = $ARGV[++$i]
  }
  elsif ( $ARGV[$i] eq "-la" ) {
    $land_avoid = $ARGV[++$i]
  }
  elsif ( $ARGV[$i] eq "-ss" ) {
    $sea_spread = $ARGV[++$i]
  }
  elsif ( $ARGV[$i] eq "-ls" ) {
    $land_spread = $ARGV[++$i]
  }
  elsif ( $ARGV[$i] eq "-tc" ) {
    $land_cost = $ARGV[++$i]
  }
  elsif ( $ARGV[$i] eq "-sc" ) {
    $sea_cost = $ARGV[++$i]
  }
  elsif ( $ARGV[$i] eq "-sm" ) {
    $smooth = $ARGV[++$i]
  }
  elsif ( $ARGV[$i] eq "-sn" ) {
    $min_neighbour_sea = $ARGV[++$i]
  }
  elsif ( $ARGV[$i] eq "-ln" ) {
    $min_neighbour_land = $ARGV[++$i]
  }

  # Other command switches
  elsif ( $ARGV[$i] eq "-x" ) {
    $no_map_to_generate = $ARGV[++$i]
  }
  elsif ( $ARGV[$i] eq "-nw" || $ARGV[$i] eq "--no-web" ) {
    $make_webpage = 0;
  }
  elsif ( $ARGV[$i] eq "-tn" ) {
    $thumbnail_size = $ARGV[++$i]
  }
  elsif ( $ARGV[$i] eq "--help" ) {
    print "Options passed on to dommap: " . $new_line;
    print "  -h <map height>" . $new_line;
    print "  -w <map width>" . $new_line;
    print "  -s <random seed>" . $new_line;
    print "  -r <terrain ruggedness>" . $new_line;
    print "  -wl <water line (0-100)>" . $new_line;
    print "  -tl <tree line (0-100)>" . $new_line;
    print "  -ml <mountain line (0-100)>" . $new_line;
    print "  -pl <poverty line (0-100)>" . $new_line;
    print "  -rl <rich line (0-100)>" . $new_line;
    print "  -d <terrain dithering>" . $new_line;
    print "  -ns <number of sea provinces>" . $new_line;
    print "  -nl <number of land provinces>" . $new_line;
    print "  -ps <percentage of special provinces>" . $new_line;
    print "  -sa <min distance from shore (sea)>" . $new_line;
    print "  -la <min distance from shore (land)>" . $new_line;
    print "  -ss <distance between sea provinces>" . $new_line;
    print "  -ls <distance between land provinces>" . $new_line;
    print "  -sc <cost for spreading over shore>" . $new_line;
    print "  -tc <cost for spreading over terrain>" . $new_line;
    print "  -sm <amount of border smoothing>" . $new_line;
    print "  -sn <minimum neighbours for starting (sea)>" . $new_line;
    print "  -ln <minimum neighbours for starting (land)>" . $new_line;
    print $new_line;
    print "Options passed on to the Gimp script: " . $new_line;
    print "  (none implemented yet)" . $new_line;
    print "Other options:" . $new_line;
    print "  -x <number of maps to make>" . $new_line;
    print "  -nw | --no-web     Don't build a web-page and thumbnails nor package the maps." . $new_line;
    print "  -tn <thumbnail size (0-100)>" . $new_line;
    print "  --help             Print this text" . $new_line;

    exit( 0 );
  }
  else {
    print "Unknown option: " . $ARGV[$i] . $new_line;
    exit( 1 );
  }  
} # end for


print "Starting generating." . "\n";

# Write the header of the HTML file
if ($make_webpage) {
  open( html_file, ">dominion_maps.html" );
  print html_file "<!DOCTYPE HTML PUBLIC >" . $new_line;
  print html_file "<html>" . $new_line;
  print html_file "  <head>" . $new_line;
  print html_file "    <title>Random Maps</title>" . $new_line;
  print html_file "  </head>" . $new_line;
  print html_file $new_line;
  print html_file "  <body>" . $new_line;
  print html_file "    <h1>Randomly generated maps for Dominions II</h1>" . $new_line;
}

for( $i = 1; $i <= $no_map_to_generate; ++$i ) {
  print "Map #$i of $no_map_to_generate" . $new_line;

  $current_map_name = $baseName . "_" . $i;

  print "Generating map." . "\n";
  system( "dommap -h $height -w $width -n $current_map_name -s $randomSeed " .
	  "-r $rugged -d $dither -wl $water -tl $trees -ml $mountain " .
	  "-pl $poverty -rl $rich -ns $no_sea -nl $no_land -ps $special " .
	  "-sa $sea_avoid -la $land_avoid -ss $sea_spread -ls $land_spread " .
	  "-sc $sea_cost -tc $terrain_cost -sm $smooth " .
	  "-sn $min_neighbour_sea -ln $min_neighbour_land" . "\n" ); 	  

#  print "Prettifying the map." . "\n";
#  system( "gimp-1.2 --no-interface --no-xshm --no-splash -c " . 
#	  "-b '(script_fu_blur_random_map_batch \"$current_map_name.tga\")'" );

  if ($make_webpage) {
    print "Creating thumbnail." . "\n";
    system( "convert -scale " . $thumbnail_size . "%x" . 
	    $thumbnail_size . "% $current_map_name" . ".tga " .
	    "$current_map_name" . ".jpg" . "\n" );

    print "Packing the map." . "\n";
    system( "zip $current_map_name" . ".zip " . 
	    "$current_map_name" . ".tga " .
	    "$current_map_name" . ".map" );
    
    system( "rm -f $current_map_name" . ".tga " .
	    "$current_map_name" . ".map" );

    print html_file "    <a href=\"$current_map_name" . ".zip\">" . $new_line;
    print html_file "      <img src=\"$current_map_name" . ".jpg\" />" . $new_line;
    print html_file "    </a>" . $new_line;
  } # End if 
} # End for

# Close the HTML file
if ($make_webpage) {
  print html_file "  </body>" . $new_line;
  print html_file "</html>" . $new_line;
} # End if 

print "All maps created." . $new_line;
