//v 1.3
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;

//The GUI that starts the Dominions Savegame backup program.

public class DomBackupGUI {
    JFrame converterFrame;
    JPanel converterPanel;
    JTextField txtGamePath,txtBackupPath, txtInterval, txtNumberSaves, txtRestorePathFrom, txtRestorePathTo;
    JLabel lblGamePath, lblBackupPath, lblInterval, lblNumberSaves, lblRestorePathFrom, lblRestorePathTo, lblFeedback;
    JButton butBackupNow, butAutoBackup, butRestoreNow, butSaveDefaults;

    // Constructor
    public DomBackupGUI() {
	// Create the frame and container.
	converterFrame = new JFrame("Dominions Backup & Restore GUI");
	converterFrame.setSize(40, 40);
	converterPanel = new JPanel();
	converterPanel.setLayout(new GridLayout(11, 2));
	
	// Add the widgets.
	addWidgets();

	// Add the panel to the frame.
	converterFrame.getContentPane().add(converterPanel, BorderLayout.CENTER);

	// Exit when the window is closed.
        converterFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

	// Show the converter.
	converterFrame.pack();
	converterFrame.setVisible(true);
    }

    // Create and add the widgets for converter.
    private void addWidgets() {
      // Create widgets.
      txtGamePath = new JTextField(20);
      lblGamePath = new JLabel("Game Path", SwingConstants.LEFT);

      txtBackupPath = new JTextField(20);
      lblBackupPath = new JLabel("Backup Path", SwingConstants.LEFT);

      txtInterval = new JTextField(20);
      lblInterval = new JLabel("Backup Interval (seconds)", SwingConstants.LEFT);   
   
      txtNumberSaves = new JTextField(20);
      lblNumberSaves = new JLabel("Max Backups Saved", SwingConstants.LEFT);

      butBackupNow = new JButton("Backup Now");
      butAutoBackup = new JButton("Auto Backup");

      txtRestorePathFrom = new JTextField(20);
      lblRestorePathFrom = new JLabel("Backup to Restore From", SwingConstants.LEFT);

      txtRestorePathTo = new JTextField(20);
      lblRestorePathTo = new JLabel("Backup to Restore To", SwingConstants.LEFT);

      butRestoreNow = new JButton("Restore Now");

      butSaveDefaults = new JButton("Save Setup as Default");
      lblFeedback = new JLabel("Welcome to DomBackup!", SwingConstants.RIGHT);

      // Add widgets to container.
      converterPanel.add(lblGamePath);
      converterPanel.add(txtGamePath);

      converterPanel.add(lblBackupPath);
      converterPanel.add(txtBackupPath);

      converterPanel.add(lblInterval);
      converterPanel.add(txtInterval);

      converterPanel.add(lblNumberSaves);
      converterPanel.add(txtNumberSaves);
      
      converterPanel.add(butBackupNow);
      converterPanel.add(butAutoBackup);

      converterPanel.add(new JLabel("", SwingConstants.LEFT));
      converterPanel.add(new JLabel("", SwingConstants.LEFT));

      converterPanel.add(lblRestorePathFrom);
      converterPanel.add(txtRestorePathFrom);

      converterPanel.add(lblRestorePathTo);
      converterPanel.add(txtRestorePathTo);

      converterPanel.add(butRestoreNow);
      converterPanel.add(new JLabel("", SwingConstants.LEFT));

      converterPanel.add(new JLabel("", SwingConstants.LEFT));
      converterPanel.add(new JLabel("", SwingConstants.LEFT));

      converterPanel.add(butSaveDefaults);
      converterPanel.add(lblFeedback);

      // Get the default values
      ReadWriteBackupDomDefaults rwbdd = new ReadWriteBackupDomDefaults();

      // Set default values for text boxes
      txtGamePath.setText(rwbdd.ReadDomDefaultsBackupPath());
      txtBackupPath.setText(rwbdd.ReadDomDefaultsSaveToPath());
      txtInterval.setText("" + rwbdd.ReadDomDefaultsBackupInterval());
      txtNumberSaves.setText("" + rwbdd.ReadDomDefaultsNumberSaves());
      txtRestorePathFrom.setText(rwbdd.ReadDomDefaultsRestorePathFrom());
      txtRestorePathTo.setText(rwbdd.ReadDomDefaultsRestorePathTo());

      // Add event listeners and init
      // Backup now button
      BackupNowListener bunl = new BackupNowListener();
      bunl.LinkGUI(txtGamePath, txtBackupPath, txtNumberSaves, lblFeedback);
      butBackupNow.addActionListener(bunl);

      //Restore now button
      RestoreNowListener rnl = new RestoreNowListener();
      rnl.LinkGUI(txtRestorePathTo, txtRestorePathFrom, lblFeedback);
      butRestoreNow.addActionListener(rnl);

      //Auto Backup button
      BackupAutoListener bual = new BackupAutoListener();
      bual.LinkGUI(txtGamePath, txtBackupPath, txtInterval, txtNumberSaves,
                    butBackupNow, butAutoBackup, butRestoreNow, lblFeedback);
      butAutoBackup.addActionListener(bual);

      //The save parameters to default values
      SaveDefaultsListener sdl = new SaveDefaultsListener();
      sdl.LinkGUI(txtGamePath, txtBackupPath, txtInterval, txtNumberSaves,
                  txtRestorePathFrom, txtRestorePathTo, lblFeedback);
      butSaveDefaults.addActionListener(sdl);
    }

    // main method
    public static void main(String[] args) {
	// Set the look and feel.
	try {
	    UIManager.setLookAndFeel(
		UIManager.getCrossPlatformLookAndFeelClassName());
	} catch(Exception e) {}

	DomBackupGUI converter = new DomBackupGUI();
    }
}
