import java.io.*;

//Read and write the program default values.

public class ReadWriteBackupDomDefaults
{
  //This allows for the difference in the Windows/unix file paths
  private String FolderDelim = System.getProperty("file.separator");

  //The other vars. They have defaults in case of problems
  private String BackupPath = "c:\\games\\dominions\\game1\\", SaveToPath = "c:\\games\\dominions\\gameBACKUP\\",
         RestorePathFrom = ("c:\\games\\dominions\\gameBACKUP\\"), RestorePathTo = ("c:\\games\\dominions\\game1\\");

  private int BackupInterval = 120, NumberSaves = 50;

  private String Header = "#Program defaults. Order is:Backup Game Path, Backup SaveTo Path, Backup Interval, # Backup slots, Restore From Path, Restore To Path";

  //Constructor. Actually attempts the reads here - if it fails the defaults are used
  public ReadWriteBackupDomDefaults()
  {
    File DomIniFile = new File (System.getProperty("user.dir") + FolderDelim + "DomBackup.ini");  

    BufferedReader in = null;

    try
    {
      in = new BufferedReader(new FileReader(DomIniFile));

      Header = in.readLine();
      BackupPath = in.readLine();
      SaveToPath = in.readLine();
      BackupInterval = (int) ((Integer.parseInt(in.readLine())));
      NumberSaves = (int) ((Integer.parseInt(in.readLine())));
      RestorePathFrom = in.readLine();
      RestorePathTo = in.readLine();
    }
    catch (Throwable t) {}
    finally
    {
	  try { in.close(); } catch (IOException e) { ; }
    }

  }

  //Get the vars for loading the GUI
  public String ReadDomDefaultsBackupPath()
  {
    return BackupPath;
  }

  public String ReadDomDefaultsSaveToPath()
  {
    return SaveToPath;
  }

  public int ReadDomDefaultsBackupInterval()
  {
    return BackupInterval;
  }

  public int ReadDomDefaultsNumberSaves()
  {
    return NumberSaves;
  }

  public String ReadDomDefaultsRestorePathFrom()
  {
    return RestorePathFrom;
  }

  public String ReadDomDefaultsRestorePathTo()
  {
    return RestorePathTo;
  }

  //Write a new ini file with the values passed in.
  public void WriteDomDefaults(String NewBackupPath, String NewSaveToPath, int NewBackupInterval, int NewNumberSaves,
                         String NewRestorePathFrom, String NewRestorePathTo)
  {
    File DomIniFile = new File (System.getProperty("user.dir") + FolderDelim + "DomBackup.ini");  
    DomIniFile.delete();

    try
    {
      DomIniFile.createNewFile();
    }
    catch (Throwable t) {};

    PrintWriter out = null;
    try
    {
      out = new PrintWriter(new BufferedWriter(new FileWriter(DomIniFile)));
      out.write(Header + "\n");
      out.write(NewBackupPath + "\n");
      out.write(NewSaveToPath + "\n");
      out.write("" + NewBackupInterval + "\n");
      out.write("" + NewNumberSaves + "\n");
      out.write(NewRestorePathFrom + "\n");
      out.write(NewRestorePathTo + "\n");
    }
    catch (Throwable t)
    {
      System.err.println(t.getMessage());
    }
    finally
    {
      out.close();
    }
  }

}
