import java.io.*;
import java.util.*;
import javax.swing.JLabel;

//This class actually restores the files for the Dominions savegame file

public class RestoreDomTurn {

private String GamePath = "";
private String RestorePath = "";

//This is the GUI plugin. This allows ouptput to go to a label on a GUI somewhere.
private JLabel lblFeedback;
private boolean booLabelInit = false;

//This allows for the difference in the Windows/unix file paths
private String FolderDelim = System.getProperty("file.separator");

public void InitializeSavePath(String newGamePath, String newRestorePath)
{
//Initialize the mandatory data
  GamePath = newGamePath; 
  RestorePath = newRestorePath;

//Delete this for Unix builds
  if (!GamePath.endsWith(FolderDelim))
  {
    GamePath = GamePath + FolderDelim;
  }

  if (!RestorePath.endsWith(FolderDelim))
  {
    RestorePath= RestorePath + FolderDelim;
  }
//End Delete

}

public void InitializeFeedbackLabel(JLabel lblNewFeedback)
{
//Initialize the optional parameters. This is for GUI output
  lblFeedback = lblNewFeedback;
  booLabelInit = true;
}

public void main(String[] args)
{
  //This executes this program as a standalone command line interface
  BufferedReader in = new BufferedReader(new InputStreamReader(System.in));

  try
  {
    LocalPrintln("Enter gamepath to overwrite (this will be deleted):");
    GamePath = in.readLine();

    LocalPrintln("Enter backup gamepath to load from:");
    RestorePath = in.readLine();
  }
  catch (IOException e)
  {
    LocalErrorPrint(e.getMessage());
  }

  InitializeSavePath(GamePath,RestorePath);

  run();
}

public void run()
{
// This actually backs up the stuff. The path and optional feedback init must be done before this (or the previous values will be used)
  LocalPrintln("Start Restore");

  DomFileFilter ffDom1 = new DomFileFilter();

  File TestRestorePath = new File(RestorePath);

  if (!TestRestorePath.exists() || TestRestorePath.isFile())
  {
    LocalPrintln("Restore From Dir does not exist");
  }
  else
  {
    File TestGamePath = new File(GamePath);
    if (TestGamePath.isFile())
    {
      LocalPrintln("Restore To Dir is a file");
    }
    else
    {
      if (!TestGamePath.exists())
      {
        LocalPrintln("Making Restore To Dir");
        TestGamePath.mkdir();
      }

      File[] DomFileList= new File(RestorePath).listFiles(ffDom1);

      if (DomFileList.length < 1)
      {
          LocalPrintln("Restore From Dir not a Dom Savegame");
      }
      else
      {
        for (int intloop = 0; intloop <= (DomFileList.length -1); intloop++)
        {
          LocalPrintln("Restoring " + RestorePath  + DomFileList[intloop].getName()+ " to " + GamePath + DomFileList[intloop].getName() );

          try { FileCopier.copy(RestorePath  + DomFileList[intloop].getName(), GamePath  + DomFileList[intloop].getName()); }
            catch (IOException e) { System.err.println(e.getMessage()); }
        }

        LocalPrintln("Restored at " + (Calendar.getInstance().getTime().toString()));
      }
    }
  }
}

private void LocalPrintln(String strMessage)
{
//Writes to standard out and the lbl if set
  System.out.println(strMessage);
  
  if (booLabelInit)
  {
    lblFeedback.setText(strMessage);
  }
}

private void LocalErrorPrint(String strMessage)
{
//Writes to standard out and the lbl if set
  System.err.println(strMessage);
  
  if (booLabelInit)
  {
    lblFeedback.setText(strMessage);
  }
}

}
	  