import java.io.*;
import java.util.*;
import javax.swing.JLabel;

//This class takes a Dominions savegame and backs it up.

public class BackupDomTurn extends TimerTask
{
//The parameters for the backup
private String GamePath = "";
private String SavePath = "";
private int SavesToKeep = 10;
private long[] DomBackFileTimes = new long[1];

//This allows for the difference in the Windows/unix file paths
private String FolderDelim = System.getProperty("file.separator");

//This is the GUI plugin. This allows ouptput to go to a label on a GUI somewhere.
private JLabel lblFeedback;
private boolean booLabelInit = false;

public void InitializeSavePath(String newGamePath, String newSavePath, int newSavesToKeep)
{
//Initialize the mandatory paramaters
  GamePath = newGamePath; 
  SavePath = newSavePath;
  SavesToKeep = newSavesToKeep;

  if (!GamePath.endsWith(FolderDelim))
  {
    GamePath = GamePath + FolderDelim;
  }

  if (!SavePath.endsWith(FolderDelim))
  {
    SavePath= SavePath+ FolderDelim;
  }
}

public void InitializeFeedbackLabel(JLabel lblNewFeedback)
{
//Initialize the optional parameters. This is for GUI output
  lblFeedback = lblNewFeedback;
  booLabelInit = true;
}

public boolean cancel()
{
//Stop the execution
  return true;
}

public long scheduledExecutionTime()
{
//return the last execution time. obviously not implemented yet!
  return 0;
}
  
public void run()
{
// Actually backup save game list. It always backs up the first time, but each subsequent backup (with this object)
// only backup if the files change. The file change logic works but may be improvable (tricky since java doesn't have a filecopy command)

  //Check to see if we need to backup right now.
  DomFileFilter ffDom1 = new DomFileFilter();
  File[] DomFileList= new File(GamePath).listFiles(ffDom1);

  boolean SkipBackup = true;

  try
  {
    if (DomFileList.length == DomBackFileTimes.length)
    {
      for (int intloop = 0; intloop < (DomFileList.length); intloop++)
      {
        SkipBackup = (SkipBackup && (DomFileList[intloop].lastModified() == DomBackFileTimes[intloop]));
      }
    }
    else
    {
      SkipBackup = false;
    }
  }
  catch (Throwable t)
  {
    SkipBackup = false;
  }

  if (SkipBackup)
  {
  }
  else
  {
    // make sure the savegame path <> restore path
    if (SavePath.compareToIgnoreCase(GamePath) == 0)
    {
      LocalPrintln("Save Path = GamePath: Aborting!");
    }
    else
    {
    //insure that this is a Dominions save game directory
    if (DomFileList.length >= 1)
    {
      DomBackFileTimes = new long[(DomFileList.length)];

      LocalPrintln("Backup " + DomFileList.length + " files at " + (Calendar.getInstance().getTime().toString()));

      File DeleteOrRename = new File(SavePath + SavesToKeep + FolderDelim);
  
      //Delete the Last save if it exists
      if (DeleteOrRename.exists())
      {
	if (!EmptyDirectory(DeleteOrRename.getAbsolutePath() ))
	{
          LocalPrintln("Backup Failed: Save dir " + DeleteOrRename.getAbsolutePath() + " was not deleted");
          throw new Error("Directory " + DeleteOrRename.getAbsolutePath() + " was NOT deleted! - aborting!");
	}
      }

      //Move all the other saves down a slot
      for (int intloop = (SavesToKeep - 1); intloop >= 0; intloop--)
      {
        DeleteOrRename = new File(SavePath + intloop + FolderDelim);
    
        if (DeleteOrRename.exists())
        {
          File RenameTo = new File(SavePath + (intloop + 1) + FolderDelim);
          DeleteOrRename.renameTo(RenameTo);
        }
      }

      //Make the root directory for the new turn saves if needed
      DeleteOrRename = new File(SavePath);
      if (!DeleteOrRename.exists())
      {
        LocalPrintln("Creating Save Dir:" + SavePath);
        DeleteOrRename.mkdir();
      }
      else
      {
        LocalPrintln("Dir already exists:" + SavePath);
      }

      //Make the directory for the new turn
      DeleteOrRename = new File(SavePath + 0 + FolderDelim);
      
      //Delete the old one. This prevents .trn and 2h files from stagnating if you use the same folder to back up several games with different nations
      if (DeleteOrRename.exists())
      {
	if (!EmptyDirectory(DeleteOrRename.getAbsolutePath() ))
	{
          LocalPrintln("Backup Failed: Save dir " + DeleteOrRename.getAbsolutePath() + " was not deleted");
          throw new Error("Directory " + DeleteOrRename.getAbsolutePath() + " was NOT deleted! - aborting!");
	}
      }

      DeleteOrRename.mkdir();

      //Copy the current turn
      for (int intloop = 0; intloop <= (DomFileList.length -1); intloop++)
      {
         LocalPrintln("Copying " + GamePath + DomFileList[intloop].getName() + " to " + SavePath + DomFileList[intloop].getName());

        DomBackFileTimes[intloop] = DomFileList[intloop].lastModified();

        try { FileCopier.copy(GamePath + DomFileList[intloop].getName(),SavePath + 0 + FolderDelim + DomFileList[intloop].getName()); }
          catch (IOException e) { LocalErrorPrint(e.getMessage()); }
      }
    }
    else
    {
      LocalPrintln(SavePath + " does not contain Dominions savegames");
    }
    }
  }
}

private boolean EmptyDirectory(String strFolderPath)
{
//Empties a specific directory, so it can be deleted

  File DeleteOrRename = new File(strFolderPath);
  DomFileFilter ffDom1 = new DomFileFilter();

  File[] DomFileList= DeleteOrRename.listFiles(ffDom1);

  for (int intloop = 0; intloop < (DomFileList.length); intloop++)
  {
     LocalPrintln("Deleting File: " + DomFileList[intloop] );
     DomFileList[intloop].delete();
  }

  return DeleteOrRename.delete();
}

private void LocalPrintln(String strMessage)
{
//Writes to standard out and the lbl if set
  System.out.println(strMessage);
  
  if (booLabelInit)
  {
    lblFeedback.setText(strMessage);
  }
}

private void LocalErrorPrint(String strMessage)
{
//Writes to standard out and the lbl if set
  System.err.println(strMessage);
  
  if (booLabelInit)
  {
    lblFeedback.setText(strMessage);
  }
}
}

	  