//v 1.3
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

//This class saves the current screen values as the default for next time we run the program.

public class SaveDefaultsListener implements ActionListener {

  // This is where the options are retrieved from
  private JTextField txtGamePath,txtBackupPath, txtInterval, txtNumberSaves, txtRestorePathFrom, txtRestorePathTo;
  private JLabel lblFeedback;

  public void LinkGUI(JTextField txtNewGamePath,JTextField txtNewBackupPath,JTextField txtNewInterval,JTextField txtNewNumberSaves,
                      JTextField txtNewRestorePathFrom, JTextField txtNewRestorePathTo, JLabel lblNewFeedback)
  {
    txtGamePath = txtNewGamePath;
    txtBackupPath = txtNewBackupPath;
    txtInterval = txtNewInterval;
    txtNumberSaves = txtNewNumberSaves;
    txtRestorePathFrom = txtNewRestorePathFrom;
    txtRestorePathTo = txtNewRestorePathTo;
    lblFeedback = lblNewFeedback;
  }

  // Implementation of ActionListener interface.
  public void actionPerformed(ActionEvent event)
  {
    int NewInterval = 120, NewNumberSave = 50;

    // get the default save values - if they are not numerics, ignore them
    try
    {
      NewInterval  = (int) (Integer.parseInt(txtInterval.getText()));
    }
    catch (Throwable t) {};

    try
    {
      NewNumberSave = (int) (Integer.parseInt(txtNumberSaves.getText()));
    }
    catch (Throwable t) {};

    // Get the default values
    ReadWriteBackupDomDefaults rwbdd = new ReadWriteBackupDomDefaults();

    rwbdd.WriteDomDefaults(txtGamePath.getText(), txtBackupPath.getText(), NewInterval, NewNumberSave,
                         txtRestorePathFrom.getText(), txtRestorePathTo.getText());

    lblFeedback.setText("Defaults saved!");
  }
}
