### The SE4 Templatizer-PY
### Created by Ed Kolis (ekolis@cinci.rr.com)
### Creates SE4 data files from template files containing Python scripts inside
### of {} blocks (which must be contained on one line for now).
### Special Rules for converting input to output:
### {} blocks: executed as Perl scripts and replaced with their return value
###            (unless found at beginning of line, in which case executed only)
### Special Variables used within the {} blocks:
### minlevels: Array of minimum tech-grid levels
### maxlevels: Array of maximum tech-grid levels (must be same size as minlevels)
### levels: Array of current tech-grid levels
### minrange: Minimum firing range of a weapon
### maxrange: Maximum firing range of a weapon
### range: Current firing range of a weapon

import StringIO;
infilename = raw_input("Input filename: ");
infile = open(infilename, "r");
outfilename = raw_input("Output filename: ");
outfile = open(outfilename, "w");

# read and process input
foundbegin = 0;
inrecord = [];
alldone = 0;
normalmode = 0; # reading data
localmode = 1; # inside a {{ }} block, while defines local code
globalmode = 2; # inside a {{{ }}} block, which defines global code
headermode = -1; # before the *BEGIN* tag
mode = headermode;
localcode = "";
globalcode = "";
while not alldone:
	# read a record
	inrecord = "";
	recorddone = 0;
	# defaults
	minlevels = [1];
	maxlevels = [1];
	minrange = 1;
	minrange = 20;
	while not recorddone:
		# read a line and add it to the record
		inline = infile.readline();
		# if EOF, we're done soon
		if not inline:
			alldone = 1;
		if mode == normalmode:
			# normal mode: just processing data
			if inline[0:3] == "{{{":
				recorddone = 1;
				recordmode = normalmode;
				mode = globalmode;
			elif inline[0:2] == "{{":
				print "Entering Local mode ";
				recorddone = 1;
				recordmode = normalmode;
				mode = localmode;
			elif inline == "\n" or inline == "":
				recorddone = 1;
				recordmode = normalmode;
			else:
				inrecord = inrecord + inline;
		elif mode == localmode:
			# local mode: defining record-local code
			if inline[0:2] == "}}":
				mode = normalmode;
				recorddone = 1;
				recordmode = localmode;
			else:
				inrecord = inrecord + inline;
		elif mode == localmode:
			# global mode: defining file-global code
			if inline[0:3] == "}}}":
				mode = normalmode;
				recorddone = 1;
				recordmode = globalmode;
			else:
				inrecord = inrecord + inline;
		elif mode == headermode:
			# header mode: just scan for the *BEGIN* tag
			if inline[0:7] == "*BEGIN*":
				mode = normalmode;
				recorddone = 1;
				recordmode = headermode;
				outfile.write("*BEGIN*\r\n\r\n\r\n");
	# process the record
	if recordmode == normalmode:
		print "Read a normal record:\n";
		print inrecord;			
		# glom it all together and run it
		warning = "WARNING - no output records will be generated for this input record, as one of the maximum levels is less than its corresponding minimum level!\n";
		newline = "\r\n";
		eol = "\n";
		code = globalcode + localcode + """
# make sure something is generated
if (minlevels == []):
	minlevels = [1];
if (maxlevels == []):
	maxlevels = [1];
# pad the shorter of the level lists with 1's
while len(minlevels) < len(maxlevels):
	minlevels = minlevels + [1];
while len(minlevels) > len(maxlevels):
	maxlevels = maxlevels + [1];
print newline + "Templatizing over " + str(minlevels) + " to " + str(maxlevels) + newline;
# error checking - no infinite loops!
skip = 0;
for i in range(1, len(minlevels)):
	if maxlevels[i] < minlevels[i]:
		print warning; 
		skip = 1;
if not skip:
	levels = minlevels[:];
	recorddone = 0;
	# do templatizing
	while not recorddone:
		# create output
		inrecsio = StringIO.StringIO(inrecord);
		outrecsio = StringIO.StringIO();
		siodone = 0;
		while not siodone:
			inline = inrecsio.readline();
			if inline == "":
				siodone = 1;
			if inline[0:20] == "Weapon Damage At Rng":
				range = minrange;
				while (range <= maxrange):
					# scan for {} blocks and parse them
					i = 0;
					delimiter = 0;
					while i < len(inline):
						j = i;
						braces = 0;
						if inline[i] == "{":
							while j < len(inline) and inline[j] != "}":
								j = j + 1;
						if i > 1 and inline[i-2:i] == ":=":
							delimiter = 1;
						# only want to print the "Weapon Dmg At Rng := " once
						if j == i and ((delimiter or range == minrange) and not inline[j] == eol):
							outrecsio.write(inline[j]);
						elif j != i:
							outrecsio.write(max(int(eval(inline[i + 1: j])), 0));
						i = j + 1;
					range = range + 1;
				outrecsio.write(newline);
			else:
				# scan for {} blocks and parse them
				i = 0;
				while i < len(inline):
					j = i;
					braces = 0;
					if inline[i] == "{":
						while j < len(inline) and inline[j] != "}":
							j = j + 1;
					if j == i:
						outrecsio.write(inline[j]);
					else:
						outrecsio.write(eval(inline[i + 1: j]));
					i = j + 1;
		outrecord = outrecsio.getvalue();
		# print output to file
		outfile.write(outrecord);
		if (len(outrecord) > 2):
			outfile.write(newline + newline);
		# increment levels
		i = len(levels) - 1;
		levels[i] = levels[i] + 1;
		while levels[i] > maxlevels[i]:
			j = i;
			while j < len(levels):
				levels[j] = minlevels[j];
				j = j + 1;
			i = i - 1;
			if i < 0:
				recorddone = 1;
				break;
			levels[i] = levels[i] + 1;""";
		exec(compile(code, "templatizer.py combined with " + infilename, "exec"));
		# clear local code
		localcode = "";
	elif recordmode == localmode:
		print "Read a local code record.\nThis will be applied to the next normal record after any global code:\n";
		print inrecord;
		localcode = localcode + inrecord;
	elif recordmode == globalmode:
		print "Read a global record.\nThis will be applied to all subsequent records before any code local to those records:\n";
		print inrecord;
		globalcode = globalcode + inrecord;
	elif recordmode == headermode:
		print "Read the header tag, ready to start!\n";
if mode == headermode:
	print "Did you forget the *BEGIN* tag?\n";
infile.close();
outfile.close();
