#!/usr/bin/python

"""

	Description. This script is helpful for PBEM hosting of Dominions II computer game.
	It has methods for sending and receiving turns to/from players and for broadcasing messages.
	It uses a configuration file .domII_PBEM_conf

	Author. Yosi Izaq (aka WraithLord), izaqyos@gmail.com 

	Permission to use.
	I would like for this utility to be used freely, modified, incorporated and distributed freely, for that I want to be identical in terms of usage to GPL. 
	I would also like that if used in such way that my (somewhat hard ;) ) work on this be acknowledged.

	I will continue to support this utility. I will add a GUI to it and will transition it to dom-III.
	For any issues or wishes please contact me, either at Shranel forums or at izaqyos@gmail.com.

	Thanks!

	My thanks for being able to put this thing together goes to:
		1. The libgmail guys for this awesome lib, http://libgmail.sourceforge.net/
		2. ASPN cookbooks for their fine recipes, http://aspn.activestate.com/ASPN/Cookbook/Python
		3. Python community for great documentation and support.

	Usage.
	Run the script and follow the CLI instructions.

	Hints at key functionality:
	This file can also be used as a lib. (imported) example:

	>>> import domII_PBEM_utils
	>>> Mgr = domII_PBEM_utils.DomIIPbemMgr()
	game:  RAND
	>>> Mgr.get_turns()

	To verify the turns are ok. execute from dom2 install path: 
	OR use the verify() method:
	>>> Mgr.verify_turn()

	To backup the game's turn do:
	>>> Mgr.backup_turn()

	To backup a specific game turn do:	
	>>> backup_turn('COA')

	Hosting procedure:

	0. Get the turns:
	>>>Mgr.get_turns()

	1. To verify turns and then host do:
	>>> Mgr.host()
	
	2. Then to send the turns:
	>>> Mgr.send_turn('/cygdrive/c/Program Files/dominions2/COA/pythium.trn', 'izaqyos@gmail.com','test', '\r\nEnjoy\r\nWraithLord')
	>>> Mgr.send_turns(1, 'message')
	>>>Mgr.send_turns('\r\nMay you find this game enjoyable and best of luck!!!\r\nWraithLord')
	>>>Mgr.send_turns('\r\nNext hosting will be at blabla\r\nWraithLord')

	3. To send status updates to players:
	>>> Mgr.broadcast('subject', 'message')
	>>> Mgr.broadcast('COA next hosting', '\r\nHi\r\nNext hosting will be on Friday 10:30 PM GMT+2.\r\nWraith\r\n') 
	>>> Mgr.broadcast('COA Status', '\r\nHi\r\nI am missing turns from Ctis and Ermor.\r\n Next hosting will be on Friday 10:30 PM GMT+2.\r\n\r\nWraith\r\n')
broadcasting. subject:  COA next hosting message:  
Hi
Next hosting will be on Friday 10:30 PM GMT+2.
Wraith

"""
#import re
#import os
#import sys
#import glob
import shutil, tarfile,ConfigParser, os, re, sys, glob
#import pickle
import libgmail
from libgmail import *

#ToDo, look up in the internet for python log printer lib
# until then use the if (dbg_lvl) for prints
# debug levels are from 0 - no debug to 10 - maximum debug.
# Use pyexe.py to compile an exe for windows (more conveneint 
dbg_lvl = 5

class DomGameCfg:
	def __init__(self):
		if dbg_lvl == 10:
			print "initing class DomGameCfg..."
		name = ' '
		players = {}
		sent_turns_msg = ' '

	name = ' '
	players = dict()
	sent_turns_msg = ' '

class DomIIPbemMgr:
	"Class for managing dom II PBEM games with options for sending receiving and backuping of turn files"
	dom_path = ' ' 
	#config_file = '/cygdrive/d/work/scripts/games/.domII_PBEM_conf'
	config_file = os.path.join(os.getcwd(), '.domII_PBEM_conf')
	games = dict() #list of DomGameCfg instances.
	ga = GmailAccount
	config = ConfigParser.ConfigParser()
	host_email = ' '
	host_pwd = ' '
	sig_msg = ' '
	active_game = ' '
	temp_turns_path = ' '
	backup_path = ' '
	initial_path = ' '

	def __init__(self):
		print "initing class..."
		self.initial_path = os.getcwd()
		self.loadConf()
		self.connect()

	#Todo, continue with manage game. finish the menu print and check that all the options work.
	# then test on windows and release.!
	def mngGame(self):
		print "Manage Active game, [",self.active_game,"]."

		switchMngAction = {
				"1": self.get_turns,
				"2": self.send_turns,
				"3": self.broadcast_msg,
				"4": self.status_notification,
				"5": self.verify_turn,
				"6": self.backup_turn,
				"7": self.reload_turn,
				"8": self.host,
				}

		mngGameMenu = """
				Please choose an option from [1-8]. Press any other key to return to main menu.
				1. Retreive game turns.			[into temporary turns path]
				2. Send new turns to players.		[Distribute new turns]
				3. Broadcast a message.			[Send a message to all players in active game]
				4. Send status notification.		[send a notification of which turns are missing to players]
				5. Verify that all turns are valid.	[print a list of all missing or invalid turns]
				6. Backup current turns.		[create a backup of the turn files]
				7. Reload turns from archive.		[create a backup of the turn files]
				8. Host game.				[verify that all turns are valid, backup and then host the game]
				q. Return to main menu.

				"""


		opt = raw_input(mngGameMenu)
		while opt != 'q':
			switchMngAction.get(opt, help)()
			opt = raw_input(mngGameMenu)


		#ToDo.
		# Add a method to save game, and cfg value for saved game path, instead of using the perl 
		# script!
		# Try to make an exe of the script and release it.
		# Add in set configuration the capability to set the active game dynamically


	def setConf(self):
		print "Set configuration values for current session."

		def inp_active_game():
			game = raw_input("Please choose active game from: "+str(self.games.keys()) + ' ')
			self.set_active_game(game)

		def inp_backup_path():
			path = raw_input("Please enter desired backup path: ")
			self.set_backup_path(path)

		def inp_sig_msg():
			sig = raw_input("Please enter desired signature message: ")
			self.set_sig_msg(sig)

		switchSetConf = {
				"1": inp_active_game,
				"2": inp_backup_path,
				"3": inp_sig_msg,
				}

		setConfMenu = """
				Please choose an option from [1-3]. Press any other key to return to main menu.
				1. Set active game.			[Select current game to manage]
				2. Set backup path.			[Select directory for turn archive]
				3. Set signature.			[Enter signature for use in all outgoing messages]
				q. Return to main menu.
				"""


		opt = raw_input(setConfMenu)
		while opt != 'q':
			switchSetConf.get(opt, help)()
			opt = raw_input(setConfMenu)

	def viewConf(self):
			#print config
		confPrint = "DomIIPbemMgr Configuration:\n\
		Dominions II installation path: "+ self.dom_path+ "\n\
		Configured games: "+ str(self.games.keys())+ "\n\
		Host email: "+ self.host_email+ "\n\
		Message Signature: "+ self.sig_msg+ "\n\
		Turns backup directory path: "+ os.path.join(self.backup_path,self.active_game)+"\n\
		Temporary turns directory path: "+os.path.join(self.temp_turns_path,self.active_game)+"\n\
		Active Game: "+ self.active_game+ "\n\
		Sent turns message for active game: "+ self.games[self.active_game].sent_turns_msg+"\n\
		Active Game players: "+ str(self.games[self.active_game].players)+ "\n"

		print confPrint
		
	def loadConf(self):
		print "Loading class configuration"

		switchCfgItem = {
				"dom_path": self.set_dom_path,
				"host_pwd": self.set_host_pwd,
				"active_game": self.set_active_game,
				"host_email": self.set_host_email,
				"sig_msg": self.set_sig_msg,
				"temp_turns_path": self.set_temp_turns_path,
				"backup_path": self.set_backup_path,
				}

		self.config.readfp(open(self.config_file))
		for section in self.config.sections():
			if dbg_lvl > 5:
				print "section found: ", section
				print "section items: ", self.config.items(section)
			
		# PARSE the GENERAL section
		general_item = self.config.items('GENERAL')
		for item, val in general_item:
			if dbg_lvl == 10:
				print "item in general: ",item, " value: ", val
			switchCfgItem.get(item)(val.strip())

		# PARSE the GAMES section
		general_item = self.config.items('GAMES')
		for item, val in general_item:
			if dbg_lvl == 10:
				print "item in games: ",item, " value: ", val
		games_list = val.split(',')
		if dbg_lvl > 5:
			print "loaded game name list: ", games_list 

		# Parse games configuration and load it to class.
		for game_name in games_list:
			game_item = self.config.items(game_name.strip())
			game = DomGameCfg()
			game.name = game_name.strip()

			for item, val in game_item:
				if dbg_lvl == 10:
					print "item in game: ",game_name," are: ",item, " value: ", val

				if (item == 'players'):
					temp_player_list = {}
					if dbg_lvl > 5:
						print "game ", game.name,", loading players list, ", val
					for player in val.split(","):
						temp_player_list[player[(player.index(':')+1):]] = player[:player.index(':')]
						if dbg_lvl == 10:
							print "adding nation: ",[player[(player.index(':')+1):]],", email: ",player[:player.index(':')], "to game: ",game.name, "current player list: ", game.players
					game.players = temp_player_list

				if (item == 'sent_turns_msg'):
					if dbg_lvl > 5:
						print "game ", game.name,", sent turns message, ", val
					game.sent_turns_msg = val

					self.games[game.name] = game


#"""
#			 ToDo, finish loading the games.
#			 Change path of cfg file to relative
#			 Check that basic functionality works, like hosting, getting and sending turns etc
#			 for that add manage games option to main menu and build a sub menu.

#			 Then, add menu for managing configuration.

#			 Last, use Tkinter for add GUI to the script.

#			 Oh, and make sure the script works both for windows and cygwin.
#			 AND, look at the libgmail implemeantation to use the password reading util.
#			 Also make sure password isn't displayed anywhere in prints.
#"""

	def set_temp_turns_path(self, in_temp_turns_path):
		if dbg_lvl == 10:
			print "setting value of temporary turns path to: ", in_temp_turns_path
		self.temp_turns_path = in_temp_turns_path

	def set_backup_path(self, in_backup_path):
		if dbg_lvl == 10:
			print "setting value of backup turns path to: ", in_backup_path
		self.backup_path = in_backup_path

	def set_dom_path(self, in_dom_path):
		if dbg_lvl == 10:
			print "setting value of dominions path to: ", in_dom_path
		self.dom_path = in_dom_path

	def set_active_game(self, in_active_game):
		if dbg_lvl == 10:
			print "setting value of active game to: [", in_active_game.strip(),"]"
		self.active_game = in_active_game.strip()

	def set_games(self, in_games):
		if dbg_lvl == 10:
			print "setting value of game list to: ", in_games
		self.games = in_games

	def set_host_email(self, in_host_email):
		if dbg_lvl == 10:
			print "setting value of host email to: ", in_host_email
		self.host_email = in_host_email

	def set_host_pwd(self, in_host_pwd):
		if dbg_lvl == 10:
			print "setting value of host password" 
		self.host_pwd = in_host_pwd

	def set_sig_msg(self, in_sig_msg):
		if dbg_lvl == 10:
			print "setting value of signature to: ", in_sig_msg
		self.sig_msg = in_sig_msg


	def connect(self):
		self.ga = GmailAccount(self.host_email,self.host_pwd)
                self.ga.login()
	
	def get_turns(self):
		print "Retreiving turn files from gmail."

		pattern ='.*'+self.active_game+'.*'
		if dbg_lvl == 10:
			print "dling subjects: ", pattern
		p = re.compile(pattern)
			
        	folder = self.ga.getMessagesByFolder('inbox')

        	for thread in folder:
                	s = thread.subject
	                m = p.match(thread.subject)
			if dbg_lvl == 10:
				print "Current subject: ",s, " pattern match: ",m
	                if m:
	                        print thread.id, len(thread), s
	                        for msg in thread:
					if dbg_lvl == 10:
						print "Message attachments: ", msg.attachments
	                                for att in msg.attachments:
	                                        print "attached ", att.filename
						if att.filename.endswith(".2h"):
							#Uncomment to save files to a temporary dir instead of directly to the game dir:
							#temp_dir = os.path.join(self.temp_turns_path,self.active_game)
							temp_dir = os.path.join(self.dom_path,self.active_game)
							print "Found turn file for host: ",att.filename, " \nDownloading turn file to: ", temp_dir
							if not os.path.exists(temp_dir):
							    os.makedirs(temp_dir)

							file_dir = os.path.join(temp_dir,att.filename)
	                                        	f=open(file_dir, 'w')
	                                        	f.write(att._getContent())
	                                        	f.close()
	
	def send_turn(self, game, to, subj, body = 'Enjoy'):
		filenames = [game]
		msg = GmailComposedMessage(to, subj, body , filenames=filenames )
		self.ga.sendMessage(msg)
	
	def send_turns(self,  msg = '\r\nEnjoy!\r\nWraithLord'):
		ret = self.verify_turn()
		turn_number = ret.pop(0)
		body = self.games[self.active_game].sent_turns_msg+'\r\n'+self.sig_msg
		print "Sending turn files "+turn_number+' message: '+body 
		if dbg_lvl == 10:
			print "Player list, ", self.games[self.active_game].players

		for nation, to in self.games[self.active_game].players.iteritems():
			print "Sending turn to ", to, ' nation ', nation
			turn_path = os.path.join(self.dom_path,self.active_game,nation+'.trn')
			if dbg_lvl == 10:
				print 'turn path: ', turn_path
			self.send_turn(turn_path, to, 'New '+self.active_game+' turn, number '+turn_number+', for '+nation, body)
		
	def get_user_message(self):
		message_prompt = ">>>"
		#get message from admin
		print "You will be asked to enter message, to end message input, please press ctrl+E then ENTER."
		message = ' '
		line = raw_input(message_prompt)
		message = message+line+"\n"
		while (len(line) == 0) or ((len(line) > 0) and ord(line[0]) != 5): #ctrl+E is the termination signal
			line = raw_input(message_prompt)
			if (len(line) == 0) or ((len(line) > 0) and ord(line[0]) != 5):
				message = message+line+"\n"

		return message


	def broadcast_msg(self):
		subj_prompt = "Please enter message subject:"
		#get subject from admin
		subject = raw_input(subj_prompt)

		body = self.get_user_message()

		#broadcast
		body = body + "\n"+ self.sig_msg
		self.broadcast(subject, body)

	def broadcast(self, subject, msg):
		if dbg_lvl == 10:
			print "broadcasting. subject: ", subject, "message: \n",msg
#		print "Players emails are taken from list: ", self.players
		to = '';
		for email in self.games[self.active_game].players.values():
			to = email+';'+to

		if dbg_lvl == 10:
			print "address list: ", to

		print "Broadcasting subject: ", subject, " Message: \n",msg," \nTo: ", self.games[self.active_game].players.values()
		msg = GmailComposedMessage(to, subject, msg) 
                self.ga.sendMessage(msg)

	def status_notification(self, subject_postfix="status"):
		print "Notifying players for missing turns."

		(turn, missing) = self.verify_turn()

		print "Please enter notification message (hint, include next hosting time)."
		message = self.get_user_message()

		subject_postfix = self.active_game+' '+subject_postfix+' Notification'

		if len(missing) ==0 :
			missing_report = "There were no stales this turn. :)"
		else:
			missing_report = "Missing turns from following nations: "

		first_iter = 1
		for nation in missing:
			if first_iter==1:
				missing_report +=nation
				first_iter = 0
			else:
				missing_report +=', '+nation

		missing_report+='.\r\n\r\n'

		body = message+missing_report+self.sig_msg

		self.broadcast(subject_postfix, body)
		
	def backup_turn(self):

		print "Commencing turns backup..."

		print "Determine turn # and missing or invalid turns..."
		turn, missing_set = self.verify_turn()

		if dbg_lvl == 10:
			print "Current turn is: ", turn, "missing or invalid turns: ", missing_set

		backup_dir = os.path.join(self.backup_path, self.active_game, turn)
		if dbg_lvl == 10:
			print "Backup dir: ", backup_dir

		if not os.path.exists(backup_dir):
		    os.makedirs(backup_dir)

		print "Creating bzw tarball of turns in: ", backup_dir

		destination = os.path.join(backup_dir, self.active_game+'_'+turn+'.tar.bz2')
		foldertobackup = os.path.join(self.dom_path, self.active_game)

		out = tarfile.TarFile.open(destination, 'w:bz2')
		out.add(foldertobackup, arcname=os.path.basename(foldertobackup))
		out.close()

	def reload_turn(self):

		print "Reloading dominions turn from backup archive..."

		turn = raw_input("Please enter turn # to reload. ")

		print "Reloading turn: ", turn

		backup_dir = os.path.join(self.backup_path, self.active_game, turn)
		if dbg_lvl == 10:
			print "Backup dir: ", backup_dir, "Destination dir: ", dest

		#if not os.path.exists(dest):
		#    os.makedirs(dest)

		foldertobackup = os.path.join(backup_dir, self.active_game+'_'+turn+'.tar.bz2')

		tar = tarfile.open(foldertobackup, "r:bz2")

		##ToDo, copy the tarfile to the dest file, extract using the code below and delete.
		#if dbg_lvl == 10:
		#	print "Copying archive, ", foldertobackup, " to ", dest
		#shutil.copy(foldertobackup, dest)


		try:
			print "Extracting bzw tarball ", foldertobackup, "to ", self.dom_path
			tar = tarfile.open(foldertobackup, 'r:bz2')
			for item in tar:
				print item.name, "is", item.size, "bytes in size and is",
				if item.isreg():
					print "a regular file."
				elif item.isdir():
					print "a directory."
				else:
					print "something else."

				try:
					tar.extract(item,self.dom_path )
					print 'Extracting, ', item
				except tarfile.ReadError, re:
					print "Exception, can't read archive or invalid archive.", re
				except tarfile.ExtractError, ee:
					print "Exception, can't extreact archive.", ee
		except:
			name = os.path.basename(sys.argv[0])
			print name[:name.rfind('.')], '<filename>'


		#if dbg_lvl == 1:
		#	print "Deleting archive copy, ",os.path.join(dest, self.active_game+'_'+turn+'.tar.bz2') 
		#try:
		#	os.chmod (os.path.join(dest, self.active_game+'_'+turn+'.tar.bz2'), 0666)
		#	os.remove(os.path.join(dest, self.active_game+'_'+turn+'.tar.bz2'))
		#except os.error, e:
		#	print "Error deleting file, ",e
		#	print "Please remove the file manually. File: ",os.path.join(dest, self.active_game+'_'+turn+'.tar.bz2')

		#for tarinfo in tar:
		#    print tarinfo.name, "is", tarinfo.size, "bytes in size and is",

		#	try:
		#		if not os.path.exists(os.path.join(dest, tarinfo)):
		#		print 'Copying %s to %s...' % (os.path.join(backup_dir,, backup)
                #        shutil.copy(filepath, backup)
                #except (OSError, IOError), e:
                #    pass

		#    if tarinfo.isreg():
		#	print "a regular file."
		#    elif tarinfo.isdir():
		#	print "a directory."
		#    else:
		#	print "something else."
		#tar.close()

				
	def verify_turn(self):
		"""
		Method that uses Illwinters --verify switch.
		1. get turn# from ftherlnd.chk file.
		2. Compile a list of nations that don't have the current turn or are not in OK status.
		3. Print that list and return two things, the turn number and the list of nations with missing turns.
		"""

		print "Validating turns..."
		
		dom_cmd= os.path.join(self.dom_path, 'dom2.exe')
		if dbg_lvl == 10:
			print "cmd dir is: ", dom_cmd

		os.chdir(self.dom_path)

		cmd1 = 'dom2.exe'+' '+self.active_game+' --verify'
		#cmd1 = cmd1.replace(' ', '\ ')
		if dbg_lvl == 10:
			print "executing command: ", cmd1, " from dir: ", os.getcwd()
		os.system(cmd1)
		
		#get current turn
		fthr_path = os.path.join(self.dom_path, self.active_game,'ftherlnd.chk')
		if dbg_lvl == 10:
			print "fatherland file path: ", fthr_path

		fthr_file = open(fthr_path, "rb")
		pat1 = '\sturnnbr\s(\d+)'
#		p1 = re.compile(pat1)
		for line in fthr_file:
#			print line
			m = re.search(pat1, line)
			if (m):
			    turn = m.group(1)
#		print "turn: ",turn
		fthr_file.close()

		#Check for invalid turns or missing turns.
		nations_missing_turns = []
		os.chdir(os.path.join(self.dom_path,self.active_game))
		chk_files = glob.glob('*.chk');
#		print "verifying turn files: ",chk_files
#		print "removing file: ",'ftherlnd.chk'
		chk_files.remove('ftherlnd.chk')
		for file in chk_files:
			nation = file.split('.').pop(0)
#			print "checking nation: ",nation
			chk_file = open(file, "rb")
			first_line = 1
			missing = 0
			for line in chk_file:
#				print line
# check that turn is valid
				if ((first_line == 1) and (not (line.startswith('2h file is OK!')))):
#					print "Problem with turn file ", file, " of nation ",nation
					#Turn file is not valid
					missing = 1
				first_line = 0

# check that turn is current				
				m = re.search(pat1, line)
				if (m):
					nation_turn = m.group(1)
#					print "turn is ", turn," nation turn is ",nation_turn, " nation, ", nation
					if nation_turn != turn:
						missing = 1
				
				if missing:
				# so we know this nation is missing a turn 
				# but is it at all active??? only if not shall it
				# be reported as missing
					if (self.games[self.active_game].players.has_key(nation)): 
						nations_missing_turns.append(nation)
					missing = 0
						
			chk_file.close()

		#remove chk files
		chk_files = glob.glob('*.chk');
		for file in chk_files:
			os.remove(file)
			
		nations_missing_turns_set = set(nations_missing_turns)
		print "turn is ",turn, "nations missing turns: ", nations_missing_turns_set
		ret = [turn, nations_missing_turns_set]
		return ret

	def host(self):
		""" 
		Verify turns. Confirm then backup and host.	
		"""
		
		self.verify_turn()
		ans = raw_input("Are you sure you wish to host?[yes, no]")
		dom_path = ' '
		if ans in ('y', 'ye', 'yes'):
			self.backup_turn()

			dom_cmd= os.path.join(self.dom_path, 'dom2.exe')
			if dbg_lvl == 10:
				print "cmd dir is: ", dom_cmd

			os.chdir(self.dom_path)

			cmd1 = 'dom2.exe'+' '+self.active_game+' --host'
			if dbg_lvl == 10:
				print "executing command: ", cmd1, " from dir: ", os.getcwd()
			os.system(cmd1)

		else:
			print "Hosting cancelled."

		def host_and_send_turns():
			#ToDoFirst host and then send the turns.
			print "Hosting turn and then dispatching new turns to players"
"""
Iterate over the dictionary and send the turns to the players.
Consider adding the domII install path to the configuration.
"""	

## Below is an old version of code. Should be functional but is obsolete:
#def backup_turn(gameName, turn_no):

#	"""
#	gameName, string containing the game name, say 'RAND'
#	turn_no, string with the turn number, say '1'
#	"""
#	cmd = './save_dom.pl s '+gameName
#	if dbg_lvl == 10:
#		print "executing ", cmd
#	os.system(cmd)

#def get_turns_from_gmail(subj):
#        pattern ='.*'+subj+'*'
#        p = re.compile(pattern)

#        ga = GmailAccount("izaqyos@gmail.com", "<put password here>")
#        ga.login()
#        folder = ga.getMessagesByFolder('inbox')

#        for thread in folder:
#                s = thread.subject
#                m = p.match(thread.subject)
#                if m:
#                        print thread.id, len(thread), s
#                        for msg in thread:
##                               print msg.attachments
#                                for att in msg.attachments:
#                                        print "attached ", att.filename
#                                        f=open('/cygdrive/d/temp/'+att.filename, 'w')
#                                        f.write(att._getContent())
##                                       pickle.dump(att,f)
#                                        f.close()

def help():
        usage = """
		Description.	
		This script is very helpful for PBEM hosting of Dominions II computer game.
		It has methods for sending and receiving turns to/from players and for broadcasing messages.
		It uses a configuration file.
		It relys upon: domII_PBEM_conf which is a perl script for backuping turns and most importantly libgmail, which is a great lib for using gmail.

		Author. 
		Yosi Izaq (aka WraithLord)"

		Usage.
		Run the script and follow the CLI instructions.
		Please report errors and request to izaqyos@gmail.com
		This script is free for usage, modification and distribution, so long as my (hard) work is acknowledged ;)
		"""
	print usage


def ineractive_mode():
	print "Dom II PBEM Manager Interactive mode."
	import sys
#	print sys.argv

	# no args
	if (len(sys.argv) == 1):
#		help()
#		sys.exit()

	#sys.argv.pop(0)

	#arg = sys.argv.pop(0)
	#print arg
	#if (arg == '-i'):
		mgr = DomIIPbemMgr()
	
		switchAction = {
				"1": mgr.viewConf,
				"2": mgr.setConf,
				"3": mgr.mngGame,
				"h": help,
				"q": sys.exit
				}

		while (1):
			print "Please choose an option."
			menu_msg = """
				1. View Configuration.			[View current configuration values]
				2. Set Configuration.			[TBD]
				3. Manage game.				[open a sub menu for managing active game]
				h. Help, About.
				q. quit Dom-II PBEM manager.

				"""

			def my_quit(): sys.exit(0)

			opt = raw_input(menu_msg)
			switchAction.get(opt, help)()


# Main:
ineractive_mode()
