#!/usr/bin/python

################################################################################
# Resource Cost Scaling Factor
# by Nolan Kelly, 2006
#
# This script doubles all cost values in Components.txt. It creates a file
# "ComponentsOutFile.txt" containing the doubled values.
################################################################################


################################################################################
# Globals
################################################################################

# The factor by which you are scaling costs.
scale_factor = 2

################################################################################
# don't muck about below this line!
################################################################################

import string
import re
import sys
import os

# Scales existing Circle Radius X, Y
def cost_re (match):
  res_type = str(match.group(1))
  ws = str(match.group(2))
  cost = int(match.group(3))
  return 'Cost ' + res_type + ws + ':= ' + str(int(cost * scale_factor))

################################################################################
# Handle Components File
compfile = open('./Components.txt', 'r')
outfile = open('./ComponentsOutFile.txt', 'w')

# Get the first line in the file, in case it is empty.
line = compfile.readline()

cost_match = re.compile('Cost ([a-zA-Z]+)(\s+):= (\d{1,4})')

# Skip the file header.
while line.strip() != "*BEGIN*":
  outfile.write(line)
  
  # Get the next line.
  line = compfile.readline()

# Parse through the file, doubling all cost values.
while line != "":
  line = cost_match.sub( cost_re, line, count=1)

  outfile.write(line)

  # Get the next line.
  line = compfile.readline()

compfile.close()
outfile.close()
# End Components File
################################################################################
