;; Major mode for editing Dominions III map files

(require 'cl)
(defvar dommap-mode-hook nil)

(defvar dommap-mode-version "3.0"
  "The latest version of Dominions this mode was written to support." )

;; Use dommap-mode for files ending with .map
(add-to-list 'auto-mode-alist '("\\.map\\'" . dommap-mode))


;; Sets up the categories of keywords
(defvar dommap-mode-world-keywords '( "#title" "#dom2title"
"#imagefile" "#scenario" "#description" "#features" "#nonamefilter" )
  "Keywords that affect the whole world")

(defvar dommap-mode-topography-keywords '( "#neighbour" "#noneighbour"
"#landname" "#terrain" )
  "Keywords that deals with the physical topography of the map property")

(defvar dommap-mode-political-keywords '( "#nostart" "#landplayers"
"#seaplayers" "#start" "#orderedstart" "#specstart" "#nohomelandnames"
"#cannotwin" "#computerplayer" "#victorycondition" "#victorypoints"
"#god" "#specdom" "#compspecdom" "#scale_chaos" "#scale_lazy"
"#scale_cold" "#scale_death" "#scale_unluck" "#scale_unmagic"
"#dominionstr" "#allies" "#startspell" "#owner" )
   "Keywords that affects the nations and political layout")

(defvar dommap-mode-start-region-keywords '( "#land" "#setland" )
   "Keywords that changes the active region")

(defvar dommap-mode-region-keywords '( "#killfeatures" "#feature"
"#knownfeature" "#fort" "#temple" "#lab" "#owner" "#unrest"
"#population" "#poptype" "#defence" "#landname" "#terrain" )
   "Keywords that affect a single region")

(defvar dommap-mode-start-commander-keywords '( "#commander" )
  "Keywords that changes the active commander" )

(defvar dommap-mode-commander-keywords '( "#comname" "#bodyguards"
"#units" "#clearmagic" "#xp" "#mag_priest" "#mag_unpriest" "#mag_air"
"#mag_astral" "#mag_blood" "#mag_death" "#mag_earth" "#mag_fire"
"#mag_nature" "#mag_water" "#randomequip" "#additem" )
  "Keywords that affect the active commander" )

;; Syntax highlighting
(defvar dommap-mode-font-lock-keywords
  (eval-when-compile
	(list 
	 (list (concat "^" (regexp-opt (delete-duplicates 
					       (append dommap-mode-world-keywords 
						       dommap-mode-topography-keywords nil)) t)  "\\>") 
	       '(1 font-lock-builtin-face))
	 (list (concat "^" (regexp-opt (delete-duplicates 
					       (append dommap-mode-political-keywords nil)) t)  "\\>") 
	       '(1 font-lock-constant-face))
	 (list (concat "^" (regexp-opt (delete-duplicates 
					       (append dommap-mode-region-keywords
						       dommap-mode-commander-keywords
						       nil)) t)  "\\>") 
	       '(1 font-lock-function-name-face))
	 (list (concat "^" (regexp-opt (delete-duplicates 
					       (append dommap-mode-start-region-keywords
						       dommap-mode-start-commander-keywords nil)) t)  "\\>")
	       '(1 font-lock-keyword-face))
	 )))
  
;; Syntax-map. "--" starts a line comment,
(defvar dommap-mode-syntax-table nil
  "Syntax table used while in dommap mode.")
(setq dommap-mode-syntax-table (make-syntax-table))
(modify-syntax-entry ?- ". 12b" dommap-mode-syntax-table)
(modify-syntax-entry ?\n "> b" dommap-mode-syntax-table)
(modify-syntax-entry ?# "_" dommap-mode-syntax-table)
(set-syntax-table dommap-mode-syntax-table)

;; Functions for movement between elements
(defvar dommap-mode-region-start-regexp
  (regexp-opt dommap-mode-start-region-keywords t))

(defun dommap-forward-region ( )
  "Moves forward to the start of the next region-specific block"
  (interactive)
  (end-of-line)
  (re-search-forward dommap-mode-region-start-regexp nil t))

(defun dommap-backward-region ( )
  "Moves backward to the start of the previous region-specific block"
  (interactive)
  (beginning-of-line)
  (re-search-backward dommap-mode-region-start-regexp nil t))

;; Functions for movement between bookmarks
(defvar dommap-mode-bookmark-regexp "^-- ==>")

(defun dommap-forward-bookmark ( )
  "Moves forward to the next bookmark"
  (interactive)
  (end-of-line)
  (re-search-forward dommap-mode-bookmark-regexp nil t))

(defun dommap-backward-bookmark ( )
  "Moves backward to previous bookmark"
  (interactive)
  (beginning-of-line)
  (re-search-backward dommap-mode-bookmark-regexp nil t))

;; Sets up the keymap
(defvar dommap-mode-map (make-sparse-keymap)
  "Local keymap used for Dommap Mode" )
(define-key dommap-mode-map "\C-c\C-c" 'comment-region)
(define-key dommap-mode-map "\C-c\C-f" 'dommap-forward-region)
(define-key dommap-mode-map "\C-c\C-b" 'dommap-backward-region)
(define-key dommap-mode-map "\C-c\C-d" 'dommap-forward-section)
(define-key dommap-mode-map "\C-c\C-u" 'dommap-backward-section)

;; Define the mode
(define-derived-mode dommap-mode fundamental-mode "dommap"
  "Major mode for editing Dominions III map files.
Special commands:
\\{dommap-mode-map}"
  (make-local-variable 'font-lock-defaults)
  (setq font-lock-defaults '(dommap-mode-font-lock-keywords))
  (use-local-map dommap-mode-map)
  (make-local-variable 'comment-start)
  (set 'comment-start "-- ")
  )
(provide 'dommap-mode)
