;; Major mode for editing Dominions III mod files

(require 'cl)
(defvar dommod-mode-hook nil)

(defvar dommod-mode-version "3.0"
  "The latest version of Dominions this mode was written to support." )

;; Use dommod-mode for files ending with .dm
(add-to-list 'auto-mode-alist '("\\.dm\\'" . dommod-mode))

;; Define the categories of keywords
(defvar dommod-mode-element-start-keywords '( "#selectweapon"
"#newweapon" "#selectarmor" "#newarmor" "#selectmonster" "#newmonster"
"#selectitem" "#selectnametype" "#selectsite" "#newsite" "#selectnation" )
  "Keywords that starts a element")


(defvar dommod-mode-general-keywords '( "#modname" "#description" 
"#icon" "#defaultguiframe" "#version" "#domversion" "#poppergold"
"#resourcemult" "#supplymult" "#unresthalfinc" "#unresthalfres" 
"#eventisrare" "#turmoilincome" "#turmoilevents" "#deathincome"
"#deatsupply " "#deathdeath" "#slothincome" "#slothresources" 
"#coldincome" "#coldsupply" "#misfortune" "#luckevents" "#indepflag"
"#resourcescale" )
  "Keywords that sets a general (mod-wide) property") 

(defvar dommod-mode-weapon-keywords '( "#name" "#ammo" "#aoe" "#att"
"#armorpiercing" "#armornegating" "#bonus" "#cold"
"#def" "#dmg" "#dt_cap" "#dt_demon" "#dt_holy" "#dt_normal"
"#dt_paralyze" "#dt_poison" "#dt_stun" "#explspr" "#fire" "#flail"
"#flyspr" "#len" "#magic" "#nostr" "#nratt"
"#range" "#rcost" "#twohanded" "#shock" "#sound" "#secondaryeffect"
"#secondaryeffectalways" )
   "Keywords used in weapon modding")

(defvar dommod-mode-armor-keywords '( "#name" "#type" "#prot" "#def" 
"#enc" "#rcost")
   "Keywords used in armor modding")

(defvar dommod-mode-monster-basic-keywords '( "#name" "#descr"
"#spr1" "#spr2" "#ap" "#mapmove" "#hp" "#prot" "#size" "#str" "#enc"
"#att" "#def" "#prec" "#mr" "#mor" "#weapon" "#armor" "#gcost"
"#rcost" "#pathcost" "#startdom")
  "Keywords used for basic monster modding")

(defvar dommod-mode-monster-advanced-keywords '( "#ambidextrous"
"#amphibian" "#animal" "#animalawe" "#awe" "#aquatic" "#assassin"
"#berserk" "#blind" "#castledef" "#clear" "#clearmagic" "#clearspec"
"#copystats" "#copyspr" "#cold" "#coldblood" "#coldres" "#custommagic"
"#demon" "#diseasecloud" "#douse" "#entangle" "#eyeloss" "#ethereal"
"#eyes" "#fireshield" "#fear" "#female" "#fireres" "#firstshape"
"#flying" "#forestsurvival" "#forgebonus" "#gemprod" "#heal" "#healer"
"#heat" "#holy" "#horrormark" "#iceprot" "#illusion" "#immobile"
"#immortal" "#inanimate" "#itemslots" "#magicbeing" "#magicboost"
"#magicskill" "#maxage" "#mountainsurvival" "#mounted" "#nametype"
"#neednoteat" "#noheal" "#noitem" "#older" "#pillagebonus"
"#poisonarmor" "#poisoncloud" "#poisonres" "#pooramphibian"
"#regeneration" "#reinvigoration" "#researchbonus" "#restrictedgod"
"#sailing" "#secondshape" "#secondtmpshape" "#siegebonus"
"#shapechange" "#shockres" "#spy" "#standard" "#startage" "#stealthy"
"#supplybonus" "#swampsurvival" "#trample" "#undead" "#wastesurvival")
"Keywords used for advanced monster modding")

(defvar dommod-mode-commander-keywords '( "#noleader" "#poorleader"
"#okleader" "#goodleader" "#expertleader" "#superiorleader"
"#nomagicleader" "#poormagicleader" "#okmagicleader" "#goodmagicleader" "#expertmagicleader"
"#superiormagicleader" "#noundeadleader" "#poorundeadleader"
"#okundeadleader" "#goodundeadleader" "#expertundeadleader"
"#superiorundeadleader")
    "Keywords used for modding commanders and pretenders")

(defvar dommod-mode-spell-keywords '( "#school" "#researchlevel"
"#path" "#pathlevel" "#fatiguecost" "#precision" )
   "Keywords used for spell modding")

(defvar dommod-mode-item-keywords '( "#constlevel" "#mainpath"
"#mainlevel" "#secondarypath" "#secondarylevel")
   "Keywords used for modding items.")

(defvar dommod-mode-name-keywords
  '( "#clear" "#addname")
   "Keywords used for name modding.")

(defvar dommod-mode-site-keywords '( "#name" "#path" "#level"
				     "#rarity" "#loc" "#gems" "#homemon" "#homecom")
  "Keywords used for magic site modding")

(defvar dommod-mode-nation-keywords '( "#name" "#epithet" "#era" "#brief" "#descr"
"#summary" "#flag" "#color" "#clearnation" "#clearrec" "#clearsites" "#addrecunit"
"#addreccom" "#bloodnation" "#idealcold" "#nothemes" "#clearheroes" "#defcom1"
"#defcom2" "#defunit1" "#defunit1b" "#defunit2" "defunit2b"
"#defmult1" "#defmult1b" "#defmult2" "#defmult2b" "#dyingdom" "#hero1"
"#hero2" "#hero3" "#hero4" "#hero5" "#mapbackground" "#multihero1"
"#multihero2" "#nodeathsupply" "#nopreach" "#startcom"
"#startunittype" "#startunittype1" "#startunittype2" "#startunitnbrs"
"#startunitnbrs1" "#startunitnbrs2" "#startscout"
"#startsite" "#castleprod" "#sacrificedom" "#uwnation" "templepic"
"#startfort" "#defaultfort" "#farmfort" "#mountainfort" "#forestfort"
"#swampfort")
   "Keywords used for nation modding.")

;; Syntax highlighting
 (defvar dommod-mode-font-lock-keywords
   (eval-when-compile
     (list
      (list (concat "^" (regexp-opt (append dommod-mode-element-start-keywords '( "#end" )) t) "\\>") 
	    '(1 font-lock-keyword-face))
      (list (concat "^" (regexp-opt dommod-mode-general-keywords t) "\\>") '(1 font-lock-constant-face))
      (list (concat "^" (regexp-opt (delete-duplicates (append dommod-mode-weapon-keywords dommod-mode-armor-keywords dommod-mode-monster-basic-keywords dommod-mode-monster-advanced-keywords dommod-mode-spell-keywords dommod-mode-item-keywords dommod-mode-name-keywords dommod-mode-site-keywords dommod-mode-nation-keywords)) t) "\\>") '(1 font-lock-function-name-face))
      (list (concat "^" (regexp-opt dommod-mode-commander-keywords t) "\\>") 
	    '(1 font-lock-builtin-face))
      (list (concat "^" "\\(-- ==.*\\)" "\\>") '(1 font-lock-constant-face))
      (list (concat "^" "\\(==.*\\)" "\\>") '(1 font-lock-constant-face))
      )
     )
   )	      
  

;; Syntax-map. "--" starts a line comment,
(defvar dommod-mode-syntax-table nil
  "Syntax table used while in Dommode mode.")
(setq dommod-mode-syntax-table (make-syntax-table))
(modify-syntax-entry ?- ". 12b" dommod-mode-syntax-table)
(modify-syntax-entry ?\n "> b" dommod-mode-syntax-table)
(modify-syntax-entry ?# "_" dommod-mode-syntax-table)
(set-syntax-table dommod-mode-syntax-table)


;; Functions for movement between elements
(defvar dommod-mode-element-start-regexp
  (regexp-opt dommod-mode-element-start-keywords t))

(defun dommod-forward-element ( )
  "Moves forward to the start of the next element"
  (interactive)
  (end-of-line)
  (re-search-forward dommod-mode-element-start-regexp nil t))

(defun dommod-backward-element ( )
  "Moves backward to the start of the previous element"
  (interactive)
  (beginning-of-line)
  (re-search-backward dommod-mode-element-start-regexp nil t))

;; Functions for movement between bookmarks
(defvar dommod-mode-bookmark-regexp "^-- ==>")

(defun dommod-forward-bookmark ( )
  "Moves forward to the next bookmark"
  (interactive)
  (end-of-line)
  (re-search-forward dommod-mode-bookmark-regexp nil t))

(defun dommod-backward-bookmark ( )
  "Moves backward to previous bookmark"
  (interactive)
  (beginning-of-line)
  (re-search-backward dommod-mode-bookmark-regexp nil t))

;; Sets up the keymap
(defvar dommod-mode-map (make-sparse-keymap)
  "Local keymap used for Dommod Mode" )

(define-key dommod-mode-map "\C-c\C-c" 'comment-region)
(define-key dommod-mode-map "\C-c\C-f" 'dommod-forward-element)
(define-key dommod-mode-map "\C-c\C-b" 'dommod-backward-element)
(define-key dommod-mode-map "\C-c\C-d" 'dommod-forward-section)
(define-key dommod-mode-map "\C-c\C-u" 'dommod-backward-section)

;; Define the mode
(define-derived-mode dommod-mode fundamental-mode "DomMode"
  "Major mode for editing Dominions III mod files.
Special commands:
\\{dommod-mode-map}"
  (setq font-lock-defaults '(dommod-mode-font-lock-keywords nil nil nil))
  (use-local-map dommod-mode-map)
  (make-local-variable 'comment-start)
  (set 'comment-start "-- ")
  )
(provide 'dommod-mode)
