#!/usr/bin/python

################################################################################
# System Scaling Script
# by Nolan Kelly, 2006
#
# This script converts all instances of "Ring #" to "Circle Radius X, Y" in
# SystemTypes.txt. During the conversion, it scales the distances involved by
# the value of the scale_factor variable.
#
# Note that Ring 1 values are left alone. Ring 1 indicates the very center of
# the system, so it does not matter if you leave it at that.
################################################################################


################################################################################
# Globals
################################################################################

# The factor by which you are scaling system sizes.
scale_factor = 1

# Set this to the exact foldername used by the mod containing the 
# SystemTypes.txt file you wish to scale. To use the stock file, set it to '..'
#modname = '..'
modname = 'Solar Systems'

################################################################################
# don't muck about below this line!
################################################################################
import string
import re
import sys
import os

# Converts Ring N into Circle Radius X, Y
def ring_re (match):
  if match.group() == 'Ring 1':
    return 'Ring 1'
  
  value = int(match.group(1))
  return 'Circle Radius ' + str(int(value * 40 * scale_factor)) + ', ' + str(int(value * 40 * scale_factor))

# Scales existing Circle Radius X, Y
def circle_re (match):
  X = int(match.group(1))
  Y = int(match.group(2))
  return 'Circle Radius ' + str(int(X * scale_factor)) + ', ' + str(int(Y * scale_factor))

# Scales WP Min Radius
def wpmin_re (match):
  Y = int(match.group(1))
  return 'WP Min Radius                                    := ' + str(int(Y * scale_factor))

# Scales WP Max Radius
def wpmax_re (match):
  Y = int(match.group(1))
  return 'WP Max Radius                                    := ' + str(int(Y * scale_factor))

sysfile = open('../../' + modname + '/Data/SystemTypes.txt', 'r')

if os.getcwd().split('\\')[-2] == modname:
  print 'WARNING: Target mod same as source mod. Output file will be SystemTypesTemp.txt.'
  outfile = open('./SystemTypesTemp.txt', 'w')
else:
  outfile = open('./SystemTypes.txt', 'w')

# Get the first line in the file, in case it is empty.
line = sysfile.readline()

circle_match = re.compile('Circle Radius (\d{1,4}), (\d{1,4})')

ring_match = re.compile('Ring (\d{1,2})')
offset_ring_match = re.compile('Offset (\d{1,2}) Ring (\d{1,2})')

wpmin_match = re.compile('WP Min Radius \s+ := (\d{1,4})')
wpmax_match = re.compile('WP Max Radius \s+ := (\d{1,4})')

# Skip the file header.
while line.strip() != "*BEGIN*":
  outfile.write(line)
  
  # Get the next line.
  line = sysfile.readline()


while line != "":
  line = circle_match.sub(circle_re, line, count=1)

  # Do not replace Offset # Ring #
  if (offset_ring_match.search(line) == None):
    line = ring_match.sub(ring_re, line, count=1)

  line = wpmin_match.sub(wpmin_re, line, count=1)
  line = wpmax_match.sub(wpmax_re, line, count=1)


  outfile.write(line)

  # Get the next line.
  line = sysfile.readline()

sysfile.close()
outfile.close()
