#! /usr/bin/env python

'''
Author: Marek 'b0rsuk' Onuszko
Last modification: 08.XII.2006
Purpose: documentation script for Dominions3: The Awakening strategy game.


This script takes a string of path letters, and outputs all spells that can be cast with these paths.
takes spells from a separate data file 'necronomicon'. It should be in the same directory.
'''

# parses one line from spell data file
def parseSpell(line):
    global spellpaths, spellname, levelofspell, spellschool, spelltype, spellcategory
    words = line.split()
    
    spellpaths = words[0]
    spellname = words[1]
    levelofspell = words[2] #only spellname used at the moment
    spellschool = words[3]
    spelltype = words[4]

# determines letters of primary and secondary path of spell, for example AAS is (a)ir a(s)tral
def parsePaths(letters):
    global primarypath, secondarypath
    
    primarypath = letters[0]
    # if first and last letter of spellpath string differ, spell uses two paths
    if letters[0] != letters[-1]:
        secondarypath = letters[-1]
    else:
        secondarypath = ''
    
# compares amount of path letters (FAWESDNBH) of mage and spell. Return 0 if spell can be cast by this mage.
def comparePaths(paths_spell, paths_mage):
    if paths_spell.count(primarypath[:]) <= paths_mage.count(primarypath[:]) \
    and paths_spell.count(secondarypath[:]) <= paths_mage.count(secondarypath[:]):
        return 0
    else:
        return 1

#the biggest function. Gets a list of spells (one per line)
# and path string of a mage. Prints spells castable
# by the mage. No boosters and no randoms.
def showCastableSpells(spells, magepaths):
        for spell in spells:
            parseSpell(spell)
            parsePaths(spellpaths)            

            if comparePaths(spellpaths, magepaths) == 0:
                print spellname + ' ' + levelofspell + ' ' + spellschool


if __name__ == '__main__':
    import sys
    
    if len(sys.argv) != 2:
        print 'usage: ' + sys.argv[0] + ' magicpaths'
    else:

#Actual program starts HERE:


        paths_of_a_mage = sys.argv[1].upper() #first argument, uppercase
        
        spellfile = open('necronomicon')
        researchedspells = spellfile.readlines()    
        spellfile.close()
        
        showCastableSpells(researchedspells, paths_of_a_mage)
