#!/usr/bin/perl


#Arguments are -
# minimum # of neighbors
# desired distance between start sites

sub SDRunSum {
# arguments are -
# number of items.
# current running sum of mean.
# current running sum of stdev.
# new value
        $_[0]++;

        $delta = ($_[3] - $_[1]) / $_[0];
        $_[2] += $delta * $delta * $_[0];
        $_[1] += $delta;
        $_[2] += ($_[3] - $_[1]) * ($_[3] - $_[1]);
}


$d_neigh = $ARGV[0];
$d_dist = $ARGV[1];
$max_sea = $ARGV[2];

while (<STDIN>)
{
	chomp $_;
	@line = split (/ /); 

	if (/terrain/){
		$terrain[$line[1]] = $line[2];
		if ($line[2] % 8 >= 4){
			$type[$line[1]] = -1;
		}
		else {
			$type[$line[1]] = 0;
		}
		$cool[$line[1]] = $type[$line[1]];
		if ($line[2] % 128 >= 64 || $line[2] % 64 >= 32 || $line[2] % 4096 >= 2048){
			$cool[$line[1]]+=2;
		}

## Hell, let's get the entire frickin' mask.
		$mask[$line[1]] = $line[2];


		$dist{$line[1]}{$line[1]} = 0;
		$halfdist{$line[1]}{$line[1]} = 0;
		if ($line[1] > $numprov){$numprov = $line[1];}
	}

	if (/neighbour/){
		$adj{$line[1]}{$line[2]} = 1;			
		$adj{$line[2]}{$line[1]} = 1;			
		$dist{$line[1]}{$line[2]} = 1;			
		$dist{$line[2]}{$line[1]} = 1;			
		$halfdist{$line[1]}{$line[2]} = 1;			
		$halfdist{$line[2]}{$line[1]} = 1;			
	}
}

# Okay, now we need to know which provinces are eligible start-sites.
for ($i = 1; $i <= $numprov; $i++){
	$total = 0; $elig = 0; $same = 0;
	for $j (keys %{$adj{$i}}){
		if ($cool[$i] <= $type[$j]) {$elig++;}
		if ($type[$i] == $type[$j]) {$same++;}
		$total++;
	}
#	print "$i,$elig\n";
	if ($elig >= $d_neigh && $same >= $d_neigh -2){
		$elig_list{$i} = 1;
	}
	if ($same == 0 && $type[$i] == -1){print "-- $i is a single province lake!\n";} 
	if ($same == 0 && $type[$i] == 0){print "-- $i is a single province island!\n";} 
	if ($total == 0){print "##$i is an isolated province!\n";}
	$num_neighbors{$i} = $same;
} 

# Now we need to extend the adjacency list for each province out to $d_dist.
# For the sake of placing city-type specials, we'll also extend it out to $d_dist - 2.	

for ($i = 1; $i <= $numprov; $i++){
for $j (keys %{$adj{$i}}){
for $k (keys %{$adj{$j}}){
	if (!exists $dist{$i}{$k}){
			$dist{$i}{$k} = 2;
			$halfdist{$i}{$k} = 2;
			$zone{2}{$i}{$k} = 1;
	}	
}}}

for ($l = 3; $l <= $d_dist; $l++){
for ($i = 1; $i <= $numprov; $i++){
for $j (keys %{$zone{$l-1}{$i}}){
for $k (keys %{$adj{$j}}){
	if (!exists $dist{$i}{$k}){
			if ($l <= $d_dist / 2){$halfdist{$i}{$k} = 2;}
			$dist{$i}{$k} = $l;
			$zone{$l}{$i}{$k} = 1;
	}	
}}}}


for $i (keys %elig_list){
	if ($type[$i] == -1){
		delete $elig_list{$i};
	}
}

for ($i = 1; $i <= $numprov; $i++){
if (exists $elig_list{$i}){
	for $j (keys %{$dist{$i}})
	{
		if (exists $elig_list{$j}){
			$clashes{$i}++;
			$clashlist{$i}{$j} = 1;
		}
	}
}
}



# Finally, we're going to get the distance between all pairs of start sites, and find any provinces which are isolated from land routes.

for ($i = 1; $i <= $numprov; $i++){
for $j (keys %{$adj{$i}}){
for $k (keys %{$adj{$j}}){
	if (!exists $path{$i}{$k} && $type[$i] != -1 && $type[$k] != -1){
			$path{$i}{$k} = 2;
			$pathz{2}{$i}{$k} = 1;
	}	
}}}

$l = 3;
$m = 1;
while ($m > 0){
	$m = 0;
	for ($i = 1; $i <= $numprov; $i++){
	for $j (keys %{$pathz{$l-1}{$i}}){
	for $k (keys %{$adj{$j}}){
		if (!exists $path{$i}{$k} && $type[$i] != -1 && $type[$k] != -1){
				if ($l <= $d_dist / 2){$halfdist{$i}{$k} = 2;}
				$path{$i}{$k} = $l;
				$pathz{$l}{$i}{$k} = 1;
				$m++;
		}	
	}}}
	print "-- $m paths at $l\n";
	$l++;
}


# 1 -> small province
# 2 -> big province
# 1024 -> many sites
# 64 -> waste
# 2048 -> deep
# 32 -> swamp


$numstarts = 0;
$okay = 1;
### THIS PART NEEDS TO BE CHANGED

@startpriority = sort {$clashes{$a} <=> $clashes{$b}} keys %elig_list;
$i = $startpriority[0];
print "#start $i\n";
if ($type[$i] == -1){print "-- sea start\n";}
for $j (keys %{$adj{$i}}){
	print "#terrain $j ";
	print (((($terrain[$j] | 1) ^ 1 ) | 2) | 1024);
	print "\n";
}
for $j (keys %{$halfdist{$i}}){
	$excluded{$j} = 1;
}			
for $j (keys %{$clashlist{$i}}){
	$excluded{$j} = 1;
}
$excluded{$i} = 1;
$startlist{$i} = 1;
delete $elig_list{$i};
$numstarts++;

@startpriority = reverse sort {$path{$i}{$a} <=> $path{$i}{$b}} keys %elig_list;
$i = $startpriority[0];
print "#start $i\n";
if ($type[$i] == -1){print "-- sea start\n";}
for $j (keys %{$adj{$i}}){
	print "#terrain $j ";
	print (((($terrain[$j] | 1) ^ 1 ) | 2) | 1024);
	print "\n";
}
for $j (keys %{$halfdist{$i}}){
	$excluded{$j} = 1;
	delete $elig_list{$j};
}			
for $j (keys %{$clashlist{$i}}){
	$excluded{$j} = 1;
	delete $elig_list{$j};
}
$excluded{$i} = 1;
$startlist{$i} = 1;
delete $elig_list{$i};
$numstarts++;

while ($okay > 0){
	$okay = 0;
	for $i (keys %startlist){
		$this_remote[$i] = 0;
	}

	for $i (keys %startlist){
	for $j (keys %startlist){
		if ($i < $j){
		$this_remote[$i] += $path{$i}{$j};
		$this_remote[$j] += $path{$i}{$j};
		}
	}}

	for $i (keys %elig_list){
		$bc = 0; $bm = 0; $bsd = 0;
		for $j (keys %startlist){
			$this_remote[$i] += $path{$i}{$j};
			$this_remote[$j] += $path{$i}{$j};
			&SDRunSum ($bc, $bm, $bsd, $this_remote[$j]);
		}
		&SDRunSum ($bc, $bm, $bsd, $this_remote[$i]);
		$sdev[$i] = $bsd;
#		print $i . "," . $sdev[$i] . "\n";
		for $j (keys %startlist){
			$this_remote[$j] -= $path{$i}{$j};
		}
	}

	@startpriority = sort {$sdev[$a] <=> $sdev[$b]} keys %elig_list;
	$i = $startpriority[0];
	print "#start $i\n";
	if ($type[$i] == -1){print "-- sea start\n";}
	for $j (keys %{$adj{$i}}){
		print "#terrain $j ";
		print (((($terrain[$j] | 1) ^ 1 ) | 2) | 1024);
		print "\n";
	}
	for $j (keys %{$halfdist{$i}}){
		$excluded{$j} = 1;
		delete $elig_list{$j};
	}			
	for $j (keys %{$clashlist{$i}}){
		$excluded{$j} = 1;
		delete $elig_list{$j};
	}
	$excluded{$i} = 1;
	$startlist{$i} = 1;
	delete $elig_list{$i};
	$numstarts++;

	@foo = keys %elig_list;
	$okay = @foo;	

#
#
#
#
#for $i (@startpriority){
#	if (!exists $excluded{$i}){
#		print "#start $i\n";
#		if ($type[$i] == -1){print "## sea start\n";}
#		for $j (keys %{$adj{$i}}){
#			print "#terrain $j ";
#			print (((($terrain[$j] | 1) ^ 1 ) | 2) | 1024);
#			print "\n";
#		}
#
#		for $j (keys %{$halfdist{$i}}){
#			$excluded{$j} = 1;
#		}			
#		for $j (keys %{$clashlist{$i}}){
#			$excluded{$j} = 1;
#		}			
#		$excluded{$i} = 1;
#		$startlist{$i} = 1;
#		delete $elig_list{$i};
#		$numstarts++;
#	}
#}


}

print "-- found $numstarts start sites.\n";

### THE ABOVE PART NEEDS TO BE CHANGED

# Now we're going to suggest locations for specials among the remaining provinces that are outside of this distance, regardless of neighbors.

# No, that's not what I'm doing.

@specialpriority = reverse sort {$num_neighbors{$a} <=> $num_neighbors{$b}} keys %num_neighbors;

for $i (@specialpriority){
	if (!exists $excluded{$i}){
		print "--adding a special in $i which has " . $num_neighbors{$i} . " neighbors.";
		if ($type[$i] == -1){print " (sea special)";}
		print "\n";
#		print "#land $i";
#		print "#clearfeatures";
		
		for $j (keys %{$dist{$i}}){
			$excluded{$j} = 1;
		}			
		$excluded{$i} = 1;
	}
}


for $i (keys %startlist){
	for $j (keys %startlist){
	if ($i < $j) {
		print "-- path from,$i,$j," . $path{$i}{$j} . "\n";
		$remoteness[$i] += $path{$i}{$j};
		$remoteness[$j] += $path{$i}{$j};	
	}
	}
}

for $i (keys %startlist) {print "-- remotness,$i," . $remoteness[$i] . "\n";}

for ($i = 1; $i <= $numprov; $i++){
	$count = 0;
	for $j (keys %startlist){
		if (exists $path{$i}{$j} || exists $path{$j}{$i}){
			$count++;
		}
	}
	if ($count < $numstarts){
		$diff = $numstarts - $count;
		print "-- $i is isolated from $diff start positions.\n"; 
	}
}

#for ($l = 3; $l <= $d_dist; $l++){
#for ($i = 1; $i <= $numprov; $i++){
#for $j (keys %{$zone{$l-1}{$i}}){
#for $k (keys %{$adj{$j}}){
#	if (!exists $dist{$i}{$k}){
#			if ($l <= $d_dist / 2){$halfdist{$i}{$k} = 2;}
#			$dist{$i}{$k} = $l;
#			$zone{$l}{$i}{$k} = 1;
#	}	
#}}}}
