#!/usr/bin/perl

use strict;


# Read arguments

my %arguments = (
	"-map"     => \(our $mapfile),               # The original map file
	"-nslist"  => \(our $nostart_file),          # No start province number list list
	"-begin"   => \(our $beginning),             # Range start
	"-end"     => \(our $ending),                # Range stop
	"-output"  => \(our $output)                 # Output file
);

for (my $arg_num = 0; $arg_num < (scalar @ARGV); $arg_num++){
	if (exists $arguments{$ARGV[$arg_num]}){
		chomp(${$arguments{$ARGV[$arg_num]}} = $ARGV[$arg_num + 1]);
	}
}

unless ($output){
	$output = $mapfile;
}

if ($mapfile eq "" or ($nostart_file eq "" and ($beginning eq "" or $ending eq ""))){
	print "\nSYNTAX: NoStart.pl -map [mapfile] -nslist [nostart list] -begin [beginning] -end [ending] -output [output file]\n\nArguments may be given in any order, as long as they are declared.\n\n* \"Mapfile\" is the .map file you wish to modify\n* \"Nostart list\" is a text file that has list of province numbers, one number per line. (Optional)\n* \"Begining\" is the beginning of the range of province numbers to change. (Optional)\n* \"Ending\" is the last of the range of province numbers to change. (Optional)\n* \"Output file\" is the file name where the new .map file will be written. (Optional, default same as map file)\n\n";
	exit;
}


# Variables

my $output_file  = "";                           # Output string
my %nostart_list = ();                           # List of provinces to flag as no start
my $check_pow    = 9;                            # The power of 2 to be checked
my $check_num    = 2 ** $check_pow;              # The actual numer to be checked


# Read nostart list

if ($nostart_file){
	open INPUT1, "<$nostart_file" or die "Can't find province list.\n";
	foreach (<INPUT1>){
		chomp;
		$_ =~ s/\s//g;
		$nostart_list{$_} = 1;
	}
}

close INPUT1;


# Read nostart range

for ($beginning .. $ending){
	$nostart_list{$_} = 1;
}



# Read and modify map file

open INPUT2, "<$mapfile" or die "Can't find map file.\n";

foreach (<INPUT2>){
	chomp;
	my @line = split /\s/;
	if ($line[0] eq "#terrain"){
		if (exists $nostart_list{$line[1]}){
			unless (($line[2] & $check_num) == $check_num){
				$line[2] += $check_num;
			}
		}
	}
	my $line_out = join (" ", @line);
	$line_out .= "\n";
	$output_file .= $line_out;
}


# Print results

open OUTPUT, ">$output";

print OUTPUT $output_file;

close OUTPUT;
