--
-- F'Thaggua-Madness and Doom v1.0 Nation Mod for Dominions III
-- Art and Mod By Honeybadger
--
-- Illwinter Game Design
-- www.illwinter.com
-- 

-- General Mod Data

#modname "F'Thaqqua"
#description "Deros are a diminutive people that once lived deep underground in small, isolated communities. A mix of many different races: humans, dwarves, hoburgs, and others, they are physically very tough and hardy, but prone to mental instability due to intense inbreeding, lack of sunlight, and strange magical fields encountered underground. This has led to the formation of dozens of death-cults among the Dero. The Dero were forced to the surface when their insatiable god, the N'Kai, turned it's appetite on them. The move to the surface has rendered most of them highly xenophobic and completely psychotic. In ages past, the Dero cults worshipped the many freakish servitors of the N'Kai that lived deep underground, but with the move to the surface, they now have turned their worship to beings from beyond the stars, themselves."
#icon "./Fthaqqua/mod_banner.tga"
#version 1.00
#domversion 3.01

-- Item Data

#newweapon 816
#name "Crimson Dagger"
#att 1
#def 0
#dmg 4
#len 1
#magic
#secondaryeffect 64
#secondaryeffect 306
#nratt 1
#rcost 9
#sound 8
#end

#newweapon 817
#name "Crimson Glaive"
#att 2
#def 0
#dmg 9
#len 3
#magic
#secondaryeffect 64
#secondaryeffect 306
#nratt 1
#twohanded
#rcost 20
#sound 8
#end

#newweapon 818
#name "Crimson Bow"
#ammo 6
#att 2
#def 0
#dmg 10
#dt_normal
#flyspr 109 1
#magic
#secondaryeffect 64
#secondaryeffect 306
#nostr
#nratt 1
#range 20
#rcost 12
#sound 13
#end

#newweapon 819
#name "Prism Fangs"
#att 2
#def 0
#dmg 1
#len 0
#magic
#secondaryeffect 52
#secondaryeffect 53
#secondaryeffect 54
#secondaryeffect 55
#secondaryeffect 306
#nratt 1
#rcost 12
#sound 22
#explspr 10141
#end

#newweapon 820
#name "Crimson Voulge"
#att 1
#def 0
#dmg 12
#len 4
#magic
#secondaryeffect 64
#secondaryeffect 306
#nratt 1
#twohanded
#rcost 18
#sound 8
#end

#newweapon 821
#name "Alchemical Explosion"
#ammo 1
#att 3
#def 0
#dmg 10
#dt_normal
#armorpiercing
#flyspr 313 4
#secondaryeffect 54
#secondaryeffect 171
#secondaryeffect 51
#nostr
#nratt 1
#range 1
#rcost 20
#sound 16
#end

#newweapon 825
#name "Triple Bite"
#att 0
#def 0
#dmg -5
#dt_normal
#nratt 3
#range 1
#rcost 20
#sound 20
#end

#newweapon 826
#name "Tentacles"
#att 0
#def 0
#dmg -5
#dt_normal
#nratt 3
#range 1
#rcost 20
#sound 9
#end


#newweapon 822
#name "War Cleaver"
#att 1
#def -2
#dmg 4
#len 1
#nratt 2
#rcost 5
#sound 10
#end

#newweapon 823
#name "Crimson Saber"
#att 2
#def 0
#dmg 6
#len 2
#magic
#secondaryeffect 64
#secondaryeffect 306
#nratt 1
#rcost 9
#sound 8
#end

#newweapon 824
#name "Big Scary Axe"
#att -1
#def -1
#dmg 8
#len 2
#nratt 1
#rcost 5
#sound 10
#end

#newweapon 827
#name "Birl's Constantly Crimson Axe"
#att 0
#def 0
#dmg 8
#len 2
#nratt 1
#secondaryeffect 64
#secondaryeffect 306
#rcost 5
#sound 10
#end

#newweapon 828
#name "Exploding Skull"
#ammo 3
#att 3
#def 0
#dmg 12
#dt_normal
#armorpiercing
#flyspr 313 4
#explspr 10113
#secondaryeffectalways 221
#nostr
#aoe 5
#bonus
#nratt 1
#range 20
#rcost 1
#sound 16
#end

#newweapon 829
#name "Giant Tentacle of Doom"
#att 0
#def 0
#dmg 0
#dt_normal
#secondaryeffectalways 255
#len 6
#aoe 5
#nratt 1
#rcost 5
#sound 9
#end


-- Monster Data

#newmonster 2582
#name "F'thaggua"
#spr1 "./Fthaqqua/firevampire.tga"
#spr2 "./Fthaqqua/firevampire2.tga"
#descr "The F'thaqqua are tiny arcs of living plasma. They serve the Great Death as scouts."
#ap 12
#mapmove 3
#hp 1
#prot 1
#size 1
#str 5
#enc 0
#att 9
#def 15
#prec 6
#mr 12
#mor 50
#gcost 1
#rcost 1
#weapon 63
#blind
#holy
#itemslots 1
#flying
#immortal
#ethereal
#stealth 5
#glamour
#poisres 100
#fireres 100
#demon
#magicbeing
#maxage 15000
#pillagebonus 1
#noleader
#nomagicleader
#noundeadleader
#nametype 117
#end


#newmonster 2596
#name "Dero Nihilist"
#spr1 "./Fthaqqua/nihilist1.tga"
#spr2 "./Fthaqqua/nihilist2.tga"
#descr "Nihilists are dero who actively work with the Fthaqqua on a daily basis. It was self-destructive fanatics such as these who first summoned the Great Death to this world. They are cruel, morbid, often psychotically insane, and don't care about anything except destruction of themselves, the world, everything. Dero Nihilists, due to their beliefs, are forbidden from wearing any kind of armor-even shields are frowned upon."
#ap 12
#mapmove 2
#hp 5
#prot 7
#size 1
#str 9
#enc 1
#att 9
#def 6
#prec 10
#mr 12
#mor 30
#berserk 3
#eyes 2
#darkvision 50
#holy
#gcost 30
#rcost 5
#weapon 822
#weapon 822
#ambidextrous
#itemslots 15494
#maxage 60
#pillagebonus 1
#poorleader
#nomagicleader
#noundeadleader
#nametype 141
#end

#newmonster 2610
#name "Dero Maniac"
#spr1 "./Fthaqqua/deroaxe1.tga"
#spr2 "./Fthaqqua/deroaxe2.tga"
#descr "Maniacs are dero who have gone completely berserk from staring at the sun. Stronger than other Dero, but ill-equipped to function in society, they are used as shock troops on the front lines."
#ap 15
#mapmove 2
#hp 6
#prot 9
#size 1
#str 12
#enc 1
#att 12
#def 3
#prec 10
#mr 12
#mor 99
#eyes 2
#darkvision 50
#holy
#gcost 30
#rcost 5
#weapon 824
#ambidextrous
#itemslots 15494
#maxage 60
#pillagebonus 1
#poorleader
#nomagicleader
#noundeadleader
#nametype 141
#end

#newmonster 2615
#name "Bloody Birl"
#spr1 "./Fthaqqua/Bloody1.tga"
#spr2 "./Fthaqqua/Bloody2.tga"
#descr "Birl likes to kill. And kill, and kill, and kill. Where most Dero wear bright, multi-colored robes with little or no other ornamentation, Birl adorns his robes-and his huge axe-with the many skulls of those he's killed. Birl is tough, smart, and creative. A true psychotic genius, he's legendary for his ability to survive anything, leaving a charnal-house of victims behind him. Birl always works alone."
#ap 15
#mapmove 2
#hp 30
#prot 9
#size 1
#str 15
#enc 1
#att 15
#def 15
#prec 10
#mr 21
#mor 99
#eyes 2
#darkvision 50
#holy
#heal
#gcost 30
#rcost 5
#stealthy 5
#assassin 
#regeneration 5
#immortal
#magicskill 8 1
#weapon 827
#weapon 828
#ambidextrous
#itemslots 15494
#maxage 150#pillagebonus 10
#noleader
#nomagicleader
#noundeadleader
#nametype 141
#end


#newmonster 2603
#name "Dero Guard"
#spr1 "./Fthaqqua/derovoul1.tga"
#spr2 "./Fthaqqua/derovoul2.tga"
#descr "Not all dero are homicidal maniacs-some are just paranoid xenophobes. These slightly more reliable dero are employed by the Great Death as temple guards and bodyguards."
#ap 12
#mapmove 2
#hp 5
#prot 7
#size 1
#str 9
#enc 1
#att 12
#def 6
#prec 10
#mr 15
#mor 30
#berserk 3
#eyes 2
#darkvision 50
#holy
#gcost 50
#castledef 1
#rcost 5
#weapon 820
#ambidextrous
#itemslots 15494
#maxage 60
#pillagebonus 1
#poorleader
#nomagicleader
#noundeadleader
#nametype 141
#end


#newmonster 2583
#name "Evercold"
#spr1 "./Fthaqqua/evercold.tga"
#spr2 "./Fthaqqua/evercold2.tga"
#descr "Ghastly frozen zombies created by a Xokkoth embracing and draining the life force from a living being, and then reanimating the corpse by replacing it's blood with Xokkoth ichor. The end result is a soulless killing thing that only desires to drain the world of warmth and life. As much as it might wish to die, however, the evil ichor pumped into it's veins will not allow it, and the Evercold will instantly heal all but the most massive damage. Eyes frozen solid, the only sensation of the world around them the Evercold experience is the heat they detect through what remains of their skin."
#ap 10
#mapmove 1
#hp 15
#prot 6
#size 2
#str 12
#enc 0
#att 9
#def 9
#prec 6
#mr 8
#mor 50
#gcost 1
#rcost 1
#weapon "claws"
#demon
#regenerate 100
#blind
#holy
#neednoteat
#coldres 300
#fireres -50
#iceprot 3
#itemslots 15494
#cold
#eyes 2
#maxage 100
#noleader
#nomagicleader
#noundeadleader
#nametype 105
#end

#newmonster 2584
#name "Star Hound"
#spr1 "./Fthaqqua/starhound1.tga"
#spr2 "./Fthaqqua/starhound2.tga"
#descr "Star Hounds are dangerous spirits summoned from the depths of space to hunt down living prey. They are the preferred assassins of the Great Deaths"
#ap 18
#mapmove 3
#hp 20
#prot 7
#size 4
#str 15
#enc 0
#att 12
#def 15
#prec 7
#mr 10
#mor 30
#gcost 1
#rcost 1
#weapon "claw"
#weapon "claw"
#weapon "bite"
#sailing
#holy
#eyes 2
#maxage 15000
#ethereal
#immortal
#fear 0
#itemslots 1
#demon
#magic being
#fireres 50
#coldres 50
#poisonres 100
#stealthy 2
#assassin
#noleader
#nomagicleader
#noundeadleader
#nametype 117
#end

#newmonster 2585
#name "Squiggoth"
#spr1 "./Fthaqqua/electrichydra.tga"
#spr2 "./Fthaqqua/electrichydra2.tga"
#descr "Squiggoths are incomprehensible horrors that serve the Great Deaths as inquisitors. Hideous, dangerous, and possessed of a low cunning, they serve the Great Deaths well."
#ap 12
#mapmove 1
#hp 18
#prot 6
#size 3
#str 12
#enc 0
#att 9
#def 12
#prec 12
#mr 16
#mor 12
#inquisitor 1
#eyes 12
#gcost 1
#rcost 1
#weapon 271
#weapon 271
#weapon 271
#magic being
#demon
#fear 0
#pillagebonus 1
#shockres 100
#poisonres 100
#immortal
#ethereal
#amphibian
#holy
#itemslots 1
#maxage 15000
#noleader
#poormagicleader
#poorundeadleader
#nametype 140
#end

#newmonster 2586
#name "Reaper"
#spr1 "./Fthaqqua/clawgiant1.tga"
#spr2 "./Fthaqqua/clawgiant2.tga"
#descr "Vast, shadowy abominations that dominate battlefields, laying waste to whole armies, and yet...are never clearly described, save that those few who get a close look at them and survive the experience inevitably go hopelessly insane."
#ap 7
#mapmove 1
#hp 45
#prot 15
#size 5
#str 25
#enc 0
#att 10
#def 6
#prec 8
#mr 15
#mor 50
#gcost 1
#rcost 1
#fear 0
#weapon "golden claw"
#weapon "golden claw"
#weapon "golden claw"
#weapon "golden claw"
#magic being
#demon
#blind
#holy
#itemslots 1
#ethereal
#immortal
#fear 0
#pillagebonus 5
#maxage 15000
#noleader
#nomagicleader
#noundeadleader
#nametype 140
#end

#newmonster 2587
#name "Xokkoth"
#spr1 "./Fthaqqua/slayerlord1.tga"
#spr2 "./Fthaqqua/slayerlord2.tga"
#descr "The dark generals of the legions of the Great Death, Xokkoth are rarely encountered, and never sought out. Powerfully evil, infinitely sadistic, the minds of the Xokkoth are almost as awful as their hideous bodies. They have relatively humanoid torsos, covered in matted purple fur and thick vinelike organs, but where their arms should be are instead two powerful tentacles, and they have no heads, per se-only a mound of flesh resembling a molten candle from which shine sickly yellow lights. Their inner workings are no less abyssmal, filled with intensely cold, transparent blue ichor instead of blood."
#ap 8
#mapmove 1
#hp 50
#prot 16
#size 4
#str 28
#enc 0
#att 16
#def 12
#prec 8
#mr 18
#mor 30
#gcost 1
#rcost 1
#weapon 271
#weapon 271
#magic being
#demon
#blind
#holy
#pillagebonus 2
#immortal
#ethereal
#fear 5
#cold
#iceprot 3
#coldres 300
#poisonres 100
#maxage 15000
#noleader
#okmagicleader
#okundeadleader
#nametype 117
#end

#newmonster 2588
#name "Derleth"
#spr1 "./Fthaqqua/reaper1.tga"
#spr2 "./Fthaqqua/reaper2.tga"
#descr "Although the Derleth presence resembles a huge Fthaqqua, this is only due to the limited interpretation of a sane mind. The Derlith is far stranger, and far more powerful, intelligent, and dangerous."
#ap 10
#mapmove 1
#hp 12
#prot 9
#size 3
#str 12
#enc 0
#att 15
#def 12
#prec 12
#mr 17
#mor 30
#gcost 1
#rcost 1
#weapon 86
#weapon 86
#weapon 271
#maxage 15000
#magic being
#ethereal
#itemslots 1
#fireres 100
#demon
#blind
#holy
#pillagebonus 1
#heat
#flying
#noleader
#nomagicleader
#noundeadleader
#nametype 140
#end

#newmonster 2611
#name "Trefoil Eye"
#spr1 "./Fthaqqua/trefoil.tga"
#spr2 "./Fthaqqua/trefoil2.tga"
#descr "Dark legends speak of the horror that comes to those who sleep, the trefoil eye that lives beneath the deep. Nothing more is known."
#ap 15
#mapmove 3
#hp 60
#prot 10
#size 5
#str 1
#enc 0
#att 15
#def 15
#prec 15
#mr 18
#mor 30
#gcost 1
#rcost 1
#weapon 86
#weapon 86
#weapon 86
#weapon 274
#maxage 15000
#magic being
#ethereal
#stealthy 1
#assassin
#itemslots 1
#magicskill 0 1
#magicskill 1 1
#magicskill 2 1
#magicskill 3 1
#magicskill 4 2
#magicskill 50 1
#fireres 100
#shockres 50
#coldres 50
#demon
#eyes 1
#holy
#pillagebonus 5
#flying
#goodleader
#goodmagicleader
#goodundeadleader
#itemslots 1
#nametype 140
#end


#newmonster 2589
#name "Bale"
#spr1 "./Fthaqqua/Bale1.tga"
#spr2 "./Fthaqqua/Bale2.tga"
#descr "With the coming of the Great Deaths, it is not only those who live on the land, but the land itself that has been corrupted and terrorized. Bales are enormous treelike structures, but where green leaves and flowers might otherwise be, instead is found a terrible golden eye, gazing mercillessly and covetously over the naked countryside. And although they are the size of huge trees, the Bales do move."
#ap 3
#mapmove 1
#hp 75
#prot 1
#size 6
#str 1
#enc 0
#att 5
#def 5
#prec 5
#mr 15
#mor 50
#gcost 1
#rcost 1
#maxage 15000
#magicbeing
#weapon "sleepvines"
#weapon "sleepvines"
#weapon "sleepvines"
#demon
#holy
#eyes 1
#fear 0
#itemslots 1
#pillagebonus 5
#gemprod 4 1
#noleader
#nomagicleader
#noundeadleader
#nametype 117
#end

#newmonster 2590
#name "Screamer"
#spr1 "./Fthaqqua/screamer1.tga"
#spr2 "./Fthaqqua/screamer2.tga"
#descr "Tiny, insect-like horrors summoned by the Great Death to aid in the murder of a world. Hideously fast, they relentlessly persue their pray." 
#ap 30
#mapmove 1
#hp 1
#prot 1
#size 1
#str 1
#enc 3
#att 9
#def 5
#prec 10
#mr 5
#mor 50
#gcost 1
#rcost 1
#weapon "venomous bite"
#demon
#magicbeing
#blind
#holy
#maxage 30
#itemslots 1
#noleader
#nomagicleader
#noundeadleader
#nametype 117
#end

#newmonster 2591
#name "Phase Spider"
#spr1 "./Fthaqqua/phasespider1.tga"
#spr2 "./Fthaqqua/phasespider2.tga"
#descr "Spider-things from beyond time and space, brought to this world to serve as scouts and opportunistic predators by the Great Death."
#ap 24
#mapmove 3
#hp 12
#prot 8
#size 2
#str 11
#enc 3
#att 12
#def 12
#prec 12
#mr 12
#mor 15
#gcost 1
#rcost 1
#poisonres 100
#immortal
#ethereal
#magicbeing
#demon
#eyes 8
#weapon "Prism Fangs"
#weapon "web spit"
#poisonres 100
#stealthy 5
#itemslots 1
#assassin
#fear 0
#holy
#maxage 15000
#noleader
#nomagicleader
#noundeadleader
#nametype 141
#end

#newmonster 2593
#name "Great Death"
#spr1 "./Fthaqqua/grdeathmon1.tga"
#spr2 "./Fthaqqua/grdeathmon2.tga"
#descr "The Death of the World."
#ap 0
#mapmove 0
#hp 60
#prot 25
#size 6
#str 15
#enc 3
#att 18
#def 12
#prec 16
#mr 24
#mor 30
#gcost 240
#rcost 1
#weapon "area death"
#ethereal
#startdom 1
#pathcost 120
#amphibian
#blind
#itemslots 61440
#fear 15
#magicskill 4 4
#researchbonus 5
#maxage 15000
#noleader
#superiormagicleader
#superiorundeadleader
#nametype 140
#end

#newmonster 2594
#name "Dholg"
#spr1 "./Fthaqqua/dholg.tga"
#spr2 "./Fthaqqua/dholg2.tga"
#descr "Xokkoths have the ability to drain their blood into prepaired corpses, creating Evercold in the process, but the blood of the Xokkoth can be used for another, even more vile purpose. By piling hundreds of corpses together and covering them with Xokkoth ichor, a special construct may be built from the very essence of pain and suffering-a moving mountain of pain, a slow, unstoppable glacier of death-which drives all others before it."
#ap 1
#mapmove 1
#hp 20
#prot 9
#size 4
#str 30
#enc 0
#att 9
#def 5
#prec 1
#mr 15
#mor 50
#gcost 1
#rcost 1
#cold
#iceprot 3
#fear 5
#coldres 300
#regenerate 50
#blind
#holy
#trample
#itemslots 1
#maxage 15000
#noleader
#nomagicleader
#noundeadleader
#nametype 140
#end

#newmonster 2595
#name "Nhorl"
#spr1 "./Fthaqqua/nhorl1.tga"
#spr2 "./Fthaqqua/nhorl2.tga"
#descr "Nhorls resemble a cross between a maggot and a leech, only a million times larger. They are the spawn of the vile Xokkoth. Nhorls are hatched inside Dholg mounds, and don't venture far from their birthing nests until they grow into Xokkoths."
#ap 12
#mapmove 0
#hp 20
#prot 12
#size 2
#str 20
#enc 3
#att 12
#def 9
#prec 12
#mr 16
#mor 15
#gcost 1
#rcost 1
#weapon "tentacle"
#weapon "tentacle"
#weapon "bile"
#ethereal
#holy
#cold
#iceprot 1
#blind
#fear 0
#itemslots 1
#maxage 15000
#noleader
#nomagicleader
#noundeadleader
#nametype 140
#end

#newmonster 2597
#name "Nihilist Cultist"
#spr1 "./Fthaqqua/ncultist1.tga"
#spr2 "./Fthaqqua/ncultist2.tga"
#descr "Nihilists are deros who actively work with and worship the Fthaqquao. They are led by cultists who are arguably even more disturbed than their brethren."
#ap 10
#mapmove 2
#hp 5
#prot 2
#size 1
#str 10
#enc 3
#att 9
#def 3
#prec 10
#mr 16
#mor 30
#insane 1
#berserk 6
#magicskill 8 1
#gcost 60
#rcost 10
#weapon "Magic Staff"
#eyes 2
#holy
#darkvision 50
#maxage 60
#itemslots 15494
#pillagebonus 1
#poorleader
#nomagicleader
#noundeadleader
#nametype 140
#end

#newmonster 2614
#name "Dero Warlock"
#spr1 "./Fthaqqua/warlock1.tga"
#spr2 "./Fthaqqua/warlock2.tga"
#descr "With the coming of the F'thaggua, most Dero with magical ability have either been exterminated or transformed, and are even, compared to the other Dero, relatively sane. Apparently at random (but who holds council with the Great Death?) very few go untouched by the Great Death. It's believed by some that these Dero, possessing natural magic, are the true anchors which link the F'thaggua to this world, and were they all exterminated, the F'thaggua would be banished with their passing."
#ap 10
#mapmove 2
#hp 6
#prot 3
#size 1
#str 9
#enc 3
#att 9
#def 6
#prec 10
#mr 17
#mor 15
#magicskill 4 1
#gcost 125
#rcost 10
#weapon "Magic Staff"
#eyes 2
#holy
#darkvision 50
#maxage 90
#itemslots 15494
#pillagebonus 1
#poorleader
#nomagicleader
#noundeadleader
#nametype 131
#end


#newmonster 2609
#name "Stoneface"
#spr1 "./Fthaqqua/slayer1.tga"
#spr2 "./Fthaqqua/slayer2.tga"
#descr "Stonefaces are the most elite destroyers among the Fthaqqua cult of death. Totally without mercy or pity or fear, they are killers to the core, who the Great Death itself has begun to take an interest in."
#ap 12
#mapmove 2
#hp 8
#prot 3
#size 1
#str 12
#enc 1
#att 13
#def 6
#prec 10
#mr 16
#mor 30
#berserk 3
#eyes 2
#darkvision 50
#holy
#magicskill 8 1
#gcost 90
#rcost 2
#weapon "Crimson Dagger" 
#weapon "Crimson Dagger" 
#regeneration 5
#ambidextrous
#stealth 2
#assassin
#itemslots 15494
#maxage 60
#pillagebonus 1
#poorleader
#nomagicleader
#noundeadleader
#nametype 140
#end

#newmonster 2598
#name "Deathshead"
#spr1 "./Fthaqqua/deathshead1.tga"
#spr2 "./Fthaqqua/deathshead2.tga"
#descr "Deathsheads are experienced Stoneface assassins and warriors who have proven themselves to the Great Death time and time again. "Favored" by the Great Death, their minds and bodies have been altered, making them even deadlier and less human than they were."
#ap 15
#mapmove 3
#hp 15
#prot 12
#size 1
#str 15
#enc 0
#att 15
#def 15
#prec 10
#mr 16
#mor 30
#berserk 3
#blind
#holy
#magicskill 8 1
#gcost 150
#rcost 5
#weapon "Crimson Saber" 
#weapon 271
#weapon 251 
#regeneration 5
#heal
#ambidextrous
#stealth 0
#assassin
#itemslots 15494
#maxage 60
#pillagebonus 1
#poorleader
#nomagicleader
#noundeadleader
#nametype 140
#end

#newmonster 2606
#name "Deathshead Warlock"
#spr1 "./Fthaqqua/deathwar.tga"
#spr2 "./Fthaqqua/deathwar2.tga"
#descr "Some Deathsheads, "favored" above others by the Great Death, have been granted the gift of magic, at the cost of hideous transformation of their bodies into great mounds of putrid flesh, corrupted and mutated by the Fthaqqua. Deathshead Warlocks are perhaps at once both their greatest glory and the greatest crime. In earlier ages the Dero were masters of many disciplines of magic, but the Fthaqqua fed on this magic and those who practiced it's discipline, until nothing remained. They have now returned magic to the Dero nation, but only in the form of wild magic, housed in the flabby bodies and distended brains of these vast, grotesque slugs."
#ap 10
#mapmove 0
#hp 30
#prot 10
#size 3
#str 12
#enc 1
#att 9
#def 9
#prec 14
#mr 16
#mor 30
#berserk 1
#research 4
#eyes 2
#holy
#magicskill 0 1
#magicskill 1 1
#magicskill 2 1
#magicskill 3 1
#magicskill 4 2
#gcost 600
#regeneration 10
#heal
#rcost 5
#weapon 63
#itemslots 12288
#maxage 60
#poorleader
#poormagicleader
#poorundeadleader
#nametype 117
#end

#newmonster 2607
#name "Uluddha the Unbound"
#spr1 "./Fthaqqua/Uluddha1.tga"
#spr2 "./Fthaqqua/Uluddha2.tga"
#descr "Uluddha was the Dero warlock who concieved and ultimately presided over the ritual that brought the Great Death into this world. The Fthaqqua gifted Uluddha beyond all others, transforming her body, mind, and spirit into a monster beyond all recognition."
#ap 10
#mapmove 0
#hp 90
#prot 15
#size 6
#str 25
#enc 0
#att 12
#def 9
#prec 15
#mr 21
#mor 30
#research 9
#holy
#blind
#etherial
#regeneration 10
#heal
#female
#magicskill 0 2
#magicskill 1 2
#magicskill 2 2
#magicskill 3 2
#magicskill 4 4
#magicskill 7 3
#magicskill 8 3
#gcost 1
#rcost 5
#weapon 63
#itemslots 12288
#maxage 15000
#poorleader
#poormagicleader
#poorundeadleader
#nametype 117
#end


#newmonster 2599
#name "Slayer Lord"
#spr1 "./Fthaqqua/slayerlo1.tga"
#spr2 "./Fthaqqua/slayerlo2.tga"
#descr "Deathsheads are the most elite destroyers among the Fthaqqua cult of death. Totally without mercy or pity or fear, they are killers to the core. They are led by Slayer Lords-dark disciples of the Fthaqqua, and the champions of death."
#ap 15
#mapmove 3
#hp 30
#prot 15
#size 1
#str 13
#enc 1
#att 13
#def 6
#prec 10
#mr 18
#mor 30
#berserk 5
#eyes 2
#darkvision 50
#holy
#magicskill 8 1
#gcost 250
#rcost 10
#weapon "Crimson Glaive" 
#weapon 271 
#weapon 251
#ambidextrous
#stealth 0
#assassin
#regeneration 20
#heal
#itemslots 15494
#maxage 60
#pillagebonus 1
#poorleader
#nomagicleader
#noundeadleader
#nametype 140
#end

#newmonster 2600
#name "Dero Sniper"
#spr1 "./Fthaqqua/deroarc1.tga"
#spr2 "./Fthaqqua/deroarc2.tga"
#descr "Deros, though insane, are also very skilled weaponsmiths-a trait they inherited from their dwarf ancestors. Deros have the ability to forge a crimson metal into deadly weapons which age and sicken those struck by them."
#ap 15
#mapmove 2
#hp 5
#prot 3
#size 1
#str 9
#enc 1
#att 8
#def 6
#prec 12
#mr 15
#mor 30
#berserk 3
#eyes 2
#darkvision 50
#holy
#gcost 30
#rcost 3
#weapon "Crimson Bow" 
#weapon "dagger"
#weapon "dagger"
#ambidextrous
#itemslots 15494
#maxage 60
#pillagebonus 1
#poorleader
#nomagicleader
#noundeadleader
#nametype 140
#end

#newmonster 2601
#name "Interdimensional Appendage"
#spr1 "./Fthaqqua/indesc1.tga"
#spr2 "./Fthaqqua/indesc2.tga"
#descr "The appendage of an unimaginable abomination, brought forth from beyond the furthest depths of the Earth."
#ap 10
#mapmove 1
#hp 90
#prot 15
#size 6
#str 30
#enc 0
#att 18
#def 6
#prec 3
#mr 30
#mor 50
#gcost 1
#rcost 1
#weapon 829
#weapon 63
#weapon 63
#weapon 63
#poisonres 100
#coldres 100
#shockres 100
#fireres 100
#blind
#siege 30
#ethereal
#immortal
#regenerate 5
#holy
#stealthy 0
#itemslots 1
#assassin
#fear 5
#maxage 15000
#noleader
#nomagicleader
#noundeadleader
#nametype 140
#end

#newmonster 2604
#name "Nihilist Assassin"
#spr1 "./Fthaqqua/nihilassa1.tga"
#spr2 "./Fthaqqua/nihilassa2.tga"
#descr "Not all dero are homicidal maniacs-some are just pathologically suicidal. Highly volatile chemicals are strapped to these depressing Dero so that they may live short, glorious lives, and not be around long enough to bring the other Dero down."
#ap 16
#mapmove 2
#hp 5
#prot 1
#size 1
#str 9
#enc 1
#att 12
#def 6
#prec 14
#mr 15
#mor 99
#berserk 3
#eyes 2
#darkvision 50
#holy
#gcost 30
#rcost 5
#weapon "alchemical explosion"
#ambidextrous
#itemslots 15494
#maxage 60
#pillagebonus 1
#noleader
#nomagicleader
#noundeadleader
#nametype 140
#end

#newmonster 2605
#name "Manes"
#spr1 "./Fthaqqua/Manes1.tga"
#spr2 "./Fthaqqua/Manes2.tga"
#descr "A Manes is created when a traitorous Dero has been slain by the lifedrain attack of a Fthaqqua. Dero loathe undead-they consider any extension of life after death to be blasphemous, and so this is the absolute worst sentence that can be handed down to a criminal-considered far worse than death by most Dero. Unfortunately, it's rather liberally applied in the uber-paranoid Dero society. A horrific wraith is thus created, and used as a tool of war."
#ap 15
#mapmove 2
#hp 5
#prot 15
#size 1
#str 10
#enc 0
#att 10
#def 10
#prec 6
#mr 15
#mor 50
#gcost 1
#rcost 1
#weapon "lifedrain"
#undead
#etherial
#blind
#stealth 5
#neednoteat
#coldres 300
#poisonres 300
#fireres 300
#shockres 300
#itemslots 15494
#maxage 1000
#noleader
#nomagicleader
#noundeadleader
#nametype 105
#end

#newmonster 2608
#name "The Faceless Man"
#spr1 "./Fthaqqua/grdeath1.tga"
#spr2 "./Fthaqqua/grdeath2.tga"
#descr "Noone knows the origin of the Faceless Man. All that is known is that he is a very powerful priest and mage held in high regard by the Great Death, and that he is a master of illusions. He literally has no face, appearing as just a featureless ruddy-skinned, nude human male. Although his appearance is not particularly frightening, he has the ability to radiate absolute menace and infinite horror."
#ap 15
#mapmove 3
#hp 30
#prot 15
#size 2
#str 10
#enc 0
#att 10
#def 25
#prec 15
#mr 20
#mor 30
#research 1
#holy
#blind
#etherial
#glamour
#stealth 5
#fly
#fear 15
#magicskill 4 2
#magicskill 5 1
#magicskill 7 1
#magicskill 8 3
#gcost 1
#rcost 5
#weapon "lifedrain"
#itemslots 15494
#maxage 15000
#goodleader
#okmagicleader
#okundeadleader
#nametype 140
#end

#newmonster 2612
#name "Drifting Horror"
#spr1 "./Fthaqqua/floatinghorror.tga"
#spr2 "./Fthaqqua/floatinghorror2.tga"
#descr "Tentacles in the night...tentacles and too many...hungry...mouths."
#ap 12
#mapmove 2
#hp 40
#prot 12
#size 5
#str 20
#enc 0
#att 10
#def 5
#prec 3
#mr 12
#mor 50
#gcost 1
#rcost 1
#weapon 85
#weapon 85
#weapon 85
#weapon 825
#poisonres 100
#coldres 50
#shockres 25
#blind
#ethereal
#immortal
#regenerate 10
#holy
#stealthy 0
#itemslots 1
#assassin
#fear 0
#flying
#maxage 15000
#noleader
#nomagicleader
#noundeadleader
#nametype 140
#end

#newmonster 2613
#name "Yibbith Star-Strangler"
#spr1 "./Fthaqqua/Yibbith1.tga"
#spr2 "./Fthaqqua/Yibbith2.tga"
#descr "Beyond the veils of night lie hungry things with too many mouths and no description-Yibbith is mighty and feared among them."
#ap 12
#mapmove 2
#hp 125
#prot 12
#size 6
#str 25
#enc 0
#att 12
#def 9
#prec 3
#mr 22
#mor 50
#gcost 1
#rcost 1
#weapon 826
#weapon 826
#weapon 826
#weapon 825
#poisonres 100
#coldres 50
#shockres 25
#blind
#ethereal
#immortal
#regenerate 10
#holy
#stealthy 0
#itemslots 1
#assassin
#fear 0
#flying
#maxage 15000
#noleader
#nomagicleader
#noundeadleader
#end



-- Spell Data
#newspell
#name "Fthaqqua"
#descr "This ritual opens a tiny hole in the fabric of reality, calling out to a Fthaqqua, and allowing it to enter our world."
#restricted 73
#school 5
#researchlevel 0
#path 0 4
#pathlevel 0 1
#effect 10021
#fatiguecost 600
#damage 2582
#nreff 1
#end

#newspell
#name "Star Hound"
#descr "This ritual sends an irresistable call through time and space, summoning a Star Hound to the hunt."
#restricted 73
#school 5
#researchlevel 2
#path 0 4
#pathlevel 0 2
#effect 10021
#fatiguecost 1200
#damage 2584
#nreff 1
#end

#newspell
#name "Manes"
#descr "The ritualized execution of several traitorous Dero, by having their souls devoured by the Fthaqqua, and then reincorporated through the use of death magic."
#restricted 73
#school 1
#researchlevel 4
#path 0 4
#path 1 5
#pathlevel 0 2
#pathlevel 1 2
#effect 10001
#fatiguecost 1200
#damage 2605
#nreff 6
#end

#newspell
#name "Bale"
#descr "This unholy ritual desecrates a portion of the world, causing it to fall out of dimensional sync with the surrounding area and allowing a Bale Seed to be planted. A Bale will grow unnaturally fast from this seed as it sucks a portion of the life-force of the world itself."
#restricted 73
#school 5
#researchlevel 0
#path 0 4
#pathlevel 0 1
#effect 10021
#fatiguecost 6000
#damage 2589
#nreff 1
#end

#newspell
#name "Phase Spider"
#descr "This spell creates a portal to the Shadow Dimension, summoning from it a deadly Phase Spider."
#restricted 73
#school 5
#researchlevel 2
#path 0 4
#pathlevel 0 2
#effect 10021
#fatiguecost 900
#damage 2591
#nreff 1
#end

#newspell
#name "Drifting Horror"
#descr "This spell creates an opening through the floor of the night. Through the opening created floats a tentacled horror."
#restricted 73
#school 5
#researchlevel 4
#path 0 4
#pathlevel 0 4
#effect 10021
#fatiguecost 1200
#damage 2612
#nreff 1
#end


#newspell
#name "Squiggoth"
#descr "This spell opens a hole into the Dimension of Pain, allowing a Squiggoth to slither through."
#restricted 73
#school 5
#researchlevel 6
#path 0 4
#pathlevel 0 2
#effect 10021
#fatiguecost 2400
#damage 2585
#nreff 1
#end

#newspell
#name "Derleth"
#descr "This ritual invites a Derleth to bring a single aspect of it's being into our dimension."
#restricted 73
#school 5
#researchlevel 3
#path 0 4
#pathlevel 0 3
#effect 10021
#fatiguecost 900
#damage 2588
#nreff 1
#end

#newspell
#name "Reaper"
#descr "Out of that which is not, and should never be, this ritual allows something awful to be born."
#restricted 73
#school 5
#researchlevel 5
#path 0 4
#pathlevel 0 4
#effect 10021
#fatiguecost 1800
#damage 2586
#nreff 1
#end

#newspell
#name "Xokkoth"
#descr "This unspeakable ritual summons a Xokkoth from the end of time."
#restricted 73
#school 5
#researchlevel 6
#path 0 4
#pathlevel 0 4
#effect 10021
#fatiguecost 6000
#damage 2587
#nreff 1
#end

#newspell
#name "Screamer"
#descr "This spell grotesquely transforms tiny beasts and insects into ravenous things best left unexamined."
#restricted 73
#school 5
#researchlevel 0
#path 0 4
#pathlevel 0 1
#effect 10001
#fatiguecost 600
#damage 2590
#nreff 12
#end

#newspell
#name "Dholg"
#descr "This ritual is the means by which the Xokkoth reproduce themselves. It is horrible beyond explanation, but the end result is a Dholg mound."
#restricted 73
#school 5
#researchlevel 4
#path 0 4
#pathlevel 0 4
#effect 10021
#fatiguecost 1800
#damage 2594
#nreff 1
#end

#newspell
#name "Nhorl"
#descr "This spell calls a pair of immature Xokkoth, Nhorls, from their sleep deep inside a Dholg mound."
#restricted 73
#school 5
#researchlevel 1
#path 0 4
#pathlevel 0 1
#effect 10001
#fatiguecost 600
#damage 2591
#nreff 2
#end

#newspell
#name "Evercold"
#descr "This spell is the culmination of a long process of torture, murder, desanguination, and reanimation, as several unfortunate souls are transformed into Evercolds."
#restricted 73
#school 5
#researchlevel 0
#path 0 4
#pathlevel 0 2
#effect 10001
#fatiguecost 600
#damage 2583
#nreff 3
#end

#newspell
#name "Interdimensional Appendage"
#descr "This dark rite attracts the attention of an abomination beyond imagining, which sends one of it's infinite tentacles to mindlessly probe into our world."
#restricted 73
#school 5
#researchlevel 7
#path 0 4
#pathlevel 0 4
#effect 10021
#fatiguecost 7500
#damage 2601
#nreff 1
#end

-- Nation Data

#selectnation 73
#name "Fthaqqua"
#epithet "Cult of Fthaqqua"
#era 3
#descr "From out of depths of space and time, dimensions unimaginable, comes the Great Death and it's hordes, bent on the destruction of all magic, all hope, all life in the universe."
#summary "Race: Deros.  Military: Psychos and aliens.  Magic: Astral only, weak.  Priests: Weak. Fthaqqua eat astral gems, because they're the essence of all other magic. You're going to want to use Empowerment with this nation more than any other, because you have no easy paths to magic."
#brief "SPACE!...space...space...VAMPIRES!...vampires...vampires"
#flag "./Fthaqqua/Fthaqqua_icon.tga"
#color 0.92 0.8 0.45
#idealcold 3

#clearrec

#addrecunit "Dero Nihilist" 2596
#addrecunit "Dero Sniper" 2600
#addrecunit "Deathshead" 2598
#addrecunit "Dero Guard" 2603
#addrecunit "Nihilist Assassin" 2604
#addrecunit "Dero Maniac" 2610
#addrecunit "Stoneface" 2609

#addreccom "Nihilist Cultist" 2597
#addreccom "Slayer Lord" 2599
#addreccom "Deathshead Warlock" 2606
#addreccom "Dero Warlock" 2614

#defcom1 2597
#defcom2 2599
#defunit1 2596
#defunit1b 2610
#defunit2 2600
#defunit2b 2609
#defmult1 10
#defmult1b 10
#defmult2 10
#defmult2b 10

#multihero1 2611
#hero1 2607
#hero2 2608
#hero3 2613
#hero4 2615


#startcom "Nihilist Cultist" 2597
#startscout "Nihilist Cultist" 2597

#idealcold 3
#startsite "ancient temple"
#sacrificedom

#templepic 13

#startfort 42
#defaultfort 1
#farmfort 7
#mountainfort 36
#forestfort 33
#swampfort 11

#end

