-- Necropolis mod for Dominions III, version 1.1
-- Created by Edward Vaughn - Adapted to Dominions 3 by Sombre



--- Uses nation number: 		78
--- Uses monster numbers:		2708-2742
--- Uses site numbers: 			973, 974
--- Uses weapon numbers: 		780-5
--- Uses armour numbers: 		330-5
--- Uses nametype number: 		147



-- MODIFICATION CODE

-- General Mod Data

#modname "Necropolis"
#description "Adds the new Late Era nation of Necropolis to the game."
#icon "./necro/banner.tga"
#version 1.20



------ New Armour


#newarmor 330
#name "Necropolitain Gaiter"
#type 6
#def 0
#prot 1
#enc 0
#rcost 1
#end

#newarmor 331
#name "Necropolitain Greaves"
#type 5
#def 1
#prot 3
#enc 0
#rcost 2
#end

#newarmor 332
#name "Necropolitain Headdress"
#type 6
#def 0
#prot 2
#enc 1
#rcost 1
#end

#newarmor 333
#name "Necropolitain Hauberk"
#type 5
#def 0
#prot 6
#enc 1
#rcost 3
#end

#newarmor 334
#name "Full Necropolitain Armor"
#type 5
#def 0
#prot 8
#enc 1
#rcost 5
#end

#newarmor 335
#name "Winged Necropolitain Headdress"
#type 6
#def 0
#prot 3
#enc 2
#rcost 2
#end



------ New Weapons


#newweapon 780
#name "Khopesh"
#att 1
#def 0
#dmg 7
#len 2
#sound 8
#rcost 5
#end

#newweapon 781
#name "Spectral Sceptre"
#att 0
#def 1
#dmg 2
#len 1
#sound 10
#magic
#rcost 1
#end

#newweapon 782
#name "Sun Bow"
#aoe 2
#att 4
#def 0
#dmg 12
#len 2
#range 45
#ammo 12
#magic
#nostr
#nratt 1
#twohanded
#sound 14
#flyspr 350 4
#armorpiercing
#secondaryeffectalways 171
#rcost 8
#end

#newweapon 783
#name "Cursed Blade of the Everdying"
#att 1
#def 1
#dmg 9
#len 2
#aoe 1
#magic
#explspr 10200
#secondaryeffect 64
#sound 8
#rcost 8
#end

#newweapon 784
#name "The Long Death"
#att 1
#def 1
#dmg 12
#len 3
#aoe 1
#magic
#explspr 10200
#secondaryeffect 64
#sound 8
#rcost 8
#end

#newweapon 785
#name "Spectral Khopesh"
#att 0
#def 0
#dmg 5
#len 2
#sound 10
#magic
#rcost 1
#end



-- Name Data

#selectnametype 147
#clear
#addname "Abda"
#addname "Abdel"
#addname "Abdul"
#addname "Adib"
#addname "Afdal"
#addname "Ahmac"
#addname "Ahmad"
#addname "Ahsan"
#addname "Akram"
#addname "Amonabda"
#addname "Amonabdel"
#addname "Amonadib"
#addname "Amonafdal"
#addname "Amonahmac"
#addname "Amonahmad"
#addname "Amonahsan"
#addname "Amonakram"
#addname "Amonanakh"
#addname "Amonansan"
#addname "Amonarrat"
#addname "Amonbahar"
#addname "Amonbasam"
#addname "Amondahab"
#addname "Amondjmal"
#addname "Amonfaruk"
#addname "Amonfarza"
#addname "Amonfawza"
#addname "Amonfet"
#addname "Amonhafiz"
#addname "Amonhaij"
#addname "Amonharrad"
#addname "Amonhashim"
#addname "Amonhotep"
#addname "Amonigbal"
#addname "Amoniget"
#addname "Amonikkad"
#addname "Amonkamal"
#addname "Amonkarim"
#addname "Amonladgul"
#addname "Amonlalot"
#addname "Amonmadjid"
#addname "Amonmeneka"
#addname "Amonmusa"
#addname "Amonmadim"
#addname "Amonnadin"
#addname "Amonnajib"
#addname "Amonnassar"
#addname "Amonobat"
#addname "Amonosma"
#addname "Amonrafi"
#addname "Amonsaffa"
#addname "Amonsanep"
#addname "Amonset"
#addname "Amonsharrat"
#addname "Amontepun"
#addname "Amonyahya"
#addname "Amonhad"
#addname "Amonthul"
#addname "Amonket"
#addname "Anakh"
#addname "Ansan"
#addname "Arcotep"
#addname "Arrat"
#addname "Ashraf"
#addname "Bahar"
#addname "Benul"
#addname "Carnac"
#addname "Candar"
#addname "Basam"
#addname "Boutro"
#addname "Dahab"
#addname "Djmal"
#addname "Fadoul"
#addname "Faisal"
#addname "Faruk"
#addname "Farza"
#addname "Fawza"
#addname "Fet"
#addname "Hafiz"
#addname "Haij"
#addname "Harrad"
#addname "Hashim"
#addname "Hotep"
#addname "Hotomen"
#addname "Igbal"
#addname "Iget"
#addname "Ikkad"
#addname "Imhotep"
#addname "Izzkat"
#addname "Kamal"
#addname "Karim"
#addname "Kartoum"
#addname "Ladgul"
#addname "Lalot"
#addname "Lokat"
#addname "Madjid"
#addname "Mamoman"
#addname "Meneka"
#addname "Musa"
#addname "Nadim"
#addname "Nadin"
#addname "Najib"
#addname "Nassar"
#addname "Nerul"
#addname "Obat"
#addname "Osma"
#addname "Pharot"
#addname "Quamar"
#addname "Rafi"
#addname "Ran"
#addname "Rashid"
#addname "Rishid"
#addname "Saffa"
#addname "Sanep"
#addname "Set"
#addname "Seth"
#addname "Seti"
#addname "Shaddar"
#addname "Shamotep"
#addname "Sharrat"
#addname "Shayu'un"
#addname "Tepun"
#addname "Thebe"
#addname "Thul"
#addname "Tutanka"
#addname "Wassif"
#addname "Yahya"
#addname "Yanhotep"
#end



------- New Monsters


---- Ethereal Solider

#newmonster 2708
#name "Ethereal Soldier"
#spr1 "./necro/misc_etherealsoldier1.tga"
#spr2 "./necro/misc_etherealsoldier2.tga"
#descr "A member of the battle line who has been slain in combat but not completely destroyed continues to serve Necropolis in this ethereal form.  Compared with the ancient ethereal judges, this being is relatively unused to its ghostly state and lacks the martial prowess it once enjoyed in life.  It attacks with a paralyzing grip and instills fear in the enemy.  Knowing that death is no barrier, ethereal Necropolitains are virtually fearless."
#ap 12
#mapmove 2
#hp 6
#prot 3
#size 2
#str 10
#enc 3
#att 8
#def 8
#prec 10
#mr 12
#mor 18
#gcost 0
#rcost 0
#weapon "Paralyze"
#ethereal
#pooramphibian
#magicbeing
#neednoteat
#poorleader
#poormagicleader
#noundeadleader
#nametype 147
#maxage 400
#end

---- Ethereal Scout

#newmonster 2709
#name "Ethereal Scout"
#spr1 "./necro/misc_etherealspy1.tga"
#spr2 "./necro/misc_etherealspy2.tga"
#descr "An Agent or Old Hand who is killed or decays, but is not entirely destroyed will continue to serve as an Ethereal Scout.  However, being unaccustomed to this form its abilities in spying and sneaking are not as potent as they once were.  Ethereal Scouts can gain limited knowledge about foreign lands."
#ap 12
#mapmove 2
#hp 6
#prot 0
#size 2
#str 10
#enc 3
#att 8
#def 8
#prec 10
#mr 12
#mor 18
#gcost 0
#rcost 0
#weapon "Paralyze"
#stealthy 5
#ethereal
#pooramphibian
#magicbeing
#neednoteat
#noleader
#nomagicleader
#noundeadleader
#nametype 147
#maxage 400
#end


---- Ethereal Commander

#newmonster 2710
#name "Ethereal Commander"
#spr1 "./necro/misc_etherealcommander1.tga"
#spr2 "./necro/misc_etherealcommander2.tga"
#descr "When a living or purgator general is slain in battle, should he survive total destruction, he will rise again into the service of the city as an Ethereal Commander.  Unlike lesser battle-born ethereals, commanders still have the power to wield weapons and magic items.  Their leadership abilities and combat prowess are reduced, however, as a result of the sudden change of form.  They can still lead a small number of purgator or ethereal troops."
#ap 12
#mapmove 2
#hp 9
#prot 5
#size 2
#str 10
#enc 3
#att 10
#def 10
#prec 10
#mr 12
#mor 18
#gcost 0
#rcost 0
#weapon 785
#ethereal
#pooramphibian
#magicbeing
#neednoteat
#poorleader
#okmagicleader
#noundeadleader
#nametype 147
#maxage 400
#end


---- Ethereal Priest


#newmonster 2711
#name "Ethereal Priest"
#spr1 "./necro/misc_etherealpriest1.tga"
#spr2 "./necro/misc_etherealpriest2.tga"
#descr "The priests of Necropolis know quite well that death is not a serious barrier.  Indeed, the central ritual in the Necropolitain cult is the ritual suicide of temple acolytes in order to increase their power.  If a priest dies in battle, he may continue to serve in an ethereal form, but with reduced potency and influence.  These Ethereal Priests can, however, lead a number of purgators or ethereals."
#ap 12
#mapmove 2
#hp 6
#prot 0
#size 2
#str 10
#enc 3
#att 8
#def 8
#prec 10
#mr 12
#mor 18
#gcost 0
#rcost 0
#weapon "Paralyze"
#clearmagic
#magicskill 8 1
#holy
#ethereal
#pooramphibian
#magicbeing
#neednoteat
#poorleader
#okmagicleader
#noundeadleader
#nametype 147
#maxage 400
#end

(Terrified Ethereal >> Ethereal Soldier)

#newmonster 2712
#name "Terrified Ethereal"
#spr1 "./necro/misc_ethereal1.tga"
#spr2 "./necro/misc_ethereal2.tga"
#descr "Death in battle is not the end for a Necropolitain.  A purgator seeks the descruction of its body as a release from the sickening corporeal form.  When a purgator falls in combat, the wrecked warrior immediately springs back into the fight as an ethereal spirit.  The transition, however, is violent and sudden and the ghosts are usually terrified.  If they survive the battle, they will continue to serve in an ethereal form."
#ap 12
#mapmove 1
#hp 6
#prot 0
#size 2
#str 10
#enc 3
#att 8
#def 8
#prec 10
#mr 12
#mor 10
#gcost 120
#rcost 1
#weapon "Paralyze"
#ethereal
#pooramphibian
#magicbeing
#neednoteat
#noleader
#nomagicleader
#noundeadleader
#firstshape 2708
#nametype 147
#maxage 400
#end

(Terrified Ethereal >> Ethereal Spy)

#newmonster 2713
#name "Terrified Ethereal"
#spr1 "./necro/misc_ethereal1.tga"
#spr2 "./necro/misc_ethereal2.tga"
#descr "Death in battle is not the end for a Necropolitain.  A purgator seeks the descruction of its body as a release from the sickening corporeal form.  When a purgator falls in combat, the wrecked warrior immediately springs back into the fight as an ethereal spirit.  The transition, however, is violent and sudden and the ghosts are usually terrified.  If they survive the battle, they will continue to serve in an ethereal form."
#ap 12
#mapmove 1
#hp 6
#prot 0
#size 2
#str 10
#enc 3
#att 8
#def 8
#prec 10
#mr 12
#mor 10
#gcost 120
#rcost 1
#weapon "Paralyze"
#ethereal
#pooramphibian
#magicbeing
#neednoteat
#noleader
#nomagicleader
#noundeadleader
#firstshape 2709
#nametype 147
#maxage 400
#end

(Terrified Ethereal >> Ethereal Commander)

#newmonster 2714
#name "Terrified Ethereal"
#spr1 "./necro/misc_ethereal1.tga"
#spr2 "./necro/misc_ethereal2.tga"
#descr "Death in battle is not the end for a Necropolitain.  A purgator seeks the descruction of its body as a release from the sickening corporeal form.  When a purgator falls in combat, the wrecked warrior immediately springs back into the fight as an ethereal spirit.  The transition, however, is violent and sudden and the ghosts are usually terrified.  If they survive the battle, they will continue to serve in an ethereal form."
#ap 12
#mapmove 1
#hp 6
#prot 0
#size 2
#str 10
#enc 3
#att 8
#def 8
#prec 10
#mr 12
#mor 10
#gcost 120
#rcost 1
#weapon "Paralyze"
#ethereal
#pooramphibian
#magicbeing
#neednoteat
#noleader
#nomagicleader
#noundeadleader
#firstshape 2710
#nametype 147
#maxage 400
#end

(Terrified Ethereal >> Ethereal Priest)

#newmonster 2715
#name "Terrified Ethereal"
#spr1 "./necro/misc_ethereal1.tga"
#spr2 "./necro/misc_ethereal2.tga"
#descr "Death in battle is not the end for a Necropolitain.  A purgator seeks the descruction of its body as a release from the sickening corporeal form.  When a purgator falls in combat, the wrecked warrior immediately springs back into the fight as an ethereal spirit.  The transition, however, is violent and sudden and the ghosts are usually terrified.  If they survive the battle, they will continue to serve in an ethereal form."
#ap 12
#mapmove 1
#hp 6
#prot 0
#size 2
#str 10
#enc 3
#att 8
#def 8
#prec 10
#mr 12
#mor 10
#gcost 120
#rcost 1
#weapon "Paralyze"
#ethereal
#pooramphibian
#magicbeing
#neednoteat
#noleader
#nomagicleader
#noundeadleader
#firstshape 2711
#nametype 147
#maxage 400
#end

(Slain >> Ethereal Soldier)

#newmonster 2716
#name "Slain"
#spr1 "./necro/misc_slain.tga"
#descr "Death in battle is not the end for a Necropolitain.  When the body is so damaged that it no longer lives, the soul keeps it animated.  This is the broken form of a Necropolitain or purgator killed in combat.  It continues to fight by crawling disturbingly across the field, but is severely damaged and will strike fear in weak-minded foes.  If the Slain survives this battle its flesh will slough off in the coming weeks and it will continue to serve the city in an ethereal form."
#ap 8
#mapmove 1
#hp 5
#prot 0
#size 1
#str 7
#enc 3
#att 10
#def 10
#prec 10
#mr 12
#mor 25
#gcost 0
#rcost 0
#weapon 29
#weapon 29
#inanimate
#pooramphibian
#magicbeing
#neednoteat
#poisonres 100
#noheal
#noleader
#nomagicleader
#noundeadleader
#firstshape 2708
#secondshape 2712
#nametype 147
#maxage 400
#end

(Slain >> Ethereal Spy)

#newmonster 2717
#name "Slain"
#spr1 "./necro/misc_slain.tga"
#descr "Death in battle is not the end for a Necropolitain.  When the body is so damaged that it no longer lives, the soul keeps it animated.  This is the broken form of a Necropolitain or purgator killed in combat.  It continues to fight by crawling disturbingly across the field, but is severely damaged and will strike fear in weak-minded foes.  If the Slain survives this battle its flesh will slough off in the coming weeks and it will continue to serve the city in an ethereal form."
#ap 8
#mapmove 1
#hp 5
#prot 0
#size 1
#str 7
#enc 3
#att 10
#def 10
#prec 10
#mr 12
#mor 25
#gcost 0
#rcost 0
#weapon 29
#weapon 29
#inanimate
#pooramphibian
#magicbeing
#neednoteat
#poisonres 100
#noheal
#noleader
#nomagicleader
#noundeadleader
#firstshape 2709
#secondshape 2713
#nametype 147
#maxage 400
#end

(Slain >> Ethereal Commander)

#newmonster 2718
#name "Slain"
#spr1 "./necro/misc_slain.tga"
#descr "Death in battle is not the end for a Necropolitain.  When the body is so damaged that it no longer lives, the soul keeps it animated.  This is the broken form of a Necropolitain or purgator killed in combat.  It continues to fight by crawling disturbingly across the field, but is severely damaged and will strike fear in weak-minded foes.  If the Slain survives this battle its flesh will slough off in the coming weeks and it will continue to serve the city in an ethereal form."
#ap 8
#mapmove 1
#hp 5
#prot 0
#size 1
#str 7
#enc 3
#att 10
#def 10
#prec 10
#mr 12
#mor 25
#gcost 0
#rcost 0
#weapon 29
#weapon 29
#inanimate
#pooramphibian
#magicbeing
#neednoteat
#poisonres 100
#noheal
#noleader
#nomagicleader
#noundeadleader
#firstshape 2710
#secondshape 2714
#nametype 147
#maxage 400
#end

(Slain >> Ethereal Priest)

#newmonster 2719
#name "Slain"
#spr1 "./necro/misc_slain.tga"
#descr "Death in battle is not the end for a Necropolitain.  When the body is so damaged that it no longer lives, the soul keeps it animated.  This is the broken form of a Necropolitain or purgator killed in combat.  It continues to fight by crawling disturbingly across the field, but is severely damaged and will strike fear in weak-minded foes.  If the Slain survives this battle its flesh will slough off in the coming weeks and it will continue to serve the city in an ethereal form."
#ap 8
#mapmove 1
#hp 5
#prot 0
#size 1
#str 7
#enc 3
#att 10
#def 10
#prec 10
#mr 12
#mor 25
#gcost 0
#rcost 0
#weapon 29
#weapon 29
#inanimate
#pooramphibian
#magicbeing
#neednoteat
#poisonres 100
#noheal
#noleader
#nomagicleader
#noundeadleader
#firstshape 2711
#secondshape 2715
#nametype 147
#maxage 400
#end


---- Necro Spearman


#newmonster 2720
#name "Necropolitain Spearman"
#spr1 "./necro/recruit_spear1.tga"
#spr2 "./necro/recruit_spear2.tga"
#descr "The living armies of Necropolis are not very different from those of other nations.  The basic infantrymen are lightly armed and armored.  The climate and traditions of Necropolis preclude heavy suits of chain or plate and most soldiers wear only gilded gauntlets and greaves.  Armed with a spear and or javelins, these are units of limited potential."
#ap 12
#mapmove 2
#hp 12
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 10
#prec 10
#mr 10
#mor 11
#gcost 9
#rcost 1
#weapon 1
#armor "Necropolitain Gaiter"
#armor "Necropolitain Greaves"
#okleader
#nomagicleader
#noundeadleader
#secondshape 2716
#nametype 147
#end

---- Necro Skirmisher

#newmonster 2721
#name "Necropolitain Skirmisher"
#spr1 "./necro/recruit_spearjav1.tga"
#spr2 "./necro/recruit_spearjav2.tga"
#descr "The living armies of Necropolis are not very different from those of other nations.  The basic infantrymen are lightly armed and armored.  The climate and traditions of Necropolis preclude heavy suits of chain or plate and most soldiers wear only gilded gauntlets and greaves.  Armed with a spear and or javelins, these are units of limited potential."
#ap 12
#mapmove 2
#hp 12
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 10
#prec 10
#mr 10
#mor 11
#gcost 9
#rcost 1
#weapon 1
#weapon 21
#armor "Necropolitain Gaiter"
#armor "Necropolitain Greaves"
#okleader
#nomagicleader
#noundeadleader
#secondshape 2716
#nametype 147
#end


---- Necro Archer


#newmonster 2722
#name "Necropolitain Archer"
#spr1 "./necro/recruit_archer1.tga"
#spr2 "./necro/recruit_archer2.tga"
#descr "The archers of Necropolis are armed with powerful composite bows and are decent, inexpensive missile troops.  They wear light armor like the rest of the living Necropolitain army."
#ap 12
#mapmove 2
#hp 12
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 10
#prec 10
#mr 10
#mor 11
#gcost 10
#rcost 1
#weapon 264
#weapon 9
#armor "Necropolitain Gaiter"
#armor "Necropolitain Greaves"
#okleader
#nomagicleader
#noundeadleader
#secondshape 2716
#nametype 147
#end


---- Necro Warder


#newmonster 2723
#name "Necropolitain Warder"
#spr1 "./necro/recruit_warder1.tga"
#spr2 "./necro/recruit_warder2.tga"
#descr "In ancient times, soldiers equipped with only a very large tower shield were sent into battle alongside the archers and given the duty of protecting them from enemy arrows.  These Warders are still part of the city's army, but fight now with gilded axes and smaller shields."
#ap 12
#mapmove 1
#hp 12
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 11
#prec 10
#mr 10
#mor 11
#gcost 10
#rcost 1
#weapon "Axe"
#armor "Necropolitain Gaiter"
#armor "Necropolitain Greaves"
#armor "Tower Shield"
#okleader
#nomagicleader
#noundeadleader
#secondshape 2716
#nametype 147
#end


---- City Guard


#newmonster 2724
#name "City Guard"
#spr1 "./necro/recruit_catguardaxe1.tga"
#spr2 "./necro/recruit_catguardaxe2.tga"
#descr "Within the grey walls of Necropolis itself, the guards of the city keep order and protect nobles.  They wear the green livery of the above-ground city.  As warriors, they are slightly more skilled than the regular infantry."
#ap 12
#mapmove 2
#hp 13
#prot 0
#size 2
#str 11
#enc 3
#att 11
#def 10
#prec 10
#mr 10
#mor 12
#gcost 12
#rcost 1
#weapon "Axe"
#armor "Necropolitain Headdress"
#armor "Necropolitain Greaves"
#armor "Shield"
#okleader
#nomagicleader
#noundeadleader
#secondshape 2716
#nametype 147
#end


---- City Guard


#newmonster 2725
#name "City Guard"
#spr1 "./necro/recruit_catguard1.tga"
#spr2 "./necro/recruit_catguard2.tga"
#descr "Within the grey walls of Necropolis itself, the guards of the city keep order and protect nobles.  They wear the green livery of the above-ground city and are armed with swords, a mark of martial distinction in Necropolitain society.  As warriors, they are slightly more skilled than the regular infantry."
#ap 12
#mapmove 2
#hp 13
#prot 0
#size 2
#str 11
#enc 3
#att 11
#def 10
#prec 10
#mr 10
#mor 12
#gcost 12
#rcost 1
#weapon 8
#armor "Necropolitain Headdress"
#armor "Necropolitain Greaves"
#okleader
#nomagicleader
#noundeadleader
#secondshape 2716
#nametype 147
#end


---- Catacombs Guard


#newmonster 2726
#name "Catacombs Guard"
#spr1 "./necro/recruit_cataguard1.tga"
#spr2 "./necro/recruit_cataguard2.tga"
#descr "The gates into the catacombs beneath Necropolis are kept safe by a regiment of dedicated living soldiers.  These Catacombs Guards wield a khopesh, a wicked curved blade of Necropolitain design, and are better armored than lesser troops."
#ap 12
#mapmove 2
#hp 13
#prot 0
#size 2
#str 12
#enc 3
#att 12
#def 12
#prec 10
#mr 11
#mor 13
#gcost 17
#rcost 1
#weapon 780
#armor "Necropolitain Headdress"
#armor "Necropolitain Hauberk"
#armor "Shield"
#okleader
#nomagicleader
#noundeadleader
#secondshape 2716
#nametype 147
#end


---- Sentinel


#newmonster 2727
#name "Sentinel"
#spr1 "./necro/recruit_sentinel1.tga"
#spr2 "./necro/recruit_sentinel2.tga"
#descr "Within the catacombs and underworld the purgators are the masters and regulators.  Catacombs Guards who have served their entire lives as warriors are promoted upon death.  Given the winged helm of the purgator military elite, they become the protectors of the darkness below."
#ap 12
#mapmove 1
#hp 12
#prot 0
#size 2
#str 10
#enc 3
#att 12
#def 13
#prec 10
#mr 12
#mor 17
#gcost 20
#rcost 1
#weapon 780
#armor "Winged Necropolitain Headdress"
#armor "Necropolitain Hauberk"
#armor "Shield"
#holy
#inanimate
#pooramphibian
#magicbeing
#neednoteat
#poisonres 100
#noheal
#okleader
#goodmagicleader
#noundeadleader
#secondshape 2716
#nametype 147
#maxage 400
#end


---- Agent


#newmonster 2728
#name "Agent"
#spr1 "./necro/commander_agent1.tga"
#spr2 "./necro/commander_agent2.tga"
#descr "Able to move across the countryside undetected, Agents of the city serve as scouts and spies for the armies."
#ap 12
#mapmove 2
#hp 12
#prot 0
#size 2
#str 10
#enc 3
#att 11
#def 10
#prec 10
#mr 10
#mor 13
#gcost 60
#rcost 1
#stealthy 10
#spy
#weapon 9
#noleader
#nomagicleader
#noundeadleader
#secondshape 2717
#nametype 147
#end


---- Old Hand


#newmonster 2729
#name "Old Hand"
#spr1 "./necro/commander_oldhand1.tga"
#spr2 "./necro/commander_oldhand2.tga"
#descr "In life, Agents are the eyes and ears of the city in foreign lands.  In death, their skills and experiences are applied to far more sinister aims.  The Old Hand is very hard to detect when sneaking in foreign lands and can perform assassination attempts."
#ap 12
#mapmove 2
#hp 12
#prot 0
#size 2
#str 9
#enc 3
#att 13
#def 12
#prec 10
#mr 12
#mor 17
#gcost 65
#rcost 1
#weapon 126
#weapon 126
#ambidextrous 2
#stealthy 15
#assassin
#inanimate
#pooramphibian
#magicbeing
#neednoteat
#poisonres 100
#noheal
#noleader
#nomagicleader
#noundeadleader
#secondshape 2717
#nametype 147
#maxage 600
#end


---- Advocate


#newmonster 2730
#name "Advocate"
#spr1 "./necro/commander_advocate1.tga"
#spr2 "./necro/commander_advocate2.tga"
#descr "An Advocate is a living Necropolitain who has dedicated himself to the army and is sworn to defend the city and its lords in life and after.  As commanders of the city's guard, Advocates are charged with the defense of the entrances to the catacombs.  Advocates are captains of moderate skill and are armed with the best equipment available."
#ap 12
#mapmove 2
#hp 15
#prot 0
#size 2
#str 12
#enc 3
#att 11
#def 11
#prec 10
#mr 11
#mor 13
#gcost 40
#rcost 1
#weapon 780
#armor "Necropolitain Headdress"
#armor "Full Necropolitain Armor"
#armor "Shield"
#okleader
#nomagicleader
#noundeadleader
#secondshape 2718
#nametype 147
#end


---- Marshal


#newmonster 2731
#clear
#name "Marshal"
#spr1 "./necro/commander_marshal1.tga"
#spr2 "./necro/commander_marshal2.tga"
#descr "Advocates who survive their entire mortal lives without being cut down in battle are promoted upon death.  The Marshals are the generals of the catacombs and underworld beneath the city.  They bring the experiences of a lifetime of battles and are yet young and strong among the everdying."
#ap 12
#mapmove 1
#hp 13
#prot 0
#size 2
#str 10
#enc 3
#att 13
#def 13
#prec 10
#mr 12
#mor 18
#gcost 70
#rcost 1
#weapon 780
#armor "Winged Necropolitain Headdress" 
#armor "Full Necropolitain Armor"
#armor "Shield"
#holy
#inanimate
#pooramphibian
#magicbeing
#neednoteat
#poisonres 100
#noheal
#goodleader
#goodmagicleader
#noundeadleader
#secondshape 2718
#nametype 147
#maxage 400
#end


---- Acolyte


#newmonster 2732
#clear
#name "Acolyte"
#spr1 "./necro/commander_acolyte1.tga"
#spr2 "./necro/commander_acolyte2.tga"
#descr "Living initiates in the Necropolitain temples submit themselves to the wisdom of the Mortarch, the high ruler of the church.  The life of an Acolyte is spent in preparation for his transformation to purgator by suicide at age thirty."
#ap 12
#mapmove 2
#hp 12
#prot 0
#size 2
#str 10
#enc 3
#att 8
#def 8
#prec 10
#mr 13
#mor 15
#gcost 60
#rcost 1
#weapon 9
#magicskill 8 2
#holy
#poorleader
#nomagicleader
#noundeadleader
#secondshape 2719
#nametype 147
#startage 20
#end


---- Suicide King


#newmonster 2733
#name "Suicide King"
#spr1 "./necro/commander_suicide1.tga"
#spr2 "./necro/commander_suicide2.tga"
#descr "When a priest of Necropolis reaches the age of thirty he submits himself to the ritual suicide central to the church.  After his body's death, he is promoted and becomes one of the Suicide Kings, the high priests of Necropolis."
#ap 12
#mapmove 2
#hp 12
#prot 0
#size 2
#str 10
#enc 3
#att 8
#def 8
#prec 10
#mr 15
#mor 20
#gcost 80
#rcost 1
#weapon 9
#magicskill 8 3
#holy
#inanimate
#pooramphibian
#magicbeing
#neednoteat
#poisonres 100
#noheal
#okleader
#goodmagicleader
#noundeadleader
#secondshape 2719
#nametype 147
#maxage 600
#end


---- Arbiter


#newmonster 2734
#name "Arbiter"
#spr1 "./necro/commander_arbiter1.tga"
#spr2 "./necro/commander_arbiter2.tga"
#descr "At one time, the judges were the rulers of the city and they initiated the campaign to extinguish magic from the kingdom.  Those judges live still, but their physical bodies have since decayed completely and they persist in this world only as ethereal spirits.  Their great age has attuned their senses to magical power and they have become those whom they once persecuted.  Arbiters are the lower judges of the city."
#ap 12
#mapmove 2
#hp 10
#prot 0
#size 2
#str 8
#enc 3
#att 8
#def 8
#prec 11
#mr 14
#mor 16
#gcost 120
#rcost 1
#weapon 781
#armor "Necropolitain Headdress"
#armor "Necropolitain Greaves"
#magicskill 4 1
#magicskill 51 1
#ethereal
#pooramphibian
#magicbeing
#neednoteat
#okleader
#goodmagicleader
#noundeadleader
#nametype 147
#maxage 500
#end


---- Judicator


#newmonster 2735
#name "Judicator"
#spr1 "./necro/commander_judicator1.tga"
#spr2 "./necro/commander_judicator2.tga"
#descr "At one time, the judges were the rulers of the city and they initiated the campaign to extinguish magic from the kingdom.  Those judges live still, but their physical bodies have since decayed completely and they persist in this world only as ethereal spirits.  Their great age has attuned their senses to magical power and they have become those whom they once persecuted.  Judicators are the ancient high judges of the city and they are able to mask their presence with illusions."
#ap 12
#mapmove 2
#hp 12
#prot 0
#size 2
#str 8
#enc 3
#att 8
#def 8
#prec 13
#mr 16
#mor 18
#gcost 240
#rcost 1
#weapon 781
#weapon 781
#armor "Necropolitain Headdress"
#armor "Necropolitain Greaves"
#ambidextrous 2
#magicskill 4 2
#magicskill 51 2
#magicskill 51 1
#illusion
#ethereal
#pooramphibian
#magicbeing
#neednoteat
#goodleader
#goodmagicleader
#noundeadleader
#nametype 147
#maxage 800
#end


---- City Father


#newmonster 2736
#name "City Father"
#spr1 "./necro/pretender_father1.tga"
#spr2 "./necro/pretender_father2.tga"
#descr "The first person to ever be affected by the everdying curse of Necropolis, this being has existed for over one thousand years.  During the time of the inquisition against magic he was the lord of the city and ordered the persecution.  Like other ancient Necropolitains, he has shed his decaying physical form and is now only a spirit.  However, his soul has grown so strong that he has become the city of Necropolis itself and the city has become him.  He is forever bound to the city and cannot leave its walls, but within it he is incredibly powerful and very hard to kill.  Every season his spirit reveals the location of an Astral Pearl within the depths of the catacombs.  The City Father wields a huge khopesh imbued with the power of the Necropolitain curse."
#ap 18
#mapmove 0
#hp 20
#prot 12
#size 3
#str 14
#enc 0
#att 15
#def 15
#prec 14
#mr 18
#mor 30
#gcost 100
#rcost 1
#weapon 784
#magicskill 4 3
#regeneration 10
#illusion
#ethereal
#pooramphibian
#immortal
#gemprod 4 1
#startdom 2
#magicbeing
#neednoteat
#expertleader
#expertmagicleader
#noundeadleader
#pathcost 50
#restrictedgod 78
#maxage 1450
#end


---- Necro Gnome


#newmonster 2737
#copystats 345
#spr1 "./necro/gnome1.tga"
#spr2 "./necro/gnome2.tga"
#descr "Gnomes are natives of the underworld beneath the catacombs of Necropolis.  Over the ages they have come to respect the purgators who rule the city above and have sworn friendship to them.  Gnomes are users of Earth and Nature magic who disguise themselves with illusionary spells.  Though rarely seen above-ground, they are respect and valuable allies of Necropolis."
#weapon 13
#end


---- Troglodyte


#newmonster 2738
#copystats 447
#spr1 "./necro/trog1.tga"
#spr2 "./necro/trog2.tga"
#descr "Troglodytes are huge, stupid, subterranean-dwelling creatures of great strength.  They stare coldly with two reflective green eyes set in a muscled, headless torso and consider much of nothing during their long lives deep in the tunnels of the Underworld.  Almost nothing is known about their eating or breeding habits.  The purgators of Necropolis have come to respect the brute strength of the Troglodytes with whom they share the Great Dark and can recruit them for difficult labor or military service.  Troglodytes attack their foes by flinging themselves wildly in the direction of the enemy.  Their size makes it easy for Troglodytes to crush human opponents."
#end






------ HEROES




---- Sun Bow Hero


#newmonster 2739
#name "Hero"
#spr1 "./necro/hero_bow1.tga"
#spr2 "./necro/hero_bow2.tga"
#descr "Veteran of a hundred campaigns, this commander is truly a Hero.  He knows no fear on the field of battle knowing that the curse of his people will restore him immediately should he fall.  He is armed with the Sun Bow, a weapon said to have been forged by a long-forgotten sun god that causes a small blaze of heavenly light to erupt wherever its shooter aims."
#ap 12
#mapmove 3
#hp 18
#prot 0
#size 2
#str 10
#enc 3
#att 11
#def 11
#prec 12
#mr 12
#mor 16
#gcost 40
#rcost 1
#weapon 782
#weapon "Dagger"
#armor "Necropolitain Headdress"
#armor "Full Necropolitain Armor"
#goodleader
#nomagicleader
#noundeadleader
#secondshape 2718
#nametype 147
#end

#newmonster 2740
#name "Marshal of the Underworld"
#spr1 "./necro/hero_undermarshal1.tga"
#spr2 "./necro/hero_undermarshal2.tga"
#descr "In life this commander was unsurpassed in his battlefield prowess.  As strong and skilled as an Emerald Lord of Pythium, this general now commands the sentinels of the Necropolitain catacombs and underworld.  Much of his mortal strength remains and he is as deadly as ever.  The Marshal of the Underworld is armed with a foul sword that has been imbued with the power of the Necropolitain curse."
#ap 12
#mapmove 1
#hp 18
#prot 0
#size 2
#str 12
#enc 3
#att 14
#def 14
#prec 10
#mr 14
#mor 20
#gcost 70
#rcost 1
#weapon 783
#armor "Winged Necropolitain Headdress" 
#armor "Full Necropolitain Armor"
#armor "Shield"
#holy
#inanimate
#pooramphibian
#magicbeing
#neednoteat
#poisonres 100
#noheal
#superiorleader
#goodmagicleader
#noundeadleader
#secondshape 2718
#nametype 147
#maxage 800
#end


#newmonster 2741
#clear
#name "Master of the Scales"
#spr1 "./necro/hero_mots1.tga"
#spr2 "./necro/hero_mots2.tga"
#descr "Centuries ago, the Master of the Scales was the highest judge of the city.  He served as the chief official of the court and personally oversaw the inquisition against magic.  Now he is perhaps the most magically-attuned wizard in all of the city.  He still carries great authority and influence over the affairs of Necropolis and is both a powerful mage and respected commander."
#ap 12
#mapmove 2
#hp 16
#prot 0
#size 2
#str 8
#enc 3
#att 8
#def 8
#prec 14
#mr 17
#mor 20
#gcost 240
#rcost 1
#weapon 781
#armor "Necropolitain Headdress"
#armor "Necropolitain Greaves"
#magicskill 4 3
#magicskill 51 2
#magicskill 51 1
#magicskill 51 1
#illusion
#ethereal
#pooramphibian
#magicbeing
#neednoteat
#expertleader
#goodmagicleader
#noundeadleader
#nametype 147
#maxage 800
#end


#newmonster 2742
#name "Mortarch"
#spr1 "./necro/hero_mortarch1.tga"
#spr2 "./necro/hero_mortarch2.tga"
#descr "The highest priest of Necropolis is the Mortarch, the grand vizier and master of the suicide ritual of the church.  He is a very powerful purgator priest and can easily spread the influence of god."
#ap 18
#mapmove 2
#hp 12
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 10
#prec 10
#mr 16
#mor 20
#gcost 50
#rcost 1
#weapon 9
#holy
#magicskill 8 5
#inanimate
#pooramphibian
#magicbeing
#neednoteat
#poisonres 100
#noheal
#expertleader
#goodmagicleader
#noundeadleader
#secondshape 2719
#nametype 147
#maxage 800
#end



------ SITES


#newsite 973
#name "Underworld"
#path 3
#level 0
#rarity 5
#gems 3 2
#homecom 2737
#homemon 2738
#end

#newsite 974
#name "City Catacombs"
#path 8
#level 0
#rarity 5
#gems 4 2
#homecom 2733
#homemon 2727
#end




------ NATION

#selectnation 78
#clearnation
#clearsites
#clearsites
#guiframe "./necro/necro_gui.tga"
#name "Necropolis"
#epithet "City of the Everdying"
#era 3
#brief "Necropolis is a theocratic city-state inhabited by a cursed people.  When their bodies die their souls remain and animate the corpse.  These everdying are known as purgators.  Powerful ethereal wizards and semi-dead priests rule the City of the Everdying and command armies of living infantry and dead elites."
#descr "In an ancient time, the fear of dark magic drove the judges of Necropolis to persecute and exile spell-casters.  One of these, a crone called the Withered Witch, lay a curse upon the city before her expulsion from its lands.  When the residents of Necropolis die their souls do no depart their bodies.  Instead, the mind remains trapped within an animated decaying corpse.  When the flesh at last falls away they yet remain as disembodied ghosts.  The Necropolitains will live forever, unable to pass on to the next realm... tormented.  That is unless their new god can gather the all power of the world and break the curse."
#summary "* Race: Humans, semi-dead purgators, ethereals

* Military: Light human infantry and archers, medium elites, troglodyte allies

* Magic: Astral, Elements

* Priests: Strong"

#flag "./necro/necro_icon.tga"
#templepic 16




#addrecunit 2720
#addrecunit 2721
#addrecunit 2722
#addrecunit 2723
#addrecunit 2724
#addrecunit 2725
#addrecunit 2726


#addreccom 2728
#addreccom 2729
#addreccom 2730
#addreccom 2731
#addreccom 2732
#addreccom 2734
#addreccom 2735



#defcom1 2730
#defcom2 2731
#defunit1 2721
#defunit2 2722
#defmult1 20
#defmult2 10


#startcom 2730
#startunittype1 2720
#startunitnbrs1 10
#startunittype2 2721
#startunitnbrs2 10
#startscout 2728


#startsite "City Catacombs"
#startsite "Underworld"



#startfort 31

#defaultfort 4

#farmfort 3

#mountainfort 36

#swampfort 11

#forestfort 33


#hero1 2739
#hero2 2740
#hero3 2741
#hero4 2742

#color 0.4 0.1 0.5

#end

