#modname "KingMaker Mod"
#description "This mod integrates a number of other mods for the KingMaker megagame. In particular it includes Slobby's major update of Gandalf Parker's single-age mod, Zepath's streamers and standards with additional work by llamabeast, research changes by DrPraetorious, Twan's Mists of Deception fix and spell-bannings and gem-item cost increases by Xietor. The mod was compiled by llamabeast."
#version 1.0
#domversion 3.17

--- Banned spells for KingMaker (done by Xietor) ---
#selectspell "Arcane Nexus"
#school -1
#end
 
#selectspell "Burden of Time"
#school -1
#end
 
#selectspell "Utterdark"
#school -1
#end
 
#selectspell "Astral Corruption"
#school -1
#end
 
--- Increased cost of gem-producing items (done by Xietor) ---
#selectitem "Clam of Pearls"
#mainlevel 4
#secondarylevel 2
#end
 
#selectitem "Fever Fetish"
#mainlevel 2
#end
 
#selectitem "Blood Stone"
#secondarylevel 3
#end

-- Single Age mod with full descriptions, by Slobby
#selectnation 0
#name "EA Arcoscephale"
#era 2
#brief "An ancient human kingdom led by Philosophers, Arcoscephale mainly uses heavy infantry, chariots and flying Icarids. The Philosophers are skilled researchers. Oreiads, roaming mountain spirits, and Mystics skilled in Astral and Elemental magic give Arcoscephale great magical versatility. The priestesses of Arcoscephale can heal wounded soldiers."
#descr "The kingdom of Arcoscephale is yet to be founded. Bronze is more common than iron and hoplites have yet to see the dawn of day. Instead, myrmidons and chariots compose the core of the armies. In this time, slaves are commonly used and most free men have plenty of time to spend on fine arts and good living. Philosophers gather in the cities to discuss esoteric truths and engineers manufacture clever contraptions for civil or military use. At the heart of Arcoscephale lies Mount Cephalos, abode of the Awakening God. At the foot of the mountain is a great temple where sacred Pegasus Riders are trained. Icarids, men with mechanical wings, are also used in warfare. The philosophers are better at magical research in a slothful Dominion."
#summary "Race: Humans.  Military: Heavy infantry, chariots, flying infantry, sacred Pegasus Riders, engineers.  Magic: Nature, Astral, Elements. Philosopher researchers.  Priests: Average, healing, Sceptic preachers (reduces Dominion).  Dominion: Scry (accurate and automatic military reports inside dominion)."
#end 
 
#selectnation 1
#name "EA Ermor"
#era 2
#brief "Ermor is a human empire centered around a great city. The Empire has just recently converted to the New Faith and its magical skills are very versatile as mage-priests from the Old Faith still linger."
#descr "Ermor is an empire centered around a great city. For centuries it has grown and become more and more influential. Traders and travelers from near and far come to the city. By military campaigns, diplomacy and trade, Ermor has become a power to be reckoned with. By adopting local traditions and beliefs, the Ermorians posed little threat to neighbours and conquered peoples, but this has begun to change. A New God is arising. Old syncretistic faiths and spirit worship were banned by a Prophet dressed in white shrouds. The remnants of his body and shrouds are buried in the Holy City of Eldregate where the adherents of the New Faith are awaiting the arrival of the Reawakening God foreseen by the Prophet. The all-encompassing old state cult of the Numinas still survives, but the Pontifices and Flamen are slowly adopting the New Faith."
#summary "Race: Human.  Military: Human legionnaires and lizard auxiliaries.  Magic: All paths except Blood. Primarily Fire, Death and Astral.  Priests: Powerful, can heal afflictions."
#end 
 
#selectnation 2
#name "EA Ulm"
#era 2
#brief "Ulm is a nation with a barbarian legacy. They are strong and proud and worship steel and spirits of the wild. The warriors of Ulm are stealthy and well versed in the ways of the wild. The warrior smiths are masters of magical forging."
#descr "Ulm is a land of cold mountains and dense forests. These wild lands were settled by proud and fierce barbarians in ages past. Their ancestry has made the inhabitants of the forests stronger and more resilient to the cold climate than ordinary men. Upon becoming men, youngsters are given a single knife and left in the forest at first snowfall. Those who survive the winter are allowed to return to their family. The barbarians of Ulm live in small settlements ruled by chieftains and warrior smiths who search for the Enigma of Steel. Steel is sacred metal and its maker is as well. Smithing has become equivalent of making a sacrifice to the Lord and no other culture has developed such a skill in magical forging. Horses are rare and those who use them in warfare are held in contempt. Sneak attacks, on the other hand, are common, and many warriors use stealth to engage opponents in hand-to-hand combat."
#summary "Race: Barbarians, partial cold resistance.  Military: Strong medium infantry, stealthy infantry.  Magic: Earth, Nature, Fire, Air, Water, some Death, superior magic item forging.  Priests: Weak."
#end 
 
#selectnation 3
#name "EA Marverni"
#era 2
#brief "Marverni is a nation of tribal chiefdoms led by Druids, powerful readers of the stars and the Earth. Most warriors fight bare-chested, but noble warriors use chainmail cuirasses."
#descr "The Marverni is a nation of tribal chiefdoms guided by Druids and religious magistrates. The tribes have a long history of war and infighting, but recent developments have joined the tribes in pursuit of a single goal. The most prominent tribes are the Marverni, the Ambibates, the Eponi and the Carnutes. The Sequani, though a small tribe, are influential due to the large number of Druids among them. The smiths of the Marverni tribe are reputedly the inventors of chainmail and most nobles of the tribes use it. Lowborn warriors fight bare-chested. The Ambibates are known for their martial skills. The Eponi nobles fight on horseback and are the only cavalry available to the nation. The Carnute tribe guards the Sacred Forest of Carnutes where the Druids gather every year. The Carnute warriors are able to go berserk when wounded. Boars are a sacred symbol the Marverni nation."
#summary "Race: Humans.  Military: Light and medium infantry, medium cavalry.  Magic: Earth, Astral, Nature, Water.  Priests: Medium, can perform blood sacrifices."
#end 
 
#selectnation 4
#name "EA Sauromatia"
#era 2
#brief "Sauromatia is a tribal nation ruled by women. Swift raiders and lancers form the backbone of the armies. Amazon warriors and Androphags are the sacred elites of the Sauromatians. Witch Kings, masters of dark sorcery, rule the Androphag tribe. Hydras from the Pythian Marsh are tamed and used in warfare."
#descr "Sauromatia is a nation of nomadic warrior tribes ruled by women. Men and women fight side by side and all prominent tribes are ruled by warrior queens. This is a legacy of the Sauromatians merging with the Amazon tribes in times past. The Amazon leaders were not accepted, because they were not warriors, but they influenced the Sauromatians and women warriors gained power and prestige. Only the tribe of the Androphags has totally rejected the notion of female leadership. The Androphags are ruled by ancient Witch Kings who introduced cannibalism and man-flaying to the Sauromatians. The Androphags also use hydras from the Marshes of Pythia in warfare."
#summary "Military: Light and medium cavalry, serpent riders, lizard riders, hydras.  Magic: Death, Nature, Blood, some Astral and Water.  Priests: Weak."
#end 
 
#selectnation 5
#name "EA T'ien Ch'i"
#era 2
#brief "T'ien Ch'i is an emerging empire. Masters of the Five Elements and Celestial Masters are versatile mages. The nobles partake personally in battles and their chariots form an important part of the army. Sacred Celestial Beings and the Sacred Warriors of the Five Elements form the elite core of the armies."
#descr "The Celestial Empire has not yet been founded. The magic of the Way permeates the realm and reclusive mages conjure Celestial Beings to do their bidding. Nobles wage war upon each other for honor and glory. A few chosen warriors and mages dedicate their lives to training in the Way of the Five Elements. The deceased are worshipped and village priests conjure the dead to ask for guidance and aid. It is a times of legends."
#summary "Race: Humans.  Military: Versatile and well-equipped with large shields and iron armaments. Noble chariots.  Magic: Water, Astral, Air, Fire, Nature, some Earth and Death, Summon Celestial Beings.  Priests: Average."
#end 
 
#selectnation 6
#name "early Machaka"
#era 0
#end 
 
#selectnation 7
#name "EA Mictlan"
#era 2
#brief "Mictlan is an old kingdom ruled by priest-kings. Their God hungers and must be sated with blood sacrifices. Mictlan has powerful blood mages and priests, but its infantry uses archaic weapons."
#descr "Mictlan is an ancient tribal empire that has been isolated for centuries. The foul practices of the priest-kings of Mictlan have caused most neighbors to leave or face slavery or death by sacrifice. Since the dawn of the kingdom, blood has been spilled in the temples of the capital to feed the waning powers of the Hungry God. The armies are mainly composed of slaves from newly conquered lands. The mage-priests of Mictlan celebrate the two Faces and the two Dominions of the Hungry God, namely the Sun and the Moon, the Rain and the Forest. They are all skilled blood mages."
#summary "Race: Humans, prefers Heat scale +1.  Military: Light infantry with slings and javelins, tribal kings can levy slaves.   Magic: Blood, Fire, Astral, Nature, Water.  Priests: Powerful, can perform blood sacrifices, Dominion does not spread unless blood is sacrificed."
#end 
 
#selectnation 8
#name "EA Abysia"
#era 2
#brief "Abysians are lava-born humanoids that radiate heat. Abysians mainly use heavy infantry. They have skilled Fire and Blood mages and their priests can perform blood sacrifices. Abysians dislike cold provinces."
#descr "Abysia is a hot wasteland at the center of which lies a great volcano whose lava-lit caverns are inhabited by magma-born humanoids. Their flesh radiates heat and they are not harmed by flames. Abysians are stronger than humans and use very heavy armor and weaponry. Bows are not used, as they would turn to cinders in the glowing hands of the Abysians. The war machine of Abysia also includes Salamanders, lizardlike beings composed of the same hot lava-born flesh as the Abysians. The Anointed of Rhuax and the Anathemant Priests of the Flame Cult practice blood sacrifice to strengthen the power of the Awakening God. The Warlocks of the Smouldercone, a newly formed magical order, practices Blood magic and search for suitable blood slaves in conquered lands. Abysians prefer to live in extremely hot places. They do not farm or hunt for a living, so their income and supplies are not affected by the Growth/Death scale of a province. However, population will still die slowly in Abysia-controlled provinces with Death scales."
#summary "Race: Radiates heat, fire resistance, prefers Heat scale +3, wasteland survival.  Military: Very heavy infantry, no missile weapons, salamanders.  Magic: Fire, Blood, Astral, some Earth.  Priests: Powerful, can perform blood sacrifices."
#end 
 
#selectnation 9
#name "EA Caelum"
#era 2
#brief "Caelum is a union of three tribes of winged beings that live on high mountaintops. One tribe is fully immune to cold and another tribe is cold and lightning resistant. All mages of Caelum are skilled in Air magic and some also have some skill in Water and Death. All of Caelum dislikes warm lands."
#descr "Caelum is a magocracy of winged humanoids inhabiting the highest mountain peaks. Under the wise rule of the Eagle Kings, semi-divine beings of an earlier age, three tribes have formed a kingdom. The tribes are the Tempest Lords of Spire Horn Mountain, the Raptors of Raven's Vale and the Caelians of High Caelum. The Spire Horn Caelians are partially resistant to cold and lightning. The Raptorians are stronger and attuned to the Earth, but lack the elemental resistance characteristic of the other clans. The High Caelians live in the coldest mountain peaks and are unaffected by low temperatures. They are thinner and lighter then the other clans. The high Caelians are led by mages known as Seraphs, masters of Air magic. The Seraphs craft the magical ice that Caelians use instead of regular metal. The ice tempers with lower temperatures and the heavy ice armor is more durable in cold climates than in warmer ones. All weapons crafted from the ice are magical and capable of harming magical beings. The Caelians are skilled archers and prefer hit-and-run tactics, even though they do have some heavy troops, such as huge Mammoths."
#summary "Race: Flying, partially cold resistant, partially shock resistant, prefers Cold scale +2.  Military: Flying units, skilled archers, mammoths.  Magic: Air, some Water, Earth and Death, rarely Fire.  Priests: Average."
#end 
 
#selectnation 10
#name "EA C'tis"
#era 2
#brief "C'tis is an ancient kingdom of lizardmen. They do not use cavalry or archers, but use chariots and javelins instead. C'tis has powerful Death mages and powerful Lizard King priests. The lizards dislike cold provinces."
#descr "C'tis is a swampy river valley surrounded by sandy deserts. In the fertile valley a sacral kingdom of lizardlike humanoids has formed. The kingdom is ancient by human standards and its wisdom and magical knowledge are great. At the top of the society are the Lizard King and his Royal Heirs. The King is the highest priest of C'tis. Under the king are the High Priests with their sacred serpents and the enigmatic Sauromancers, great mages of death and rebirth. The lizards are herbivores, but have enslaved a race of carnivorous lizardmen who serve as soldiers and workers. The C'tissians are somewhat slow in movement, but have thick hides that protect them from cuts and bruises. Both lizard races are cold-blooded and become exhausted very quickly when fighting in cold provinces. They have partial resistance to poisons. The inhabitants of C'tis prefer to live in warm provinces."
#summary "Race: Thick hides, cold-blooded, poison resistance, prefers Heat scale +1.  Military: Chariots, infantry, slave warriors, sacred serpents.  Magic: Death, Nature, some Water and Astral.  Priests: Powerful."
#end 
 
#selectnation 11
#name "EA Pangaea"
#era 2
#brief "Pangaea is a woodland realm of wild halfmen. Pangaea has stealthy satyrs, flying harpies, strong centaurs, and raging minotaur warriors. The Panii are powerful mages of Nature and Earth and are able to lure women into the wild."
#descr "Pangaea is a woodland nation inhabited by wild beings connected with nature. Halfmen such as satyrs, centaurs and minotaurs serve the lords of the Sacred Groves deep in the forests. Expansion by the civilized nations has forced the beasts of Pangaea to arm themselves with man-made weapons. Minotaurs wield huge battleaxes and centaurs are trained to use spears and longbows. The magic of the Panii lures women into the forests where they turn wild and shed all their clothing. These women are called Maenads and are turned loose to fight humans with their bare hands and teeth."
#summary "Race: Forest beings, stealthy troops, troops may heal their battle afflictions.  Military: Satyr and minotaur infantry, centaur archers and warriors.  Magic: Magical Tunes, Nature, Earth, Blood.  Priests: Average."
#end 
 
#selectnation 12
#name "EA Agartha"
#era 2
#brief "A cavern realm of Pale Ones and troglodytes. Pale Ones can grow to huge proportions. Oracles and Earth-Blood mage-kings rule the Pale Ones. All Pale Ones have perfect night vision."
#descr "In dark caverns under the Roots of the Earth a strange race of one-eyed humanoids has evolved. Untouched by the sun, they have become known to humans as the Pale ones. The Pale Ones are gifted with perfect darkvision and gills and inhabit underwater rivers and lakes as well as cavernous halls. Pale Ones never stop growing and ancient ones can grow to huge proportions. The wisest of the Ancient Ones are known as the Oracles, priest-mages of great power. The Oracles are gathered in a great, cavernous hall where they divine the fate of the Pale Ones."
#summary "Race: Pale Ones and troglodytes. Darkvision. Poor amphibians.  Military: Light infantry, medium infantry, Wet Ones, huge Ancient Ones.  Magic: Earth, Fire, Water, Death.  Priests: Powerful."
#end 
 
#selectnation 13
#name "EA Tir na n'Og"
#era 2
#brief "Tir na n'Og is a blessed isle ruled by a magical race known as Tuatha and their Sidhe descendants. Fir Bolg, lesser descendants of the Nemedians, compose much of the population. The Sidhe and Tuatha are able to weave illusions to hide their true appearance."
#descr "Tir na n'Og is a blessed isle surrounded by whispering mists. It is the home of the Tuatha, a highly magical race descended from the Nemedians who once warred with the Fomorians. The Tuatha have made themselves lords and masters over the Fir Bolg, a lesser race descended from the same Nemedian ancestors. With the aid of the Fir Bolg, the Tuatha attacked the Fomorian giants and almost succeeded where the Nemedians failed, but eventually the Fomorians proved too powerful and the Tuatha were driven back to their blessed isle. The Tuatha and their Sidhe descendants have turned to crafts, poetry and magical arts, but some have chosen the path of war and have become warriors and generals of great renown. The Fir Bolg, inferior to the Tuatha, but still far superior to ordinary men, compose much of the population and serve as farmers and lowly warriors."
#summary "Race: Tuatha, Sidhe, Fir Bolg, illusions.  Military: Fir Bolg infantry, Sidhe infantry, sacred Tuatha warriors.  Magic: Spell Songs, Air, Nature, Water, some Earth.  Priests: Average."
#end 
 
#selectnation 14
#name "EA Fomoria"
#era 2
#brief "Fomoria is a bountiful land inhabited by malformed giants. The land was attacked by wave after wave of invaders. Of these, the Fir Bolg, lesser descendants of the Nemedians, have established themselves and live in peace with the Fomorians. A few of the magically powerful Nemedians also linger on."
#descr "The bountiful land of Fomoria was claimed by giants who once guarded the dark and stormy ocean realm of the drowned dead. With death ever near, their loyalties had changed and their malice grown. With the ascendancy of a previous Pantokrator they were punished for their sins and banished from their dark home. The full effects of the Curse became evident when the Fomorians settled in a fertile land. Their offspring were short and cursed with monstrous appearance. The few surviving Fomorian giants saw their once proud race degenerate and die. Then came the Invasions. Partholonians, Nemedians, Fir Bolg and Tuatha all claimed the land of Fomoria. Twice the Fomorians were all but defeated by foreign magic, but twice they conjured a plague that slew the invaders. The third wave of invaders, the Fir Bolg, accepted Fomorian rule and aided the giants in defeating the Tuatha. Now Fir Bolg compose much of the Fomorian population. Fomorians are skilled shipwrights, powerful storm crafters and have a legacy of mastery over the dead."
#summary "Race: Malformed Fomorian giants, Fir Bolg, Nemedians. Ocean sailing and units able to enter the sea.  Military: Fir Bolg Infantry, Fomorian infantry, Nemedian infantry.  Magic: Air, Death, some Water and Nature.  Priests: Mostly weak, Fomorian King of average skill."
#end 
 
#selectnation 15
#name "EA Vanheim"
#era 2
#brief "Vanheim is a nation ruled by Vanir, ancient enemies of the Jotun giants. Vanir can sail across the oceans and hide themselves with illusions. They mostly use infantry and sacred berserkers. Their Dwarven smiths are powerful Earth mages."
#descr "Vanheim is a land of misty moors and bitter forests inhabited by a tall and innately magical race known as the Vanir. The Vanir are mortal enemies of the giants of Jotunheim and since the beginning of time they have waged a great war upon each other. They are masters of illusions and are able to trick mortals with their glamour. In halls under the mountains of Vanheim live Dwarves, smiths capable of crafting fabulous items. Vanheim is a land of magic and even the horses are enchanted and exceptionally fast. Vanir are skilled shipwrights and navigators and can sail the oceans. Lesser beings are not held in high regard and their blood is sacrificed to sate the Awakening God."
#summary "Race: Ocean sailing, illusions, prefers Cold scale +1.  Military: Vanir.  Magic: Air, Earth, Blood, some Fire and Death.  Priests: Average, can perform blood sacrifices."
#end 
 
#selectnation 16
#name "EA Helheim"
#era 2
#brief "Helheim is a nation of Vanir ruled by Hanged Kings guarding the entrance to Hel. Vanir can hide themselves with illusions. they utilize many unique troops, including flying Valkyries. The Hangadrotts are powerful Death and Air mages and the Svartalf smiths are skilled in Earth and Death magics."
#descr "Helheim is a land of shadows, windswept moors and silent mountains. Here lies Gnipahalan, the Stone Cave, where the dead pass through on their way to Hel. The Hanged Kings, ancient Vanir that have hanged themselves to learn the secrets of Death, rule the land from their thrones of Helhalla. Helheim is inhabited by Vanir, a race of tall and innately magical beings that are able to trick mortals with their glamour. The Vanir of Helheim have sequestered themselves from the Vanir of Vanheim and have not been part of the great war with the giants. For ages they have been guiding the dead on their way to Hel in service of a dead god. Now a new god is arising and the old ways are changing. The Valkyries, guides of the dead, have become messengers of death and sacred warriors of the new God. Valkyries, the female Vanir of Helheim, are able to fly, a gift from the dead god they once served. Lesser beings are not held in high regard and their blood is sacrificed to sate the Awakening God. Unlike their cousins in Vanheim, the Vanir of Helheim are not shipwrights and sailors."
#summary "Race: Flying troops, illusions, prefers Cold scale +1.  Military: Vanir heavy infantry, Valkyries, Vanir cavalry.  Magic: Death, Air, Earth, Blood, some Fire.  Priests: Average, can perform blood sacrifices."
#end 
 
#selectnation 17
#name "EA Niefelheim"
#era 2
#brief "Niefelheim is a frozen realm and the home of the Niefel Giants, descendants of the Rimtursar. Giants are immune to the cold and dislike hot lands. Their mages are versatile and powerful sorcerers."
#descr "Niefelheim, the Land of Eternal Frost, was once the home of the frost giants. The Rimtursar, ancient giants who possessed godlike powers, were the undisputed rulers of the world. The giants of Jotunheim are the descendants of the Rimtursar. From the cold glaciers in Niefelheim, frost giants have emerged anew. These Niefel Giants are not nearly as powerful as their ancestors, but they are stronger by far than the giants of later ages. Giants are immensely strong and resilient, but their size makes them easy targets. They are born in the cold and do not suffer from cold climates. Niefelheim is ruled by several Jarls who rarely join forces. Gygjas, old and wicked hags, serve the Niefel giants with sorcerous advice. The people of Niefelheim prefer to live in very cold provinces. The icy winds of Niefelheim cause the cold climate to expand beyond the Dominion of the Pretender God."
#summary "Race: Cold resistant, needs lots of supplies, prefers Cold scale +3.  Military: Niefel Giants, giant infantry.  Magic: Water, Blood, Death, Nature, Astral, some Air.  Priests: Average.  Dominion: Spreads cold."
#end 
 
#selectnation 18
#name "EA Kailasa"
#era 2
#brief "Kailasa is a realm of intelligent apes ruled by Yakshas and Yavanas, divine beings living on the Sacred Mountain of Kailasa."
#descr "On the sacred Mount Kailasa, beings from an earlier era still linger. They are blessed with mystical powers but are few in number. With the emergence of the new God they have mustered aid from a most unsuspected source. Deep in the forests below the Sacred Mountain, apes of uncanny brightness have evolved. The apes are uncivilized and have only recently mastered the mysteries of metal working."
#summary "Race: Yakshas and apes.  Military: A multitude of missile weapons and light infantry.  Magic: Water, Earth, Astral, Nature.  Priests: Weak."
#end 
 
#selectnation 19
#name "EA Yomi"
#era 2
#brief "Yomi is a nation of Oni and their servants. Oni are demons of the mountain wilderness. They are magically powerful and almost immortal, but few in number and rather stupid."
#descr "Yomi is a land of inhospitable mountains, steaming, sulphuric pools and sudden volcanic eruptions. At the center of this unforgiving land lies a great cone-shaped mountain at the top of which is an entrance to the Netherworld. From this gate the Oni have come, one by one or in small groups. Oni are demons of the wild: ugly, pot-bellied and mischievous. They are ruled by Oni Kings who occasionally emerge from the Netherworld to wreak havoc on the land of the living. Oni are almost immortal and must be killed in spirit as well as in body to stay dead."
#summary "Race: Demons.  Military: Semi-immortal Oni, Bakemono and human servants. Light infantry, medium infantry.  Magic: Death, Fire, Earth, some Air and Nature. Powerful mages, bad at research.  Priests: Weak."
#end 
 
#selectnation 20
#name "EA Hinnom"
#era 2
#brief "Hinnom is a wasteland inhabited by several kinds of giants. The Rephaite lords rule the lesser giants by fear and force."
#descr "Hinnom is a dry wasteland inhabited by giants. At the dawn of time, on the sacred mount Hermon, six Angels in full celestial splendour descended to aid and instruct the giants of the land. The Avvim were a people strong and beautiful of mind and body. They were adept students and their culture flourished under the tutelage of the Grigori, the angelic Watchers. But before long the Angels became enamoured with the Avvim and taught them things that should not be taught. Tempted by the beauty of the Avvim, they took their daughters as wives and sinned before the Celestial Powers. Their offspring were the Nephilim, giants of godlike power, abominable to the world. The Angels were imprisoned in the Underworld for their sins, but the Nephilim were partly of this world and could not be banished by the Celestial Powers. The Nephilim made themselves kings over the Avvim, and they fathered sons who became known as the Rephaim. The Nehilim and their sons had unnatural appetites and consumed food, livestock, beasts and finally their own offspring. With time, the Nephilim left Hinnom in search of a purpose and left their sons to rule the Avvim."
#summary "Race: Rephaite giants with enormous appetites.  Lesser Avvite and Horite giants. Prefers Heat scale +2.  Military: Horite cave dwellers, Avvite giants, chariots.  Magic: Fire, Earth, Astral, Blood, some Nature and Air.  Priests: Weak, sacred Rephaite giants, can perform blood sacrifices."
#end 
 
#selectnation 21
#name "EA Atlantis"
#era 2
#brief "Atlantis is an underwater nation of amphibious beings. They do not use missile troops. They have powerful Earth and Water mages and powerful Priests."
#descr "For centuries the seas have been the domain of the Tritons, but recently a nation of beings resembling a cross between, fish, frog, and humans has emerged in the deepest gorges of the oceans. The race is not entirely unknown as there are a few of them who have made shallow coastal reefs their home, but the Triton Kings never imagined that they were numerous or powerful enough to form a nation. These Atlantians of the deeps never stop growing and will live for several hundred years unless killed. The Atlantian society is organized in a strict hierarchy of size and age. The oldest and most cunning Atlantians have made themselves kings and queens of The Basalt City in the deepest reaches of the ocean. The Atlantians of the deeps use weapons of enchanted basalt made by the Basalt Kings."
#summary "Race: Amphibious.  Military: Light infantry, shamblers, no missile weapons.  Magic: Earth, Water, Fire, some Astral.  Priests: Powerful."
#end 
 
#selectnation 22
#name "EA Rlyeh"
#era 2
#brief "R'lyeh is an underwater nation. An ancient race of mentally superior beings has enslaved other races to work for it. R'lyeh has Atlantian and Oceanian troops as well as their own Aboleths. The Aboleths are powerful Astral and Water mages."
#descr "In the deepest of oceans lives the strange fishlike race called the Aboleths. These beings are highly intelligent and the older Aboleths called Mind Lords can enslave lesser beings with the force of mind alone. Having this power means they have enslaved Mermen and Deep Ones to do the daily work and to fill up the ranks of their armies. In a deep gorge the enslaved workers have built a score of small but magnificent cities for their rulers. In this gorge live the greatest of the Aboleths."
#summary "Race: Underwater.  Military: Atlantian and Oceanian slaves, Aboleths.  Magic: Astral, Water, some Earth, Death and Nature.  Priests: Average."
#end 
 

 selectnation 23
 era 1
 end 
 

 selectnation 24
 era 1
 end 
 

 selectnation 25
 era 1
 end 
 

#selectnation 26
#name "EA Oceania"
#era 2
#brief "Oceania is an underwater realm of tritons and mermen. Tritons are unable to leave the sea, but mermen can shed their tails and walk on dry land. Both races have mages, but only the merman mages can leave the sea and their magical power becomes severely reduced when they do. The legendary Bishop Fishes lead the cult."
#descr "For ages the oceans have been dominated by the tritons of Oceania. But recently other races have been stirring in the depths and the Triton Kings muster their forces to meet the new threat. Oceania is a nation of tritons and mermen. Tritons are unable to leave the sea, but mermen can shed their tails and walk on dry land. Both races have mages, but only the merman mages can leave the sea, although their magical power is reduced when they do. The legendary Bishop Fishes are powerful priests and lead the sacred Triton Knights who are mounted on magical Hippocampi steeds."
#summary "Race: Underwater.  Military: Aquatic tritons and amphibious mermen. Light infantry, medium infantry, sacred aquatic knights.  Magic: Water, Nature, some Fire, Air and Earth. Mages weaker on dry land.  Priests: Powerful, underwater only."
#end 
 
#selectnation 27
#name "MA Arcoscephale"
#era 2
#brief "An ancient human kingdom led by Astrologers, Arcoscephale mainly uses heavy infantry, chariots and war elephants. The Astrologers are powerful Astral mages. Mystics skilled in Astral and Elemental magic give Arcoscephale great magical versatility. The priestesses of Arcoscephale can heal wounded soldiers."
#descr "Arcoscephale is an old kingdom. Although its glory days are long past, the ancient Astrologers who aided past kings in building Arcoscephale into a mighty empire have recently emerged from their centuries-old seclusion, to restore the Old Kingdom to world domination once more. Priestesses with great knowledge of healing are trained in ancient temples built during the peak of the Old Kingdom. The priestesses are able to scry upon enemy troops and provinces that are located within the God's Dominion. The war machine of ancient Arcoscephale has not changed over the past centuries. Cumbersome plate hauberks and long spears are still used and the cavalry is primitive. Elephants and chariots, unpredictable but devastating, are still popular."
#summary "Race: Humans.  Military: Heavy spear-armed infantry, elephants, chariots.  Magic: Astral, Fire, Earth, Water, some Nature.  Priests: Average, healing.  Dominion: Scry (accurate and automatic military reports inside dominion)."
#end 
 
#selectnation 28
#name "MA Ermor"
#era 2
#brief "Ermor was a human empire that was corrupted and fell into darkness. Now Ermor is a land where the dead and the living walk side by side. Ermor uses legionnaires and undead. Their Thaumaturgs are skilled mages of Death and Astral magic. They are also unholy priests capable of reanimating the dead."
#descr "Ermor was once a great empire that had conquered most of the known world. The realm crumbled as the great mages of the Empire studied dark magic under the Sauromancers of C'tis. Unaware of the dangers of dark sorcery, priests performed unholy rites in the capital city of Eldregate. In one cataclysmic event, Death was let loose. Only with extreme sacrifice did the Empire prevail. The Old Ermorian Faith was abandoned and the Death Cult was introduced to hold Death at bay. If the proper ceremonies are not performed, Death will once again walk the land. The Ermorian Thaumaturgs are leaders of the Death Cult and are able to call on the dead to make them fight side by side with the Ermorian legions. The human portion of the Empire's army consists of legionnaires."
#summary "Race: Men and undead. Undead do not need supplies, can enter water, are unbreakable and can walk day and night.  Military: Human legionnaires and undead hordes of lesser quality.  Magic: Astral, Death.  Priests: Can reanimate the dead."
#end 
 
#selectnation 29
#name "MA Pythium"
#era 2
#brief "Pythium is a splinter empire that broke free from Ermor when it fell. Pythium uses legionnaires, but also has Serpent Cataphracts and hydras. The Theurgs of Pythium are powerful priests and Astral mages. Pythium uses Theurgical communion to empower their mages in battles."
#descr "The Emerald Empire of Pythium is a splinter empire of the great Empire of Ermor. As dark arts were practiced in the heart of the Empire, the stars warned the Theurgs of Pythia to flee the impending doom. They led Pythia away from the falling Empire and formed an imperial theocracy under their wise rule. but this was not enough to save them. As Ermor crumbled, the provinces of Pythium rebelled and broke away from their old masters. The Emperor of Pythium could not reclaim the rebelling lands and the power of the Emerald Empire diminished over the centuries. The war machine of Pythium is based on the old legionnaire army of Ermor with some minor modifications. During Ermorian times, part of the Pythian lands was under the sway of the Sauromatian tribes. The Androphags used hydras of the Pythian Marshes in warfare. For a long time hydras were only used in the Pythian arenas, but now the old practice has been adopted along with the usage of serpent mounts."
#summary "Race: Humans.  Military: Legionnaires, Serpent Cataphracts, gladiators, hydras.  Magic: Astral, Air, Water, some Fire.  Priests: Powerful."
#end 
 
#selectnation 30
#name "MA Man"
#era 2
#brief "Man is a feudal kingdom of humans. They use knights and skilled longbowmen. They have powerful mages of Nature and Air, but their priests are weak. They have powerful special troops of Avalon."
#descr "The kingdom of Man is a feudal kingdom. Their kingdom was established by conquering a race of tall and magically powerful beings known as the Tuatha. When the Tuatha were destroyed, their greatest treasure was found: the magical forest of Avalon. Hidden deep within was great magic. The Witches of Man entered the forest, learned the old lore, and helped Man to grow in power and influence. The infantry of Man is limited and lacks heavy troops. Their regular armies most often consist of powerful knights and skilled longbowmen. The Witches train their own special troops: the Wardens and Knights of Avalon. These troops are very skilled and are also magically enchanted by the Witches."
#summary "Race: Humans.  Military: Infantry, longbowmen, knights, special troops of Avalon.  Magic: Spell Songs, Nature, Air, some Water and Earth.  Priests: Weak."
#end 
 
#selectnation 31
#name "MA Ulm"
#era 2
#brief "Ulm is a human kingdom famous for its steel. They use heavy infantry and heavy knights. Even their crossbowmen use heavy armor. Their smiths, Earth mages of limited skill, are able to forge magic items at reduced cost. The priests of Ulm are weak."
#descr "Ulm is a young kingdom, risen from the Ulmic tribes conquered by the fallen Empire of Ermor. From the ashes of Ermor emerged a new kingdom true to its ancient legacy, the Enigma of Steel. Where Marignon relied on religion to build a kingdom, Ulm relied on steel. The mines of Ulm are famous for their riches and the smiths of Ulm work the iron into the blacksteel armor used by the knights and infantry of Ulm. The people of Ulm are heavily built by human standards. Their infantry use full chain or plate armor made of blacksteel. The feared Black Knights of Ulm are the most heavily armored troops known to man. The leaders of Ulm have never approved of magic and only the Master Smiths are allowed to use it. The smiths are used to working in conditions that are magically unfavorable and are therefore not adversely affected by provinces that have a strong Drain dominion. The smiths craft armor and weaponry for lords and kings, but the strength of steel is preferred to magic. Even religion is of secondary importance in Ulm."
#summary "Race: Stocky humans, production bonus in all castles.  Military: Heavy infantry, crossbows, knights, superior armor.  Magic: Earth, Fire, rarely Air and Astral. Superior magic item forging. Smiths are not affected b Drain scale.  Priests: Weak."
#end 
 
#selectnation 32
#name "MA Marignon"
#era 2
#brief "Marignon is a human kingdom based on religious zeal. Holy knights and Inquisitors ride out to purge the world of enemy faiths. Marignon has powerful Fire mages and powerful priests."
#descr "Marignon is a feudal theocracy. The Inquisition controls all aspects of the country, including warfare. The feudal lords pay tithes and tax the peasants, but all political decisions are made solely by the Church. Marignon rose out of the ashes of Ermor and has succeeded in holding the shadow of the fallen empire at bay through religious zeal and austerity. The widespread fanaticism in Marignon has done wonders for its survival thus far. The heavy infantry of Marignon is armed with large weapons such as great swords and halberds. All units carry the bright red-and-orange livery of Marignon. The Inquisitors of Marignon are trained in the House of Fiery Justice together with Witch Hunters. The Witch Hunters are mage-priests who use Astral magic."
#summary "Race: Humans.  Military: Heavy infantry, crossbows, knights.  Magic: Fire, Astral, some Air and Earth.  Priests: Powerful, Inquisitors."
#end 
 
#selectnation 33
#name "MA Mictlan"
#era 2
#brief "Mictlan is an old kingdom ruled by priest-kings. Mictlan has powerful priests, but its infantry uses archaic weapons."
#descr "Mictlan is an ancient tribal empire that has been isolated for centuries. The foul practices of the priest-kings of Mictlan have caused most neighbors to leave or face slavery or death by sacrifice. Since the dawn of the kingdom, blood has been spilled in the temples of the capital. Now a new era has dawned and the isolation is broken with the coming of the Lawgiver. The Blood Cult has been abolished and the priests now follow the Lawgiver. Isolation has made Mictlan a backward nation and its warriors use archaic weaponry and armor. The armies are mainly composed of slaves from newly conquered lands. the mage-priests of Mictlan celebrate the two Faces and the two Dominions of the Lawgiver, namely the Sun and the Moon, the Rain and the Forest."
#summary "Race: Humans, prefers Heat scale +1.  Military: Light infantry with slings and javelins, tribal kings can levy slaves.  Magic: Fire, Astral, Nature, Water.  Priests: Powerful."
#end 
 
#selectnation 34
#name "MA T'ien Ch'i"
#era 2
#brief "T'ien Ch'i is a bureaucratic empire. Versatile mages of The Way of the Five Elements, Celestial Masters and religious ministers serve the Emperor. The cavalry of the Empire is well known and sacred Celestial Beings form the elite core of the armies. Provinces inside Dominion gain local defence for free."
#descr "The Celestial Empire of T'ien Ch'i is ancient. Since the founding of the Empire, peace has reigned and a Bureaucracy of great efficiency has evolved. Ministers and officials chosen by skill rather than birth govern the Empire. The Emperor and his family are considered divine, but are not involved in the administration. The cavalry of T'ien Ch'i is well known and the Bureaucracy has enforced a conscription policy that has been very successful. A magic tradition called The Way is practiced by hermits and scholars in the kingdom. Prominent Masters of the Way come to the Heavenly Gate in the capital to be ordained as Celestial Masters. These mage-priests can summon heavenly beings from the Celestial Sphere to serve the Empire."
#summary "Race: Humans.  Military: Cavalry, heavy infantry, archers, crossbows. Conscription.  Magic: Water, Astral, Air, some Earth and Nature, Summon Celestial Beings.  Priests: Average.  Dominion: Conscription (defence increases in provinces with Order scale)."
#end 
 
#selectnation 35
#name "MA Machaka"
#era 2
#brief "A human kingdom ruled by priests. Machaka uses great spider mounts and has both light infantry and heavy hoplites. Witch doctors and Black Sorcerers give Machaka a wide range of magical skills. Machakans dislike cold lands."
#descr "Machaka is an old sacral kingdom where the well-being of the land is thought to be dependent on the will of the king. The king is the highest priest of the kingdom, but should he fail in his duties, he is sacrificed and replaced by one of his numerous sons or brothers. The priests of the kingdom are the true rulers of the land. Religious ceremonies, judicial tasks and the gathering of intelligence are all performed by the Eyes, Ears, and Voices of the Lord. Only warfare is handed over to secular commanders. Machaka uses light infantry, archers and heavy hoplites second only to those of Arcoscephale. In the forests of Machaka, giant spiders are caught and used as mounts. One other area is left untouched by the priests: magic. Simple witch doctors living outside villages grudgingly serve the priests. In the depths of the God Forest lies a lonely mountain filled with caves. Here resides the true power of Machaka - the Black Sorcerers, Sorceresses and their Spider Warriors. Machakans prefer hot lands."
#summary "Race: Humans, prefers Heat scale +2.  Military: Heavy infantry, light infantry, spider riders, assassins.   Magic: Fire, Earth, Death, Nature.  Priests: Average."
#end 
 
#selectnation 36
#name "MA Agartha"
#era 2
#brief "A cavern realm of humans and a few remaining Pale Ones. Pale Ones can grow to huge proportions and the old ones are rare and sacred. The Agarthan humans have only limited night vision, whereas the Pale Ones see perfectly in the dark."
#descr "In dark caverns under the Roots of the Earth a strange race of one-eyed humanoids has evolved. Untouched by the sun, they have become known to humans as the Pale Ones. When humans first met these pale giants, it was in war. With the destruction of the false god of the Pale Ones, peace was established and humans moved down into the caverns of Agartha. Here they found fabulous riches and ancient secrets. The humans slowly replaced the Pale Ones and now most of Agartha's inhabitants are pale-skinned humans with large eyes. Everything left by the Ancient Ones has become subject to worship by the humans. Ancient statues are enchanted and given life by Golem Crafters, priest-mages of the Agarthan Golem Cult. A few surviving Oracles lead the Cult and keep the memories of past ages alive."
#summary "Race: Humans and Pale Ones. Darkvision. Poor amphibians.  Military: light and heavy infantry, huge and sacred Ancient Ones.  Magic: Earth, some Fire, Water and Death.  Priests: Powerful."
#end 
 
#selectnation 37
#name "MA Abysia"
#era 2
#brief "Abysians are lava-born humanoids that radiate heat. Abysians mainly use heavy infantry. They have skilled Fire and Blood mages and their priests can perform blood sacrifices. Abysians dislike cold provinces."	
#descr "Abysia is a hot wasteland at the center of which lies a great volcano whose lava-lit caverns are inhabited by magma-born humanoids. Their flesh radiates heat and they are not harmed by flames. Abysians are stronger than humans and prefer heavy armor and weaponry. Bows are not used, as they would turn to cinders in the glowing hands of the Abysians. The war machine of Abysia also includes Salamanders, lizardlike beings composed of the same hot lava-born flesh as the Abysians. Abysian Warlocks are very powerful Blood mages and skilled crossbreeders. The Anathemant Priests of the Flame Cult practice blood sacrifice to strengthen the power of the Awakening God. Abysians prefer to live in extremely hot places. They do not farm or hunt for a living, so their income and supplies are not affected by the Growth/Death scale of a province. However, population will still die slowly in Abysia-controlled provinces with Death scales."
#summary "Race: Radiates heat, fire resistance, prefers Heat scale +3, wasteland survival.  Military: Heavy infantry, no missile weapons, salamanders.  Magic: Fire, Blood, Astral, some Earth.  Priests: Powerful, can perform blood sacrifices."
#end 
 
#selectnation 38
#name "MA Caelum"
#era 2
#brief "Caelum is a magocracy of slender, winged beings living on the coldest mountaintops. They are skilled archers and train war mammoths. The heavy infantry of Caelum uses arms and armor of magical ice. Caelian Seraphs are powerful mages of wind and frost. They are cold resistant and dislike warm lands."
#descr "Caelum is a magocracy of winged humanoids inhabiting the highest mountain peaks. In ancient times, there were three Caelian clans, but when the Harab Seraphs of the Raptor Clan began to study the dark ways, the High Caelians condemned them and civil war broke out. The Raptor Clan was banished and scattered across the world. The Eagle Kings were replaced by the High Seraphs of the Palace of Frozen Crystal. The Seraphs are masters of Air magic and craft the magical ice that Caelians use instead of regular metal. The ice tempers with lower temperatures and the heavy ice armor is more durable in cold climates than in warmer ones. All weapons crafted from the ice are magical and capable of harming magical beings. The High Caelians live in the coldest mountain peaks and are unaffected by low temperatures. They are thin and light. Spire Horn Caelians are less resistant to cold but have partial resistance to lightning. The Caelians are skilled archers and prefer hit-and-run tactics, even though they do have some heavy troops, such as huge Mammoths."
#summary "Race: Flying, cold resistant, partially shock resistant, prefers Cold scale +3.  Military: Flying units, skilled archers, mammoths.  Magic: Air, Water, some Astral and Death.  Priests: Average."
#end 
 
#selectnation 39
#name "MA C'tis"
#era 2
#brief "C'tis is an ancient kingdom of lizardmen. They do not use cavalry or archers, but use poison slingers instead. C'tis has powerful priest-kings. The Dominion of C'tis causes lands to turn into rotting marshlands. The lizards dislike cold provinces."
#descr "C'tis is a swampy river valley surrounded by sandy deserts. In the fertile valley a sacral kingdom of lizardlike humanoids has formed. The kingdom is ancient by human standards and its wisdom and magical knowledge are great. At the top of the society are the Lizard King and his Royal Heirs. The King is the highest priest of C'tis. Under the king are the High Priests with their sacred serpents. The lizards are herbivores, but have enslaved a race of carnivorous lizardmen who serve as soldiers and workers. The C'tissians are somewhat slow in movement, but have thick hides that protect them from cuts and bruises. Both lizard races are cold-blooded and become exhausted very quickly when fighting in cold provinces. They have partial resistance to poisons. The inhabitants of C'tis prefer to live in warm provinces. With the coming of the new God, the swamps of C'tis have begun to spread. Dense rains and oppressive heat turn the land into unhealthy marshlands, thick with the stench of rotting vegetation. Marshmasters have taken the place of the Sauromancers of old and the Swarm Guard has replaced the chariots as elite troops. In this land, the lizards prosper. Within provinces influenced by this Dominion, income is increased by 1 percent per level of Dominion, and the income of enemy provinces is reduced by 5 percent per level of Dominion. Unless cold-blooded, soldiers inside the Dominion will suffer from disease."
#summary "Race: Thick hides, cold-blooded, poison resistance, prefers Heat scale +1.  Military: Chariots, infantry, slave warriors, sacred serpents.  Magic: Death, Nature, Water, some Astral.  Priests: Powerful."
#end 
 
#selectnation 40
#name "MA Pangaea"
#era 2
#brief "Pangaea is a woodland realm of wild halfmen. Pangaea has stealthy satyrs, flying harpies, strong centaurs, and raging minotaur warriors. The Panii are powerful mages of Nature and Earth and are able to lure women into the wild."
#descr "Pangaea is a woodland nation inhabited by wild beings connected with nature. Halfmen such as satyrs, centaurs, and minotaurs serve the lords of the Sacred Groves deep in the forests. In ancient times, the woods covered much of the world, but that has changed. Man is no longer beast and animals are no longer wild. The world of the wild is disappearing. Centaurs have developed civilized societies and donned armor. The Panii, guardians of the Groves, have decided that it is time to act to preserve their dwindling habitat."
#summary "Race: Forest Beings, stealthy troops, troops may heal their battle afflictions.  Military: Satyr and minotaur infantry, centaur cataphracts, warriors and archers.  Magic: Magical Tunes, Nature, Earth, Blood, some Death.  Priests: Average."
#end 
 
#selectnation 41
#name "MA Vanheim"
#era 2
#brief "Vanheim is a human nation ruled by Vanir, ancient enemies of the Jotun giants. Vanir can sail across the oceans and hide themselves with illusions. They mostly use infantry, but utilize many unique troops, including flying Valkyries, human berserkers and skinshifters. Their Dwarven smiths are powerful Earth mages."
#descr "Vanheim is a land of misty moors and bitter forests. Humans compose most of the Population, but the rulers of the land belong to a tall and innately magical race known as the Vanir. The Vanir once fought the giants of Jotunheim, but with the coming of man, they have turned their attention elsewhere. Now only a precious few of the Vanir remain and humans are no longer slaves. Humans compose the basic infantry units of Vanheim. The Vanir have blessed some loyal humans with superior fighting skills and the ability to enter a state of wild rage or wolven shape. The Vanir are masters of illusion who fight while mounted on exceptionally fast horses. Female Vanir are called Valkyries and have the ability to fly. This ability was a gift from a dead god who used them as messengers of death. During those days, blood was sacrificed. The old ways have not been used in ages, but still the oldest of the Vanir remember how to sate nature with blood. The Vanir are very skilled sailors and can sail the oceans."
#summary "Race: Ocean sailing, flying troops, illusions, prefers Cold Scale +1.  Military: Heavy infantry, skinshifters, Valkyries, Vanir.  Magic: Air, Earth, Blood, some Fire and Death.  Priests: Average, can perform blood sacrifices."
#end 
 
#selectnation 42
#name "MA Jotunheim"
#era 2
#brief "Jotunheim is the home of the giants of the north. Jotuns are immune to the cold and dislike hot lands. Their Vaetti allies use wolf riders, but no heavy cavalry or bows are used. Their mages are versatile and powerful sorcerers."
#descr "Jotunheim is a land of bitter winters and cool summers. It is the home of giants and goblins. The giants of Jotun are immensely strong and resilient. They are born in the cold and do not suffer from cold climates. Jotunheim is ruled by several Jarls who rarely join forces. In the heart of Jotunheim lies an ancient Forest of Iron and Ice. Here live the Gygjas, old wicked hags with great sorcerous skills. They are served by the Vaettir, who are small, wicked goblins of the Jotun woodlands. They rarely venture outside the woodlands, but do join the armies of Jotunheim when the Gygjas bid them to. The people of Jotunheim prefer to live in very cold provinces."
#summary "Race: Cold resistant, needs lots of supplies, prefers Cold scale +2.  Military: Giant infantry, Vaettir, and Wolf Riders.  Magic: Water, Blood, Death, Nature, Astral.  Priests: Average."
#end 
 
#selectnation 43
#name "MA Bandar Log"
#era 2
#brief "In the dense forests of the Bandar is a realm of intelligent apes. The exceptionally smart white apes are sacred and blessed with the gift of magic. The apes have a multitude of missile weapons and have trained elephants and tigers to be used in warfare."
#descr "In the dense forests of the Bandar realm, apes of uncanny brightness have emerged. Under the influence of semi-divine beings, the apes have evolved intelligence and culture. When the former rulers of Bandar Log returned to their Celestial Realms, the apes were left without leadership. A warlike, hierarchical society was formed with the large Bandar apes at the top. But the influence of the former masters was not forgotten and the blessed white apes who were gifted with higher intelligence and magical powers were able to keep their influence and power. Bandar Log is a divided society. Small Markatas are at the bottom of the society. Vanara apes of human size are the most common. Large Bandar apes rule most of the society and form the military. Sacred white apes are trained as sages, priests and holy warriors."
#summary "Race: Apes.  Military: A multitude of missile weapons, light and medium infantry, elephants, sacred tiger riders.  Magic: Astral, Nature, some Water and Earth.  Priests: Weak."
#end 
 
#selectnation 44
#name "MA Shinuyama"
#era 2
#brief "Shinuyama is a nation of Bakemono, ghostly goblins of the wilderness. Some of them have supernatural abilities such as an aura of fear or shapeshifting abilities."
#descr "When the entrance to the Netherworld closed, the Oni became fewer and fewer. Their Bakemono slaves and human servants rebelled, and when the last of the Dai Oni died, the realm was taken over by Bakemono Kings. Human smiths were forced to reveal the secrets of metalcraft and the Bakemono have become ready to conquer the lowlands from the humans. The Bakemono still live in a tribal society ruled by the strongest and most powerful of their kin. The Bakemono are a diverse kind: huge lumbering O-Bakemono, proud Dai-Bakemono, strange shapeshifters and ghostly apparitions all heed the call of the Bakemono Kings and the Awakening God."
#summary "Race: Bakemono.  Military: Light infantry, medium infantry, heavy infantry. Kappas able to enter the sea, supernatural commanders.  Magic: Death, Fire, Earth, Water, Nature. Many national summons.  Priests: Weak."
#end 
 
#selectnation 45
#name "MA Ashdod"
#era 2
#brief "Ashdod is a wasteland inhabited by giants. The giants have degenerated since earlier times and only in the twin cities live the Anakim of pure blood."
#descr "Ashdod is a dry wasteland inhabited by the Rephaim, giants descended from the Nephilim of primordial times. The Rephaim have degenerated and lost the prodigal powers of their predecessors, but they are still mighty in comparison to other beings. While not as mighty as they once were, there are still a few Rephaim with pure blood. In the twin cities of Ashdod and Ashkelon live the Anakim, mightiest of the Rephaim, and the Anakite priest-kings. With the disappearance of the Nephilim and the pureblooded Rephaim, the Nephilim Cult has been replaced by ancestor worship. Malikum, Rephaite kings of old, are worshipped at sacred banquets for the dead. The Kohanim of earlier times have been replaced by the Zamzummim, priest-mages and shepherds of the dead, who fulfill their purpose in life by being devoured at the funerary banquets."
#summary "Race: Giants.  Military: Rephaite giant infantry and human slaves. Prefers Heat scale +2.  Magic: Fire, Earth, Astral, Death.  Priests: Weak, with one medium priest, sacred Anakite giants."
#end 
 
#selectnation 46
#name "MA Atlantis"
#era 2
#brief "Atlantis is an underwater nation of amphibious beings. They do not use missile troops. They have powerful Water mages and powerful priests."
#descr "When the Star fell into the sea the Basalt City and the Dark Crystal were destroyed, the reign of the Basalt Queens was ended and the surviving Atlantians reformed the kingdom. Atlantis is an underwater nation of strange beings resembling a cross between fish, frog and human. Atlantians never stop growing and will live for several hundred years unless killed. The Atlantian society is organized in a strict hierarchy of size and age. The oldest and most cunning Atlantians are trained as priests or mages. Because the Atlantians find it difficult to use magic, they often capture human children and train them in magic in the Coral Towers. The soldiers of Atlantis use spears tipped with living coral shards and wear armor made of coral chunks. The coral is poisonous and is cultivated solely for the purposes of war."
#summary "Race: Amphibious.  Military: Coral-armed infantry, shamblers, war lobsters, no missile weapons.  Magic: Water, Astral, Fire, Earth.  Priests: Powerful."
#end 
 
#selectnation 47
#name "MA R'lyeh"
#era 2
#brief "R'lyeh is an underwater nation. An ancient race of mentally superior beings from a fallen star has enslaved a colony of Atlantians. R'lyeh has Atlantian slave troopers, strange hybrids and Illithids who use mind blasts. The Starspawns of R'lyeh are powerful Astral mages."
#descr "In ages past, a distant star inhabited by a great race of strange, alien beings was struck with an unimaginable catastrophe. The star fell from the heavens, breaking into tiny shards. One such shard fell through the Spheres and down upon the world. The shard came to rest on the ocean floor and there a remnant of this great race adapted and survived. They multiplied and enslaved a race of fishlike humanoids by sheer strength of mind. R'lyeh, the Sunken City, is a mind-defying place built under the sea with an architecture unlike any known to man. In the halls of R'lyeh the Starspawns, the Great Ones who survived the Fall, plan the re-emergence of their Great Race. The Starspawns are powerful mages with great knowledge of distant stars and all of the Great Race are powerful mindcrafters. All coastal forts of R'lyeh have a special well where women can submerge themselves in the hope of being impregnated by a Great One. However, most will be taken by Deep Ones instead, and the women's offspring will be strange, fishlike humanoids instead of the noble Starchildren they wanted. These half-human hybrids are usually devoted to the cause of putting mankind below the sea and often join the army of R'lyeh free of charge."
#summary "Race: Underwater.  Military: Atlantian and Oceanian slaves, hybrids, Illithids.  Magic: Astral, Water, Earth, Death, some Nature.  Priests: Average, can summon Void Beings."
#end 
 
#selectnation 48
#name "MA Oceania"
#era 2
#brief "Oceania is an underwater nation. Tritons are unable to leave the sea, but mermen and ichtysatyrs can shed their tails and walk on dry land. The Capricorn is a powerful Nature and Water mage, but loses some of his power if he leaves the sea. Sirens can take birdshape and lure enemies into the sea. The legendary Bishop Fishes lead the Cult."
#descr "Oceania is an underwater realm of tritons and half-men. Since the Atlantians emerged from the deeps, the tritons have lost their former domains. Many of the pearl cities have been destroyed and royal bloodlines wiped out. Only with the Fall of the Star was the Atlantian onslaught halted. The Starspawns of the Sunken City enslaved the Atlantians and consumed their will. During the war between Atlantis and R'lyeh, a new God emerged from the depths and the Triton Kings were able to muster their forces and found allies in the mermen and ichtysatyrs of more shallow waters. Now it is time to reclaim the deeps and conquer the world. Wise and powerful Capricorns, mages of the sea and shores, have been given the task of conquering the wild inlands. Sirens, magically skilled mermaids, lure men to watery graves with their beautiful songs."
#summary "Race: Underwater.  Military: Aquatic tritons and amphibious half-men. Light infantry, medium infantry, sacred, amphibious ichtycentaur knights, sirens.  Magic: Nature, Water, some Air and Earth. Mages weaker on dry land.  Priests: Powerful, underwater only."
#end 
 
#selectnation 49
#name "LA Arcoscephale"
#era 2
#brief "An ancient human kingdom led by Astrologers, Arcoscephale mainly uses heavy infantry backed up by strong ape warriors from a distant land and heavily armed war elephants. both Sibyls and Mystics are powerful Astral mages. The priestesses of Arcoscephale have some skill in Nature magic and can heal wounded soldiers."
#descr "Arcoscephale is an old kingdom that once ruled much of the known world. With the fall of the Old Kingdom centuries ago, tradition was the only thing that remained to the population. Mystics and priestesses of the old cult still serve the kings of Arcoscephale. The infantry and cavalry are still hopelessly archaic, but the awakening of the new God has brought some changes. Some traditions have been abandoned and the cavalry has been improved. Skilled and lightly armed phalangites are starting to replace the heavier hoplites and the cardaces. Although the wise Astrologers who aided past kings were killed or disbanded, a new breed of seeresses called the Sibyls has appeared. The Sibyls offer great help in manoeuvring the once-mighty kingdom to a powerful platform for the Awakening God. Priestesses with great knowledge of healing are trained in ancient temples built during the peak of the Old Kingdom. The priestesses are able to scry upon enemy troops and provinces that are located within the God's Dominion."
#summary "Race: Humans.  Military: Heavy spear-armed infantry, elephants, ape warriors.  Magic: Astral, Nature, Fire, Earth, Water, some Death.  Priests: Average, healing.  Dominion: Scry (accurate and automatic military reports inside dominion)."
#end 
 
#selectnation 50
#name "LA Ermor"
#era 2
#brief "Ermor was a human empire that was corrupted and fell into darkness. Now Ermor is a land of the dead. Skeletal legions march from the Ashen Empire to conquer the lands of the living."
#descr "Ermor was once a great empire that had conquered most of the known world. The realm crumbled as the great mages of the Empire studied dark magic under the Sauromancers of C'tis. Unaware of the dangers of dark sorcery, priests performed unholy rites in the capital city of Eldregate. In one cataclysmic event, Death was let loose. For a long time, Death was held at bay by the Ermorian Death Cult, but it was only a temporary solution. The Cult attracted attention from an earlier God, a dark and hungry god. The vast power of this Awakening God erased the boundaries between the land of the living and the land of the dead. Ermor is now a cursed land of ashes and darkness where nothing grows. The bones of long-dead inhabitants reassemble to form legions of undead under the leadership of the cursed priests of the old Ermorian cult. Undead legions are now marching forth to reconquer a world once theirs. The Ermorian Dominion reanimates the dead without the aid of unholy priests. It also destroys the land, turning crops and forests into ashes. Population and supplies are reduced."
#summary "Race: Undead. Do not need supplies, can enter water, are unbreakable and can walk day and night.  Military: Undead legionnaires, wailing ladies, unholy knights and hordes of newly dead.  Magic: Death, some Elemental and Astral.  Priests: Powerful. Can reanimate the dead.  Dominion: Reanimates the dead. Kills population."
#end 
 
#selectnation 51
#name "LA Man"
#era 2
#brief "Man is a feudal kingdom of humans who have almost lost the magic of an earlier age. They use knights, skilled longbowmen and crossbowmen. They have mage scholars who are able to study in magically drained lands. The surviving Wardens of Avalon are sacred stealthy troops."
#descr "The kingdom of Man is a feudal kingdom. Their kingdom was established by conquering a race of tall and magically powerful beings known as the Tuatha. When the Tuatha were destroyed, their magic was taken by the Witches of Man. They helped Man to grow in power and influence, but with the great magic came a great Curse and the Witches dwindled in number and magic left the kingdom. To contain the Curse, the Old Magic was banned and a scholarly order of Magisters replaced the Witches of Avalon and their wild ways. The infantry of Man has evolved since the Age of Avalon and the crossbow is common, but knights and longbowmen still make up a large part of the armies. The Wardens of Avalon have escaped the Curse and are the only remnant of the Old Ways."
#summary "Race: Humans.  Military: Infantry, longbowmen, crossbow-equipped heavy infantry, knights, Wardens of Avalon.  Magic: Air, Earth, Astral, some Fire, rarely Death.  Priests: Average."
#end 
 
#selectnation 52
#name "LA Ulm"
#era 2
#brief "Ulm is a human kingdom destroyed by civil war and a great curse. Hunger for mortal flesh plagues the nobles of the land. An Iron Inquisition controls the kingdom and all magic is banned. Secretive occultists of the Illuminated Order hide in the shadows and manipulate leaders far and close."
#descr "After years of civil war, the Iron Kingdom crumbled. During the Night of the Treason a great Malediction was placed upon the kingdom. The forests became dark and hostile. Wolves and creatures even worse stalked the land. Slowly the kingdom recovered, but it was not what it once was. The knightly order was all but destroyed and the Master Smiths had disappeared. The secrets of blacksteel were forgotten. An order of Black Priests emerged in Ulm. They formed an Iron Cult and forbade the use of magic. Magic outside religion was announced to be sacrilegious and the few surviving Master Smiths were put to the flames. Although magery is forbidden there are some fortune tellers and members of the Order of the Illuminated Ones who secretly ply their trade in the arcane."
#summary "Race: Stocky humans, production bonus in all castles.  Military: Medium infantry, stealthy rangers, knights, ghoul guardians.  Magic: Astral, Blood, some Earth, Death and Nature, rarely Fire.  Priests: Weak."
#end 
 
#selectnation 53
#name "LA Marignon"
#era 2
#brief "Marignon is a human kingdom based on religious zeal. Missionaries sail out to spread the word of the True God. Marignon has powerful priests as well as Fire and Blood mages."
#descr "With the recapture of the Chalice, the threat of heretics has diminished and with the aid of the Goetic Masters' inexpensive human sacrifices, the Infernal forces can be kept dormant and the Holy Knights of the Chalice are no longer needed. Marignon is slowly turning its interests outwards. Recent developments in shipbuilding and navigation have allowed priests and nobles of Marignon to expand the influence of God to distant shores. To bring the True Faith to the heathens has become more important than hunting heretics at home. Witch Hunters have been replaced by Navigators and Chartmakers."
#summary "Race: Humans, Ocean sailing.  Military: Heavy infantry, crossbows, knights.  Magic: Fire, Blood, Astral, Air, some Water and Earth.  Priests: Powerful, Inquisitors."
#end 
 
#selectnation 54
#name "LA Mictlan"
#era 2
#brief "Mictlan is an old kingdom overtaken by Atlantian Kings. Their God hungers and must be sated with blood sacrifice. Mictlan has powerful Water and Blood mages and priests, but its infantry uses archaic weapons."
#descr "When Atlantis was destroyed and the Atlantians scattered, some fled into the deep swamps and jungles of Mictlan. Here they found a people who worshipped the Rain as one aspect of their God. The Atlantian Kings became Kings of Rain and reshaped the faith to their needs. They found the secrets of the ancient Blood Cult and reinstalled the foul practices of ancient times. Then the New God rose, hungry for blood. Now Mictlan is once again expanding its territories to feed the hunger of its Lord. Isolation has made Mictlan a backward nation and its warriors use archaic weaponry and armor. The armies are mainly composed of slaves from newly conquered lands. The mage-priests of Mictlan celebrate the two Faces and the two Dominions of the Hungry God, namely the Sun and the Moon, the Rain and the Forest."
#summary "Race: Humans and Atlantians, prefers Heat scale +1.  Military: Light infantry with slings and javelins, tribal kings can levy slaves. Sacred Atlantians can enter the sea.  Magic: Water, Blood, Fire, Astral, Nature.  Priests: Powerful, can perform blood sacrifices, Dominion does not spread unless blood is sacrificed."
#end 
 
#selectnation 55
#name "LA T'ien Ch'i"
#era 2
#brief "The Celestial Empire is crumbling and the Bureaucracy is all but destroyed. The Imperial Guard is no more and the cavalry of old has been replaced by skilled barbarian horsemen. Ancestral worship is popular once more and the Masters of the Dead are replacing the priests of the Bureaucracy."
#descr "The Celestial Empire is crumbling. Constant invasions from the barbaric khans have all but destroyed the bureaucracy. The Imperial family has been replaced by Barbarian Kings. The Imperial Guard is no more and the cavalry of old has been replaced by skilled barbarian horsemen. Ancestral worship is popular once more and the Masters of the Dead are replacing the priests of the Bureaucracy. The conscription policy is still in use, but not as efficient as before."
#summary "Race: Humans.  Military: Cavalry, heavy infantry, archers. Conscription.  Magic: Water, Earth, Death, Nature, Air, Astral, Summon Celestial Beings.  Priests: Weak."
#end 
 
#selectnation 56
#name "LA Jomon"
#era 2
#brief "Jomon is a feudal nation of human warlords and their samurai warriors. Ninja assassins complement the military forces."
#descr "The rice fields of Jomon were the first to be attacked by the Bakemono onslaught. After years of slavery and mistreatment, the human inhabitants rebelled as the Bakemono had once rebelled against their Oni masters. One by one the Bakemono tribes were replaced by human Daimyos and their sworn warriors. A strict, feudal warrior society replaced the unorganized rule of the Bakemono kings. Even war has become ritualized and the peasants are left largely in peace. With the coming of the God, the Daimyos have joined forces and look for other realms to conquer."
#summary "Race: Humans.  Military: Light infantry, samurai archers, samurai infantry, samurai cavalry, ninja assassins.  Magic: Weak. Astral, Earth, Nature, Fire, Air, Water.  Priests: Average."
#end 
 
#selectnation 57
#name "LA Agartha"
#era 2
#brief "A cavern realm of humans who worship and consult the remains of the older race of Pale Ones. Cave drakes are tamed and used as mounts for their knights. Ktonian necromancers skilled in Death and Earth magic reanimate the dead so they can continue to assist the realm."
#descr "In dark caverns under the Roots of the Earth a strange race of one-eyed humanoids once evolved. Untouched by the sun they became known to humans as the Pale Ones. When humans first met these pale giants, it was in war. With the destruction of the false god of the Pale Ones, peace was established and humans moved down into the caverns of Agartha. Here they found fabulous riches and ancient secrets. The humans replaced the Pale Ones and now all Agarthans are pale-skinned humans with large eyes. Everything left by the Ancients became subject to worship in Agartha. At first, statues of the Ancients were adored and animated by the Golem Crafters, but most of the statues were destroyed during the great war and new forms of worship have evolved. The mummified remains of the now-extinct Pale Ones are worshipped and reanimated by necromancer-priests. While mummies of Pale ones are sacred, the human dead are not treated with the same respect. Used for menial tasks and warfare, the dead of Agartha now walk side by side with the living."
#summary "Race: Humans with limited darkvision.  Military: Light and heavy infantry, steel crossbows, cave drake knights.  Magic: Earth, Death, Fire, some Astral.  Priests: Average."
#end 
 
#selectnation 58
#name "LA Abysia"
#era 2
#brief "Abysians are lava-born humanoids that radiate heat. With the dilution of their blood humanbreds have become increasingly common and now pureblooded Abysians are rare and sacred. Abysians mainly use heavy infantry. They have skilled Fire and Blood mages and their priests can perform blood sacrifices. Abysians dislike cold provinces."
#descr "When the Warlocks began their horrible breeding experiments, they unknowingly spelled the doom of Abysia. But it was not the Demonbreds that posed a threat; it was the Humanbreds, multiplying and swarming the kingdom like vermin. Now the heat of the Smouldercone is faltering with the declining number of pure Abysians and magic is seeping from the land. Other sources of magic are needed and the Blood cult of ancient times is renewed with fervor. Pureblooded Abysians, now rare, serve as priests and sacred warriors."
#summary "Race: Humanbred Abysians. Fire resistance, prefers Heat scale +2, wasteland survival.  Military: Light and heavy infantry, axe throwers.  Magic: Fire, Blood, Astral, some Earth.  Priests: Powerful, can perform blood sacrifices."
#end 
 
#selectnation 59
#name "LA Caelum"
#era 2
#brief "Caelum is a magocracy of slender, winged beings living on the coldest mountaintops. The mages are skilled in Air, Earth and Death magic. They also have Earth smiths capable of producing magic items with very few magic resources. Caelum has very skilled archers and trains mammoths. The nation prefers cold lands."
#descr "Caelum is a magocracy of winged humanoids inhabiting the highest mountain peaks. In ancient times, there were three Caelian clans, but when the Harab Seraphs of the Raptor Clan began to study the dark ways, the High Caelians condemned them and civil war broke out. The Raptor Clan was banished and scattered across the world. The Eagle Kings were replaced by the High Seraphs of the Palace of Frozen Crystal. But now a new God is rising and the scattered tribes have gathered. The Raptors returned to Caelum and overthrew the magocracy. Harab Seraphs, the mage-priests of this new and dark faith, have replaced the High Seraphs and black-winged Raptors have become the ruling elite. Now the Raptors have cast their eyes upon other nations. The Harab Seraphs are skilled in Air, Death and Earth magic. Some Seraphs are still alive and craft the magical ice that Caelians use instead of regular metal. The ice tempers with lower temperatures and the heavy ice armor is more durable in cold climates than in warmer ones. All weapons crafted from the ice are magical and capable of harming magical beings. The High Caelians live in the coldest mountain peaks and are unaffected by low temperatures. They are thin and light. Spire Horn Caelians are less resistant to cold but have partial resistance to lightning. The Raptor Clan Caelians live on the lower mountain slopes and are of heavier stock. They are not as resistant to the elements as the other Caelians. The Caelians are skilled archers and prefer hit-and-run tactics, even though they do have some heavy troops, such as huge Mammoths."
#summary "Race: Flying, cold resistant, prefers Cold scale +1.  Military: Flying units, skilled archers, mammoths.  Magic: Air, Death, Earth, some Water.  Priests: Average."
#end 
 
#selectnation 60
#name "LA C'tis"
#era 2
#brief "C'tis is an ancient kingdom of lizardmen. they do not use cavalry or archers. C'tis has powerful priest-kings and Death mages able to reanimate mummified kings of ancient times. The lizards dislike cold provinces."
#descr "C'tis is a river valley surrounded by sandy deserts. Once the valley was fertile and great swamps surrounded the great river. Now the deserts spread and the swamps grow fewer and smaller each passing year. The valley is the home of an ancient sacral kingdom of lizardlike humanoids. in ancient times, the High Priests of C'tis mastered the craft of embalming to preserve the remains of their kings. Since the dawn of the kingdom, tombs have been constructed in the desert to contain the mummified kings and priests. With the Awakening of the God, the Sauromancers, great mages of death and rebirth, have re-emerged and taken the place of the Marshmasters. Through studies of ancient lore they have perfected dark rituals that awaken the kings of old to lead the stirring dead as the Lizard Kings lead the kingdom of the living. At the top of the C'tissian society is the Lizard King. The King is the highest priest of C'tis. Under the King are the High Priests and the enigmatic Sauromancers. The lizards are herbivores, but have enslaved a race of carnivorous lizardmen who serve as soldiers and workers. The C'tissians are somewhat slow in movement, but have thick hides that protect them from cuts and bruises. Both lizard races are cold-blooded and become exhausted very quickly when fighting in cold provinces. They have partial resistance to poisons. The inhabitants of C'tis prefer to live in warm provinces. The Tomb Kings and Tomb Priests are able to reanimate the dead."
#summary "Race: Thick hides, cold-blooded, poison resistance, prefers Heat scale +1. Reanimated dead.  Military: Infantry, slave warriors, sacred serpents, undead.  Magic: Death, Fire, some Nature, Astral and Earth.  Priests: Powerful, Undead priests."
#end 
 
#selectnation 61
#name "LA Pangaea"
#era 2
#brief "Civilization has finally reached Pangaea and the halfmen have built cities and are using iron armaments. The strong and well-armed minotaurs and centaurs are formidable warriors, but the priests have dwindled in power."
#descr "Pangaea is a woodland nation inhabited by wild beings connected with nature. Halfmen such as satyrs, centaurs and minotaurs serve the lords of the Sacred Groves deep in the forests. In ancient times, the woods covered much of the world, but that has changed. Civilization has finally reached the forests of Pangaea. The old ways are giving way to new traditions. Archaic weapons are replaced by new ones of tempered steel. Ancient cultic practices have all but disappeared and human females once attracted to the wild dances and songs no longer seek the revelry of the Panic tunes."
#summary "Race: Forest beings, stealthy troops, troops may heal their battle afflictions.  Military: Infantry composed of minotaurs, centaurs, satyrs and dryads, centaur cataphracts.  Magic: Magical Tunes, Nature, Earth, Death, rarely Blood.  Priests: Weak."
#end 
 
#selectnation 62
#name "LA Midgard"
#era 2
#brief "Midgard is a human nation whose religious leaders are the few remaining Vanir. Vanir can sail across the oceans and hide themselves with illusions. They mostly use infantry, but utilize many unique troops, including human berserkers and skinshifters. Their human mages are accomplished at Air and Astral magic."
#descr "Once Midgard was called Vanheim, home of the Vanir. But since the coming of man, the Vanir have dwindled in numbers. At first, the Vanir were the undisputed rulers of the land, but the growing human population has taken over the land and renamed it Midgard. Only a few Vanir survive, but their magic has not yet departed the land. The Vanir are sacred to the human population and the few surviving Vanjarls carry great influence. The humans of Midgard themselves have become altered by the ancient magic of the Vanir and skinshifters are more common than they once were."
#summary "Race: Ocean sailing, illusions, prefers Cold scale +1.  Military: Heavy infantry, skinshifters, berserkers, Vanir.  Magic: Air, Astral, Blood, Earth, Death, some Nature.  Priests: Average, can perform blood sacrifices."
#end 
 
#selectnation 63
#name "LA Utgard"
#era 2
#brief "Utgard is the home of the giants of the north. Jotuns are immune to the cold and dislike hot lands. With their numbers dwindling, the giants have allied with humans. They don't use heavy cavalry or bows. The human Norns are versatile and powerful sorceresses and seeresses."
#descr "Utgard is a land of bitter winters and cool summers. It was once Jotunheim, the home of giants. But with the coming of man, their population has dwindled. After man ventured to the icy lands of Jotunheim, the giants of Jotun discovered the humans to be resourceful allies. With the awakening God, all grudges have been cast aside and men and giants fight side by side. The alliance with the humans has estranged the Gygjas and their Vaetti servants, who no longer aid the giants. Instead human seeresses have become influential. In the heart of Utgard lies the magical Well of Urd where the Norns gather and divine the future of the world. The giants of Utgard are immensely strong and resilient. They are born in the cold and do not suffer from cold climates. The people of Utgard prefer to live in cool provinces."
#summary "Race: Cold resistant, needs lots of supplies, prefers Cold scale +1.  Military: Giant infantry, human infantry.  Magic: Water, Astral, Death, Blood, Nature.  Priests: Average."
#end 
 
#selectnation 64
#name "LA Patala"
#era 2
#brief "Patala is a realm of intelligent apes ruled by Nagas, divine serpent beings of the Underworld Realm of Patala."
#descr "In the dense forests of the Bandar realm, apes of uncanny brightness have emerged. Under the influence of semi-divine beings, the apes evolved intelligence and culture. When the former rulers of Bandar Log returned to their Celestial Realms, the apes were left without leadership and innovation in the nation ground to a halt. A warlike hierarchical society was formed with the large Bandar apes at the top. Later, Nagas arrived from the Nether Realm of Patala, from where all rivers spring. The Nagas are divine beings of the Underworld and its rivers and are to the apes what the Yakshas had been in ages past. With mesmerizing stares and dancing serpentine bodies, they entranced the Bandar Log and claimed their empire as their own. Patala is a divided society. Small Markatas are at the bottom of the society. Vanara apes of human size are the most common. Large Bandar apes rule most of the society and form the military. Above all are the sacred Nagas and their kings."
#summary "Race: Nagas and apes.  Military: A multitude of missile weapons, light and medium infantry, sacred naga warriors.  Magic: Water, Earth, Nature, Astral.  Priests: Average."
#end 
 
#selectnation 65
#name "LA Gath"
#era 2
#brief "Gath is a nation of human tribes subjugated by the giants of Gath, last of the Rephaim."
#descr "Gath is a dry land that has only recently recovered from the devastation caused by its earlier inhabitants. For ages the land has been dominated by giants, but under constant pressure from human immigrants and the Abysian Tide of Fire, the original inhabitants of the land were forced to retreat and watch as city after city was destroyed. Now there is but one city left: Gath, the City of Giants. The Gittites still dominate the surrounding land and have subjugated several human tribes. While the human tribes comprise much of the population of the kingdom, the Gittites are the undisputed rulers of the land. By keeping iron-working from the human population and through a strictly centralized cult focused around bloody sacrifices at the Great Temple, the Gittites have kept control of the land. The Gittites are small compared to the ancient Rephaim, but still large by human standards."
#summary "Race: Gittite giants and humans.  Military: Gittite infantry, several human tribes with different skills. Prefers Heat scale +1.  Magic: Fire, Earth, Astral, Nature, Death.  Priests: Medium with powerful priest at capital, temples cost 800 gold, sacred Gibborite giants, can perform blood sacrifices."
#end 
 
#selectnation 66
#name "LA Atlantis"
#era 2
#brief "Atlantis is a nation of amphibious beings that have been forced out of the water. They do not use missile troops. They have powerful Water and Death mages."
#descr "With the Second Fall of Atlantis and the demise of the Coral queens at the hands of R'lyeh, the Atlantians were forced to retreat from the seas. A few surviving Kings of the Deep entered a pact with a sleeping God at a forsaken coast of ice and bones. The Atlantian Angakut, Shaman Kings, lead the Bone Cult and practice Death magic previously unheard of in Atlantian history. The Angakut have coerced captured Caelian ice crafters to yield the secrets of their skills and now most of the Atlantians use arms of enchanted ice. Even their great city is built on interlinked ice floes."
#summary "Race: Amphibious.  Military: Polearms, magical ice armaments, no missile weapons.  Magic: Water, Death, some Air and Earth.  Priests: Medium."
#end 
 
#selectnation 67
#name "LA Rlyeh"
#era 2
#brief "R'lyeh is an underwater nation. A God dreaming of the Void is awakening and inflicting insanity on this world. The army of R'lyeh consists of madmen, Void Beasts, Atlantian slave troopers, strange hybrids, and illithids who use mind blasts. The Starspawns of R'lyeh are powerful Astral mages."
#descr "In ages past, a distant star inhabited by a great race of strange, alien beings was struck with an unimaginable catastrophe. The star fell from the heavens, breaking into tiny shards. One such shard fell through the Spheres and down upon the world. The shard came to rest on the ocean floor and there a remnant of this great race adapted and survived. They multiplied and enslaved a race of fishlike humanoids by sheer strength of mind and conquered the underwater realms of the world. In the halls of R'lyeh the Starspawns, the Great Ones who survived the Fall, opened a gate into the Void and unleashed its horrors upon the world. But the Void was not to be controlled even by the Starspawns. The very fabric of the Veil was weakened and madness struck the inhabitants of mighty R'lyeh. Only the most powerful of the Starspawns were able to keep their minds intact. The Empire crumbled as insanity took the leaders and the former slaves and servants of the Empire were able to lift the yoke of R'lyeh. But now a God is awakening, and it is a God Dreaming of the Void. Mind-defying Dreams of the Sleeping God are plaguing the inhabitants of coastal and underwater cities and with the Dreams come the horrors. Strange, cannibalistic cults worshipping the Void call them from Beyond. The Dreamlands of R'lyeh threaten to destroy the world. All coastal forts of R'lyeh have a special well where women can submerge themselves in the hope of being impregnated by a Great One. However, most will be taken by Deep Ones instead and the women's offspring will be strange, fishlike humanoids instead of the noble Starchildren they wanted. These half-human hybrids are usually devoted to the cause of putting mankind below the sea and often join the army of R'lyeh free of charge."
#summary "Race: Underwater.  Military: Atlantian and Oceanian slaves, hybrids, illithids.  Magic: Astral, Water, Earth, Death, some Nature.  Priests: Average, can summon Void Beings.  Dominion effect: Kills population. Creates dreamers, madmen and Void Beings. Makes all non-Void Beings insane."
#end 
 
#selectnation 68
#name "EA Lanka"
#era 2
#brief "Lanka is a realm of intelligent apes ruled by Rakshasas, demon ogres skilled in dark sorcery and necromancy."
#descr "On the dark and densely forested island of Lanka, Rakshasas, demon ogres from an earlier era, still linger. Gifted with tremendous strength, they once fought the Devatas of Kailasa, but since then the most powerful of the Rakshasas have left this world for the Nether Realms. The remaining Rakshasas have captured and enslaved the monkey people of Kailasa and made them serve as warriors, hunters or food. The Rakshasas had no use for the peaceful White Ones and Kala-Mukhas, Rakshasa halfbreeds, lead the monkey people of Lanka. Since the enslavement of the apes, the ancient conflict between the Devatas of Kailasa and the Rakshasas of Lanka has been renewed."
#summary "Race: Demon ogres, apes and undead.  Military: Strong Rakshasa infantry, missile units and light infantry, reanimated apes.  Magic: Air, Blood, Death, Nature.  Priests: Medium."
#end 
 
#selectnation 69
#name "MA Eriu"
#brief "Eriu was founded when humans defeated the Tuatha in ages past. Now the Tuatha and their Sidhe descendants re-emerge from their hiding places to lead the humans. The Sidhe and Tuatha are able to weave illusions to hide their true appearance. They are skilled Air and Nature mages."
#descr "When men came to the land of the Tuatha and the Fir Bolg, there was a drawn out battle which ended with the defeat and total withdrawal of the Tuatha. The Land of the Ever Young was forever lost to this world and Avalon was taken by the Witches of Man. The Sidhe, descendants of the Tuatha, retreated into strange twilight realms with entrances hidden in ancient mounds. The land of the Fir Bolg was split by the invading forces: Man and their Witches, and the Milesians. The Milesians named their land Eriu. Most of the Eriu population is composed of humans of Milesian ancestry, but a few Fir Bolg still survive in remote villages. With the coming of the new God, the Daoine Sidhe have re-emerged from their magical mounds to lead the Milesians. Eriu is now a nation of humans and Fir Bolg led by the awakening Sidhe."
#summary "Race: Milesian humans and Fir Bolg ruled by Sidhe and Tuatha, illusions.  Military: Milesian infantry, Fir Bolg infantry, sacred Sidhe infantry.  Magic: Spell Songs, Air, Nature, Water, some Earth.  Priests: Average."
#era 2
#end 
 
#selectnation 70
#name "LA Pythium"
#era 2
#brief "Pythium is a splinter empire that broke free from Ermor when it fell. Pythium uses legionnaires, but also has Serpent Cataphracts and hydras. Since the heyday of the Empire, the Theurgs have lost much of their power. Instead, a multitude of heretical mystery cults flourish."
#descr "The Emerald Empire of Pythium was a splinter empire of the great Empire of Ermor. As dark arts were practiced in the heart of the Empire, the stars warned the Theurgs of Pythia to flee the impending doom. They led Pythia away from the falling Empire and formed an imperial theocracy under their wise rule. As Ermor slowly crumbled, the Emerald Empire struggled to keep the old Ermorian provinces under their rule. From these provinces came strange cults and foreign beliefs. Just as Ermor was seduced by the C'tissian cults of Death, the Pythians were fascinated by the exotic practices of the lizardmen. With shadows lingering near, the C'tissian cults were particularly seductive. No other people had such knowledge of Death and the dead. The popularity of the Theurgs diminished and the Serpent Cult gradually replaced the old state cult. But the Serpent Cult was not the only foreign cult that got a foothold in the Empire. Heretical mystery cults flourish and threaten to cast the Empire into disorder. Pythium uses a reformed legionnaire army with frontier soldiers and mobile field troops. The Serpent Cataphracts have received special status and they have become the most respected force in the Empire."
#summary "Race: Humans.  Military: Heavy legionnaires, sacred Serpent Cataphracts, gladiators, sacred hydras.  Magic: Access to weak mages of al paths, with stronger mages of Nature.  Priests: Weak, one available priest of average level. Heretical mystics who lower Dominion."
#end 
 
#selectnation 71
#name "LA Bogarus"
#era 2
#brief "Bogarus is a nation of humans that have replaced the vanir as rulers of a cold and inhospitable land. From mighty cities, princes and religious leaders carve an empire out of the frozen lands. Mages of various traditions ply their trade sponsored by the princes. In villages across the land fanatic cults of flagellants have formed."
#descr "Bogarus is a land of harsh winters and short summers. When the Vanir claimed the cold and bitter land of the north they named it Vanarus and carved a kingdom out of the frozen land. Now humans have replaced the last of the Vanjarls and the kingdom is now guided by Eparchs and Exarchs. Mighty cities under the rule of the warring princes have united under a few Grand Princes and a reformed faith. Bogatyrs of heroic stature and prowess, defenders and champions of the faith, occasionally emerge to lead and protect the people from the wicked. The Grand Princes use infantry as well as elite cavalry forces. Mages of various traditions ply their trade in the palaces of the Grand Princes. The People of Bogarus prefer a cold climate."
#summary "Race: Humans with partial cold resistance.  Military: Heavy cavalry, mounted archers, infantry.  Magic: Fire, Astral, Blood, some Air and Death, Summonable beings of earlier eras.  Priests: Powerful."
#end 
 
#selectnation 72
#name "Filler 72"
#era 0
#end 
 
#selectnation 73
#name "Filler 73"
#era 0
#end 
 
#selectnation 74
#name "Filler 74"
#era 0
#end 
 
#selectnation 75
#name "Filler 75"
#era 0
#end 
 
#selectnation 76
#name "Filler 76"
#era 0
#end 
 
#selectnation 77
#name "Filler 77"
#era 0
#end 
 
#selectnation 78
#name "Filler 78"
#era 0
#end 
 
#selectnation 79
#name "Filler 79"
#era 0
#end 

--- Twan's very cunning Mists of Deception fix---
#newspell
#name "Summon Ghost Wolves"
#school 1
#path 0 1
#pathlevel 0 3
#researchlevel 2
#fatiguecost 10
#damage 298
#flyspr 10001
#explspr 10001
#effect 1
#nreff 2
#range 5
#precision 0
#descr "The illusionist create 2 phantasmal wolves that attack the ennemy"
#end

#newspell
#name "Summon Phantasmal Warrior"
#school 1
#path 0 1
#pathlevel 0 1
#researchlevel 1
#fatiguecost 10
#flyspr 10001
#explspr 10001
#effect 1
#range 5
#precision 0
#damage 297
#nreff 1
#descr "The illusionist creates a phantom warrior who attacks his ennemies. These warriors move spasmoficaly, sometimes moving far sometimes not at all."
#end

#selectspell "Phantasmal Warrior"
#school -1
#effect 9043
#nreff 1002
#nextspell "Ghost Wolves"
#end

#selectspell "Ghost Wolves"
#school -1
#effect 9043
#nreff 1001
#nextspell "Mist"
#end

#selectspell "Mists of Deception"
#effect 9043
#damage 695 
#nreff 2
#nextspell "Phantasmal Warrior"
#end

#end

--- Research changes - spells of level 6 and below are lowered by one level. ---
--- Many thanks to DrPraetorious for the excellent awk script ---
#selectspell "Manifest Vitriol"
#researchlevel 5
#end
--"Fire Flies"
#selectspell 95
#researchlevel -1
#end
--"Air Shield"
#selectspell 96
#researchlevel -1
#end
--"Freezing Touch"
#selectspell 97
#researchlevel -1
#end
--"Flying Shards"
#selectspell 98
#researchlevel -1
#end
--"Twist Fate"
#selectspell 99
#researchlevel -1
#end
--"Hand of Dust"
#selectspell 100
#researchlevel -1
#end
--"Sleep Touch"
#selectspell 101
#researchlevel -1
#end
--"Bleed"
#selectspell 102
#researchlevel -1
#end
--"Unholy Command"
#selectspell 103
#researchlevel -1
#end
--"Unholy Protection"
#selectspell 104
#researchlevel -1
#end
--"Unholy Blessing"
#selectspell 105
#researchlevel -1
#end
--"Unholy Power"
#selectspell 106
#researchlevel -1
#end
--"Anathema"
#selectspell 107
#researchlevel -1
#end
--"Unholy Protection"
#selectspell 108
#researchlevel -1
#end
--"Unholy Blessing"
#selectspell 109
#researchlevel -1
#end
--"Apostacy"
#selectspell 110
#researchlevel -1
#end
--"Unholy Power"
#selectspell 111
#researchlevel -1
#end
--"Unholy Blessing"
#selectspell 112
#researchlevel -1
#end
--"Protection of the Sepulchre"
#selectspell 113
#researchlevel -1
#end
--"Power of the Sepulchre"
#selectspell 114
#researchlevel -1
#end
--"Revive Lictor"
#selectspell 115
#researchlevel -1
#end
--"Revive Censor"
#selectspell 116
#researchlevel -1
#end
--"Revive Acolyte"
#selectspell 117
#researchlevel -1
#end
--"Revive Bishop"
#selectspell 118
#researchlevel -1
#end
--"Revive Arch Bishop"
#selectspell 119
#researchlevel -1
#end
--"Revive Spectator"
#selectspell 120
#researchlevel -1
#end
--"Revive Dusk Elder"
#selectspell 121
#researchlevel -1
#end
--"Revive Shadow Tribune"
#selectspell 122
#researchlevel 0
#end
--"Revive Wailing Lady"
#selectspell 123
#researchlevel 1
#end
--"Lictorian Guard"
#selectspell 124
#researchlevel 2
#end
--"Revive Wraith Centurion"
#selectspell 125
#researchlevel 4
#end
--"Lamentation"
#selectspell 126
#researchlevel 4
#end
--"Revive Wraith Senator"
#selectspell 127
#researchlevel 5
#end
--"Revive Wraith Consul"
#selectspell 128
#researchlevel 7
#end
--"Great Lamentation"
#selectspell 129
#researchlevel 7
#end
--"Soul Gate"
#selectspell 130
#researchlevel 8
#end
--"Lictorian Legion"
#selectspell 131
#researchlevel 8
#end
--"Ermorian Legion"
#selectspell 132
#researchlevel 5
#end
--"Revive Grave Consort"
#selectspell 133
#researchlevel -1
#end
--"Revive Tomb Priest"
#selectspell 134
#researchlevel -1
#end
--"Revive Tomb King"
#selectspell 135
#researchlevel -1
#end
--"Protection of the Grave"
#selectspell 136
#researchlevel -1
#end
--"Power of the Grave"
#selectspell 137
#researchlevel -1
#end
--"Protection of the Grave"
#selectspell 138
#researchlevel -1
#end
--"Royal Power"
#selectspell 139
#researchlevel -1
#end
--"Royal Protection"
#selectspell 140
#researchlevel -1
#end
--"Power of the Reborn King"
#selectspell 141
#researchlevel -1
#end
--"Song of Bravery"
#selectspell 142
#researchlevel -1
#end
--"Soothing Song"
#selectspell 143
#researchlevel -1
#end
--"Healing Song"
#selectspell 144
#researchlevel -1
#end
--"Tune of Fear"
#selectspell 146
#researchlevel -1
#end
--"Tune of Growth"
#selectspell 147
#researchlevel -1
#end
--"Tune of Dancing Death"
#selectspell 148
#researchlevel -1
#end
--"Carrion Centaur"
#selectspell 149
#researchlevel 0
#end
--"Quick Roots"
#selectspell 150
#researchlevel 0
#end
--"Carrion Lady"
#selectspell 151
#researchlevel 3
#end
--"Regrowth"
#selectspell 152
#researchlevel 3
#end
--"Carrion Lord"
#selectspell 153
#researchlevel 5
#end
--"Mend the Dead"
#selectspell 154
#researchlevel 5
#end
--"Puppet Mastery"
#selectspell 155
#researchlevel 5
#end
--"Carrion Woods"
#selectspell 156
#researchlevel 8
#end
--"Carrion Growth"
#selectspell 157
#researchlevel 8
#end
--"Sloth of Bears"
#selectspell 158
#researchlevel 2
#end
--"Pack of Wolves"
#selectspell 159
#researchlevel 2
#end
--"Sanguine Heritage"
#selectspell 160
#researchlevel -1
#end
--"Summon Sirrush"
#selectspell 161
#researchlevel 4
#end
--"Summon Monster Toads"
#selectspell 162
#researchlevel 4
#end
--"Contact Sirrush"
#selectspell 163
#researchlevel 4
#end
--"Contact Couatl"
#selectspell 164
#researchlevel 7
#end
--"Devourer of Souls"
#selectspell 165
#researchlevel 9
#end
--"Call Amesha Spenta"
#selectspell 166
#researchlevel 8
#end
--"Contact Harbinger"
#selectspell 167
#researchlevel 5
#end
--"Angelic Host"
#selectspell 168
#researchlevel 7
#end
--"Heavenly Wrath"
#selectspell 169
#researchlevel 7
#end
--"Heavenly Choir"
#selectspell 170
#researchlevel 9
#end
--"Bind Harlequin"
#selectspell 171
#researchlevel 0
#end
--"Reascendance"
#selectspell 172
#researchlevel 7
#end
--"Pack of Wolves"
#selectspell 173
#researchlevel 2
#end
--"Pack of Wolves"
#selectspell 174
#researchlevel 2
#end
--"Illwinter"
#selectspell 175
#researchlevel 5
#end
--"Summon Jaguar Toad"
#selectspell 176
#researchlevel 0
#end
--"Summon Jaguars"
#selectspell 177
#researchlevel 2
#end
--"Summon Monster Toad"
#selectspell 178
#researchlevel 4
#end
--"Contact Couatl"
#selectspell 179
#researchlevel 5
#end
--"Summon Tlaloque"
#selectspell 180
#researchlevel 7
#end
--"Bind Beast Bats"
#selectspell 181
#researchlevel 1
#end
--"Bind Jaguar Fiends"
#selectspell 182
#researchlevel 3
#end
--"Contact Civateteo"
#selectspell 183
#researchlevel 4
#end
--"Bind Tzitzimitl"
#selectspell 184
#researchlevel 5
#end
--"Contact Tlahuelpuchi"
#selectspell 185
#researchlevel 5
#end
--"Contact Onaqui"
#selectspell 186
#researchlevel 7
#end
--"Rain of Jaguars"
#selectspell 187
#researchlevel 8
#end
--"Celestial Servant"
#selectspell 188
#researchlevel 0
#end
--"Heavenly Rivers"
#selectspell 189
#researchlevel 2
#end
--"Ambush of Tigers"
#selectspell 190
#researchlevel 2
#end
--"Celestial Hounds"
#selectspell 191
#researchlevel 3
#end
--"Heavenly Fires"
#selectspell 192
#researchlevel 4
#end
--"Call Celestial Soldiers"
#selectspell 193
#researchlevel 5
#end
--"Call Ancestor"
#selectspell 194
#researchlevel 0
#end
--"Wrath of the Ancestors"
#selectspell 195
#researchlevel 7
#end
--"Ambush of Tigers"
#selectspell 196
#researchlevel 2
#end
--"Summon Nagas"
#selectspell 197
#researchlevel 2
#end
--"Summon Apsaras"
#selectspell 198
#researchlevel 2
#end
--"Contact Yaksha"
#selectspell 199
#researchlevel 3
#end
--"Contact Yakshini"
#selectspell 200
#researchlevel 3
#end
--"Contact Nagini"
#selectspell 201
#researchlevel 3
#end
--"Summon Gandharvas"
#selectspell 202
#researchlevel 4
#end
--"Contact Nagaraja"
#selectspell 203
#researchlevel 4
#end
--"Summon Kinnara"
#selectspell 204
#researchlevel 5
#end
--"Contact Nagarishi"
#selectspell 205
#researchlevel 5
#end
--"Summon Siddha"
#selectspell 206
#researchlevel 7
#end
--"Summon Devata"
#selectspell 207
#researchlevel 8
#end
--"Summon Ko-Oni"
#selectspell 208
#researchlevel 0
#end
--"Summon Kappa"
#selectspell 209
#researchlevel 0
#end
--"Summon Ao-Oni"
#selectspell 210
#researchlevel 1
#end
--"Summon Karasu Tengu"
#selectspell 211
#researchlevel 1
#end
--"Summon Aka-Oni"
#selectspell 212
#researchlevel 2
#end
--"Ambush of Tigers"
#selectspell 213
#researchlevel 2
#end
--"Summon Konoha Tengus"
#selectspell 214
#researchlevel 2
#end
--"Ghost General"
#selectspell 215
#researchlevel 3
#end
--"Summon Oni"
#selectspell 216
#researchlevel 3
#end
--"Contact Dai Tengu"
#selectspell 217
#researchlevel 4
#end
--"Contact Nushi"
#selectspell 218
#researchlevel 4
#end
--"Summon Kuro-Oni"
#selectspell 219
#researchlevel 4
#end
--"Summon Oni General"
#selectspell 220
#researchlevel 5
#end
--"Contact Kitsune"
#selectspell 221
#researchlevel 5
#end
--"Summon Dai Oni"
#selectspell 222
#researchlevel 8
#end
--"Summon Umbral"
#selectspell 223
#researchlevel 4
#end
--"Rhuax Pact"
#selectspell 225
#researchlevel 2
#end
--"Barathrus Pact"
#selectspell 226
#researchlevel 2
#end
--"Attentive Statues"
#selectspell 227
#researchlevel 2
#end
--"Enliven Sentinel"
#selectspell 228
#researchlevel 3
#end
--"Enliven Granite Guard"
#selectspell 229
#researchlevel 4
#end
--"Enliven Marble Oracle"
#selectspell 230
#researchlevel 5
#end
--"Iron Corpse Reanimation"
#selectspell 231
#researchlevel 2
#end
--"Reanimate Ancestor"
#selectspell 232
#researchlevel 2
#end
--"Flame Corpse Construction"
#selectspell 233
#researchlevel 4
#end
--"Ktonian Legion"
#selectspell 234
#researchlevel 5
#end
--"Awaken Cavern Wight"
#selectspell 235
#researchlevel 2
#end
--"Awaken Sepulchral"
#selectspell 236
#researchlevel 3
#end
--"Awaken Tomb Oracle"
#selectspell 237
#researchlevel 4
#end
--"Hall of the Dead"
#selectspell 238
#researchlevel 8
#end
--"Iron Marionettes"
#selectspell 239
#researchlevel 4
#end
--"Contact Void Spectre"
#selectspell 240
#researchlevel 5
#end
--"Dreams of R'lyeh"
#selectspell 241
#researchlevel 5
#end
--"Burning Hands"
#selectspell 244
#researchlevel 0
#end
--"Fire Darts"
#selectspell 245
#researchlevel 0
#end
--"Flame Bolt"
#selectspell 246
#researchlevel 0
#end
--"Shocking Grasp"
#selectspell 247
#researchlevel 0
#end
--"Slime"
#selectspell 248
#researchlevel 0
#end
--"Cold Bolt"
#selectspell 249
#researchlevel 0
#end
--"Geyser"
#selectspell 250
#researchlevel 0
#end
--"Acid Spray"
#selectspell 251
#researchlevel 0
#end
--"Astral Projection"
#selectspell 252
#researchlevel 0
#end
--"Star Fires"
#selectspell 253
#researchlevel 0
#end
--"Fire Blast"
#selectspell 254
#researchlevel 1
#end
--"Flare"
#selectspell 255
#researchlevel 1
#end
--"Sulphur Haze"
#selectspell 256
#researchlevel 1
#end
--"Cold Blast"
#selectspell 257
#researchlevel 1
#end
--"Rain"
#selectspell 258
#researchlevel 1
#end
--"Lightning Bolt"
#selectspell 259
#researchlevel 1
#end
--"Shock Wave"
#selectspell 260
#researchlevel 1
#end
--"Rust Mist"
#selectspell 261
#researchlevel 1
#end
--"Solar Rays"
#selectspell 262
#researchlevel 1
#end
--"Arcane Probing"
#selectspell 263
#researchlevel 1
#end
--"Vine Arrow"
#selectspell 264
#researchlevel 1
#end
--"Fireball"
#selectspell 265
#researchlevel 2
#end
--"Fires from Afar"
#selectspell 266
#researchlevel 2
#end
--"Mist"
#selectspell 267
#researchlevel 2
#end
--"Freezing Mist"
#selectspell 268
#researchlevel 2
#end
--"Acid Bolt"
#selectspell 269
#researchlevel 2
#end
--"Magma Bolts"
#selectspell 270
#researchlevel 2
#end
--"Magic Duel"
#selectspell 271
#researchlevel 2
#end
--"Healing Light"
#selectspell 272
#researchlevel 2
#end
--"Shadow Bolt"
#selectspell 273
#researchlevel 2
#end
--"Sleep Cloud"
#selectspell 274
#researchlevel 2
#end
--"Holy Pyre"
#selectspell 275
#researchlevel 3
#end
--"Fire Cloud"
#selectspell 276
#researchlevel 3
#end
--"Fate of Oedipus"
#selectspell 277
#researchlevel 3
#end
--"Thunder Strike"
#selectspell 278
#researchlevel 3
#end
--"Hurricane"
#selectspell 279
#researchlevel 3
#end
--"Water Strike"
#selectspell 280
#researchlevel 3
#end
--"Acid Rain"
#selectspell 281
#researchlevel 3
#end
--"Blade Wind"
#selectspell 282
#researchlevel 3
#end
--"Nether Bolt"
#selectspell 283
#researchlevel 3
#end
--"Breath of the Dragon"
#selectspell 284
#researchlevel 3
#end
--"Falling Fires"
#selectspell 285
#researchlevel 4
#end
--"Falling Frost"
#selectspell 286
#researchlevel 4
#end
--"Orb Lightning"
#selectspell 287
#researchlevel 4
#end
--"Storm"
#selectspell 288
#researchlevel 4
#end
--"Earthquake"
#selectspell 289
#researchlevel 4
#end
--"Gifts from Heaven"
#selectspell 290
#researchlevel 4
#end
--"Stellar Cascades"
#selectspell 291
#researchlevel 4
#end
--"Shadow Blast"
#selectspell 292
#researchlevel 4
#end
--"Poison Cloud"
#selectspell 293
#researchlevel 4
#end
--"Healing Mists"
#selectspell 294
#researchlevel 4
#end
--"Flame Eruption"
#selectspell 295
#researchlevel 5
#end
--"Wrathful Skies"
#selectspell 296
#researchlevel 5
#end
--"Perpetual Storm"
#selectspell 297
#researchlevel 5
#end
--"Cleansing Water"
#selectspell 298
#researchlevel 5
#end
--"Magma Eruption"
#selectspell 299
#researchlevel 5
#end
--"Mind Hunt"
#selectspell 300
#researchlevel 5
#end
--"Astral Fires"
#selectspell 301
#researchlevel 5
#end
--"The Wrath of God"
#selectspell 302
#researchlevel 5
#end
--"Bane Fire"
#selectspell 303
#researchlevel 5
#end
--"Wailing Winds"
#selectspell 304
#researchlevel 5
#end
--"Stream of Life"
#selectspell 305
#researchlevel 5
#end
--"Fire Storm"
#selectspell 306
#researchlevel 7
#end
--"Ice Strike"
#selectspell 307
#researchlevel 7
#end
--"Murdering Winter"
#selectspell 308
#researchlevel 7
#end
--"Acid Storm"
#selectspell 309
#researchlevel 7
#end
--"Shimmering Fields"
#selectspell 310
#researchlevel 7
#end
--"Rain of Stones"
#selectspell 311
#researchlevel 7
#end
--"Cloud of Death"
#selectspell 312
#researchlevel 7
#end
--"Wind of Death"
#selectspell 313
#researchlevel 7
#end
--"Nether Darts"
#selectspell 314
#researchlevel 7
#end
--"Pillar of Fire"
#selectspell 315
#researchlevel 8
#end
--"Second Sun"
#selectspell 316
#researchlevel 8
#end
--"Maelstrom"
#selectspell 317
#researchlevel 8
#end
--"Astral Tempest"
#selectspell 318
#researchlevel 8
#end
--"Flames from the Sky"
#selectspell 319
#researchlevel 9
#end
--"Flame Storm"
#selectspell 320
#researchlevel 9
#end
--"Volcanic Eruption"
#selectspell 321
#researchlevel 9
#end
--"Niefel Flames"
#selectspell 322
#researchlevel 9
#end
--"Tidal Wave"
#selectspell 323
#researchlevel 9
#end
--"Strands of Arcane Power"
#selectspell 324
#researchlevel 9
#end
--"Fire Resistance"
#selectspell 325
#researchlevel 0
#end
--"Charge Body"
#selectspell 326
#researchlevel 0
#end
--"Aim"
#selectspell 327
#researchlevel 0
#end
--"Resist Lightning"
#selectspell 328
#researchlevel 0
#end
--"False Fetters"
#selectspell 329
#researchlevel 0
#end
--"Cold Resistance"
#selectspell 330
#researchlevel 0
#end
--"Resist Fire"
#selectspell 331
#researchlevel 0
#end
--"Fists of Iron"
#selectspell 332
#researchlevel 0
#end
--"Earth Grip"
#selectspell 333
#researchlevel 0
#end
--"Earth Might"
#selectspell 334
#researchlevel 0
#end
--"Hand of Death"
#selectspell 335
#researchlevel 0
#end
--"Eagle Eyes"
#selectspell 336
#researchlevel 0
#end
--"Poison Touch"
#selectspell 337
#researchlevel 0
#end
--"Resist Poison"
#selectspell 338
#researchlevel 0
#end
--"Barkskin"
#selectspell 339
#researchlevel 0
#end
--"Personal Luck"
#selectspell 340
#researchlevel 0
#end
--"Combustion"
#selectspell 341
#researchlevel 1
#end
--"Phantasmal Warrior"
#selectspell 342
#researchlevel 1
#end
--"Mirror Image"
#selectspell 343
#researchlevel 1
#end
--"Quicken self"
#selectspell 344
#researchlevel 1
#end
--"Stoneskin"
#selectspell 345
#researchlevel 1
#end
--"Armor of Achilles"
#selectspell 346
#researchlevel 1
#end
--"Earth Meld"
#selectspell 347
#researchlevel 1
#end
--"Immolation"
#selectspell 348
#researchlevel 2
#end
--"Inner Sun"
#selectspell 349
#researchlevel 2
#end
--"Mistform"
#selectspell 350
#researchlevel 2
#end
--"Ghost Wolves"
#selectspell 351
#researchlevel 2
#end
--"Numbness"
#selectspell 352
#researchlevel 2
#end
--"Ironskin"
#selectspell 353
#researchlevel 2
#end
--"Protection"
#selectspell 354
#researchlevel 2
#end
--"Body Ethereal"
#selectspell 355
#researchlevel 2
#end
--"Wind Guide"
#selectspell 356
#researchlevel 3
#end
--"Quickness"
#selectspell 357
#researchlevel 3
#end
--"Encase in Ice"
#selectspell 358
#researchlevel 3
#end
--"Wolven Winter"
#selectspell 359
#researchlevel 3
#end
--"Destruction"
#selectspell 360
#researchlevel 3
#end
--"Curse of Stones"
#selectspell 361
#researchlevel 3
#end
--"Blight"
#selectspell 362
#researchlevel 3
#end
--"Arouse Hunger"
#selectspell 363
#researchlevel 3
#end
--"Elemental Fortitude"
#selectspell 364
#researchlevel 3
#end
--"Swarm"
#selectspell 365
#researchlevel 3
#end
--"Luck"
#selectspell 366
#researchlevel 3
#end
--"Incinerate"
#selectspell 367
#researchlevel 4
#end
--"Phantasmal Army"
#selectspell 368
#researchlevel 4
#end
--"Bone Melter"
#selectspell 369
#researchlevel 4
#end
--"Iron Warriors"
#selectspell 370
#researchlevel 4
#end
--"Invulnerability"
#selectspell 371
#researchlevel 4
#end
--"Shatter"
#selectspell 372
#researchlevel 4
#end
--"Baleful Star"
#selectspell 373
#researchlevel 4
#end
--"Drain Life"
#selectspell 374
#researchlevel 4
#end
--"Wooden Warriors"
#selectspell 375
#researchlevel 4
#end
--"Mother Oak"
#selectspell 376
#researchlevel 4
#end
--"Blindness"
#selectspell 377
#researchlevel 5
#end
--"Boil"
#selectspell 378
#researchlevel 5
#end
--"False Horror"
#selectspell 379
#researchlevel 5
#end
--"Frozen Heart"
#selectspell 380
#researchlevel 5
#end
--"Iron Bane"
#selectspell 381
#researchlevel 5
#end
--"Petrify"
#selectspell 382
#researchlevel 5
#end
--"Iron Pigs"
#selectspell 383
#researchlevel 5
#end
--"Control"
#selectspell 384
#researchlevel 5
#end
--"Battle Fortune"
#selectspell 385
#researchlevel 5
#end
--"Soul Vortex"
#selectspell 386
#researchlevel 5
#end
--"Darkness"
#selectspell 387
#researchlevel 5
#end
--"Phoenix Pyre"
#selectspell 388
#researchlevel 7
#end
--"Phantasmal Attack"
#selectspell 389
#researchlevel 7
#end
--"Fog Warriors"
#selectspell 390
#researchlevel 7
#end
--"Prison of Sedna"
#selectspell 391
#researchlevel 7
#end
--"Sea of Ice"
#selectspell 392
#researchlevel 7
#end
--"Iron Walls"
#selectspell 393
#researchlevel 7
#end
--"Marble Warriors"
#selectspell 394
#researchlevel 7
#end
--"Doom"
#selectspell 395
#researchlevel 7
#end
--"Bone Grinding"
#selectspell 396
#researchlevel 7
#end
--"Creeping Doom"
#selectspell 397
#researchlevel 7
#end
--"Transformation"
#selectspell 398
#researchlevel 7
#end
--"Mass Protection"
#selectspell 399
#researchlevel 7
#end
--"Fata Morgana"
#selectspell 400
#researchlevel 8
#end
--"Quickening"
#selectspell 401
#researchlevel 8
#end
--"Wizard's Tower"
#selectspell 402
#researchlevel 8
#end
--"Crumble"
#selectspell 403
#researchlevel 8
#end
--"Will of the Fates"
#selectspell 404
#researchlevel 8
#end
--"Disintegrate"
#selectspell 405
#researchlevel 8
#end
--"Polymorph"
#selectspell 406
#researchlevel 8
#end
--"Army of Gold"
#selectspell 407
#researchlevel 9
#end
--"Army of Lead"
#selectspell 408
#researchlevel 9
#end
--"Arcane Domination"
#selectspell 409
#researchlevel 9
#end
--"Wish"
#selectspell 410
#researchlevel 9
#end
--"Utterdark"
#selectspell 411
#researchlevel 9
#end
--"Summon Sea Dogs"
#selectspell 412
#researchlevel 0
#end
--"Spirit Curse"
#selectspell 413
#researchlevel 0
#end
--"Black Servant"
#selectspell 414
#researchlevel 0
#end
--"Tangle Vines"
#selectspell 415
#researchlevel 0
#end
--"Awaken Vine Men"
#selectspell 416
#researchlevel 0
#end
--"Summon Fire Drake"
#selectspell 417
#researchlevel 1
#end
--"Bind Scorpion Beast"
#selectspell 418
#researchlevel 1
#end
--"Summon Storm Power"
#selectspell 419
#researchlevel 1
#end
--"Summon Wyvern"
#selectspell 420
#researchlevel 1
#end
--"Summon Water Power"
#selectspell 421
#researchlevel 1
#end
--"Summon Ice Drake"
#selectspell 422
#researchlevel 1
#end
--"Summon Sea Serpent"
#selectspell 423
#researchlevel 1
#end
--"Summon Cave Drake"
#selectspell 424
#researchlevel 1
#end
--"Dark Knowledge"
#selectspell 425
#researchlevel 1
#end
--"Summon Shades"
#selectspell 426
#researchlevel 1
#end
--"Summon Animals"
#selectspell 427
#researchlevel 1
#end
--"Summon Horned Serpents"
#selectspell 428
#researchlevel 1
#end
--"Phoenix Power"
#selectspell 429
#researchlevel 2
#end
--"Summon Lesser Fire Elemental"
#selectspell 430
#researchlevel 2
#end
--"Summon Lesser Air Elemental"
#selectspell 431
#researchlevel 2
#end
--"Call of the Winds"
#selectspell 432
#researchlevel 2
#end
--"Summon Amphiptere"
#selectspell 433
#researchlevel 2
#end
--"Summon Lesser Water Elemental"
#selectspell 434
#researchlevel 2
#end
--"Voice of Apsu"
#selectspell 435
#researchlevel 2
#end
--"Call Kraken"
#selectspell 436
#researchlevel 2
#end
--"Summon Sea Lions"
#selectspell 437
#researchlevel 2
#end
--"Summon Earthpower"
#selectspell 438
#researchlevel 2
#end
--"Summon Lesser Earth Elemental"
#selectspell 439
#researchlevel 2
#end
--"Power of the Spheres"
#selectspell 440
#researchlevel 2
#end
--"Revive Wight"
#selectspell 441
#researchlevel 2
#end
--"Revive Bane"
#selectspell 442
#researchlevel 2
#end
--"Pride of Lions"
#selectspell 443
#researchlevel 2
#end
--"Awaken Vine Ogre"
#selectspell 444
#researchlevel 2
#end
--"Call of the Wild"
#selectspell 445
#researchlevel 2
#end
--"Summon Summer Lions"
#selectspell 446
#researchlevel 3
#end
--"Summon Spring Hawks"
#selectspell 447
#researchlevel 3
#end
--"School of Sharks"
#selectspell 448
#researchlevel 3
#end
--"Summon Winter Wolves"
#selectspell 449
#researchlevel 3
#end
--"Voice of Tiamat"
#selectspell 450
#researchlevel 3
#end
--"Summon Fall Bears"
#selectspell 451
#researchlevel 3
#end
--"Light of the Northern Star"
#selectspell 452
#researchlevel 3
#end
--"Summon Shade Beasts"
#selectspell 453
#researchlevel 3
#end
--"Summon Lammashtas"
#selectspell 454
#researchlevel 3
#end
--"Maggots"
#selectspell 455
#researchlevel 3
#end
--"Spirits of the Wood"
#selectspell 456
#researchlevel 3
#end
--"Summon Bog Beast"
#selectspell 457
#researchlevel 3
#end
--"Summon Kithaironic Lion"
#selectspell 458
#researchlevel 3
#end
--"Strength of Gaia"
#selectspell 459
#researchlevel 3
#end
--"Will o' the Wisp"
#selectspell 460
#researchlevel 4
#end
--"Summon Fire Elemental"
#selectspell 461
#researchlevel 4
#end
--"Summon Air Elemental"
#selectspell 462
#researchlevel 4
#end
--"Wind Ride"
#selectspell 463
#researchlevel 4
#end
--"Raven Feast"
#selectspell 464
#researchlevel 4
#end
--"Contact Draconians"
#selectspell 465
#researchlevel 4
#end
--"Summon Water Elemental"
#selectspell 466
#researchlevel 4
#end
--"Contact Naiad"
#selectspell 467
#researchlevel 4
#end
--"Naiad Warriors"
#selectspell 468
#researchlevel 4
#end
--"Summon Earth Elemental"
#selectspell 469
#researchlevel 4
#end
--"Spirit Mastery"
#selectspell 470
#researchlevel 4
#end
--"Ghost Grip"
#selectspell 471
#researchlevel 4
#end
--"Corpse Candle"
#selectspell 472
#researchlevel 4
#end
--"Revive Bane Lord"
#selectspell 473
#researchlevel 4
#end
--"Acashic Record"
#selectspell 474
#researchlevel 4
#end
--"Howl"
#selectspell 475
#researchlevel 4
#end
--"Awaken Sleeper"
#selectspell 476
#researchlevel 4
#end
--"Winged Monkeys"
#selectspell 477
#researchlevel 4
#end
--"Summon Fire Snakes"
#selectspell 478
#researchlevel 5
#end
--"Summon Great Eagle"
#selectspell 479
#researchlevel 5
#end
--"Summon Valkyries"
#selectspell 480
#researchlevel 5
#end
--"Shark Attack"
#selectspell 481
#researchlevel 5
#end
--"Contact Sea Troll"
#selectspell 482
#researchlevel 5
#end
--"Sea King's Court"
#selectspell 483
#researchlevel 5
#end
--"Streams from Hades"
#selectspell 484
#researchlevel 5
#end
--"Contact Troll"
#selectspell 485
#researchlevel 5
#end
--"Troll King's Court"
#selectspell 486
#researchlevel 5
#end
--"Ether Gate"
#selectspell 487
#researchlevel 5
#end
--"Summon Spectre"
#selectspell 488
#researchlevel 5
#end
--"Summon Ghosts"
#selectspell 489
#researchlevel 5
#end
--"Summon Sprites"
#selectspell 490
#researchlevel 5
#end
--"Contact Lamias"
#selectspell 491
#researchlevel 5
#end
--"Locust Swarms"
#selectspell 492
#researchlevel 5
#end
--"Contact Lamia Queen"
#selectspell 493
#researchlevel 5
#end
--"Living Fire"
#selectspell 494
#researchlevel 7
#end
--"Living Clouds"
#selectspell 495
#researchlevel 7
#end
--"Summon Asp Turtle"
#selectspell 496
#researchlevel 7
#end
--"Living Water"
#selectspell 497
#researchlevel 7
#end
--"Summon Catoblepas"
#selectspell 498
#researchlevel 7
#end
--"Living Earth"
#selectspell 499
#researchlevel 7
#end
--"Summon Mound Fiend"
#selectspell 500
#researchlevel 7
#end
--"Harvester of Sorrows"
#selectspell 501
#researchlevel 7
#end
--"Call Wraith Lord"
#selectspell 502
#researchlevel 7
#end
--"Animal Horde"
#selectspell 503
#researchlevel 7
#end
--"Awaken Ivy King"
#selectspell 504
#researchlevel 7
#end
--"Living Castle"
#selectspell 505
#researchlevel 7
#end
--"King of Elemental Fire"
#selectspell 506
#researchlevel 8
#end
--"Queen of Elemental Air"
#selectspell 507
#researchlevel 8
#end
--"Queen of Elemental Water"
#selectspell 508
#researchlevel 8
#end
--"Guardians of the Deep"
#selectspell 509
#researchlevel 8
#end
--"Earth Attack"
#selectspell 510
#researchlevel 8
#end
--"King of Elemental Earth"
#selectspell 511
#researchlevel 8
#end
--"Manifestation"
#selectspell 512
#researchlevel 8
#end
--"Well of Misery"
#selectspell 513
#researchlevel 8
#end
--"King of Banefires"
#selectspell 514
#researchlevel 8
#end
--"Call the Eater of the Dead"
#selectspell 515
#researchlevel 8
#end
--"Dragon Master"
#selectspell 516
#researchlevel 8
#end
--"Wild Growth"
#selectspell 517
#researchlevel 8
#end
--"Faerie Court"
#selectspell 518
#researchlevel 8
#end
--"The Kindly Ones"
#selectspell 519
#researchlevel 9
#end
--"Call Abomination"
#selectspell 520
#researchlevel 9
#end
--"Ghost Riders"
#selectspell 521
#researchlevel 9
#end
--"Legion of Wights"
#selectspell 522
#researchlevel 9
#end
--"Tartarian Gate"
#selectspell 523
#researchlevel 9
#end
--"Awaken Tarrasque"
#selectspell 524
#researchlevel 9
#end
--"Wild Hunt"
#selectspell 525
#researchlevel 9
#end
--"Enchanted Forest"
#selectspell 526
#researchlevel 9
#end
--"Corpse Man Construction"
#selectspell 527
#researchlevel 1
#end
--"Legions of Steel"
#selectspell 528
#researchlevel 3
#end
--"Construct Manikin"
#selectspell 529
#researchlevel 3
#end
--"Clockwork Horrors"
#selectspell 530
#researchlevel 5
#end
--"Crusher Construction"
#selectspell 531
#researchlevel 5
#end
--"Wooden Construction"
#selectspell 532
#researchlevel 5
#end
--"Construct Mandragora"
#selectspell 533
#researchlevel 5
#end
--"Weapons of Sharpness"
#selectspell 534
#researchlevel 7
#end
--"Forge of the Ancients"
#selectspell 535
#researchlevel 7
#end
--"Mechanical Men"
#selectspell 536
#researchlevel 7
#end
--"Golem Construction"
#selectspell 537
#researchlevel 7
#end
--"Siege Golem"
#selectspell 538
#researchlevel 9
#end
--"Iron Dragon"
#selectspell 539
#researchlevel 9
#end
--"Mechanical Militia"
#selectspell 540
#researchlevel 9
#end
--"Juggernaut Construction"
#selectspell 541
#researchlevel 9
#end
--"Poison Golem"
#selectspell 542
#researchlevel 9
#end
--"Flight"
#selectspell 543
#researchlevel 0
#end
--"Breath of Winter"
#selectspell 544
#researchlevel 0
#end
--"Resist Magic"
#selectspell 545
#researchlevel 0
#end
--"Animate Skeleton"
#selectspell 546
#researchlevel 0
#end
--"Animate Dead"
#selectspell 547
#researchlevel 0
#end
--"Reanimation"
#selectspell 548
#researchlevel 0
#end
--"Healing Touch"
#selectspell 549
#researchlevel 0
#end
--"Water Shield"
#selectspell 550
#researchlevel 1
#end
--"Revive King"
#selectspell 551
#researchlevel 1
#end
--"Personal Regeneration"
#selectspell 552
#researchlevel 1
#end
--"Fire Shield"
#selectspell 553
#researchlevel 2
#end
--"Seeking Arrow"
#selectspell 554
#researchlevel 2
#end
--"Strength of Giants"
#selectspell 555
#researchlevel 2
#end
--"Astral Shield"
#selectspell 556
#researchlevel 2
#end
--"Raise Dead"
#selectspell 557
#researchlevel 2
#end
--"Raise Skeletons"
#selectspell 558
#researchlevel 2
#end
--"Create Revenant"
#selectspell 559
#researchlevel 2
#end
--"Regeneration"
#selectspell 560
#researchlevel 2
#end
--"Heal"
#selectspell 561
#researchlevel 2
#end
--"Flaming Arrows"
#selectspell 562
#researchlevel 3
#end
--"Cloud Trapeze"
#selectspell 563
#researchlevel 3
#end
--"Claymen"
#selectspell 564
#researchlevel 3
#end
--"Fire Ward"
#selectspell 565
#researchlevel 3
#end
--"Astral Healing"
#selectspell 566
#researchlevel 3
#end
--"Antimagic"
#selectspell 567
#researchlevel 3
#end
--"Twiceborn"
#selectspell 568
#researchlevel 3
#end
--"Behemoth"
#selectspell 569
#researchlevel 3
#end
--"Haste"
#selectspell 570
#researchlevel 3
#end
--"Poison Ward"
#selectspell 571
#researchlevel 3
#end
--"Fire Fend"
#selectspell 572
#researchlevel 4
#end
--"Thunder Ward"
#selectspell 573
#researchlevel 4
#end
--"Watcher"
#selectspell 574
#researchlevel 4
#end
--"Winter Ward"
#selectspell 575
#researchlevel 4
#end
--"Friendly Currents"
#selectspell 576
#researchlevel 4
#end
--"Quagmire"
#selectspell 577
#researchlevel 4
#end
--"Enliven Gargoyle"
#selectspell 578
#researchlevel 4
#end
--"Ritual of Returning"
#selectspell 579
#researchlevel 4
#end
--"Dispel"
#selectspell 580
#researchlevel 4
#end
--"The Eyes of God"
#selectspell 581
#researchlevel 4
#end
--"Pale Riders"
#selectspell 582
#researchlevel 4
#end
--"Undead Horde"
#selectspell 583
#researchlevel 4
#end
--"Faery Trod"
#selectspell 584
#researchlevel 4
#end
--"Gift of Health"
#selectspell 585
#researchlevel 4
#end
--"Foul Vapors"
#selectspell 586
#researchlevel 4
#end
--"Eternal Pyre"
#selectspell 587
#researchlevel 5
#end
--"Heat from Hell"
#selectspell 588
#researchlevel 5
#end
--"Arrow Fend"
#selectspell 589
#researchlevel 5
#end
--"Dome of Solid Air"
#selectspell 590
#researchlevel 5
#end
--"Water Ward"
#selectspell 591
#researchlevel 5
#end
--"Grip of Winter"
#selectspell 592
#researchlevel 5
#end
--"Frost Dome"
#selectspell 593
#researchlevel 5
#end
--"Hidden in Snow"
#selectspell 594
#researchlevel 5
#end
--"Riches from Beneath"
#selectspell 595
#researchlevel 5
#end
--"Enliven Statues"
#selectspell 596
#researchlevel 5
#end
--"Opposition"
#selectspell 597
#researchlevel 5
#end
--"Dome of Arcane Warding"
#selectspell 598
#researchlevel 5
#end
--"Rigor Mortis"
#selectspell 599
#researchlevel 5
#end
--"Reanimate Archers"
#selectspell 600
#researchlevel 5
#end
--"Ziz"
#selectspell 601
#researchlevel 5
#end
--"Relief"
#selectspell 602
#researchlevel 5
#end
--"Dome of Flaming Death"
#selectspell 603
#researchlevel 7
#end
--"Mass Flight"
#selectspell 604
#researchlevel 7
#end
--"Ghost Ship Armada"
#selectspell 605
#researchlevel 7
#end
--"Earth Blood Deep Well"
#selectspell 606
#researchlevel 7
#end
--"Solar Brilliance"
#selectspell 607
#researchlevel 7
#end
--"Stellar Focus"
#selectspell 608
#researchlevel 7
#end
--"Carrion Reanimation"
#selectspell 609
#researchlevel 7
#end
--"Life after Death"
#selectspell 610
#researchlevel 7
#end
--"Ritual of Rebirth"
#selectspell 611
#researchlevel 7
#end
--"Leviathan"
#selectspell 612
#researchlevel 7
#end
--"Serpent's Blessing"
#selectspell 613
#researchlevel 7
#end
--"Awaken Treelord"
#selectspell 614
#researchlevel 7
#end
--"Forest Dome"
#selectspell 615
#researchlevel 7
#end
--"Warriors of Muspelheim"
#selectspell 616
#researchlevel 8
#end
--"Warriors of Niefelheim"
#selectspell 617
#researchlevel 8
#end
--"Storm Warriors"
#selectspell 618
#researchlevel 8
#end
--"Mists of Deception"
#selectspell 619
#researchlevel 8
#end
--"Wrath of the Sea"
#selectspell 620
#researchlevel 8
#end
--"Lichcraft"
#selectspell 621
#researchlevel 8
#end
--"Unraveling"
#selectspell 622
#researchlevel 8
#end
--"Mass Regeneration"
#selectspell 623
#researchlevel 8
#end
--"Haunted Forest"
#selectspell 624
#researchlevel 8
#end
--"Thetis' Blessing"
#selectspell 625
#researchlevel 9
#end
--"Demon Cleansing"
#selectspell 626
#researchlevel 9
#end
--"Arcane Nexus"
#selectspell 627
#researchlevel 9
#end
--"Army of the Dead"
#selectspell 628
#researchlevel 9
#end
--"Gaia's Blessing"
#selectspell 629
#researchlevel 9
#end
--"Gift of Nature's Bounty"
#selectspell 630
#researchlevel 9
#end
--"Desiccation"
#selectspell 631
#researchlevel 0
#end
--"Farstrike"
#selectspell 632
#researchlevel 0
#end
--"Blink"
#selectspell 633
#researchlevel 0
#end
--"Returning"
#selectspell 634
#researchlevel 0
#end
--"Communion Master"
#selectspell 635
#researchlevel 0
#end
--"Communion Slave"
#selectspell 636
#researchlevel 0
#end
--"Horror Mark"
#selectspell 637
#researchlevel 0
#end
--"Dust to Dust"
#selectspell 638
#researchlevel 0
#end
--"Decay"
#selectspell 639
#researchlevel 0
#end
--"Frighten"
#selectspell 640
#researchlevel 0
#end
--"Seven Year Fever"
#selectspell 641
#researchlevel 0
#end
--"Curse"
#selectspell 642
#researchlevel 0
#end
--"Bonds of Fire"
#selectspell 643
#researchlevel 1
#end
--"Augury"
#selectspell 644
#researchlevel 1
#end
--"Auspex"
#selectspell 645
#researchlevel 1
#end
--"Gnome Lore"
#selectspell 646
#researchlevel 1
#end
--"Mind Burn"
#selectspell 647
#researchlevel 1
#end
--"Haruspex"
#selectspell 648
#researchlevel 1
#end
--"Berserkers"
#selectspell 649
#researchlevel 1
#end
--"Sleep"
#selectspell 650
#researchlevel 1
#end
--"Rage"
#selectspell 651
#researchlevel 2
#end
--"Sailors' Death"
#selectspell 652
#researchlevel 2
#end
--"Iron Will"
#selectspell 653
#researchlevel 2
#end
--"Astral Window"
#selectspell 654
#researchlevel 2
#end
--"Teleport"
#selectspell 655
#researchlevel 2
#end
--"Panic"
#selectspell 656
#researchlevel 2
#end
--"Prison of Fire"
#selectspell 657
#researchlevel 3
#end
--"Curse of the Desert"
#selectspell 658
#researchlevel 3
#end
--"Paralyze"
#selectspell 659
#researchlevel 3
#end
--"Vengeance of the Dead"
#selectspell 660
#researchlevel 3
#end
--"Terror"
#selectspell 661
#researchlevel 3
#end
--"Touch of Madness"
#selectspell 662
#researchlevel 3
#end
--"Gift of Reason"
#selectspell 663
#researchlevel 3
#end
--"Raging Hearts"
#selectspell 664
#researchlevel 4
#end
--"Confusion"
#selectspell 665
#researchlevel 4
#end
--"Soul Slay"
#selectspell 666
#researchlevel 4
#end
--"Telestic Animation"
#selectspell 667
#researchlevel 4
#end
--"Gateway"
#selectspell 668
#researchlevel 4
#end
--"Leeching Darkness"
#selectspell 669
#researchlevel 4
#end
--"Burden of Time"
#selectspell 670
#researchlevel 4
#end
--"Control the Dead"
#selectspell 671
#researchlevel 4
#end
--"Growing Fury"
#selectspell 672
#researchlevel 4
#end
--"Melancholia"
#selectspell 673
#researchlevel 5
#end
--"Enslave Mind"
#selectspell 674
#researchlevel 5
#end
--"Imprint Souls"
#selectspell 675
#researchlevel 5
#end
--"Wither Bones"
#selectspell 676
#researchlevel 5
#end
--"Leprosy"
#selectspell 677
#researchlevel 5
#end
--"Foul Air"
#selectspell 678
#researchlevel 5
#end
--"Beckoning"
#selectspell 679
#researchlevel 5
#end
--"Purgatory"
#selectspell 680
#researchlevel 7
#end
--"Dark Skies"
#selectspell 681
#researchlevel 7
#end
--"Lure of the Deep"
#selectspell 682
#researchlevel 7
#end
--"Vortex of Returning"
#selectspell 683
#researchlevel 7
#end
--"Plague"
#selectspell 684
#researchlevel 7
#end
--"Charm"
#selectspell 685
#researchlevel 7
#end
--"Gale Gate"
#selectspell 686
#researchlevel 8
#end
--"Soul Drain"
#selectspell 687
#researchlevel 8
#end
--"Stygian Paths"
#selectspell 688
#researchlevel 8
#end
--"Black Death"
#selectspell 689
#researchlevel 8
#end
--"Astral Travel"
#selectspell 690
#researchlevel 9
#end
--"Master Enslave"
#selectspell 691
#researchlevel 9
#end
--"Undead Mastery"
#selectspell 692
#researchlevel 9
#end
--"Blood Burst"
#selectspell 693
#researchlevel 0
#end
--"Blood Heal"
#selectspell 694
#researchlevel 0
#end
--"Sabbath Master"
#selectspell 695
#researchlevel 0
#end
--"Sabbath Slave"
#selectspell 696
#researchlevel 0
#end
--"Reinvigoration"
#selectspell 697
#researchlevel 0
#end
--"Summon Imp"
#selectspell 698
#researchlevel 0
#end
--"Bind Spine Devil"
#selectspell 699
#researchlevel 0
#end
--"Blood Boil"
#selectspell 700
#researchlevel 0
#end
--"Bind Bone Fiends"
#selectspell 701
#researchlevel 0
#end
--"Bowl of Blood"
#selectspell 702
#researchlevel 1
#end
--"Agony"
#selectspell 703
#researchlevel 1
#end
--"Banish Demon"
#selectspell 704
#researchlevel 1
#end
--"Bind Fiend"
#selectspell 705
#researchlevel 1
#end
--"Hell Power"
#selectspell 706
#researchlevel 1
#end
--"Leeching Touch"
#selectspell 707
#researchlevel 2
#end
--"Pain Transfer"
#selectspell 708
#researchlevel 2
#end
--"Bind Devil"
#selectspell 709
#researchlevel 2
#end
--"Bind Frost Fiend"
#selectspell 710
#researchlevel 2
#end
--"Cross Breeding"
#selectspell 711
#researchlevel 2
#end
--"Bind Serpent Fiend"
#selectspell 712
#researchlevel 3
#end
--"Blood Lust"
#selectspell 713
#researchlevel 3
#end
--"Hellfire"
#selectspell 714
#researchlevel 3
#end
--"Bind Storm Demon"
#selectspell 715
#researchlevel 3
#end
--"Bind Demon Knight"
#selectspell 716
#researchlevel 3
#end
--"Call Lesser Horror"
#selectspell 717
#researchlevel 3
#end
--"Rain of Toads"
#selectspell 718
#researchlevel 3
#end
--"Hellbind Heart"
#selectspell 719
#researchlevel 4
#end
--"Horde from Hell"
#selectspell 720
#researchlevel 4
#end
--"Bloodletting"
#selectspell 721
#researchlevel 4
#end
--"Bind Succubus"
#selectspell 722
#researchlevel 4
#end
--"Awaken Dark Vines"
#selectspell 723
#researchlevel 4
#end
--"Send Lesser Horror"
#selectspell 724
#researchlevel 4
#end
--"Harm"
#selectspell 725
#researchlevel 5
#end
--"Rejuvenate"
#selectspell 726
#researchlevel 5
#end
--"Ritual of Five Gates"
#selectspell 727
#researchlevel 5
#end
--"Bind Ice Devil"
#selectspell 728
#researchlevel 5
#end
--"Call Horror"
#selectspell 729
#researchlevel 5
#end
--"Leech"
#selectspell 730
#researchlevel 7
#end
--"Blood Rain"
#selectspell 731
#researchlevel 7
#end
--"Bind Arch Devil"
#selectspell 732
#researchlevel 7
#end
--"Father Illearth"
#selectspell 733
#researchlevel 7
#end
--"Curse of Blood"
#selectspell 734
#researchlevel 7
#end
--"Blood Rite"
#selectspell 735
#researchlevel 7
#end
--"Dome of Corruption"
#selectspell 736
#researchlevel 7
#end
--"Astral Corruption"
#selectspell 737
#researchlevel 7
#end
--"Rush of Strength"
#selectspell 738
#researchlevel 8
#end
--"Bind Heliophagus"
#selectspell 739
#researchlevel 8
#end
--"The Looming Hell"
#selectspell 740
#researchlevel 8
#end
--"Improved Cross Breeding"
#selectspell 741
#researchlevel 8
#end
--"Send Horror"
#selectspell 742
#researchlevel 8
#end
--"Three Red Seconds"
#selectspell 743
#researchlevel 8
#end
--"Blood Vengeance"
#selectspell 744
#researchlevel 9
#end
--"Life for a Life"
#selectspell 745
#researchlevel 8
#end
--"Forces of Darkness"
#selectspell 746
#researchlevel 9
#end
--"Bind Demon Lord"
#selectspell 747
#researchlevel 9
#end
--"Infernal Forces"
#selectspell 748
#researchlevel 9
#end
--"Infernal Tempest"
#selectspell 749
#researchlevel 9
#end
--"Forces of Ice"
#selectspell 750
#researchlevel 9
#end
--"Infernal Crusade"
#selectspell 751
#researchlevel 9
#end
--"Horror Seed"
#selectspell 752
#researchlevel 9
#end
--"Banishment"
#selectspell 753
#researchlevel -1
#end
--"Blessing"
#selectspell 754
#researchlevel -1
#end
--"Sermon of Courage"
#selectspell 755
#researchlevel -1
#end
--"Smite Demon"
#selectspell 756
#researchlevel -1
#end
--"Holy Avenger"
#selectspell 757
#researchlevel -1
#end
--"Divine Blessing"
#selectspell 758
#researchlevel -1
#end
--"Smite"
#selectspell 759
#researchlevel -1
#end
--"Fanaticism"
#selectspell 760
#researchlevel -1
#end
--"Word of Power"
#selectspell 761
#researchlevel -1
#end
--"Summon Yazatas"
#selectspell 762
#researchlevel 4
#end
--"Infernal Prison"
#selectspell 763
#researchlevel 9
#end
--"Claws of Kokytos"
#selectspell 764
#researchlevel 9
#end
--"Astral Geyser"
#selectspell 765
#researchlevel 4
#end
--"Send Tupilak"
#selectspell 766
#researchlevel 4
#end
--"Storm of Thorns"
#selectspell 767
#researchlevel 7
#end
--"Contact Scorpion Man"
#selectspell 768
#researchlevel 8
#end
--"Summon Scorpion Man"
#selectspell 769
#researchlevel 8
#end
--"Summon Spectral Infantry"
#selectspell 770
#researchlevel 1
#end
--"Tempering the Will"
#selectspell 771
#researchlevel 4
#end
--"End of Culture"
#selectspell 772
#researchlevel 5
#end
--"End of Weakness"
#selectspell 773
#researchlevel 5
#end
--"Inner Furnace"
#selectspell 774
#researchlevel 4
#end
--"Celestial Music"
#selectspell 775
#researchlevel 5
#end
--"Celestial Chastisement"
#selectspell 776
#researchlevel 4
#end
--"Arcane Bolt"
#selectspell 777
#researchlevel 0
#end
--"Conflagration"
#selectspell 778
#researchlevel 8
#end
--"Hydrophobia"
#selectspell 779
#researchlevel 8
#end
--"Mossbody"
#selectspell 780
#researchlevel 2
#end
--"Infernal Disease"
#selectspell 781
#researchlevel 5
#end
--"Summon Monster Fish"
#selectspell 782
#researchlevel 5
#end
--"Summon Rakshasas"
#selectspell 783
#researchlevel 0
#end
--"Feast of Flesh"
#selectspell 784
#researchlevel 1
#end
--"Summon Asrapas"
#selectspell 785
#researchlevel 2
#end
--"Summon Rakshasa Warriors"
#selectspell 786
#researchlevel 3
#end
--"Summon Sandhyabalas"
#selectspell 787
#researchlevel 4
#end
--"Summon Dakini"
#selectspell 788
#researchlevel 5
#end
--"Summon Samanishada"
#selectspell 789
#researchlevel 7
#end
--"Summon Mandaha"
#selectspell 790
#researchlevel 8
#end
--"Summon Davanas"
#selectspell 791
#researchlevel 8
#end
--"Host of Ganas"
#selectspell 792
#researchlevel 1
#end
--"Summon Vetalas"
#selectspell 793
#researchlevel 4
#end
--"Summon Devala"
#selectspell 794
#researchlevel 9
#end
--"Summon Black Dogs"
#selectspell 795
#researchlevel 1
#end
--"Summon Barghests"
#selectspell 796
#researchlevel 3
#end
--"Summon Cu Sidhe"
#selectspell 797
#researchlevel 2
#end
--"Contact Cu Sidhe"
#selectspell 798
#researchlevel 2
#end
--"Summon Bean Sidhe"
#selectspell 799
#researchlevel 4
#end
--"Sounder of Boars"
#selectspell 800
#researchlevel 2
#end
--"Contact Boar of Carnutes"
#selectspell 801
#researchlevel 4
#end
--"Summon Morrigan"
#selectspell 802
#researchlevel 5
#end
--"Dance of the Morrigans"
#selectspell 803
#researchlevel 8
#end
--"Daughter of Typhon"
#selectspell 804
#researchlevel 9
#end
--"Orgy"
#selectspell 805
#researchlevel 0
#end
--"Call Sirrush"
#selectspell 806
#researchlevel 4
#end
--"Summon Jade Serpent"
#selectspell 807
#researchlevel 3
#end
--"Thousand Year Ginseng"
#selectspell 808
#researchlevel 5
#end
--"Internal Alchemy"
#selectspell 809
#researchlevel 4
#end
--"Summon Rudra"
#selectspell 810
#researchlevel 9
#end
--"Contact Huli Jing"
#selectspell 811
#researchlevel 5
#end
--"Monster Boar"
#selectspell 812
#researchlevel 4
#end
--"Send Dream Horror"
#selectspell 813
#researchlevel 7
#end
--"Summon Simargl"
#selectspell 814
#researchlevel 1
#end
--"Summon Firebird"
#selectspell 815
#researchlevel 2
#end
--"Summon Lady Midday"
#selectspell 816
#researchlevel 2
#end
--"Contact Sirin"
#selectspell 817
#researchlevel 2
#end
--"Send Vodyanoy"
#selectspell 818
#researchlevel 3
#end
--"Summon Rusalka"
#selectspell 819
#researchlevel 3
#end
--"Summon Likho"
#selectspell 820
#researchlevel 3
#end
--"Contact Alkonost"
#selectspell 821
#researchlevel 3
#end
--"Summon Zmey"
#selectspell 822
#researchlevel 4
#end
--"Send Bukavac"
#selectspell 823
#researchlevel 4
#end
--"Contact Gamayun"
#selectspell 824
#researchlevel 4
#end
--"Contact Beregina"
#selectspell 825
#researchlevel 5
#end
--"Contact Mountain Vila"
#selectspell 826
#researchlevel 7
#end
--"Contact Cloud Vila"
#selectspell 827
#researchlevel 7
#end
--"Contact Leshiy"
#selectspell 828
#researchlevel 8
#end
--"Gift of Flight"
#selectspell 829
#researchlevel 2
#end
--"Hidden in Sand"
#selectspell 830
#researchlevel 5
#end
--"Summon Abysian Ancestors"
#selectspell 831
#researchlevel 1
#end
--"Reawaken Fossil"
#selectspell 832
#researchlevel 4
#end
--"Iron Darts"
#selectspell 833
#researchlevel 2
#end
--"Iron Blizzard"
#selectspell 834
#researchlevel 5
#end
--"Contact Iron Angel"
#selectspell 835
#researchlevel 8
#end

--- Zepath's excellent Streamers and Standards mod ---
-- Independent Flag Command

#indepflag "./sns3/indie_icon.tga"

--  National Flag Commands

#selectnation 0
#flag "./sns3/ea_arco_icon.tga"
#end

#selectnation 1
#flag "./sns3/ea_ermor_icon.tga"
#end

#selectnation 2
#flag "./llamaBanners/ea_ulm_icon.tga"
#end

#selectnation 3
#flag "./llamaBanners/ea_marverni_icon.tga"
#end

#selectnation 4
#flag "./sns3/ea_sauro_icon.tga"
#end

#selectnation 5
#flag "./llamaBanners/ea_tienchi_icon.tga"
#end

#selectnation 7
#flag "./sns3/ea_mictlan_icon.tga"
#end

#selectnation 8
#flag "./sns3/ea_abysia_icon.tga"
#end

#selectnation 9
#flag "./sns3/ea_caelum_icon.tga"
#end

#selectnation 10
#flag "./sns3/ea_ctis_icon.tga"
#end

#selectnation 11
#flag "./sns3/ea_pangaea_icon.tga"
#end

#selectnation 12
#flag "./sns3/ea_agartha_icon.tga"
#end

#selectnation 15
#flag "./sns3/ea_vanheim_icon.tga"
#end

#selectnation 16
#flag "./sns3/ea_helheim_icon.tga"
#end

#selectnation 17
#flag "./llamaBanners/ea_jotunheim_icon.tga"
#end

#selectnation 18
#flag "./llamaBanners/ea_kailasa_icon.tga"
#end

#selectnation 19
#flag "./llamaBanners/ea_yomi_icon.tga"
#end

#selectnation 20
#flag "./llamaBanners/ea_hinnom_icon.tga"
#end

#selectnation 21
#flag "./sns3/ea_atlantis_icon.tga"
#end

#selectnation 22
#flag "./llamaBanners/ea_rlyeh_icon.tga"
#end

#selectnation 26
#flag "./sns3/ea_oceania_icon.tga"
#end

#selectnation 27
#flag "./sns3/ma_arco_icon.tga"
#end

#selectnation 28
#flag "./sns3/ma_ermor_icon.tga"
#end

#selectnation 29
#flag "./sns3/ma_pythium_icon.tga"
#end

#selectnation 30
#flag "./sns3/ma_man_icon.tga"
#end

#selectnation 31
#flag "./sns3/ma_ulm_icon.tga"
#end

#selectnation 32
#flag "./sns3/ma_marignon_icon.tga"
#end

#selectnation 33
#flag "./sns3/ma_mictlan_icon.tga"
#end

#selectnation 34
#flag "./llamaBanners/ma_tienchi_icon.tga"
#end

#selectnation 35
#flag "./sns3/ma_machaka_icon.tga"
#end

#selectnation 36
#flag "./sns3/ma_agartha_icon.tga"
#end

#selectnation 37
#flag "./sns3/ma_abysia_icon.tga"
#end

#selectnation 38
#flag "./llamaBanners/ma_caelum_icon.tga"
#end

#selectnation 39
#flag "./llamaBanners/ma_ctis_icon.tga"
#end

#selectnation 40
#flag "./sns3/ma_pangaea_icon.tga"
#end

#selectnation 41
#flag "./sns3/ma_vanheim_icon.tga"
#end

#selectnation 42
#flag "./sns3/ma_jotunheim_icon.tga"
#end

#selectnation 43
#flag "./sns3/ma_bandar_icon.tga"
#end

#selectnation 44
#flag "./sns3/ma_shinuyama_icon.tga"
#end

#selectnation 45
#flag "./llamaBanners/ma_ashdod_icon.tga"
#end

#selectnation 46
#flag "./sns3/ma_atlantis_icon.tga"
#end

#selectnation 47
#flag "./sns3/ma_rlyeh_icon.tga"
#end

#selectnation 48
#flag "./llamaBanners/ma_oceania_icon.tga"
#end

#selectnation 49
#flag "./sns3/la_arco_icon.tga"
#end

#selectnation 50
#flag "./sns3/la_ermor_icon.tga"
#end

#selectnation 51
#flag "./sns3/la_man_icon.tga"
#end

#selectnation 52
#flag "./sns3/la_ulm_icon.tga"
#end

#selectnation 53
#flag "./sns3/la_marignon_icon.tga"
#end

#selectnation 54
#flag "./sns3/la_mictlan_icon.tga"
#end

#selectnation 55
#flag "./llamaBanners/la_tienchi_icon.tga"
#end

#selectnation 56
#flag "./llamaBanners/la_jomon_icon.tga"
#end

#selectnation 57
#flag "./sns3/la_agartha_icon.tga"
#end

#selectnation 58
#flag "./sns3/la_abysia_icon.tga"
#end

#selectnation 59
#flag "./sns3/la_caelum_icon.tga"
#end

#selectnation 60
#flag "./llamaBanners/la_ctis_icon.tga"
#end

#selectnation 61
#flag "./sns3/la_pangaea_icon.tga"
#end

#selectnation 62
#flag "./sns3/la_midgard_icon.tga"
#end

#selectnation 63
#flag "./llamaBanners/la_utgard_icon.tga"
#end

#selectnation 64
#flag "./sns3/la_patala_icon.tga"
#end

#selectnation 65
#flag "./llamaBanners/la_gath_icon.tga"
#end

#selectnation 66
#flag "./sns3/la_atlantis_icon.tga"
#end

#selectnation 67
#flag "./llamaBanners/la_rlyeh_icon.tga"
#end

#selectnation 68
#flag "./sns3/ea_lanka_icon.tga"
#end

#selectnation 71
#flag "./llamaBanners/la_bogarus_icon.tga"
#end
