#Boa:Frame:DomFrame

import wx
from wx.lib.anchors import LayoutAnchors

import DirWatch
import AboutDialog

def create(parent):
    return DomFrame(parent)

[wxID_DOMFRAME, wxID_DOMFRAMEBTNDELETE, wxID_DOMFRAMEBTNRESTORE, 
 wxID_DOMFRAMEBTNSTART, wxID_DOMFRAMEBTNSTOP, wxID_DOMFRAMEBUTTONDELETEGAME, 
 wxID_DOMFRAMEGAMECHOICE, wxID_DOMFRAMELOGTXT, wxID_DOMFRAMEPANEL1, 
 wxID_DOMFRAMESTATICLINE1, wxID_DOMFRAMESTATICLINE2, wxID_DOMFRAMESTATICTEXT1, 
 wxID_DOMFRAMESTATICTEXT2, wxID_DOMFRAMESTATICTEXT3, wxID_DOMFRAMESTATICTEXT4, 
 wxID_DOMFRAMETITLETXT, wxID_DOMFRAMETURNLIST, 
] = [wx.NewId() for _init_ctrls in range(17)]

[wxID_DOMFRAMEMENUFILEEXIT_ITEM] = [wx.NewId() for _init_coll_menuFile_Items in range(1)]

[wxID_DOMFRAMEMENUHELPABOUT_ITEM] = [wx.NewId() for _init_coll_menuHelp_Items in range(1)]

class DomFrame(wx.Frame):
    def _init_coll_menuBar1_Menus(self, parent):
        # generated method, don't edit

        parent.Append(menu=self.menuFile, title='File')
        parent.Append(menu=self.menuHelp, title='Help')

    def _init_coll_menuHelp_Items(self, parent):
        # generated method, don't edit

        parent.Append(help='', id=wxID_DOMFRAMEMENUHELPABOUT_ITEM,
              kind=wx.ITEM_NORMAL, text='About')
        self.Bind(wx.EVT_MENU, self.OnMenuHelpAbout_itemMenu,
              id=wxID_DOMFRAMEMENUHELPABOUT_ITEM)

    def _init_coll_menuFile_Items(self, parent):
        # generated method, don't edit

        parent.Append(help='', id=wxID_DOMFRAMEMENUFILEEXIT_ITEM,
              kind=wx.ITEM_NORMAL, text='Exit')
        self.Bind(wx.EVT_MENU, self.OnMenuFileExit_itemMenu,
              id=wxID_DOMFRAMEMENUFILEEXIT_ITEM)

    def _init_utils(self):
        # generated method, don't edit
        self.menuFile = wx.Menu(title='')

        self.menuHelp = wx.Menu(title='')

        self.menuBar1 = wx.MenuBar()

        self._init_coll_menuFile_Items(self.menuFile)
        self._init_coll_menuHelp_Items(self.menuHelp)
        self._init_coll_menuBar1_Menus(self.menuBar1)

    def _init_ctrls(self, prnt):
        # generated method, don't edit
        wx.Frame.__init__(self, id=wxID_DOMFRAME, name='DomFrame', parent=prnt,
              pos=wx.Point(-1, -1), size=wx.Size(375, 490),
              style=wx.DEFAULT_FRAME_STYLE, title='Dom3bak')
        self._init_utils()
        self.SetClientSize(wx.Size(367, 452))
        self.SetIcon(wx.Icon(u'C:/Files/DSA/Python/Dom3Bak_Source/dom3bak_icon.ico',
              wx.BITMAP_TYPE_ICO))
        self.SetMenuBar(self.menuBar1)
        self.Bind(wx.EVT_CLOSE, self.OnDomFrameClose)

        self.panel1 = wx.Panel(id=wxID_DOMFRAMEPANEL1, name='panel1',
              parent=self, pos=wx.Point(0, 0), size=wx.Size(367, 452),
              style=wx.TAB_TRAVERSAL)

        self.TitleTxt = wx.StaticText(id=wxID_DOMFRAMETITLETXT, label='Dom3bak',
              name='TitleTxt', parent=self.panel1, pos=wx.Point(16, 8),
              size=wx.Size(159, 40), style=0)
        self.TitleTxt.SetFont(wx.Font(25, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              'Verdana'))
        self.TitleTxt.SetForegroundColour(wx.Colour(72, 116, 170))

        self.logTxt = wx.TextCtrl(id=wxID_DOMFRAMELOGTXT, name='logTxt',
              parent=self.panel1, pos=wx.Point(16, 320), size=wx.Size(336, 100),
              style=wx.TE_PROCESS_ENTER | wx.TRANSPARENT_WINDOW | wx.TE_READONLY | wx.TE_RICH2 | wx.TE_MULTILINE,
              value='')
        self.logTxt.SetForegroundColour(wx.Colour(78, 128, 152))

        self.btnStart = wx.Button(id=wxID_DOMFRAMEBTNSTART, label='Start',
              name='btnStart', parent=self.panel1, pos=wx.Point(16, 56),
              size=wx.Size(75, 23), style=0)
        self.btnStart.Bind(wx.EVT_BUTTON, self.OnBtnStartButton,
              id=wxID_DOMFRAMEBTNSTART)

        self.btnStop = wx.Button(id=wxID_DOMFRAMEBTNSTOP, label='Stop',
              name='btnStop', parent=self.panel1, pos=wx.Point(104, 56),
              size=wx.Size(75, 23), style=0)
        self.btnStop.Enable(False)
        self.btnStop.Bind(wx.EVT_BUTTON, self.OnBtnStopButton,
              id=wxID_DOMFRAMEBTNSTOP)

        self.buttonDeleteGame = wx.Button(id=wxID_DOMFRAMEBUTTONDELETEGAME,
              label='Delete game and all turns', name='buttonDeleteGame',
              parent=self.panel1, pos=wx.Point(16, 136), size=wx.Size(160, 23),
              style=0)
        self.buttonDeleteGame.Enable(False)
        self.buttonDeleteGame.Bind(wx.EVT_BUTTON, self.OnButtonDeleteGameButton,
              id=wxID_DOMFRAMEBUTTONDELETEGAME)

        self.btnRestore = wx.Button(id=wxID_DOMFRAMEBTNRESTORE, label='Restore',
              name='btnRestore', parent=self.panel1, pos=wx.Point(16, 280),
              size=wx.Size(75, 23), style=0)
        self.btnRestore.Enable(False)
        self.btnRestore.Show(True)
        self.btnRestore.Bind(wx.EVT_BUTTON, self.OnBtnRestoreButton,
              id=wxID_DOMFRAMEBTNRESTORE)

        self.btnDelete = wx.Button(id=wxID_DOMFRAMEBTNDELETE, label='Delete',
              name='btnDelete', parent=self.panel1, pos=wx.Point(104, 280),
              size=wx.Size(75, 23), style=0)
        self.btnDelete.Enable(False)
        self.btnDelete.Show(True)
        self.btnDelete.Bind(wx.EVT_BUTTON, self.OnBtnDeleteButton,
              id=wxID_DOMFRAMEBTNDELETE)

        self.staticText1 = wx.StaticText(id=wxID_DOMFRAMESTATICTEXT1,
              label='Automatically backup your \nDominions 3 turn files. \nThe turns are saved from \nthe start of each turn.',
              name='staticText1', parent=self.panel1, pos=wx.Point(192, 24),
              size=wx.Size(130, 52), style=0)

        self.staticLine1 = wx.StaticLine(id=wxID_DOMFRAMESTATICLINE1,
              name='staticLine1', parent=self.panel1, pos=wx.Point(16, 88),
              size=wx.Size(336, 2), style=0)

        self.staticLine2 = wx.StaticLine(id=wxID_DOMFRAMESTATICLINE2,
              name='staticLine2', parent=self.panel1, pos=wx.Point(16, 312),
              size=wx.Size(336, 2), style=0)

        self.gameChoice = wx.Choice(choices=["one", "two", "three"],
              id=wxID_DOMFRAMEGAMECHOICE, name='gameChoice', parent=self.panel1,
              pos=wx.Point(16, 112), size=wx.Size(160, 21), style=0)
        self.gameChoice.Bind(wx.EVT_CHOICE, self.OnGameChoiceChoice,
              id=wxID_DOMFRAMEGAMECHOICE)

        self.turnList = wx.ListBox(choices=[], id=wxID_DOMFRAMETURNLIST,
              name='turnList', parent=self.panel1, pos=wx.Point(192, 112),
              size=wx.Size(160, 192), style=wx.VSCROLL)
        self.turnList.Show(True)
        self.turnList.Enable(False)
        self.turnList.Bind(wx.EVT_LISTBOX, self.OnTurnListListbox,
              id=wxID_DOMFRAMETURNLIST)

        self.staticText2 = wx.StaticText(id=wxID_DOMFRAMESTATICTEXT2,
              label='Turn:', name='staticText2', parent=self.panel1,
              pos=wx.Point(192, 96), size=wx.Size(27, 13), style=0)
        self.staticText2.Enable(False)

        self.staticText3 = wx.StaticText(id=wxID_DOMFRAMESTATICTEXT3,
              label='Game:', name='staticText3', parent=self.panel1,
              pos=wx.Point(16, 96), size=wx.Size(32, 13), style=0)

        self.staticText4 = wx.StaticText(id=wxID_DOMFRAMESTATICTEXT4,
              label='IMPORTANT:\nIf you are restoring a turn,\nmake sure you have closed \nthe Dominions 3 game.\nIf not the results could be\ncompromised.',
              name='staticText4', parent=self.panel1, pos=wx.Point(16, 192),
              size=wx.Size(134, 78), style=0)
        self.staticText4.Enable(True)
        self.staticText4.Show(False)

    def __init__(self, parent):
        self._init_ctrls(parent)
        self.dirTools = DirWatch.DirTools()
        self.PopulateGameChoice()
        self.threads = []
        self.count = 0

    def OnBtnStartButton(self, event):
        self.btnStart.Enable(False)
        self.btnStop.Enable(True)
        self.count += 1
        thread = DirWatch.DomBackup(self.count, self)
        self.threads.append(thread)
        thread.start()

    def OnBtnStopButton(self, event):
        self.btnStart.Enable(True)
        self.btnStop.Enable(False)
        self.logTxt.AppendText('Dom3Bak has stopped backing up.\n')
        self.StopThreads()

    def OnGameChoiceChoice(self, event):
        self.buttonDeleteGame.Enable(True)
        self.turnList.Enable(True)
        self.staticText2.Enable(True)
        self.PopulateTurnList()

    def OnTurnListListbox(self, event):
        self.btnRestore.Enable(True)
        self.btnDelete.Enable(True)
        self.staticText4.Show(True)

    def OnButtonDeleteGameButton(self, event):
        dlg = wx.MessageDialog(self, 'Are you sure you\nwant to delete all\nturn files for this game?',
           'About to delete all turns.',
           wx.YES_NO | wx.NO_DEFAULT | wx.ICON_EXCLAMATION
           )
        val = dlg.ShowModal()
        if val == wx.ID_YES:
            if DirWatch.DirTools.deleteGameBackups(self.dirTools, self.gameChoice.GetStringSelection()):
                self.LogMessage("Game backups deleted.\n")
            else:
                self.LogMessage("Problem deleting backups.\n") 
            self.PopulateGameChoice()
            self.PopulateTurnList()
        dlg.Destroy()
   
    def OnBtnRestoreButton(self, event):
        dlg = wx.MessageDialog(self, 'Have you closed your game?',
           'Alert',
           wx.YES_NO | wx.YES_DEFAULT | wx.ICON_EXCLAMATION
           )
        val = dlg.ShowModal()
        if val == wx.ID_YES:
            if DirWatch.DirTools.restoreFile(self.dirTools, self.gameChoice.GetStringSelection(), self.turnList.GetStringSelection()):
                self.LogMessage("Turn restored.\n")
            else:
                self.LogMessage("Problem restoring turn.\n") 
            self.PopulateTurnList()
        else:
            self.LogMessage("Restoration cancelled.\n\tClose Dominions 3 game and try again.\n")
        dlg.Destroy()

    def OnBtnDeleteButton(self, event):
        if DirWatch.DirTools.deleteFile(self.dirTools, self.gameChoice.GetStringSelection(), self.turnList.GetStringSelection()):
            self.LogMessage("Turn deleted.\n")
        else:
            self.LogMessage("Problem deleting turn.\n") 
        self.PopulateTurnList()

    def OnDomFrameClose(self, event):
        self.StopThreads()
        self.Destroy()

    def StopThreads(self):
        while self.threads:
            thread = self.threads[0]
            thread.stop()
            self.threads.remove(thread)

    def LogMessage(self, msg):
        self.logTxt.SetInsertionPointEnd()
        self.logTxt.AppendText(msg)

    def ThreadFinished(self, thread):
        self.threads.remove(thread)

    def PopulateGameChoice(self):
        gameList = DirWatch.DirTools.getGameList(self.dirTools)
        self.gameChoice.SetItems(gameList)
        self.buttonDeleteGame.Enable(False)
    
    def PopulateTurnList(self):
        game = self.gameChoice.GetStringSelection()
        if not game == "":
            turnFiles = DirWatch.DirTools.getTurnFiles(self.dirTools, game)
            self.turnList.SetItems(turnFiles)
        else:
            self.turnList.SetItems([])
        self.btnRestore.Enable(False)
        self.btnDelete.Enable(False)
        self.staticText4.Show(False)

    def OnMenuFileItems0Menu(self, event):
        event.Skip()

    def OnMenuHelpAbout_itemMenu(self, event):
        dlg = AboutDialog.Dialog1(self)
        try:
            dlg.ShowModal()
        finally:
            dlg.Destroy() 
    def OnMenuFileExit_itemMenu(self, event):
        self.Close()

