#include"map.hpp"
void Map::GenerateMaps()
{
    HeightMap temp1,temp2;
    maps = new float*[2];
    maps[0] = temp1.Generate(size,1,100,0,0,0,0);
    maps[1] = temp2.Generate(size,0.5,100,0,0,0,0);
    StandardizeValuess();
    GenerateLocMap();
}
void Map::StandardizeValuess()
{
    GetMaxMins();
    float m1 = 100.0/(1.0*max1-min1);
    float n1 = -1*min1*m1;
    for (int i=0;i<size*size;++i)
        maps[0][i]=maps[0][i]*m1+n1;

    float m2 = 100.0/(1.0*max2-min2);
    float n2 = -1*min2*m2;
    for (int i=0;i<size*size;++i)
        maps[1][i]=maps[1][i]*m2+n2;
}
void Map::GetMaxMins()
{
    min1=maps[0][0];
    max1=maps[0][0];
    for (int i=0;i<size*size;++i)
    {
        if (maps[0][i]>max1)
            max1=maps[0][i];
        else
            if (maps[0][i]<min1)
                min1=maps[0][i];
    }
    min2=maps[1][0];
    max2=maps[1][0];
    for (int i=0;i<size*size;++i)
    {
        if (maps[1][i]>max2)
            max2=maps[1][i];
        else
            if (maps[1][i]<min2)
                min2=maps[1][i];
    }
}
void Map::GenerateLocMap()
{
    locmap = new int[width*height];
    int i,j,temp_mask;
    int tx,ty;
    float temp_p,temp_h;
    double width_m = (1.0*size)/width;
    double height_m = (1.0*size)/height;
    for (i=0;i<width;++i)
        for (j=0;j<height;++j)
        {
            //locmap[i+j*width] = 0;
            temp_mask = 0;
            tx = i*width_m;
            ty = j*height_m;
            temp_p = maps[1][ tx+size*ty ];
            temp_h = maps[0][ tx+size*ty ];
            if (temp_h<deep_ocean)
                temp_mask = temp_mask | loc_deep_sea;
            else
                if (temp_h<ocean)
                    temp_mask = temp_mask | loc_sea;
                else
                    if (temp_h>mountain)
                        temp_mask = temp_mask | loc_mountain;
                    else
                        temp_mask = temp_mask | loc_plains;

            if ((temp_mask&loc_sea)||(temp_mask&loc_deep_sea))
            {}
            else
            {
                if (temp_p<wasteland)
                    temp_mask = temp_mask | loc_waste;
                else
                    if (temp_p>farmlands)
                        temp_mask = temp_mask | loc_farm;
                    else
                        if (temp_p>forest)
                            temp_mask = temp_mask | loc_forest;
                        else
                            if (temp_p>marsh)
                                temp_mask = temp_mask | loc_swamp;
            }

            locmap[i+j*width] = temp_mask;
        }
}
void Map::CreateMapImage()
{
    image = create_bitmap(width,height);
    int i,j,temp;
    int col_deep = makecol(0,32,128);
    int col_sea = makecol(64,128,255);
    int col_else = makecol(255,0,255);
    int col_plains = makecol(64,192,32);
    int col_plains_waste = makecol(96,96,80);
    int col_plains_farm = makecol(64,224,80);
    int col_plains_forest = makecol(96,192,32);
    int col_plains_swamp = makecol(96,96,32);
    int col_mountain = makecol(192,128,0);
    int col_mountain_waste = makecol(160,64,64);
    int col_mountain_farm = makecol(128,192,64);
    int col_mountain_forest = makecol(160,160,16);
    int col_mountain_swamp = makecol(128,128,16);

    int active_col;
    for (i=0;i<width;++i)
        for (j=0;j<height;++j)
        {
            temp = locmap[i+j*width];
            switch(temp)
            {
                case loc_deep_sea:
                    active_col=col_deep;
                    break;
                case loc_sea:
                    active_col=col_sea;
                    break;
                case loc_plains:
                    active_col = col_plains;
                    break;
                case loc_plains|loc_waste:
                    active_col = col_plains_waste;
                    break;
                case loc_plains|loc_farm:
                    active_col = col_plains_farm;
                    break;
                case loc_plains|loc_forest:
                    active_col = col_plains_forest;
                    break;
                case loc_plains|loc_swamp:
                    active_col = col_plains_swamp;
                    break;
                case loc_mountain:
                    active_col = col_mountain;
                    break;
                case loc_mountain|loc_waste:
                    active_col = col_mountain_waste;
                    break;
                case loc_mountain|loc_farm:
                    active_col = col_mountain_farm;
                    break;
                case loc_mountain|loc_forest:
                    active_col = col_mountain_forest;
                    break;
                case loc_mountain|loc_swamp:
                    active_col = col_mountain_swamp;
                    break;


                default:
                    active_col=col_else;
                    break;
            }
            putpixel(image,i,j,active_col);
        }
}
void Map::DrawMap(BITMAP *target)
{
    blit(image,target,0,0,0,0,image->w,image->h);
}
void Map::DumpImage()
{
    save_bitmap("dump.bmp",image,0);
    BITMAP *temp = create_bitmap(width,height);
    int i,j;
    for (i=0;i<width;++i)
        for (j=0;j<height;++j)
            putpixel(temp,i,j,locmap[i+j*width]);
    save_bitmap("dump2.bmp",temp,0);
    destroy_bitmap(temp);
}
