-------------------------------------------------------
-------------------- Spell copy powers ----------------
-------------------------------------------------------
add_mkey
{
	mkey	= "Magic",
	type	= "skill",
	fct	=  spell_copy_to
}

-------------------------------------------------------
-------------------- Beorning powers ------------------
-------------------------------------------------------
add_mkey
{
	mkey	= "Bear-form",
	type	= "ability",
	fct	= function()
		if mimic.get_shape() == mimic.GREAT_BEAR then
			mimic.set_shape(mimic.NONE, 0)
			energy_use = get_player_energy(SPEED_MIMIC)
		elseif mimic.get_shape() == mimic.NONE then
			mimic.set_shape(mimic.GREAT_BEAR, player.lev / 2)
			energy_use = get_player_energy(SPEED_MIMIC)
		end
	end,
}

-- Hide bearform ability for non beornings
hook(hook.INIT_DONE, function()
	ability(AB_BEORNING).hidden = player.get_race().id ~= SUBRACE_BEORNING
end)


-------------------------------------------------------
-------------------- Mimicry skill --------------------
-------------------------------------------------------
mimic.actions =
{
	{
		name = "Shapeshift back to your normal form"
		exec = function()
			if mimic.get_shape() == mimic.ABOMINATION and turn - 10 * (5 + get_skill_scale(SKILL_MIMICRY, 50)) < mimic.timeout then
				message("You still cannot manage to gain back control of your body.")
				return
			end
			return true, mimic.NONE
		end
	}
	{
		name = "Shapeshift using your cloak"
		exec = function()
			local mobj = {}
			for_inventory_inven(player.inventory[INVEN_OUTER], function(obj)
				if obj.flags[FLAG_MIMIC_IDX] then %mobj.obj = obj end
			end)
			if not mobj.obj then
				message("You must wear a mimicry cloak to use this power.")
			else
				return true, mobj.obj.flags[FLAG_MIMIC_IDX]
			end
		end
	}
	{
		name = "Shapeshift into a Fire Elemental"
		allow = function() return has_ability(AB_FIRE_SHAPE) end
		exec = function()
			return true, mimic.FIRE_FORM
		end
	}
	{
		name = "Shapeshift into a Wind Elemental"
		allow = function() return has_ability(AB_AIR_SHAPE) end
		exec = function()
			return true, mimic.WIND_FORM
		end
	}
	{
		name = "Shapeshift into a Water Elemental"
		allow = function() return has_ability(AB_WATER_SHAPE) end
		exec = function()
			return true, mimic.WATER_FORM
		end
	}
	{
		name = "Shapeshift into a Stone Elemental"
		allow = function() return has_ability(AB_EARTH_SHAPE) end
		exec = function()
			return true, mimic.STONE_FORM
		end
	}
}
function mimic.action_shortinfo (y, x, a) if a then term.blank_print(a.name, y, x) end end

add_loadsave("mimic.timeout", 0)
hook(hook.BIRTH, function() mimic.timeout = 0 end)


add_mkey
{
	mkey	= "Mimicry",
	type	= "skill"
	fct	= function()
		local acts = {}
		for i = 1, getn(mimic.actions) do
			if not mimic.actions[i].allow or mimic.actions[i].allow() then
				mimic.actions[i].__index__ = i
				tinsert(acts, mimic.actions[i])
			end
		end
		local act = nil

		local ret, rep = repeat_keys.pull()
		if ret then
			if mimic.actions[rep] and (not mimic.actions[rep].allow or mimic.actions[rep].allow()) then
				act = mimic.actions[rep]
			end
		end

		act = act or choose_from_list(acts, "Mimicry actions", "Perform which mimicry action?", mimic.action_shortinfo)
		if act and act.exec then
			repeat_keys.push(act.__index__)

			local ret, shape = act.exec()
			if ret then
				if shape ~= mimic.NONE then
					if turn - 10 * (5 + get_skill_scale(SKILL_MIMICRY, 50)) < mimic.timeout then
						message("You cannot shapeshift again for "..1 + ((10 * (5 + get_skill_scale(SKILL_MIMICRY, 50)) - turn + mimic.timeout) / 10).." turns.")
						return
					end

					local chance = mimic.get_info(shape, "level") * 3
					chance = chance - get_skill_scale(SKILL_MIMICRY, 150) - (((player.stat(A_DEX) - 10) * 2) / 3)
					if chance < 5 then chance = 5
					elseif chance > 95 then chance = 95 end

					if chance > 75 then
						if not get_check("You feel uneasy with this shape-change. Try anyway?") then return end
					end
					if rng.percent(chance) then
						shape = mimic.ABOMINATION
						message("Your shape-change goes horribly wrong!")
						if rng.percent(player.skill_sav) then
							message("You manage to wrest your body back under control.")
						shape = mimic.NONE
						end
					end
					message("You shapeshift!")
				else
					message("You change back to your natural form.")
				end

				mimic.set_shape(shape, get_skill_scale(SKILL_MIMICRY, 50))
			      	energy_use = get_player_energy(SPEED_MIMIC)
				mimic.timeout = turn
			end
		end
	end,
}

-------------------------------------------------------
--------------------- Entish powers -------------------
-------------------------------------------------------
add_mkey
{
	mkey	= "Boulder-throwing",
	type	= "skill",
	fct	= function()
	end,
}


-------------------------------------------------------
------------------ Death Touch powers -----------------
-------------------------------------------------------
add_mkey
{
	mkey 	= "Touch of death"
        type	= "ability"
	fct 	= function()
			if player.csp() > 40 then
				increase_mana(-40)
				timed_effect(timed_effect.MELEE_PROJECT, rng(30) + 10, dam.INSTA_DEATH, 1, 0, PROJECT_STOP + PROJECT_KILL)
                                message("You are engulfed in a cloud of darkness.")
				energy_use = 100
			else
				message("You need at least 40 mana.")
			end
	end,
}

-------------------------------------------------------
---------------- Nicer casting interface --------------
-------------------------------------------------------
load_subsystem("easy_cast")
