-- The Dominions archery combat subsystem

-- Make the namespace
combat.archery = {}

-- This following was in the energy statement, and in a function to reduce
-- energy in the code.  can we not reduce energy using the energy statement?
-- as with weapon.lua?
--		return nil end

constant("COMBAT_ARCHERY", add_combat_system
{
	name		= "Archery"
	desc		= "The Dominions archery subsystem."
	skill		= "SKILL_NONE"
	-- For whatever reason, this doesn't acutally seem to work.
	energy		= function() return get_player_energy(SPEED_FIRE) end,
	-- This should be able to contain a function that will test to see
	-- if missile fire is available.  For whaterver reason, it doesn't
	-- appear to function.  Missile fire is instead tested for in the 
	-- 'attack' function
	available	= function() return true end,
	-- Not sure what this is used for
	info 		= function() return "???" end,
	attack		= function(y, x, max, dir) combat.archery.attack(dir) end,
	hooks		=
	{
	}
})

-- In order to keep the indent from moving so far to the right, the
-- missile attack function is built down here.
function combat.archery.attack(force_dir)
	-- Is the monster dead?
	-- This actually serves no purpose at the  moment, but was used in
	-- the code upon which this chunk of code was based.  It isn't hurting
	-- anything, so I've just left it in place.
	local mdeath = false

	-- get the weapon.
	-- hack -- to prevent problems from trying to attack with a bow,
	-- I've made bows an 'offhand' item.  This doesn't really even
	-- present any problems given the Dominions conventions, but is a
	-- little counter intuitive
	local missile = player.inventory[INVEN_OFFHAND][1]
	
	-- is it a missile weapon?
	if missile and missile.flags[FLAG_MISSILE] then
	
		-- does it have ammo?
		-- ammo is stored as a number on the bow, rather than as an 'ammo'
		-- stock that is depleted.  mechanically, this is unproblematic,
		-- but some might find it unusual.  Also, there is no functions or
		-- items to refill ammo; this is obviously a problem.
		if missile.flags[FLAG_AMMO_CURRENT] > 0 then

			-- Use energy
			energy_use = get_player_energy(SPEED_GLOBAL)

			-- getting direction.
			-- this does NOT return coordinates, only direction
			local ret, dir = get_aim_dir()
			if ret then

				-- deplete ammo
				missile.flags[FLAG_AMMO_CURRENT] = missile.flags[FLAG_AMMO_CURRENT] - 1

				-- Maximum range by firearm type.
				-- since this comes AFTER the get_aim_dir(), i'm not sure how
				-- it can limit the possible targets.  none-the-less,
				-- get_aim_dir does seem to indicate when a target is being
				-- chosen that is out of range, i'm just not sure this number
				-- has anything to do with it.  another reason I don't like
				-- get_aim_dir(), and would like to write my own function for
				-- handling targeting and coordinates
				local tdis = missile.flags[FLAG_BASE_RANGE]

				-- Start at the player
				local by = player.py
				local bx = player.px
				local y = player.py
				local x = player.px
				local ny, nx

				-- Predict the "target" location
				-- the projects the coordinates towards which the missile moves
				local dy, dx = explode_dir(dir)
				local tx = player.px + 99 * dx
				local ty = player.py + 99 * dy

				-- Check for "target request"
				if (dir == 5) then
					tx = target_col
					ty = target_row
				end
				
				-- Travel until maximum range reached.
				for cur_dis = 0, tdis do

					-- Hack -- don't shoot yourself.  essentially, if player targets
					-- itself, this prevents player from shooting itself.
					if ((y == ty) and (x == tx)) then
						break
					end

					-- Calculate the new location (see "project()")
					ny = y
					nx = x
					ny, nx = mmove2(ny, nx, by, bx, ty, tx)

					-- Save the new location
					x = nx
					y = ny

					local c_ptr = cave(y, x)
					local m_ptr

					-- We hit something?
					-- This is where the missile system works.  It simply checks
					-- after each move along the path to see if the missile is on
					-- a square containing a monster.
					if c_ptr.m_idx > 0 then
					
						-- Hack -- check for deviation AFTER the missile has
						-- 'hit' the target.  If the deviation occurs and 
						-- drops the missile on a monster, then the
						-- archery hit function can be called.  We check after
						-- the missile has hit the target because it is only then
						-- that we have the monsters coordinates.
						-- Check for deviation.
						-- Compute where a missile will land in case of deviation.
						local dist = distance(player.py, player.px, y, x)
						if dist > ((player.stat(A_PRECISION) / 2) - 2) then
							local dev = (dist * (5 / 4)) / player.stat(A_PRECISION)
							local vy = rng(-dev, dev)
							local vx = rng(-dev, dev)
							local cov = 0
							-- This is a bit of code to see how many diagonal steps the
							-- missile was moved, and to modify those steps by an amount
							-- to make the shape of the range in which a missile may be
							-- dropped a circle, rather than a square.  It essentially
							-- just checks for covariance between y and x.  The more
							-- covariance, the more diagonal steps.
							if vy < 0 and vx < 0 then
								if vy <= vx then
									cov = abs(vy) / abs(vx)
								else
									cov = abs(vx) / abs(vy)
								end
							else
								cov = 0
							end
							local div = (cov * (1 / 2)) + 1
							vy = vy / div
							vx = vx / div
							y = y + vy
							x = x + vx
							-- make the new c_ptr after adding the deviation.
							c_ptr = cave(y,x)
						end					

						-- After adding deviation effects, look again to
						-- check for monster
						if c_ptr.m_idx > 0 then
						-- there is a monster here
						
							m_ptr = monster(c_ptr.m_idx)
							if combat.archery.hit(m_ptr) then
							-- we hit

								-- Is the monster dead?
								if c_ptr.m_idx == 0 then
									mdeath = true
									break
								end
							end
						else
							-- The missile didn't hit anything, but still
							-- strikes the ground.
							local missile = player.inventory[INVEN_OFFHAND][1].flags[FLAG_DAM]
							local typ = flag_max_key(missile)
		
							local damroll = rng.drn()
							local protroll = rng.drn()
		
							damroll = damroll + rng(flag_get(missile, typ), flag_get2(missile, typ))
							protroll = protroll
		
							local dam = damroll - protroll
		
							if dam > 0 then
								project(WHO_PLAYER, 0, y, x, dam, typ, PROJECT_JUMP | PROJECT_STOP | PROJECT_KILL | PROJECT_NO_REFLECT)
							end
							break
						end
					end
				end
			end
		end
	end
end

-- the function to determine if hit and damage.  It is split off in
-- order to keep the indent from moving so far to the right.
function combat.archery.hit(monst)

	-- Do DRN rolls for attack and defense
	local attroll = rng.drn()
	local defroll = rng.drn()

	-- Compare attack and defense rolls, and see if a hit occurs
	if attroll > defroll then
	
		-- We hit.  Now get the damage and type
		local missile = player.inventory[INVEN_OFFHAND][1].flags[FLAG_DAM]
		local typ = flag_max_key(missile)

		-- do damage and protection rolls
		local damroll = rng.drn()
		local protroll = rng.drn()

		-- add missile damage and monster protection to rolls
		damroll = damroll + rng(flag_get(missile, typ), flag_get2(missile, typ))
		protroll = protroll + monst.ac

		-- compare the rolls and see if damage was inflicted
		local dam = damroll - protroll
		
		if dam > 0 then
		-- We did damage.

			project(WHO_PLAYER, 0, monst.fy, monst.fx, dam, typ, PROJECT_JUMP | PROJECT_STOP | PROJECT_KILL | PROJECT_NO_REFLECT)
		
		-- If damage < protection, then the function will jump to the end,
		-- this avoids healing through projecting 'negative damage'
		end
		
		-- the function has to return true in order to deliver the damage.
		return true
	else
		-- we missed.
		return false
	end
end

-- This maps the 'f'ire function to the 'f' key
if not get_subsystem_param("combat_archery", "no_key_bind") then
	hook(hook.KEYPRESS, function (key)
		if key == strbyte('f') then combat.archery.attack() return true end
	end)
end