-- The player fatigue subsystem
--
-- This defines counter.FATIGUE as the fatigue counter
--
-- decrease_fatigue() and increase_fatigue() are functions to decrease and increase the counter respectively.
--
-- player.cfat() and player.mfat() are functions to return the current counter value and the maximum counter value respectively.

declare_global_constants
{
	"decrease_fatigue",
	"increase_fatigue",
}

new_flag("REINVIG")
new_flag("EXHAUST")

hook.new_hook_type("PLAYER_INCREASE_FATIGUE")
counter.create
{
	name = "FATIGUE"
	min = 0
	max = 201
	reset = "min"
	-- This counter was wrote by copying another counter and modifiying it.
	-- Although it was explained to me once, I'm not entirely sure how
	-- this function works or why it is necessary.  According the person
	-- who explained it to me, it is overlycomplex, and could have been
	-- done in a much simpler fashion.  In fact, this holds true for
	-- most of t-engine
	on_decrease = function(value, modif, reason)
		local ret, new_modif = hook.process(hook.PLAYER_INCREASE_FATIGUE, value, modif)
		if ret then
			modif = new_modif
		end

		player.redraw[FLAG_PR_FATIGUE] = true
		player.window[FLAG_PW_PLAYER] = true
		return true, modif
	end
	on_increase = function(value, modif, reason)
		-- Check to see if we're dead
		-- This is where the 'passing out' effect of 100 fatigue should
		-- be added.
		if value + modif > 200 then
			message(color.RED, "You die.")
			kill_player(reason)
		end
		
		player.redraw[FLAG_PR_FATIGUE] = true
		player.window[FLAG_PW_PLAYER] = true
	end
	auto_regen = function()
		local nb = player.reinvig()
		if nb ~= 0 then
			local amt  = nb / 1000
			local im   = imod(abs(nb), 1000)

			if im ~= 0 then
				if imod(turn / 10, 1000 / im) == 0 then
					local sign = nb / abs(nb)
					amt = amt + (1 * sign)
				end
			end

			if amt ~= 0 then
				-- Ensure fatigue doesn't go negative
				local cur = counter.get(counter.FATIGUE)
				if cur + amt < 0 then
					amt = -cur
				end

				if cur == -amt and cur > 0 then
					term.disturb(0, 0)
				end					

				return amt
			end
		end
	end
}

function decrease_fatigue(reinvig)
	counter.dec(counter.FATIGUE, reinvig)
end

function increase_fatigue(exh, die_from)
	counter.inc(counter.FATIGUE, exh, die_from)
end

function player.cfat(val)
	if val then counter.set(counter.FATIGUE, val, "setting fatigue") end
	return counter.get(counter.FATIGUE)
end

function player.mfat(val)
	return counter.max(counter.FATIGUE, val)
end

function player.reinvig()
	return player.intrinsic(FLAG_REINVIG) - player.intrinsic(FLAG_EXHAUST)
end