-- Death spells

declare_global_constants
{
	"SCHOOL_DEATH",
	"ANIMATE_SKELETON",
}

SCHOOL_DEATH = add_school
{
        ["name"]  = "Death",
        ["skill"] = "SKILL_DEATH",
        ["hooks"] =
        {

        }
}

add_mkey
{
        mkey	= "Death Magic",
		type	= "ability",
        fct	= function()
                -- create a book (has SPECIAL_GENE)
			local death_book = make_book
			(
				ANIMATE_SKELETON
			)

			local spl = nil
			local ret, rep = repeat_keys.pull()
			if ret then
				if is_ok_spell(rep, death_book) then
					spl = rep
				end
			end

			-- select a spell from that book
			spl = spl or get_school_spell("cast", "is_ok_spell", death_book)

			-- and delete it.
			delete_object(death_book)

			if spl == -1 then return end

			-- Now to actually cast the spell...
			cast_school_spell(spl, spell(spl))
		end,
}

ANIMATE_SKELETON = add_spell
{
        name	= "Animate Skeleton",
        school	= SCHOOL_DEATH,
		stat	= 0,
		level	= 0,
		mana	= 0,
        mana_max= 0,
		fail	= 0,
		spell	= function()
			local ret, x, y = tgt_pt()
			if not ret then return SPELL_NOTHING end

			local faction
			if spell_caster == WHO_PLAYER then
				energy_use = get_player_speed(SPEED_GLOBAL)
				increase_fatigue(20)
				y = player.py
				x = player.px
				faction = player.faction
			
			-- This might be used if something other than another unit
			-- is summoning a monster
--			elseif spell_caster < 0 then
--				faction = FACTION_DUNGEON
				
			
			else
				y, x = get_spell_caster_info()
				faction = monster(spell_caster).faction
			end
			
			-- LAZY Hack -- need to right function to randomly place
			-- This will actually return errors as monsters are summoned
			-- into trees and other monsters and stuff
			y = y + 1
			x = x + 1
--			this will be used in later spells to set the number
--			of units summoned
--			for i = 1 do
			local ret, summoned = summon_monster(y, x, 0, faction, {flags = {LONGDEAD = true}})

				-- Force friendliness to player if player did summoning
				if spell_caster == WHO_PLAYER then
					for j = 1, getn(summoned) do
						factions.change_faction(summoned[j], FACTION_PLAYER)
					end
				end
			return true
		end,
		info     = function() return "" end,
		desc     =
		{
		}
}