-- This file is loaded at the initialisation of ToME.  It is where
-- all the systems created to provide the mechanics for the module
-- are loaded at.  The files themselves exist in the module/scripts
-- folder or the engine/subsystems folder.  Those in the module/scripts
-- folder are loaded with tome_dofile("foo.lua"); these files are
-- generally ones written to define the specific mechanics unique to
-- a module.  Those in the engine/subsytems folder are loaded with
-- load_subsystem("foo.lua"); these files are provided with the t-engine
-- and are used to fill basic functions or act as default mechanics
-- for modules

-- Add dominions specific flags
tome_dofile("flags.lua")

-- Add new colors
tome_dofile("colors.lua")

-- Add the ingame help
tome_dofile("dialogue.lua")

-- Add fatigue system
tome_dofile("fatigue.lua")

-- Add the drn rolls
tome_dofile("drn.lua")

-- Add player data
tome_dofile("player.lua")

-- Add the slots
tome_dofile("slots.lua")

-- Load the damage types
tome_dofile("dam_type.lua")

-- Load the objects
tome_dofile("objects.lua")

-- Load the monster memory
tome_dofile("memory.lua")

-- Load spells
tome_dofile_anywhere(TENGINE_DIR_DATA, "magic/spells.lua", FALSE)

-- Load the options
tome_dofile("options.lua")

-- Add the combat systems
tome_dofile("combat.lua")

-- Add the level generator
tome_dofile("generator.lua")

-- Subsystems
load_subsystem("resting",
	{
	stop_check = function()
		return player.chp() == player.mhp()
	end
	})
load_subsystem("player_life")
load_subsystem("quaff")
load_subsystem("easy_cast")