-- Monster combat

-- Load the combat monster subsystem which defines some basic stuff for all monster combat subsystems
load_subsystem("combat_monster")

-- Make the namespace
combat_monster.default = {}

-- Clearing project flags
-- clears the project flags used to apply damage.
combat_monster.__project_flags = 0

-- Define the monster combat itself
constant("COMBAT_MONSTER", combat_monster.register
{
	name = "Default monster combat"
	energy	= function() return get_player_energy(SPEED_WEAPON) end
	attack = function(y, x, c_ptr, m_idx, m_ptr, t_idx, t_ptr, t_flags)

		-- Not allowed to attack
		-- Not so sure how this works, but it seems to not cause problems.
		if not combat_monster.init_combat_turn(y, x, c_ptr, m_idx, m_ptr, t_idx, t_ptr, t_flags) then return false end

		-- get armor
		-- find out what the monster is attacking.  if it is the player
		-- than get player armor.  otherwise it must be another monster,
		-- so get its armor.
		local ac
		if t_ptr == player then
			ac = player.ac
		else
			ac = t_ptr.ac
		end

		-- Get the monster name (or "it").
		local m_name = combat_monster.desc_self(m_ptr)
		local t_name = combat_monster.desc_target(t_ptr)

		local params = {}

		-- a loop that moves through all blows
		for ap_cnt = 0, flag_max_key(m_ptr.blow) do

			local visible = false
			local obvious = false

			params.dam = 0

			local act = ""

			-- Get the monster attack
			local blow = flag_get_blow(m_ptr.blow, ap_cnt)
			if not blow then break end

			-- no more attacks
			if (blow.method == 0) then break end

			-- get the method and effect of blows
			local method = __monster_attack_methods[blow.method]
			local effect = __monster_attack_types[blow.effect]

			-- Visibility
			if (m_ptr.ml) then visible = true end

			-- this assigns all blow information to a table called 'params'
			-- I would simply use each peice of information by name, but the
			-- 'done' hook below calls for all the params, so I have left it
			-- like this.
			params.m_ptr = m_ptr
			params.m_name = m_name
			params.effect = effect
			params.method = method
			params.t_ptr = t_ptr
			params.t_name = t_name
			params.t_flags = t_flags

			-- This determines if the monster has gone through all its blows
			-- and is finished attacking.  I'm not entirely sure how it works,
			-- but it does.
			local done = hook.process(hook.HANDLE_MONSTER_BLOW, params)
			
			-- Get the monster
			local monst = monster(m_idx)

			-- Increase monster fatigue
			monst.flags[FLAG_MONST_FAT] = monst.flags[FLAG_MONST_FAT] + monst.flags[FLAG_MONST_ENCUM]

			-- Do DRN rolls for attack and defense
			local attroll = rng.drn()
			local defroll = rng.drn()

			-- Add attack and defense skills to the rolls
			attroll = attroll + monst.flags[FLAG_MONST_ATT]
			defroll = defroll + player.stat(A_DEFENSE)

			-- Subtract fatigue penalties from attack and defense rolls
			attroll = attroll - (monst.flags[FLAG_MONST_FAT] / 20)
			defroll = defroll - (player.cfat() / 10)

			-- add attack and defense skills to rolls, compare them, and see if a hit occurs.
			if (not done) and (combat_monster.__force_hit or (effect == 0) or (attroll > defroll)) then
				-- It hit

				-- Disturb others
				-- for now this stays, but the Dominions system may rework it.
				if game_options.disturb_other and (m_ptr.ml or t_ptr == player or t_ptr.ml) then
					term.disturb(1, 0)
				end

				-- Get the action
				-- This is only used to determine what is printed to the screen
				-- eg "monster attacks you"
				act = method.action

				-- Message
				combat_monster.action_message(m_ptr, m_name, t_ptr, t_name, act)

				-- Check for a critical hit.
				-- find out what fatigue value we are using, the players or
				-- another monster's
				local fat
				if t_ptr == player then

					-- get the player's fatigue
					fat = player.cfat()
				else

					-- the target must be another monster, so get that monster's
					-- fatigue
					fat = t_ptr.flags[FLAG_MONST_FAT]
				end
	
				-- Do the critroll
				local critroll = rng.drn()
				if (critroll - (fat / 15 )) < 2 then

					-- It critical hit.  Halve target protection.
					ac = ac / 2
				end	

				-- Now do DRN rolls for damage and protection
				local damroll = rng.drn()
				local protroll = rng.drn()

				-- Add monster damage and player protection to rolls
				damroll = damroll + rng.roll(blow.d_dice, blow.d_side)
				protroll = protroll + ac

				-- Compare the rolls and see if damage was inflicted.
				params.dam = damroll - protroll

				if params.dam > 0 then
					-- It did damage

					-- obviousness
					obvious = effect.obvious

					-- Apply the damage
					project(m_idx, 0, y, x, params.dam, effect.type, PROJECT_KILL | PROJECT_STOP | PROJECT_HIDE | PROJECT_HIDE_BLAST | PROJECT_NO_REFLECT | combat_monster.__project_flags)

				-- if dam < protection, the function jumps to here, skipping the
				-- damage application.  this prevents healing through 'negative damage'
				end

			elseif not done then
				-- It didn't hit, but it still disturbs.

				-- Visible monsters
				-- what's with visible monsters?
				if (m_ptr.ml) then

					-- Disturbing
					term.disturb(1, 0)

					-- Message
					monster_player_msg(strcap(m_name).." misses "..t_name..".", (t_ptr == player) or combat_monster.__force_name, t_ptr.ml)
				end
			end

			-- The following essentially moves to the next blow for those
			-- monsters with multiple blows
			-- Analyze "visible" monsters only.
			-- Why do we analyze visible monsters only?
			if not done and visible == true and (t_ptr == player or t_ptr.ml) then
				local blowmem = deep_get{memory.get_entry(race_info(m_ptr),m_ptr.ego),RT_BLOWS}
				if not blowmem[ap_cnt] then
					blowmem[ap_cnt] = 0
				end
				-- Count "obvious" attacks (and ones that cause damage)
				-- Not entirely sure what obviousness does, or if it is necessary
				if (obvious == true) or (params.dam > 0) or (blowmem[ap_cnt] > 10) then
					-- Count attacks of this type
					if (blowmem[ap_cnt] < 255) then
						blowmem[ap_cnt] = blowmem[ap_cnt] + 1
					end
				end
			end

			-- Don't keep hitting if the player is dead
			if (t_ptr == player) and (player.chp() < 0) then return end

		-- if the attack roll failed, the function jumps to the end, and
		-- no damage is computed.
		end

		-- i'm not entirely sure why this is necessary.
		return false
	end
})

-- All the monster attack methods
-- These are HOW the monster attacks.  eg melee or missile
add_monster_attack_method
{
	["name"]	= "HIT",
	["desc"]	= "hit",
	["action"]	= "hits @target@",
	["fct"]		= function() return	end,
}

-- All monster attack types
-- These are the effects of a monster hit.  eg pure damage.
add_monster_attack_type
{
	["name"]	= "HURT",
	["desc"]	= "hurt",
	["power"]	= 0,
	["type"]	= dam.MELEE,
	["obvious"]	= true,
	["fct"]		= function() return	end,
}

function default_monster_drop(m_idx, m_ptr, r_ptr)
	-- No drops
end