-- Astral spells

declare_global_constants
{
	"SCHOOL_ASTRAL",
	"STARFIRES",
}

SCHOOL_ASTRAL = add_school
{
        ["name"]  = "Astral",
        ["skill"] = "SKILL_ASTRAL",
        ["hooks"] =
        {

        }
}

add_mkey
{
        mkey	= "Astral Magic",
		type	= "ability",
        fct	= function()
                -- create a book (has SPECIAL_GENE)
			local astral_book = make_book
			(
				STARFIRES
			)

			local spl = nil
			local ret, rep = repeat_keys.pull()
			if ret then
				if is_ok_spell(rep, astral_book) then
					spl = rep
				end
			end

			-- select a spell from that book
			spl = spl or get_school_spell("cast", "is_ok_spell", astral_book)

			-- and delete it.
			delete_object(astral_book)

			if spl == -1 then return end

			-- Now to actually cast the spell...
			cast_school_spell(spl, spell(spl))
		end,
}

STARFIRES = add_spell
{
        name	= "Starfires",
        school	= SCHOOL_ASTRAL,
		stat	= 0,
		level	= 0,
		mana	= 0,
        mana_max= 0,
		fail	= 0,
		spell	= function()
			local ret, dir
			ret, dir = get_aim_dir()
			if ret then
				energy_use = get_player_energy(SPEED_GLOBAL)
				fire_ball(dam.LITE, dir, 5, 0)
				fire_ball(dam.LITE, dir, 5, 0)	
			end
			increase_fatigue(20)
		end,
		info	= function() return "" end,
		desc	=
		{
		}
}