-- Player data helper.  These are functions that gather data on the player
-- and return specific information.  They are used when necessary data may
-- vary between players, situations, or even mechanics.  For example, for
-- some characters race is a better descriptor, for others it will be
-- background, a function exists here to determine which descriptor should
-- be used.  There is also a function here to handle encumbrance values.
-- For the moment, encumbrance exists as a character stat; however this is
-- unintuitive.  Later, encumbrance values may be stored a more intuitive 
-- fashion.  Instead of having to change all areas of the code that call
-- for encumbrance values, only the get_encum function needs to be changed.

function player.get_race()
	return player.get_descriptor("race")
end

function player.get_sex()
	return player.get_descriptor("sex")
end

function player.get_background()
	return player.get_descriptor("background")
end

-- This function decides of the race or the background of the player
-- is the most appropriate value to display.  Dominions nations that
-- are mostly human will often use background rather than race as the
-- primary descriptor.
function player.get_race_and_background()
	local background = player.get_background().title
	if background == "Normal"
	then
		return player.get_race().title
	else
		return player.get_background().title
	end
end

-- This function computes and returns encumbrance.
function player.get_encum()
	local encum = player.stat(A_ENCUM)
	if player.inventory[INVEN_BODY][1] and player.inventory[INVEN_BODY][1].flags[FLAG_ENCUM] then
		return player.inventory[INVEN_BODY][1].flags[FLAG_ENCUM] + encum
	else
		return encum
	end
end

-- This function returns the appropriate flag when a melee attack
-- is done.  It is necessary because 'unarmed' attacks exist as
-- an 'inventory' item right now.  This is counterintuitive, but it
-- works, and may even be the best option.
function player.get_weap(flag)
	if player.inventory[INVEN_MAINHAND][1] then
		return player.inventory[INVEN_MAINHAND][1].flags[flag]
	else
		return player.inventory[INVEN_UNARMED][1].flags[flag]
	end
end
	