-- Character sheet display

set_character_sheet
{
	name = "Character Basic Informations"
	page = 1
	display =
	{
		-- Leftscreen info
		[{ 2, 0, "s", 1 }] = { title="Name  :", data="player_name()" color=color.LIGHT_BLUE }
		[{ 4, 0, "s", 1 }] = { title="Hit Points         ", data="player.chp()..'/'..player.mhp()" color=color.LIGHT_GREEN }
		[{ 5, 0, "s", 1 }] = { title="Protection         ", data="player.ac" color=color.LIGHT_BLUE }
		[{ 6, 0, "s", 1 }] = { title="Morale             ", data="player.stat(A_MORALE)" }
		[{ 7, 0, "s", 1 }] = { title="Magic Resistance   ", data="player.stat(A_MAGRES)" }
		[{ 8, 0, "s", 1 }] = { title="Encumbrance        ", data="player.get_encum()" color=color.LIGHT_BLUE }
		[{ 9, 0, "s", 1 }] = { title="Fatigue            ", data="player.cfat()" color=color.LIGHT_BLUE }
		[{ 11, 0, "s", 1 }] = { title="S", data="get_skill(SKILL_ASTRAL)" color=color.WHITE }
		[{ 13, 0, "s", 1 }] = { title="Level", data="player.lev" color=color.LIGHT_GREEN }
		[{ 14, 0, "s", 1 }] = { title="Exp", data="player.exp" color=color.LIGHT_GREEN }
		[{ 15, 0, "s", 1 }] = { title="Exp to Adv", data=function() if player.lev < 5 then return (player_exp[player.lev] * player.expfact) / 100 else return "****" end end color=color.LIGHT_GREEN }
		
		-- Midscreen info
		[{ 1, 30, "s", 1 }] = { title="", data="player.get_race_and_background()" color=color.LIGHT_BLUE }
		[{ 4, 30, "s", 1 }] = { title="Strength        ", data="player.stat(A_STRENGTH)" }
		[{ 5, 30, "s", 1 }] = { title="Attack Skill    ", data="player.stat(A_ATTACK)" }
		[{ 6, 30, "s", 1 }] = { title="Defense Skill   ", data="player.stat(A_DEFENSE)" }
		[{ 7, 30, "s", 1 }] = { title="Precision       ", data="player.stat(A_PRECISION)" }
		[{ 8, 30, "s", 1 }] = { title="Move" }
		[{ 9, 30, "s", 1 }] = { title="Leadership      ", data="player.stat(A_LEADERSHIP)" }
	}
	keys =
	{
		['c'] = {
			name = "change name"
			action = function()
				local new_name = input_box("New name?", 40, player_name())
				if new_name ~= "" then
					player_name(new_name)
				end
			end
		}
	}
}

-- To format your own character sheet written to file, do this:

--[[
character_sheet.dump_to_file = function(file)
	fs.write(file, current_module.name .. ' ' .. current_module.version[1] ..
	         '.' .. current_module.version[2] .. '.' ..
	         current_module.version[3] .. ' Character Sheet')

	-- etc.
end
]]

-- Useful examples:

--[[
	fs.write(file, "\nEquipment")
	fs.write(file, "---------------")
	for_inventory(player, INVEN_PACK, INVEN_TOTAL, function(obj, i, j, slot)
		fs.write(%file, format("%c) %s", index_to_label(i),
		                                object_desc(obj, true, 3)))
	end)

	fs.write(file, "\nInventory")
	fs.write(file, "---------------")
	for_inventory(player, 0, INVEN_PACK, function(obj, i, j, slot)
		fs.write(%file, format("%c) %s", index_to_label(slot),
		                                object_desc(obj, true, 3)))
	end)

	fs.write(file, "\nKills")
	fs.write(file, "---------------")
	character_sheet.print_kill_count(file)
]]
