-- Take care of displaying the screen

declare_global_constants
{
	"SCREEN_MODE_NORMAL",
}

SCREEN_MODE_NORMAL = record_screen_mode
{
	["name"] = "Normal Screen Mode";
	{
		["name"] = "Wipe",
		["flag"] = FLAG_PR_WIPE,
		["x"] = 0, ["y"] = 0,
		["width"] = function(h, w) return w - 1 end, ["height"] = function(h, w) return h - 1 end,
		["clean"] = false,
		["display"] = function(y, x)
			message()
			term.clear()
		end,
	},
	{
		["name"] = "Map",
		["flag"] = FLAG_PR_MAP,
		["x"] = 0, ["y"] = 1,
		["width"] = function(h, w) return w - 1 end, ["height"] = function(h, w) return h - 1 - 1 end,
		["clean"] = false,
		["display"] = function(y, x, h, w)
			SCREEN_HGT = 22
			SCREEN_WID = 79
			ROW_MAP = y
			COL_MAP = x
			ROW_MAP_HGT = y + h + 1
			COL_MAP_WID = x + w + 1
			panel_bounds()
			prt_map()
		end,
	},
	{
		-- This doesnt redraw message, just sets up the message zone
		["name"] = "Message",
		["flag"] = FLAG_PR_WIPE,
		["x"] = 0, ["y"] = 0,
		["width"] = function(h, w) return w - 1 end, ["height"] = 1,
		["clean"] = false,
		["display"] = function(y, x, h, w)
			message_row = y
			message_col = x
			message_col_max = w
		end,
	},
	{
		["name"] = "HP",
		["flag"] = { FLAG_PR_HP, FLAG_PR_BASIC, },
		["x"] = 0, ["y"] = function(h, w) return h - 1 end, ["width"] = 12, ["height"] = 1,
		["display"] = function(y, x)
			term.print("Hp: "..player.chp().."("..player.mhp()..")", y, x)
		end,
	},
	{
		["name"] = "Encumbrance",
		["flag"] = { FLAG_ENCUM, FLAG_PR_BASIC, },
		["x"] = 14, ["y"] = function(h, w) return h - 1 end, ["width"] = 9, ["height"] = 1,
		["display"] = function(y, x)
			term.print("Encumbrance: "..player.get_encum(), y, x)
		end,
	},
	{
		["name"] = "Fatigue",
		["flag"] = { FLAG_PR_FATIGUE, FLAG_PR_BASIC, },
		["x"] = 44, ["y"] = function(h, w) return h - 1 end, ["width"] = 9, ["height"] = 1,
		["display"] = function(y, x)
			local c
			local perc

			if (player.mfat() <= 0) then
				perc = 100
			else
				perc = (100 * player.cfat()) / player.mfat()
			end

			term.print(color.WHITE, "Fatigue ", y, x)

			local tmp = format("%4d/%4d", player.cfat(), player.mfat())

			if (perc >= 100) then
				c = color.RED
			elseif (perc > (10 * hitpoint_warn)) then
				c = color.YELLOW
			else
				c = color.LIGHT_GREEN
			end

			term.print(c, tmp, y, x + 3)
		end
	},
}



-- Setup the default one
set_screen_mode(SCREEN_MODE_NORMAL, nil)
