-- The Dominions archery combat subsystem

-- Make the namespace
combat.archery = {}

constant("COMBAT_ARCHERY", add_combat_system
{
	name		= "Archery"
	desc		= "The Dominions archery subsystem."
	skill		= "SKILL_NONE"
	energy		= function() return get_player_energy(SPEED_FIRE) end,
	available	= function() return true end,
	info 		= function() return "???" end,
	attack		= function(y, x, max, dir) combat.archery.attack(dir) end,
	hooks		=
	{
	}
})

-- In order to keep the indent from moving so far to the right, the
-- missile attack function is built down here.
function combat.archery.attack(force_dir)

	-- get the weapon.
	-- Hack -- to prevent problems with trying to attack with a launcher
	-- I've made launchers offhand weapons
	local missile = player.inventory[INVEN_OFFHAND][1]
	
	-- is it a missile weapon?
	if missile and missile.flags[FLAG_MISSILE] then
	
		-- does it have ammo?
		if missile.flags[FLAG_AMMO_CURRENT] > 0 then
		-- we can fire it

			-- Use energy
			energy_use = get_player_energy(SPEED_GLOBAL)

			-- get target
			local ret, dir = get_aim_dir()
			local y, x = target.get_coords(dir)
			if ret then

				-- deplete ammo
				missile.flags[FLAG_AMMO_CURRENT] = missile.flags[FLAG_AMMO_CURRENT] - 1

				-- Check for deviation in the missile
				local dist = distance(player.py, player.px, y, x)
				local prec = player.stat(A_PRECISION)
				y, x = target.deviate(y, x, dist, prec)				

				-- set a c_ptr on the target
				local c_ptr = cave(y, x)

				-- look to see if there is a monster here
				if c_ptr.m_idx > 0 then
				-- there is a monster here

					-- hit it with the missile
					combat.archery.hit(monster(c_ptr.m_idx))
				else
					-- The missile didn't hit anything, but still
					-- strikes the ground.
					local missile = player.inventory[INVEN_OFFHAND][1].flags[FLAG_DAM]
					local typ = flag_max_key(missile)

					local damroll = rng.drn()
					local protroll = rng.drn()

					damroll = damroll + rng(flag_get(missile, typ), flag_get2(missile, typ))
					protroll = protroll

					local dam = damroll - protroll

					if dam > 0 then
						project(WHO_PLAYER, 0, y, x, dam, typ, PROJECT_KILL | PROJECT_STOP | PROJECT_NO_REFLECT)
					end
				end
			end
		end
	end
end

-- the function to determine if hit and damage.  It is split off in
-- order to keep the indent from moving so far to the right.
function combat.archery.hit(monst)

	-- Do DRN rolls for attack and defense
	local attroll = rng.drn()
	local defroll = rng.drn()

	-- Compare attack and defense rolls, and see if a hit occurs
	if attroll > defroll then
	
		-- We hit.  Now get the damage and type
		local missile = player.inventory[INVEN_OFFHAND][1].flags[FLAG_DAM]
		local typ = flag_max_key(missile)

		-- do damage and protection rolls
		local damroll = rng.drn()
		local protroll = rng.drn()

		-- add missile damage and monster protection to rolls
		damroll = damroll + rng(flag_get(missile, typ), flag_get2(missile, typ))
		protroll = protroll + monst.ac

		-- compare the rolls and see if damage was inflicted
		local dam = damroll - protroll
		
		if dam > 0 then
		-- We did damage.

			project(WHO_PLAYER, 0, monst.fy, monst.fx, dam, typ, PROJECT_KILL | PROJECT_STOP | PROJECT_NO_REFLECT)
		
		-- If damage < protection, then the function will jump to the end,
		-- this avoids healing through projecting 'negative damage'
		end
	end
end

-- This maps the 'f'ire function to the 'f' key
if not get_subsystem_param("combat_archery", "no_key_bind") then
	hook(hook.KEYPRESS, function (key)
		if key == strbyte('f') then combat.archery.attack() return true end
	end)
end