-- Astral spells

declare_global_constants
{
	"SCHOOL_ASTRAL",
	"STARFIRES",
}

SCHOOL_ASTRAL = add_school
{
        ["name"]  = "Astral",
        ["skill"] = "SKILL_ASTRAL",
        ["hooks"] =
        {

        }
}

add_mkey
{
        mkey	= "Astral Magic",
		type	= "ability",
        fct	= function()
                -- create a book (has SPECIAL_GENE)
			local astral_book = make_book
			(
				STARFIRES
			)

			local spl = nil
			local ret, rep = repeat_keys.pull()
			if ret then
				if is_ok_spell(rep, astral_book) then
					spl = rep
				end
			end

			-- select a spell from that book
			spl = spl or get_school_spell("cast", "is_ok_spell", astral_book)

			-- and delete it.
			delete_object(astral_book)

			if spl == -1 then return end

			-- Now to actually cast the spell...
			cast_school_spell(spl, spell(spl))
		end,
}

STARFIRES = add_spell
{
	name	= "Starfires",
	school	= SCHOOL_ASTRAL,
	stat	= 0,
	level	= 0,
	mana	= 0,
	mana_max= 0,
	fail	= 0,
	spell	= function()
		local who
		local ret, dir = get_aim_dir()
		local y, x = target.get_coords(dir)
		if ret then

			-- who's casting?
			if spell_caster == WHO_PLAYER then
			-- the player is casting

				who = WHO_PLAYER
				increase_fatigue(20)
				energy_use = get_player_energy(SPEED_GLOBAL)
			else
			-- a monster is casting

				local fy, fx = get_spell_caster_info()
				local c_ptr, monst = cave(fy, fx)
				if c_ptr.m_idx > 0 then
					monst = monster(c_ptr.m_idx)
					who = c_ptr.m_idx
					increase_monst_fat(20, m_idx)
				end
			end
			project(who, 0, y, x, 5, dam.LITE, PROJECT_JUMP| PROJECT_HIDE | PROJECT_STOP | PROJECT_KILL | PROJECT_NO_REFLECT)
			project(who, 0, y, x, 5, dam.LITE, PROJECT_JUMP| PROJECT_HIDE | PROJECT_STOP | PROJECT_KILL | PROJECT_NO_REFLECT)
		end
	end,
	info	= function() return "" end,
	desc	=
	{
	}
}