#  This file isn't licensed.  However some if its libraries are.  See those files for more info.
#
#  Instructions: click on the stats or the weapon to change them.
#  Left click forward, Right click back.  On the right hand side is
#  a list of weapons and their stat requirments and arms value.  There
#  is also a listing of the stats used and their descriptions.  Click
#  'TEST' to run the simulation.  The results are printed to the shell.
#
#  Model: The Weapon's requirements are subtracted from thier corresponding
#  Combatant's stats scores: Dex, Str, and Skill.  The difference is
#  subjected to a logit function.  This result is then multiplied by
#  the required value.  This first represents the intrinsic handling of the
#  weapon that is brought out by possessing the salient skill or stat
#  (represented through the stat difference put into the logit function.)
#  This second represents the way in which possessing stats or skills
#  in deficiency or excess is compounded due to the nature of the weapon:
#  weapons needing strength benefit more from having, but not having it is
#  penelized severely (multiplying logit result by required value).  The
#  difference of these values between the two combatants is then taken and
#  subjected once again to a logit function.  This represents the interaction
#  between the two weapons in combat:  A dagger vs. a maul is different from
#  a dagger vs. a club, or another dagger.  This makes the assumption that
#  the strength of the weapon is in the degree of talent required to weild
#  it, thus low stat requirement weapons will ultimately by trumped by
#  high stat requirement weapons.  However, this also has the effect of
#  making the low stat requirement weapons typically superior if their
#  requirements are met while the more powerful/difficult weapon's
#  requirements are not.
#
#  Lastly, the Per, Psy, and Skill scores are simply added together.
#  This the 'tactics' portion of combat.  This amount is then geometrically
#  averaged with the 'weapon' portion.  As weapons become very powerful
#  (with high arms value), the 'tactics' portion is then going to present
#  a large drag on the score.  This is intended.
#
#  Well, OK, one more thing.  There will somehow be a random roll component.
#  I simply havn't decided where it should go.
#
#  Please play with this and provide your opinions on its model, and report
#  any unusual behaviors with the model.  Thanks!!!

from __future__ import division
import os
import pygame
import sys
import numpy
from lib import colors
from lib import glyph
from pygame.locals import *



#	set screen constants
SCREEN_SIZE = 800, 600
SCREEN = pygame.display.set_mode(SCREEN_SIZE)

#	set color constants
bg = colors.BLACK
fg = colors.VENETIAN_RED


# Weapon Class
class weapon():
	def __init__(self, dex, str, skl, arm):
		self.dex = dex
		self.str = str
		self.skl = skl
		self.arm = arm



# Declare Weapon Objects
club = weapon(2, 4, 2, 2)
dagger = weapon(5, 2, 5, 3)
quaterstaff = weapon(6, 4, 5, 4)
ironclub = weapon(2, 9, 2, 5)
longsword = weapon(6, 6, 7, 6)
twohandsword = weapon(5, 7, 6, 7)



# Unit class
class unit():

	def __init__(self):
		self.dex = 1
		self.str = 1
		self.skl = 1
		self.per = 1
		self.psy = 1
		self.wepname = ['club', 'dagger', 'quarterstaff', 'ironclub', 'longsword', 'twohandsword']
		self.wep = [club, dagger, quaterstaff, ironclub, longsword, twohandsword]
		self.i = 0



# Declare unit objects, these are my two combatants :)
reds = unit()
blus = unit()



# A logit function
def logit(x, c = 1):
	y = c * (1 / (1 + numpy.exp(-x)))
	return y



# This is very hackish because I was getting frustrated and so just pounded it out brute-force style
# It may not be pretty, it may be hard to read, so sorry
def combatsim(objone, wepone, objtwo, weptwo):

	# Combatant one, combatant two
	one = 0
	two = 0

	# the following three blocks perform the 'weapon' calculations on dex, str, and skill
	# see the documentation at beginning for more info
	k = objone.dex - wepone.dex
	q = objtwo.dex - weptwo.dex
	a = logit(k, 2) * wepone.dex
	b = logit(q, 2) * weptwo.dex
	k = a - b
	q = b - a
	a = logit(k, 2)
	b = logit(q, 2)
	one = one + a
	two = two + b

	k = objone.str - wepone.str
	q = objtwo.str - weptwo.str
	a = logit(k, 2) * wepone.str
	b = logit(q, 2) * weptwo.str
	k = a - b
	q = b - a
	a = logit(k, 2)
	b = logit(q, 2)
	one = one + a
	two = two + b

	k = objone.skl - wepone.skl
	q = objtwo.skl - weptwo.skl
	a = logit(k, 2) * wepone.skl
	b = logit(q, 2) * weptwo.skl
	k = a - b
	q = b - a
	a = logit(k, 2)
	b = logit(q, 2)
	one = one + a
	two = two + b

	# A simple average of the results...
	# The weighting is intrinsic in other calculations, so I didn't see any reason to weight here
	one = one / 3
	two = two / 3

	# And now multiply by the arms value
	one = one * wepone.arm
	two = two * wepone.arm

	# The 'tactics' value.  It's just a simply addition of the tatical stats/skills
	tacone = objone.skl + objone.per + objone.psy
	tactwo = objtwo.skl + objtwo.per + objtwo.psy

	# The geometric mean of the 'weapon' and 'tactics'
	one = numpy.sqrt(one * tacone)
	two = numpy.sqrt(two * tactwo)

	# Finally, the final attacks of each combatant are simply the division by the attack of the other combatant
	attone = one / two
	atttwo = two / one

	# Check your shell for the results!
	print('one: ' + str(attone))
	print('two: ' + str(atttwo) + '\n')




# Everything from here on is the gfx portion.  It should be fairly pretty.
# If anyone has any questions or interests in the library I use to do this (my Glyph library)
# feel free to contact me!

def selecters(obj, selecter, selected, pos, wepper, wepped, weppos, addsub):

	if selected != None:
		if selected == 'dex ' + str(obj.dex):
			obj.dex = obj.dex + addsub
			input = 'dex ' + str(obj.dex)
			selecter.update(input, pos, fg, fg, colors.WHITE)
		if selected == 'str ' + str(obj.str):
			obj.str = obj.str + addsub
			input = 'str ' + str(obj.str)
			selecter.update(input, pos, fg, fg, colors.WHITE)
		if selected == 'skl ' + str(obj.skl):
			obj.skl = obj.skl + addsub
			input = 'skl ' + str(obj.skl)
			selecter.update(input, pos, fg, fg, colors.WHITE)
		if selected == 'per ' + str(obj.per):
			obj.per = obj.per + addsub
			input = 'per ' + str(obj.per)
			selecter.update(input, pos, fg, fg, colors.WHITE)
		if selected == 'psy ' + str(obj.psy):
			obj.psy = obj.psy + addsub
			input = 'psy ' + str(obj.psy)
			selecter.update(input, pos, fg, fg, colors.WHITE)
	if wepped != None:
		obj.i = obj.i + addsub
		if obj.i > 5:
			obj.i = 0
		if obj.i < 0:
			obj.i = 5
		wepper.update(obj.wepname[obj.i], weppos, fg, fg, colors.WHITE)



def start():

	font = pygame.font.Font(os.path.join("data", "gui", "kharon4amini.ttf"), 8)

	titletxt = "CSS v0.1"

	descriptxt = "\
Dexterity: Represents physical nimbleness and grace\n\n\
Strength: Represents physical strength\n\n\
Skill: Represents skill in using a weapon to attack\n\n\
Perception: Represents percpetion of the physical world; both eyesight and powers of observation\n\n\
Psyche: Represents mental stability and strength\n\n\
\n\
Club: Str - 4\n\
    Dex - 2\n\
    Skl - 2\n\
    Arm - 2\n\
Dagger: Str - 2\n\
      Dex - 5\n\
      Skl - 5\n\
      Arm - 3\n\
Q'Staff: Str - 4\n\
       Dex - 6\n\
       Skl - 5\n\
       Arm - 4\n\
I'Club: Str - 9\n\
     Dex - 2\n\
     Skl - 2\n\
     Arm - 5\n\
L'Sword: Str - 6\n\
       Dex - 6\n\
       Skl - 7\n\
       Arm - 6\n\
2h'Sword: Str - 7\n\
        Dex - 5\n\
        Skl - 6\n\
        Arm - 7"

	redtxt = "dex " + str(reds.dex) + "\nstr " + str(reds.str) + "\nskl " + str(reds.skl) + "\nper " + str(reds.per) + "\npsy " + str(reds.psy)
	blutxt = "dex " + str(blus.dex) + "\nstr " + str(blus.str) + "\nskl " + str(blus.skl) + "\nper " + str(blus.per) + "\npsy " + str(blus.psy)
	weptxt = "club\ndagger\nquarterstaff\niron club\nlongsword\ntwo-handed sword"

	SCREEN.fill(colors.BLACK)

	margin = 5
	lineh = 15
	mpos = pygame.mouse.get_pos()

	titlew = 780
	titler = 20
	titlepos = (10, 10)
	title = glyph.pager(SCREEN, font, colors.BLACK, colors.VENETIAN_RED, margin, titlew, lineh, titler, titler, titlepos)
	title.input(titletxt)
	title.output()

	descripw = 320
	descripr = 540
	descrippos = (470, 50)
	descrip = glyph.pager(SCREEN, font, fg, bg, margin, descripw, lineh, descripr, descripr, descrippos)
	descrip.input(descriptxt)
	descrip.output()

	redw = 110
	redr = 80
	redpos = (10, 50)
	red = glyph.selecter(SCREEN, font, bg, margin, redw, lineh, redr, redpos)
	red.input(redtxt, fg, fg, colors.WHITE)
	reding = red.output(mpos)

	redwepw = 110
	redwepr = 20
	redweppos = (10, 140)
	redwep = glyph.selecter(SCREEN, font, bg, margin, redwepw, lineh, redwepr, redweppos)
	redwep.input(reds.wepname[reds.i], fg, fg, colors.WHITE)
	redweping = redwep.output(mpos)

	bluw = 110
	blur = 80
	blupos = (130, 50)
	blu = glyph.selecter(SCREEN, font, bg, margin, bluw, lineh, blur, blupos)
	blu.input(blutxt, fg, fg, colors.WHITE)
	bluing = blu.output(mpos)

	bluwepw = 110
	bluwepr = 20
	bluweppos = (130, 140)
	bluwep = glyph.selecter(SCREEN, font, bg, margin, bluwepw, lineh, bluwepr, bluweppos)
	bluwep.input(blus.wepname[blus.i], fg, fg, colors.WHITE)
	bluweping = bluwep.output(mpos)

	testw = 40
	testr = 20
	testpos = (70, 170)
	test = glyph.selecter(SCREEN, font, bg, margin, testw, lineh, testr, testpos)
	test.input('TEST', fg, fg, colors.WHITE)
	testing = test.output(mpos)

	while 1:

		for event in pygame.event.get():

			if event.type == KEYDOWN:
				if event.key == K_ESCAPE:
					sys.exit()

			mpos = pygame.mouse.get_pos()
			reding, redpos = red.output(mpos)
			redweping, redweppos = redwep.output(mpos)
			bluing, blupos = blu.output(mpos)
			bluweping, bluweppos = bluwep.output(mpos)
			testing = test.output(mpos)
			if event.type == MOUSEBUTTONDOWN and event.button == 1:
				selecters(reds, red, reding, redpos, redwep, redweping, redweppos, 1)
				selecters(blus, blu, bluing, blupos, bluwep, bluweping, bluweppos, 1)

			if event.type == MOUSEBUTTONDOWN and event.button == 2:
				selecters(reds, red, reding, redpos, redwep, redweping, redweppos, -1)
				selecters(blus, blu, bluing, blupos, bluwep, bluweping, bluweppos, -1)

			if event.type == MOUSEBUTTONDOWN and event.button == 1:
				if testing != None:
					combatsim(reds, reds.wep[reds.i], blus, blus.wep[blus.i])

		pygame.display.update()



if __name__ == "__main__":

	pygame.init()
	start()