using System;
using System.Data;
using System.Collections;
using MySQLDriverCS;

namespace SI_DBQuery
{
    /// <summary>
    /// Summary description for SI_DBQuery.
    /// </summary>
    public class DBQuery
    {
        private MySQLConnection _dbConn = null;
        private string _dbConnectString = "";

        // Connection Constants
        
		private const string _lobbyServerAddress = "69.56.133.54";	//"jones.theigl.com";
		//private const string _lobbyServerAddress = "mysql2.webcontrolcenter.com";	//"jones.theigl.com";
		private const string _db = "lol";
        private const string _user = "lolservices";	//"root";
        private const string _password = "r2d2c3p0";	//"spitshine";

        // Data Constants
        private static string DB_ESC = '\b'.ToString();


        public DBQuery()
        {
            _createDBQuery(_lobbyServerAddress , _db, _user, _password);
        }

        public DBQuery(string db)
        {
            _createDBQuery(_lobbyServerAddress , db, _user, _password);
        }

        public DBQuery(string serverAddress, string db, string user, string password)
        {
            _createDBQuery(serverAddress, db, user, password);
        }

        private void _createDBQuery(string serverAddress, string db, string user, string password)
        {
            string __testCS = new MySQLConnectionString(serverAddress, db, user, password).AsString;

            if (_dbConn != null)
            {
                if ( (__testCS == _dbConnectString) || (_dbConn.State == ConnectionState.Broken) || 
                    (_dbConn.State == ConnectionState.Closed) )
                {
                    CloseDBConnection();
                }
                else
                {
                    // Keep the connection we've got
                    return;
                }
            }

            _dbConnectString = __testCS;

            OpenDBConnection();
        }

        private MySQLConnection DBConn
        {
            get
            {
                if (_dbConn == null)
                {
                    OpenDBConnection();
                }
                else
                {
                    // _dbConn.State is not detecting a lost connection:
                    //  ConnectionState.Broken or .Closed, so just do open it.
                    try
                    {
                        // Test the connection before deciding to reopen it
                        MySQLCommand __cmd = new MySQLCommand("SELECT 1", _dbConn);
                        __cmd.ExecuteReader();
                        __cmd.Dispose();

                        if (_dbConn.State == ConnectionState.Closed)
                        {
                            _dbConn.Open();
                        }
                    }
                    catch
                    {
                        _dbConn.Open();
                    }
                }

                return _dbConn;
            }
        }

        public void OpenDBConnection()
        {
            _dbConn = new MySQLConnection(_dbConnectString);

            // Connecting to database
            try
            {
                _dbConn.Open();
            }
            catch
            {
                // Didn't connect
                return;
            }
        }

        public void CloseDBConnection()
        {
            if (_dbConn != null)
            {
                _dbConn.Close();
            }
        }

        public static string PASSWORD(string password)
        {
            return DB_ESC + "PASSWORD(" + ValidateInput(password) + ")";
        }

        public static string NOW()
        {
            return DB_ESC + "NOW()";
        }

        public static string NULL()
        {
            return DB_ESC + "NULL";
        }

        public static string LITERAL(string word)
        {
            return DB_ESC + word;
        }

        public static string BOOL(bool val)
        {
            if (val)
            {
                return DB_ESC + "1";
            }
            else
            {
                return DB_ESC + "0";
            }
        }

        public static string APPEND(string colName, string val)
        {
            return DB_ESC + "CONCAT(IFNULL(" + ValidateInput(colName, true) + ",'')," + ValidateInput(val) + ")";
        }

        public static string APPENDCOLS(string[] colName)
        {
            return APPENDCOLS(colName, ",");
        }

        public static string APPENDCOLS(string[] colName, string delim)
        {
            string __result = "";

            foreach (string s in colName)
            {
                if (__result != "")
                {
                    __result += ",\'" + delim + "\',";
                }

                __result += "IFNULL(" + ValidateInput(s, true) + ",'')";
            }

            if (__result != "")
            {
                __result = DB_ESC + "CONCAT(" + __result + ")";
            }

            return __result;
        }

        public static string ValidateInput(string text)
        {
            return ValidateInput(text, false);
        }

        public static string ValidateInput(string text, bool isColumnName)
        {
            if (text == null)
            {
                text = "NULL";
            }
            else if (text.StartsWith(DB_ESC))
            {
                text = text.Substring(1);
            }
            else
            {
                if (isColumnName)
                {
                    text = text.Trim();
                    text = text.Replace(" ", "");
                    text = text.Replace(",", "");
                    text = text.Replace(":", "");
                    text = text.Replace(";", "");
                    text = text.Replace("\'", "");
                }
                else
                {
                    text = text.Replace("\'", "\\'");

                    try
                    {
                        // If this is numeric, don't use quotes
                        int t = int.Parse(text);
                    }
                    catch
                    {
                        text = "\'" + text + "\'";
                    }
                }
            }

            return text;
        }

        public static void ValidateInput(ref string[] text)
        {
            ValidateInput(ref text, false);
        }

        public static void ValidateInput(ref string[] text, bool isColumnName)
        {
            if (text == null)
            {
                return;
            }

            for (int i = 0; i < text.Length; i ++)
            {
                text[i] = ValidateInput(text[i], isColumnName);
            }
        }

        private static string _makeList(string[] cols)
        {
            return _makeList(cols, true);
        }

        private static string _makeList(string[] cols, bool isColumnName)
        {
            if (cols == null)
            {
                return "";
            }

            // Validte the list of column names to return data from
            string __colList = ValidateInput(cols[0], isColumnName);

            if (cols.Length > 1)
            {
                for (int i = 1; i < cols.Length; i ++)
                {
                    __colList += "," + ValidateInput(cols[i], isColumnName);
                }
            }

            return __colList;
        }

        private static string _makeMatchPairs(string[] cols, string[] vals)
        {
            return _makeMatchPairs(cols, vals, ",", 0);
        }

        private static string _makeMatchPairs(string[] cols, string[] vals, string delim, int startIndex)
        {
            string __result = "";

            if (cols == null)
            {
                return __result;
            }

            if (startIndex < cols.Length)
            {
                __result = ValidateInput(cols[startIndex], true) + "=" + ValidateInput(vals[startIndex]);

                for (int i = startIndex + 1; i < cols.Length; i ++)
                {
                    __result += delim + ValidateInput(cols[i], true) + "=" + ValidateInput(vals[i]);
                }
            }

            return __result;
        }

        private static string _getCell(MySQLCommand cmd)
        {
            string val = "";

            MySQLDataReader reader = cmd.ExecuteReaderEx();

            if (reader.Read())
            {
                val = reader.GetString(0);
            }

            reader.Close();
            cmd.Dispose();

            return val;
        }

        private static object[] _getTable(MySQLCommand cmd)
        {
            MySQLDataReader reader = cmd.ExecuteReaderEx();
            ArrayList __list = new ArrayList();
            int __numCols = reader.FieldCount;

            while (reader.Read())
            {
                string[] cols = new string[__numCols];

                if (reader.GetValues(cols) > 0)
                {
                    __list.Add(cols);
                }
            }

            reader.Close();
            cmd.Dispose();

            object[] __val = new object[__list.Count];
			
            for (int i = 0; i < __list.Count; i ++)
            {
                __val[i] = __list[i];
            }

            return __val;
        }

        private static string[] _getRows(MySQLCommand cmd)
        {
            MySQLDataReader reader = cmd.ExecuteReaderEx();

            ArrayList __list = new ArrayList();

            while (reader.Read())
            {
                __list.Add(reader.GetString(0));
            }

            reader.Close();
            cmd.Dispose();

            string[] __val = null;

            if (__list.Count > 0)
            {
                __val = new string[__list.Count];

                for (int i = 0; i < __list.Count; i ++)
                {
                    __val[i] = (string) __list[i];
                }
            }

            return __val;
        }

        private static string[] _getRow(MySQLCommand cmd)
        {
            string[] __val = null;

            MySQLDataReader reader = cmd.ExecuteReaderEx();

            if (reader.Read())
            {
                int c = reader.FieldCount;
                __val = new string[c];
			
                for (int i = 0; i < c; i ++)
                {
                    __val[i] = reader.GetString(i);
                }
            }
            else
            {
                __val = new string[1] {""};
            }

            reader.Close();
            cmd.Dispose();

            return __val;
        }

        public static string GetSortOrderString(string orderBy, bool isDescending)
        {
            string __sortOrder = "";

            orderBy = ValidateInput(orderBy, true);

            if (orderBy != "")
            {
                __sortOrder = " ORDER BY " + orderBy;

                if (isDescending)
                {
                    __sortOrder += " DESC";
                }
                else
                {
                    __sortOrder += " ASC";
                }
            }

            return __sortOrder;
        }

        public string GetCell(string table, string idCol, string valCol, string getCol)
        {
            return GetCell(table, new string[1] {idCol}, new string[1] {valCol}, getCol);
        }

        public string GetCell(string table, string[] idCol, string[] valCol, string getCol)
        {
            table = ValidateInput(table, true);
            getCol = ValidateInput(getCol, true);

            MySQLCommand cmd = new MySQLCommand("SELECT " + getCol + " FROM " + table + " WHERE " +
                _makeMatchPairs(idCol, valCol, " AND ", 0), DBConn);

            return _getCell(cmd);
        }

        public string[] GetList(string table, string idCol, string valCol, string getCol)
        {
            return GetList(table, new string[1] {idCol}, new string[1] {valCol}, getCol, "", false);
        }

        public string[] GetList(string table, string idCol, string valCol, string getCol, 
            string orderBy, bool isDescending)
        {
            return GetList(table, new string[1] {idCol}, new string[1] {valCol}, getCol, orderBy, isDescending);
        }

        public string[] GetList(string table, string[] idCol, string[] valCol, string getCol)
        {
            return GetList(table, idCol, valCol, getCol, "", false);
        }

        public string[] GetList(string table, string[] idCol, string[] valCol, string getCol, 
            string orderBy, bool isDescending)
        {
            table = ValidateInput(table, true);
            getCol = ValidateInput(getCol, true);

            MySQLCommand cmd = new MySQLCommand("SELECT " + getCol + " FROM " + table + " WHERE " +
                _makeMatchPairs(idCol, valCol, " AND ", 0) + 
                GetSortOrderString(orderBy, isDescending), DBConn);

            return _getRows(cmd);
        }

        public string[] GetRow(string table, string idCol, string valCol, string[] getCol)
        {
            return GetRow(table, new string[1] {idCol}, new string[1] {valCol}, getCol);
        }

        public string[] GetRow(string table, string[] idCol, string[] valCol, string[] getCol)
        {
            table = ValidateInput(table, true);

            MySQLCommand cmd = new MySQLCommand("SELECT " + _makeList(getCol) + " FROM " + table + " WHERE " +
                _makeMatchPairs(idCol, valCol, " AND ", 0), DBConn);

            return _getRow(cmd);
        }

        public object[] GetRows(string table, string idCol, string valCol, string[] getCol)
        {
            return GetRows(table, new string[1] {idCol}, new string[1] {valCol}, getCol);
        }

        public object[] GetRows(string table, string[] idCol, string[] valCol, string[] getCol)
        {
            return GetRows(table, idCol, valCol, getCol, "", false);
        }

        public object[] GetRows(string table, string[] idCol, string[] valCol, string[] getCol, 
            string orderBy, bool isDescending)
        {
            table = ValidateInput(table, true);

            MySQLCommand cmd = new MySQLCommand("SELECT " + _makeList(getCol) + " FROM " + table + " WHERE " +
                _makeMatchPairs(idCol, valCol, " AND ", 0) + 
                GetSortOrderString(orderBy, isDescending), DBConn);

            return _getTable(cmd);
        }

        public string CellQuery(string query)
        {
            MySQLCommand cmd = new MySQLCommand(query, DBConn);

            return _getCell(cmd);
        }

        public string[] RowQuery(string query)
        {
            MySQLCommand cmd = new MySQLCommand(query, DBConn);

            return _getRow(cmd);
        }

        public object[] RowsQuery(string query)
        {
            MySQLCommand cmd = new MySQLCommand(query, DBConn);

            return _getTable(cmd);
        }

        // -1 = The user was not found
        //  0 = Bad username or password combo (or other criteria for found user was not met)
        // >0 = The user was authenticated
        public int AuthQuery(string table, string[] cols, string[] vals, string idCol)
        {
            table = ValidateInput(table, true);

            string __userCol = ValidateInput(cols[0], true);
            string __userVal = ValidateInput(vals[0]);
            string __passCol = ValidateInput(cols[1], true);
            string __passVal = ValidateInput(vals[1]);
            string __optMatches = _makeMatchPairs(cols, vals, " AND ", 2);

            if (__optMatches != "")
            {
                __optMatches = " AND " + __optMatches;
            }

            int __userID = -1;

            string result = CellQuery("SELECT " + idCol + " FROM " + table + " WHERE " +
                idCol + " > 0 AND " + __userCol + " = " + __userVal + __optMatches);

            if (result != "")
            {
                result = CellQuery("SELECT " + idCol + " FROM " + table + " WHERE " +
                    idCol + " > 0 AND " + __userCol + " = " + __userVal + " AND " + 
                    __passCol + " = PASSWORD(" + __passVal + ")" + __optMatches);

                if (result != "")
                {
                    __userID = int.Parse(result);
                }
                else
                {
                    __userID = 0;
                }
            }

            return __userID;
        }

        public int Insert(string query)
        {
            MySQLCommand cmd = new MySQLCommand(query, DBConn);
            int __result = cmd.ExecuteNonQuery();

            cmd.Dispose();

            if (__result > 0)
            {
                cmd = new MySQLCommand("SELECT LAST_INSERT_ID()", DBConn);

                MySQLDataReader reader = cmd.ExecuteReaderEx();

                if (reader.Read())
                {
                    __result = reader.GetInt32(0);
                }
                else
                {
                    __result = 0;
                }

                reader.Close();
                cmd.Dispose();
            }

            return __result;
        }

        public int Update(string query)
        {
            MySQLCommand cmd = new MySQLCommand(query, DBConn);
            int __result = cmd.ExecuteNonQuery();

            cmd.Dispose();

            return __result;
        }

        public int Delete(string query)
        {
            MySQLCommand cmd = new MySQLCommand(query, DBConn);
            int __result = cmd.ExecuteNonQuery();

            cmd.Dispose();

            return __result;
        }

        public int InsertRow(string table, string[] values)
        {
            int __result = Insert("INSERT INTO " + table + " VALUES (" + _makeList(values, false) + ")");

            return __result;
        }

        public int UpdateRow(string table, string idCol, string idVal, string[] cols, string[] vals)
        {
            idCol = ValidateInput(idCol, true);
            idVal = ValidateInput(idVal);

            int __result = Update("UPDATE " + table + " SET " + _makeMatchPairs(cols, vals) + 
                " WHERE " + idCol + " = " + idVal);

            return __result;
        }

        public int DeleteRow(string table, string idCol, string idVal)
        {
            idCol = ValidateInput(idCol, true);
            idVal = ValidateInput(idVal);

            int __result = Delete("DELETE FROM " + table + " WHERE " + idCol + " = " + idVal);

            return __result;
        }

        public void Dispose()
        {
            CloseDBConnection();

            _dbConn.Dispose();
        }
    }
}