using System;
using System.Collections;
using System.Collections.Specialized;
using System.Data;
using System.IO;
using System.Net;
using System.Runtime.InteropServices;
using System.Text;

using Microsoft.DirectX;
using Microsoft.DirectX.DirectPlay;

using LOLGameServer;
using SI_MiddleTier;


public class Base_GameServer
{
	#region Static Variables
	public static Hashtable AttachedClients = null;
	public static Hashtable GameInstances = null;
    public static Base_GameServer BaseGameServer = null;

	public static Hashtable AttachedPlayerListClients = null;
	#endregion
	
	#region Constants
	//these GameServer variables are now copied in Base_LobbyServer, which needs to connect to it.
	public const string GameServerAddress="127.0.0.1";
	public const int GameServerPort=21337;
	public const string GameServerGuid = "{CF102364-2677-4a22-9009-BC86CF368A07}";
	
	private const string _dbServerName = "69.56.133.54";	//"jones.theigl.com";
	//private const string _dbServerName = "mysql2.webcontrolcenter.com";	//"jones.theigl.com";
	private const string _dbName = "lol";	//"lol2";

    public const int PacketTimoutDuration=0;
    //public const int PacketTimoutDuration=60;
	#endregion
	
	#region private member variables
	/// <summary>
	/// Required designer variable.
	/// </summary>
	private Server _gameServer;
	private MiddleTier _dbquery = null;
	private MiddleTier.GameList[] _currentGameList = null;

    private int _gameTypeID = 1;	// Land of Legends, version 1.0  <-- this will always be a released version number
    #endregion

	#region Constructor
	public Base_GameServer()
	{
		// Do nothing, and let the app call StartServer later
	}

	public Base_GameServer(bool doStartServer)
	{
		if (doStartServer)
		{
			//let's make the game server start listening for internet connections
			StartServer();
		}
	}

	#endregion

	#region Dispose / Destructor
	/// <summary>
	/// Clean up any resources being used.
	/// </summary>
	public virtual void Dispose()
	{
		if (_dbquery != null)
		{
			_dbquery.Dispose();
		}
	}
	#endregion

	#region Public Methods
	public void StartServer()
	{
		_setupServer();

		// Connect to database
		_dbquery = new MiddleTier(_dbName);
	}
	public int GetXPForPlayer (int userID)
	{
		int __xp=0;
		string[] __result = _dbquery.GetPlayerStats(userID);
		if ( (__result != null) && (__result.Length > 0) )
		{
			__xp = int.Parse(MiddleTier.GetPlayerStatEntry(__result, "xp"));
		}
		return __xp;
	}
	#endregion

	#region Private Methods
	private void _setupServer() 
	{
		try
		{
			//TODO:  add an event handler for __thisForm.Closing that shuts down gracefully.

			AttachedClients = new Hashtable();
			GameInstances = new Hashtable();
			AttachedPlayerListClients = new Hashtable();
			BaseGameServer=this;

			_gameServer= new Server(); //create a new server object

			Address __address = new Address(); // create an address which will indicate a serive provider type and a port for your app 

			__address.ServiceProvider = Address.ServiceProviderTcpIp;
			__address.AddComponent(Address.KeyPort, GameServerPort);

			ApplicationDescription __appDescription = new ApplicationDescription(); //describe your application to any client trying to connect 
		    
			__appDescription.Flags = SessionFlags.ClientServer | SessionFlags.NoDpnServer;
			__appDescription.GuidApplication=new Guid(GameServerGuid); //TODO: Insert your app GUID here 
			__appDescription.SessionName="Session Description";
		    
			try
			{
				_gameServer.Host(__appDescription, __address);
			}
			catch(InvalidDeviceAddressException)
			{
				//MessageBox.Show("Another instance of this server with the same application Guid was found. This instance will now exit.");
				return;
			}
		    
			LogMessage("Server has started.");

			//_gameServer.PlayerCreated += new PlayerCreatedEventHandler(PlayerJoin);
			//_gameServer.IndicateConnect += new IndicateConnectEventHandler(PlayerAttJoin);
			//_gameServer.FindHostQuery += new FindHostQueryEventHandler(ThisHostIsFound);
			_gameServer.Receive += new ReceiveEventHandler(DataReceive);
			_gameServer.PlayerDestroyed += new PlayerDestroyedEventHandler(PlayerLeft);
			//_gameServer.PlayerDestroyed += new PlayerDestroyedEventHandler(PlayerLeft);
		}
		catch (Exception e)
		{
			SI_MiddleTier.MiddleTier.RecordExceptionToErrorFile("Game Server", e, "Problem in _setupServer()");  //make sure the name of the server is listed -- it will be recorded in the log file.

			throw e;
		}
	}
	public virtual void LogMessage(string message) 
	{
		// Allow inherited class to override
	}

	private bool _loadGameIntoMemory(int gameID) 
	{
		// Check from list of active games
		MiddleTier.GameList __gameInfo = _dbquery.GetGameInfo(gameID);

		if (__gameInfo.ID == gameID)
		{
			// Found a game, not get the players' usernames from it
			string __challengerName = _dbquery.GetUsername(__gameInfo.ChallengerUserID);
			string __challengeeName = _dbquery.GetUsername(__gameInfo.ChallengedUserID);

			if ( (__challengerName != "") && (__challengerName != "") )
			{
				// Everything is fine, great a new instance of a game in mem, not in the db yet
				GameInstances.Add(gameID, new ServerGameInstance(gameID, __challengerName, __gameInfo.ChallengerUserID, __challengeeName, __gameInfo.ChallengedUserID));

				return true;
			}
		}

		// The lookup failed; may be a bad game id or the users are not valid
		return false;
	}

	private void _sendPlayerListToClient(int __playerID) 
	{
		NetworkPacket __packet = new NetworkPacket();
		__packet.Write(GameMessageType.CurrentInGamePlayerList);
		
		//add the string w/ the list of players to the packet
		//(ServerGameInstance) GameInstances[__destinationGameID];
		//AttachedClient __tempPlayer;
		ServerGameInstance __serverGameInstance;
		AttachedClient __attachedClient;
		foreach (int __key in GameInstances.Keys) 
		{
			__serverGameInstance=(ServerGameInstance) GameInstances[__key];
			foreach (string __key2 in __serverGameInstance.AttachedClients.Keys) 
			{
				__attachedClient=(AttachedClient) __serverGameInstance.AttachedClients[__key2];
				__packet.Write(__attachedClient.PlayerID); 
				__packet.Write(__attachedClient.Username); 
				__packet.Write(__attachedClient.UserID); 
				__packet.Write(-1); //Wins -- Don't know this
				__packet.Write(-1); //Losses -- Don't know this 
				__packet.Write(__attachedClient.XP); 
				__packet.Write(__attachedClient.Level); 
				__packet.Write(__attachedClient.IsRegisteredUser); //IsRegisteredUser -- Don't know this
				__packet.Write("<none>"); //Don't know these
			}
		}

		//send the packet
		//__serverGameInstance.SendPacketToAllConnectedPlayersInGame(__returnPacket, _gameServer);
		try 
		{
			_gameServer.SendTo(__playerID, __packet, PacketTimoutDuration, SendFlags.Guaranteed | SendFlags.NoLoopback);
		} 
		catch {}
		//_sendMessageToClient(playerIDToUpdate, __returnPacket, PacketTimoutDuration, SendFlags.Guaranteed | SendFlags.NoLoopback);
		__packet.Dispose();
	}
	#endregion

	#region Event Handlers
	private void DataReceive(object sender, ReceiveEventArgs e)
	{
		string __caseBranchName="";
		try
		{
			//            if (this.InvokeRequired)
			//            {
			//                // A thread switch is necessary first, to get onto the right thread
			//                this.BeginInvoke(new ReceiveEventHandler(DataReceive), 
			//                    new object[] { sender, e });
			//            }
			//            else
			//            {
			//we recieved data from a client.  let's handle it
			//Messages.Text=Messages.Text + "Player" + ":" + e.Message.ReceiveData.ReadString() + System.Environment.NewLine;
			NetworkPacket __recievedPacket = e.Message.ReceiveData; //get the data sent to the server 
			NetworkPacket __returnPacket = null; 

			GameMessageType __gameMessageType = (GameMessageType)e.Message.ReceiveData.Read(typeof(GameMessageType));

			//PlayerObject __playerObjectSender;

			int __playerIDSender;
			ServerGameInstance __playersGame;
			int __gameID;

			int __playerID;
			string __username;
			int __gameMessageNumber=0;
			int __destinationGameID;
			ClientRole __clientRoleInGame=ClientRole.None;
			AttachedClient __thisAttachedClient=null;
			bool __isRegisteredUser=true;
			bool __isPlayer1=true;

			ServerGameInstance __serverGameInstance;
			string __gameStateConfirmationString;

			//let's lock this, so that any near-simultanious add/removes are syncronized correctly
			lock (this) 
			{
				switch (__gameMessageType) 
				{
					case GameMessageType.SendStateString:
						__caseBranchName="GameMessageType.SendStateString";
						__playerID=(int) e.Message.SenderID;

						string __stateKey = e.Message.ReceiveData.ReadString();
						string __stateString = e.Message.ReceiveData.ReadString();
						bool __storeString = (bool) e.Message.ReceiveData.Read(typeof(bool));

						__thisAttachedClient=AttachedClient.GetAttachedClientFromPlayerID(__playerID);
						__playersGame=ServerGameInstance.GetGameInstanceForAttachedClient(__thisAttachedClient);
						__playersGame.SendStateStringToAllOtherPlayersInGame(__thisAttachedClient, __stateKey, __stateString, _gameServer);

						if (__storeString) 
						{
							__playersGame.AddOrUpdateStateCache(__stateKey,__stateString);
						}

						break;												
					case GameMessageType.InGamePlayerListLogin:
						__caseBranchName="GameMessageType.InGamePlayerListLogin";
						__playerID=(int) e.Message.SenderID;
						//add this client to the list of clients interested in knowing player list updates.
						AttachedPlayerListClients.Add(__playerID,__playerID);

						LogMessage("Client (#" + __playerID.ToString() + ") attached for PlayerList.  (This is probably the GameLobby.)");

						//now send this player a list of players in a game
						_sendPlayerListToClient(__playerID);
						break;
					case GameMessageType.Login:
						__caseBranchName="GameMessageType.Login";
						__playerID=(int) e.Message.SenderID;
						bool __isReconnect=(bool) e.Message.ReceiveData.Read(typeof(bool));
						__username=(string) e.Message.ReceiveData.ReadString();
						string __password=(string) e.Message.ReceiveData.ReadString();
						string __productName = e.Message.ReceiveData.ReadString();
						string __buildNumber = e.Message.ReceiveData.ReadString();
						__destinationGameID=(int) e.Message.ReceiveData.Read(typeof(int));
						__clientRoleInGame=(ClientRole) e.Message.ReceiveData.Read(typeof(ClientRole));
						__isRegisteredUser=(bool) e.Message.ReceiveData.Read(typeof(bool));

						LogMessage(__username + " (PlayerID=" + __playerID + ") is trying to log in.");

						//check to see if the user is logged in already
						if (AttachedClients.ContainsKey(__username))
						{
							__returnPacket = new NetworkPacket();
							__returnPacket.Write(GameMessageType.LoggedInAlready);
							_gameServer.SendTo(__playerID, __returnPacket, PacketTimoutDuration, SendFlags.Guaranteed | SendFlags.NoLoopback);  
							__returnPacket.Dispose();                              
							return;
						}

						// -1 = user not found
						//  0 = bad password
						// 1+ = authenticated
						// Authenticate the new lobby user
						int __userID=0;

						int __authResult = (int)(_dbquery.AuthenticateUser(__username, __password, true, out __userID));

					switch (__authResult)
					{
						case -1:
							//send a login failed response
							LogMessage(__username + " was rejected; not a valid username...");
							__returnPacket = new NetworkPacket();
							if (__isReconnect) 
							{
								//this should never happen, but regardless, if it does we'll just fail and give up.
								__returnPacket.Write(GameMessageType.PlayerReconnectFailed);
							} 
							else 
							{
								__returnPacket.Write(GameMessageType.InvalidUser);
							}
							_gameServer.SendTo(__playerID, __returnPacket, PacketTimoutDuration, SendFlags.Guaranteed | SendFlags.NoLoopback);
							__returnPacket.Dispose();
							return;
							break;

						case 0:
							//send a login failed response
							LogMessage(__username + " was rejected for bad password...");
							__returnPacket = new NetworkPacket();
							if (__isReconnect) 
							{
								//this should never happen, but regardless, if it does we'll just fail and give up.
								__returnPacket.Write(GameMessageType.PlayerReconnectFailed);
							} 
							else 
							{
								__returnPacket.Write(GameMessageType.InvalidPassword);
							}
							_gameServer.SendTo(__playerID, __returnPacket, PacketTimoutDuration, SendFlags.Guaranteed | SendFlags.NoLoopback);
							__returnPacket.Dispose();
							return;
							break;
					}

						//if the user got this far, presumably they are being logged on.

						if (__isReconnect) 
						{
							//LET'S HANDLE THE RECONNECT CASE:
							if (!GameInstances.ContainsKey(__destinationGameID)) 
							{
								//this shouldn't happen... it would only happen if the other player already left for some reason.  This means the game should be over and we tell the reattaching player to go away.
								LogMessage(__username + " tried to reconnect to a game, but the game was already flushed...");
								__returnPacket = new NetworkPacket();
								__returnPacket.Write(GameMessageType.PlayerReconnectFailed);
								_gameServer.SendTo(__playerID, __returnPacket, PacketTimoutDuration, SendFlags.Guaranteed | SendFlags.NoLoopback);
								__returnPacket.Dispose();
								return;
							}
							//check to make sure the game status isn't closed.
							if (((ServerGameInstance)GameInstances[__destinationGameID]).GameHasEnded) 
							{
								LogMessage(__username + " tried to reconnect to a game, but the game was already flushed...");
								__returnPacket = new NetworkPacket();
								__returnPacket.Write(GameMessageType.PlayerReconnectFailed);
								_gameServer.SendTo(__playerID, __returnPacket, PacketTimoutDuration, SendFlags.Guaranteed | SendFlags.NoLoopback);
								__returnPacket.Dispose();
								return; 
							}
							//well, if we got this far, the player should be reconnecting to an active game they accidentally got disconnected from.  let's let them in w/ no further ado.
							__serverGameInstance=(ServerGameInstance) GameInstances[__destinationGameID];

							int __xp=GetXPForPlayer (__userID);

							AttachedClient __newClient = new AttachedClient(__clientRoleInGame, __username, __serverGameInstance, __playerID, __userID, __xp, __isRegisteredUser);

							//add the player to the AttachedClients list.
							Base_GameServer.AttachedClients.Add(__username,__newClient);

							//add the player to the game.
							__serverGameInstance.AddPlayerToGame(__username, __newClient);

							__returnPacket = new NetworkPacket();
							__returnPacket.Write(GameMessageType.PlayerReconnection);
							_gameServer.SendTo(__playerID, __returnPacket, PacketTimoutDuration, SendFlags.Guaranteed | SendFlags.NoLoopback);
							__returnPacket.Dispose();

							//notify the other player
							__returnPacket = new NetworkPacket();
							__returnPacket.Write(GameMessageType.PlayerReconnection);
							__serverGameInstance.SendPacketToAllOtherConnectedPlayersInGame(__newClient, __returnPacket, _gameServer);
							__returnPacket.Dispose();
						}

						//check to see the status of the game they're attaching to.  If it's valid, send the game info to them in return.
						if (GameInstances.ContainsKey(__destinationGameID)) 
						{
							//this GameID is already in memory.
							//we need to tell the GameInstance if this player is registered.
							try 
							{
								__playersGame=((ServerGameInstance)GameInstances[__destinationGameID]);
								if (__clientRoleInGame==ClientRole.Challengee) 
								{
									__playersGame.ChallengeeIsRegistered=__isRegisteredUser;
								} 
								else if (__clientRoleInGame==ClientRole.Challenger)
								{
									__playersGame.ChallengerIsRegistered=__isRegisteredUser;
								}
							} 
							catch {}
						} 
						else 
						{
							//this GameID is NOT already in memory -- let's create it  (we'll nuke it in a sec if they're not allowed to join)
							if (!_loadGameIntoMemory(__destinationGameID))
							{
								//TODO:  Deal w/ the fact that we couldn't load the game in memory?  (maybe it doesn't exist?)
								__returnPacket = new NetworkPacket();
								__returnPacket.Write(GameMessageType.GameDoesNotExist);
								_gameServer.SendTo(__playerID, __returnPacket, PacketTimoutDuration, SendFlags.Guaranteed | SendFlags.NoLoopback);
								__returnPacket.Dispose();
							}
							//we need to tell the GameInstance if this player is registered.
							try 
							{
								__playersGame=((ServerGameInstance)GameInstances[__destinationGameID]);
								if (__clientRoleInGame==ClientRole.Challengee) 
								{
									__playersGame.ChallengeeIsRegistered=__isRegisteredUser;
								} 
								else if (__clientRoleInGame==ClientRole.Challenger)
								{
									__playersGame.ChallengerIsRegistered=__isRegisteredUser;
								}
							} 
							catch {}

						}
						__serverGameInstance=(ServerGameInstance) GameInstances[__destinationGameID];

						if (__serverGameInstance.IsPlayerAbleToJoinGame(__username,__clientRoleInGame))
						{
		                    
							__returnPacket = new NetworkPacket();
							__returnPacket.Write(GameMessageType.LoginSuccess);
							_gameServer.SendTo(__playerID, __returnPacket, PacketTimoutDuration, SendFlags.Guaranteed | SendFlags.NoLoopback);
							__returnPacket.Dispose();

							int __xp=GetXPForPlayer (__userID);
							AttachedClient __newClient = new AttachedClient(__clientRoleInGame, __username, __serverGameInstance, __playerID, __userID, __xp, __isRegisteredUser);

							//add the player to the AttachedClients list.
							Base_GameServer.AttachedClients.Add(__username,__newClient);

							//add the player to the game.
							__serverGameInstance.AddPlayerToGame(__username, __newClient);

							//send all game states in memory
							__serverGameInstance.SendAllStateStringsToNewPlayer(__newClient, _gameServer);

							//update the player list.
							foreach (int  __clientID in AttachedPlayerListClients.Keys) 
							{															 
								//AttachedPlayerListClients.Add(__playerID,__playerID);
								_sendPlayerListToClient(__clientID);
							}

						} 
						else 
						{
							//TODO:  Deal w/ the fact that the player is not allowed to join the game.)
							__returnPacket = new NetworkPacket();
							__returnPacket.Write(GameMessageType.InvalidPlayerRole);
							_gameServer.SendTo(__playerID, __returnPacket, PacketTimoutDuration, SendFlags.Guaranteed | SendFlags.NoLoopback);
							__returnPacket.Dispose();

							//bump the player

							//if there's no other players in the game, let's purge this object from memory.

						}
						//if there's any other players in the same game, notify them that someone has connected.

						break;
					case GameMessageType.BeginGame:
						__caseBranchName="GameMessageType.BeginGame";
						//__networkPacket.Write(__gameSetupString);   //the game setup info -- the server won't understand this, but the clients will.
						//__networkPacket.Write(__isChallengerGoingFirst);     //is Challenger going first?


						__playerID=(int) e.Message.SenderID;
						string __gameSetupString = e.Message.ReceiveData.ReadString();
						bool __isChallengerGoingFirst=(bool) e.Message.ReceiveData.Read(typeof(bool));
						__serverGameInstance = ServerGameInstance.GetGameInstanceForAttachedClient(AttachedClient.GetAttachedClientFromPlayerID(__playerID));
						__gameID = __serverGameInstance.GameID;

						//DBSTUB:  here we need to tell the DB that the game is starting, and give it the right data.
						_dbquery.StartNewGame(__gameID,__isChallengerGoingFirst,__gameSetupString);
						__serverGameInstance.GameHasStarted=true;

						//send a message to the clients to get going.  send the game setup string.
						__returnPacket = new NetworkPacket();
						__returnPacket.Write(GameMessageType.BeginGame);
						__returnPacket.Write(__gameSetupString);
						__serverGameInstance.SendPacketToAllConnectedPlayersInGame(__returnPacket, _gameServer);
						//_gameServer.SendTo(__playerID, __returnPacket, PacketTimoutDuration, SendFlags.Guaranteed | SendFlags.NoLoopback);
						__returnPacket.Dispose();


						LogMessage("A new game is starting.");

						break;
					case GameMessageType.GameAction:
						__caseBranchName="GameMessageType.GameAction";
						//                        __networkPacket.Write(key);
						//                        __networkPacket.Write(message);
						//                        __networkPacket.Write(_gameStateBeforeAction);
						__gameMessageNumber = (int)e.Message.ReceiveData.Read(typeof(int));
						string __gameActionKey = e.Message.ReceiveData.ReadString();
						string __gameActionString = e.Message.ReceiveData.ReadString();
						__gameStateConfirmationString = e.Message.ReceiveData.ReadString();

						__playerID=(int) e.Message.SenderID;
						__thisAttachedClient=AttachedClient.GetAttachedClientFromPlayerID(__playerID);
						__serverGameInstance = ServerGameInstance.GetGameInstanceForAttachedClient(__thisAttachedClient);
						__serverGameInstance.SendGameActionToAllOtherPlayersInGame(__thisAttachedClient,__gameMessageNumber,__gameActionKey, __gameActionString, __gameStateConfirmationString, _gameServer);

						//only record the item (and increase the recieved message counter) if it's a *new* message we haven't recieved before.  (messages can be re-sent after a reconnect)
						if (__gameMessageNumber>__thisAttachedClient.LastRecordedMessageNum) 
						{
							__thisAttachedClient.LastRecordedMessageNum=__gameMessageNumber;
							//BUGBUG:  this is temporary.  we really should be appending this to a turn packet for the game in progress and then writing that and shutdown or end-of-turn
							_dbquery.AppendTurnToGame(__serverGameInstance.GameID, __gameActionString +"\r\n");
						}
						break;
					case GameMessageType.EndTurn:
						__caseBranchName="GameMessageType.EndTurn";
						//__networkPacket.Write(_gameStateBeforeAction);
						__gameMessageNumber = (int)e.Message.ReceiveData.Read(typeof(int));
						__gameStateConfirmationString = e.Message.ReceiveData.ReadString();

						//Send the GameMessageType.EndTurn message to the *other* player, and wait for a GameMessageType.EndTurnConfirm message
						__playerID=(int) e.Message.SenderID;
						__serverGameInstance = ServerGameInstance.GetGameInstanceForAttachedClient(AttachedClient.GetAttachedClientFromPlayerID(__playerID));
						__serverGameInstance.PlayerDeclaredEndTurn(__playerID);

						__returnPacket = new NetworkPacket();
						__returnPacket.Write(GameMessageType.EndTurn);
						__returnPacket.Write(__gameMessageNumber);
						__returnPacket.Write(__gameStateConfirmationString);
						__serverGameInstance.SendPacketToAllOtherConnectedPlayersInGame(AttachedClient.GetAttachedClientFromPlayerID(__playerID), __returnPacket, _gameServer);
						__returnPacket.Dispose();
						_dbquery.AppendTurnToGame(__serverGameInstance.GameID,"ENDTURN\r\n");

						//append the turn to the db  //AppendTurnToGame(int gameID, string turnInfo)
						break;
					case GameMessageType.EndTurnConfirm:
						__caseBranchName="GameMessageType.EndTurnConfirm";
						__playerID=(int) e.Message.SenderID;
						__gameMessageNumber = (int)e.Message.ReceiveData.Read(typeof(int));
						__serverGameInstance = ServerGameInstance.GetGameInstanceForAttachedClient(AttachedClient.GetAttachedClientFromPlayerID(__playerID));
						__serverGameInstance.PlayerDeclaredEndTurn(__playerID);

						__returnPacket = new NetworkPacket();
						__returnPacket.Write(GameMessageType.EndTurnConfirm);
						__returnPacket.Write(__gameMessageNumber);
						__serverGameInstance.SendPacketToAllOtherConnectedPlayersInGame(AttachedClient.GetAttachedClientFromPlayerID(__playerID),__returnPacket, _gameServer);
						__returnPacket.Dispose();

						//_dbquery.AppendTurnToGame(__serverGameInstance.GameID,"CONFIRMENDTURN\r\n");
						break;
					case GameMessageType.GameStarted:
						__caseBranchName="GameMessageType.GameStarted";
						__playerID=(int) e.Message.SenderID;
						__gameMessageNumber = (int)e.Message.ReceiveData.Read(typeof(int));
						__serverGameInstance = ServerGameInstance.GetGameInstanceForAttachedClient(AttachedClient.GetAttachedClientFromPlayerID(__playerID));

						__returnPacket = new NetworkPacket();
						__returnPacket.Write(GameMessageType.GameStarted);
						__returnPacket.Write(__gameMessageNumber);
						__serverGameInstance.SendPacketToAllOtherConnectedPlayersInGame(AttachedClient.GetAttachedClientFromPlayerID(__playerID),__returnPacket, _gameServer);
						__returnPacket.Dispose();
						break;
					case GameMessageType.MessageConfirmation:
						__caseBranchName="GameMessageType.MessageConfirmation";
						__playerID=(int) e.Message.SenderID;
						__gameMessageNumber = (int)e.Message.ReceiveData.Read(typeof(int));
						__serverGameInstance = ServerGameInstance.GetGameInstanceForAttachedClient(AttachedClient.GetAttachedClientFromPlayerID(__playerID));

						__returnPacket = new NetworkPacket();
						__returnPacket.Write(GameMessageType.MessageConfirmation);
						__returnPacket.Write(__gameMessageNumber);
						__serverGameInstance.SendPacketToAllOtherConnectedPlayersInGame(AttachedClient.GetAttachedClientFromPlayerID(__playerID),__returnPacket, _gameServer);
						__returnPacket.Dispose();

						break;
					case GameMessageType.LastRecievedMessage:
						__caseBranchName="GameMessageType.LastRecievedMessage";
						__playerID=(int) e.Message.SenderID;
						__gameMessageNumber = (int)e.Message.ReceiveData.Read(typeof(int));
						__serverGameInstance = ServerGameInstance.GetGameInstanceForAttachedClient(AttachedClient.GetAttachedClientFromPlayerID(__playerID));

						__returnPacket = new NetworkPacket();
						__returnPacket.Write(GameMessageType.LastRecievedMessage);
						__returnPacket.Write(__gameMessageNumber);
						__serverGameInstance.SendPacketToAllOtherConnectedPlayersInGame(AttachedClient.GetAttachedClientFromPlayerID(__playerID),__returnPacket, _gameServer);
						__returnPacket.Dispose();

						break;
					case GameMessageType.CaughtUpOnResentPackets:
						__caseBranchName="GameMessageType.CaughtUpOnResentPackets";
						__playerID=(int) e.Message.SenderID;
						__serverGameInstance = ServerGameInstance.GetGameInstanceForAttachedClient(AttachedClient.GetAttachedClientFromPlayerID(__playerID));

						__returnPacket = new NetworkPacket();
						__returnPacket.Write(GameMessageType.CaughtUpOnResentPackets);
						__serverGameInstance.SendPacketToAllOtherConnectedPlayersInGame(AttachedClient.GetAttachedClientFromPlayerID(__playerID),__returnPacket, _gameServer);
						__returnPacket.Dispose();

						break;
					case GameMessageType.CaughtUpConfirm:
						__caseBranchName="GameMessageType.CaughtUpConfirm";
						__playerID=(int) e.Message.SenderID;
						__serverGameInstance = ServerGameInstance.GetGameInstanceForAttachedClient(AttachedClient.GetAttachedClientFromPlayerID(__playerID));

						__returnPacket = new NetworkPacket();
						__returnPacket.Write(GameMessageType.CaughtUpConfirm);
						__serverGameInstance.SendPacketToAllOtherConnectedPlayersInGame(AttachedClient.GetAttachedClientFromPlayerID(__playerID),__returnPacket, _gameServer);
						__returnPacket.Dispose();

						break;
					case GameMessageType.GameOver:
						__caseBranchName="GameMessageType.GameOver";
						__playerID=(int) e.Message.SenderID;
						AttachedClient __attachedClient=AttachedClient.GetAttachedClientFromPlayerID(__playerID);
						lock (__attachedClient)
						{
							if (__attachedClient!=null) 
							{
								__serverGameInstance = ServerGameInstance.GetGameInstanceForAttachedClient(__attachedClient);
							} 
							else 
							{
								__serverGameInstance=null;
							}

							if (__serverGameInstance!=null)
							{	
								GameOverType __gameOverType = (GameOverType) e.Message.ReceiveData.Read(typeof(GameOverType));
								string __gameOverReason = e.Message.ReceiveData.ReadString();
								string __gameOverDebugInfo = e.Message.ReceiveData.ReadString();
								string __winningPlayer = e.Message.ReceiveData.ReadString();
								int __p1XP = (int)__recievedPacket.Read(typeof(int));
								int __p2XP = (int)__recievedPacket.Read(typeof(int));
								//this info is for the server, really
								string __p1UserName = e.Message.ReceiveData.ReadString();
								string __p2UserName = e.Message.ReceiveData.ReadString();

								__returnPacket = new NetworkPacket();
								__returnPacket.Write(GameMessageType.GameOver);
								__returnPacket.Write(__gameOverType);
								__returnPacket.Write(__gameOverReason);
								__returnPacket.Write(__gameOverDebugInfo);
								__returnPacket.Write(__winningPlayer);
								__returnPacket.Write(__p1XP);
								__returnPacket.Write(__p2XP);
								__returnPacket.Write(__p1UserName);
								__returnPacket.Write(__p2UserName);

								//tell the other people waddup
								//__serverGameInstance.SendPacketToAllOtherConnectedPlayersInGame(AttachedClient.GetAttachedClientFromPlayerID(__playerID),__returnPacket, _gameServer);
								__serverGameInstance.SendPacketToAllConnectedPlayersInGame(__returnPacket, _gameServer);
								__returnPacket.Dispose();

								//if this was GameSetupScreen, let's disconnect all the players.
								if (__serverGameInstance.GameHasStarted==false) 
								{   
									DisconnectAllPlayersInGame(__serverGameInstance);
								}

								bool __player1WasChallenger=false;
								if (__serverGameInstance.ChallengerUsername.ToLower()==__p1UserName.ToLower()) 
								{
									__player1WasChallenger=true;
								}

								__serverGameInstance.GameHasEnded=true;

								//This is where We have the player give the XP to the players
								AttachedClient __player1=AttachedClient.GetAttachedClientFromUsername(__p1UserName);
								AttachedClient __player2=AttachedClient.GetAttachedClientFromUsername(__p2UserName);

								if (__p1XP>0 && __p1UserName!="[None]")
								{
									if (__player1WasChallenger) 
									{
										__isRegisteredUser=__serverGameInstance.ChallengerIsRegistered;
									} 
									else 
									{
										__isRegisteredUser=__serverGameInstance.ChallengeeIsRegistered;
									}
									
									if (__isRegisteredUser) //only give xp to registered players
									{
										//get the players UserIDs					
										int __player1UserID=_dbquery.FindUser(__p1UserName);

										//let's give the players the XP:
										_dbquery.AddPlayerStat(__player1UserID, "xp", Convert.ToString(__player1.XP+__p1XP));
									}
								}

								if (__p2XP>0 && __p2UserName!="[None]")
								{
									if (__player1WasChallenger) 
									{
										__isRegisteredUser=__serverGameInstance.ChallengeeIsRegistered;
									} 
									else 
									{
										__isRegisteredUser=__serverGameInstance.ChallengerIsRegistered;
									}

									if (__isRegisteredUser) //only give xp to registered players
									{
										//get the players UserIDs					
										int __player2UserID=_dbquery.FindUser(__p2UserName);

										//let's give the players the XP:
										_dbquery.AddPlayerStat(__player2UserID, "xp", Convert.ToString(__player2.XP+__p2XP));
									}
								}

								//let's write the end of the game to the db.
								if (__serverGameInstance.GameHasStarted) 
								{
									_dbquery.EndGame(__serverGameInstance.GameID,__winningPlayer,__gameOverReason);
								} 
								else 
								{
									_dbquery.CancelNewGame(__serverGameInstance.GameID);
								}
							}
						}
						break;
					case GameMessageType.PlayerLoggedOff:
						__caseBranchName="GameMessageType.PlayerLoggedOff";
						__playerID=(int) e.Message.SenderID;
						__serverGameInstance = ServerGameInstance.GetGameInstanceForAttachedClient(AttachedClient.GetAttachedClientFromPlayerID(__playerID));

						try 
						{
							__attachedClient = AttachedClient.GetAttachedClientFromPlayerID(__playerID);
							__serverGameInstance.NukePlayer(__attachedClient, true, _gameServer); 
						} 
						catch (Exception e2) 
						{
							LogMessage("ERROR:  We tried to log a player off (they cancelled in game setup), but we couldn't find that AttachedClient.");
						}
						DisconnectAllPlayersInGame(__serverGameInstance);
						break;
					case GameMessageType.Rematch:
						__caseBranchName="GameMessageType.Rematch";
						__playerID=(int) e.Message.SenderID;
						__serverGameInstance = ServerGameInstance.GetGameInstanceForAttachedClient(AttachedClient.GetAttachedClientFromPlayerID(__playerID));

						//get the old challenger and challengee's PlayerID's
						int __challengerUserID=__serverGameInstance.ChallengerID;
						int __challengeeUserID=__serverGameInstance.ChallengeeID;
						AttachedClient __challengerClient=AttachedClient.GetAttachedClientFromUserID(__challengerUserID);
						AttachedClient __challengeeClient=AttachedClient.GetAttachedClientFromUserID(__challengeeUserID);

						//create a reservation for a new game, and then send both players the ID and tell them to join.

						__gameID= _dbquery.CreateNewGame(__challengerUserID, __challengeeUserID, _gameTypeID, false);

						//let's tell the challenging player first
						//SendPacketToPlayer(AttachedClient attachedClient, NetworkPacket __packetToSend, Server gameServer)

						//SendPacketToAllOtherConnectedPlayersInGame(AttachedClient.GetAttachedClientFromPlayerID(__playerID),__returnPacket, _gameServer);

						__returnPacket = new NetworkPacket();
						__returnPacket.Write(GameMessageType.Rematch);
						__returnPacket.Write(__gameID);
						__returnPacket.Write(ClientRole.Challenger);
						__serverGameInstance.SendPacketToPlayer(__challengerClient, __returnPacket, _gameServer);
						//_sendMessageToClient(__playerID, __returnPacket, PacketTimoutDuration, SendFlags.Guaranteed | SendFlags.NoLoopback);
						__returnPacket.Dispose();

						//now let's tell the challenged player.
						__returnPacket = new NetworkPacket();
						__returnPacket.Write(GameMessageType.Rematch);
						__returnPacket.Write(__gameID);
						__returnPacket.Write(ClientRole.Challengee);
						__serverGameInstance.SendPacketToPlayer(__challengeeClient, __returnPacket, _gameServer);
						__returnPacket.Dispose();

						//let's remove them from the game and log them off.
						DisconnectAllPlayersInGame(__serverGameInstance);

						//That should be it.  The players should now leave on their own when they get this message.

						break;
					case GameMessageType.DisconnectThisUser:
						__caseBranchName="GameMessageType.DisconnectThisUser";
						__playerID=(int) e.Message.SenderID;
						__serverGameInstance = ServerGameInstance.GetGameInstanceForAttachedClient(AttachedClient.GetAttachedClientFromPlayerID(__playerID));
						__serverGameInstance.NukePlayer(AttachedClient.GetAttachedClientFromPlayerID(__playerID),true,_gameServer);
						break;
				}
			}
		}
		catch (Exception ex)
		{
			SI_MiddleTier.MiddleTier.RecordExceptionToErrorFile("Game Server", ex, "GameServer DataReceive(), branch=" +__caseBranchName);  //make sure the name of the server is listed -- it will be recorded in the log file.

			throw ex;
		}
	}
//
//    public void _cancelGameForAllPlayersInGame (ServerGameInstance serverGameInstance)
//    {
//        lock (serverGameInstance.AttachedClients) 
//        {
//            AttachedClient[] __attachedClients = new AttachedClient[serverGameInstance.AttachedClients.Values.Count];
//            serverGameInstance.AttachedClients.Values.CopyTo(__attachedClients,0);
//            
//            for (int x=0;x<__attachedClients.Length;x++) 
//            {
//                serverGameInstance.NukePlayer(__attachedClients[x], false, _gameServer);   
//            }
//            //foreach (AttachedClient __attachedClient in serverGameInstance.AttachedClients.Values) 
//            //            while (serverGameInstance.AttachedClients.Values. .Values.Count!=0) 
//            //            {
//            //                AttachedClient __attachedClient=serverGameInstance.AttachedClients.Values[0];
//            //            }
//        }
//    }

    public void DisconnectAllPlayersInGame (ServerGameInstance serverGameInstance)
    {
        try 
        {
			lock (serverGameInstance.AttachedClients) 
			{
					AttachedClient[] __attachedClients = new AttachedClient[serverGameInstance.AttachedClients.Values.Count];
					serverGameInstance.AttachedClients.Values.CopyTo(__attachedClients,0);
	            
					for (int x=0;x<__attachedClients.Length;x++) 
					{
						serverGameInstance.NukePlayer(__attachedClients[x], false, _gameServer);   
					}
					//foreach (AttachedClient __attachedClient in serverGameInstance.AttachedClients.Values) 
					//            while (serverGameInstance.AttachedClients.Values. .Values.Count!=0) 
					//            {
					//                AttachedClient __attachedClient=serverGameInstance.AttachedClients.Values[0];
					//            }
			}
		} 
		catch {}
	}

	private void PlayerLeft(object sender, PlayerDestroyedEventArgs e)
	{
		//A player left -- let's handle that
		try 
		{
			try { LogMessage("A player (ID# " + e.Message.PlayerID + ") has logged off"); } catch {}
	    
            ServerGameInstance __serverGameInstance = ServerGameInstance.GetGameInstanceForAttachedClient(AttachedClient.GetAttachedClientFromPlayerID(e.Message.PlayerID));

            if (__serverGameInstance!=null && AttachedClient.GetAttachedClientFromPlayerID(e.Message.PlayerID)!=null) 
            {
                AttachedClient __attachedClient = AttachedClient.GetAttachedClientFromPlayerID(e.Message.PlayerID);

                __serverGameInstance.NukePlayer(__attachedClient, true, _gameServer);
            }
		}
		catch (Exception ex)
		{
			SI_MiddleTier.MiddleTier.RecordExceptionToErrorFile("Game Server", ex, "Problem in PlayerLeft()");  //make sure the name of the server is listed -- it will be recorded in the log file.

			//TODO:  add a log message that there was no server instance to nuke.
			try { LogMessage("ERROR:  We tried to log a player off, but we couldn't find that AttachedClient or their GameInstance object."); } catch {}

			throw ex;
		}

		//now that a player has left, let's send the updated list...
		foreach (int  __clientID in AttachedPlayerListClients.Keys) 
		{															 
			//AttachedPlayerListClients.Add(__playerID,__playerID);
			_sendPlayerListToClient(__clientID);
		}
	}

	public virtual void ShutDown()
	{
		_gameServer.Dispose();
	}

	#endregion
}