using System;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;


namespace LobbyServer
{
	public class LobbyServerAccess : Base_LobbyServer
	{
		public System.Windows.Forms.ListBox PlayerListBox;
		public System.Windows.Forms.RichTextBox Messages;

		public LobbyServerAccess(ListBox playerListBox, RichTextBox messages)
		{
			PlayerListBox = playerListBox;
			Messages = messages;

			base.StartServer();
		}

		public override void AddUser(PlayerObject playerToAdd)
		{
			base.AddUser(playerToAdd);
			PlayerListBox.Items.Add(playerToAdd.Username);
		}

		public override PlayerObject RemoveUser(int playerID)
		{
			PlayerObject __tempPlayer = base.RemoveUser(playerID);
			PlayerListBox.Items.Remove(__tempPlayer.Username);

			return __tempPlayer;
		}

		public override void KickPlayer(PlayerObject playerToKick)
		{
			base.KickPlayer(playerToKick);
		}

		public override void WriteTextToChatArea(string textToWrite) 
		{
			lock (Messages) 
			{
				if (Messages.Text.Length>0)
				{
					Messages.AppendText(System.Environment.NewLine);
				}
				Messages.AppendText(textToWrite);
				Messages.Select();
				Messages.SelectionStart=Messages.Text.Length;
				Messages.ScrollToCaret();
				//ChatBox.Select();
				//Messages.AppendText(textToWrite+System.Environment.NewLine);
				//Messages.Text=Messages.Text+textToWrite+System.Environment.NewLine;
				//Messages.Select(Messages.Text.Length,0);
				//Messages.ScrollToCaret();
			}
		}

		public override void ShutDown()
		{
			base.ShutDown();
		}

		public override void Dispose()
		{
			base.Dispose();
		}
	}

	/// <summary>
	/// Summary description for LobbyServer.
	/// </summary>
	public class LobbyServer : System.Windows.Forms.Form
	{
        #region Windows Form Components
        private System.Windows.Forms.ListBox PlayerListBox;
        private System.Windows.Forms.RichTextBox Messages;
        private System.Windows.Forms.Button ShutDown;
        private System.Windows.Forms.Label label1;
        private System.Windows.Forms.Label label2;
        private System.Windows.Forms.Button KickPlayerButton;
        /// <summary>
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.Container components = null;
        #endregion

        #region Private Member Variables
		private LobbyServerAccess _lobbyServer;
        #endregion

        #region Constructor
        public LobbyServer()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			_lobbyServer = new LobbyServerAccess(PlayerListBox, Messages);
        }

        #endregion

        #region Application Main()
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main(string[] args)
        {
        	//
        	// TODO: Add code to start application here
        	//
            Application.Run(new LobbyServer());
        }
        #endregion

        #region Destructor
        /// <summary>
		/// Clean up any resources being used.
		/// </summary>
        protected override void Dispose( bool disposing )
        {
			_lobbyServer.Dispose();

            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }

            base.Dispose(disposing);
        }
        #endregion
        
        #region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.Messages = new System.Windows.Forms.RichTextBox();
            this.ShutDown = new System.Windows.Forms.Button();
            this.PlayerListBox = new System.Windows.Forms.ListBox();
            this.label1 = new System.Windows.Forms.Label();
            this.label2 = new System.Windows.Forms.Label();
            this.KickPlayerButton = new System.Windows.Forms.Button();
            this.SuspendLayout();
            // 
            // Messages
            // 
            this.Messages.Location = new System.Drawing.Point(216, 32);
            this.Messages.Name = "Messages";
            this.Messages.ReadOnly = true;
            this.Messages.ScrollBars = System.Windows.Forms.RichTextBoxScrollBars.Vertical;
            this.Messages.Size = new System.Drawing.Size(464, 288);
            this.Messages.TabIndex = 0;
            this.Messages.Text = "";
            // 
            // ShutDown
            // 
            this.ShutDown.Location = new System.Drawing.Point(568, 328);
            this.ShutDown.Name = "ShutDown";
            this.ShutDown.Size = new System.Drawing.Size(120, 32);
            this.ShutDown.TabIndex = 2;
            this.ShutDown.Text = "Shut Down";
            this.ShutDown.Click += new System.EventHandler(this.ShutDown_Click);
            // 
            // PlayerListBox
            // 
            this.PlayerListBox.Location = new System.Drawing.Point(8, 32);
            this.PlayerListBox.Name = "PlayerListBox";
            this.PlayerListBox.Size = new System.Drawing.Size(200, 290);
            this.PlayerListBox.TabIndex = 3;
            // 
            // label1
            // 
            this.label1.Font = new System.Drawing.Font("Microsoft Sans Serif", 12F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.label1.Location = new System.Drawing.Point(216, 8);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(96, 24);
            this.label1.TabIndex = 4;
            this.label1.Text = "Messages:";
            // 
            // label2
            // 
            this.label2.Font = new System.Drawing.Font("Microsoft Sans Serif", 12F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.label2.Location = new System.Drawing.Point(8, 8);
            this.label2.Name = "label2";
            this.label2.Size = new System.Drawing.Size(88, 24);
            this.label2.TabIndex = 5;
            this.label2.Text = "Players:";
            // 
            // KickPlayerButton
            // 
            this.KickPlayerButton.Location = new System.Drawing.Point(128, 328);
            this.KickPlayerButton.Name = "KickPlayerButton";
            this.KickPlayerButton.Size = new System.Drawing.Size(80, 32);
            this.KickPlayerButton.TabIndex = 6;
            this.KickPlayerButton.Text = "KickPlayer";
            this.KickPlayerButton.Click += new System.EventHandler(this.KickPlayerButton_Click);
            // 
            // LobbyServer
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(692, 366);
            this.Controls.AddRange(new System.Windows.Forms.Control[] {
                                                                          this.KickPlayerButton,
                                                                          this.label2,
                                                                          this.label1,
                                                                          this.PlayerListBox,
                                                                          this.ShutDown,
                                                                          this.Messages});
            this.MaximizeBox = false;
            this.Name = "LobbyServer";
            this.Text = "LobbyServer";
            this.ResumeLayout(false);

        }
		#endregion

        #region Public Functions

		private void ShutDown_Click(object sender, System.EventArgs e)
		{
			//            foreach (PlayerObject __playerObject in _playerList.Players.Values) 
			//            {
			//            }
			_lobbyServer.ShutDown();
			Application.Exit();
		}

        private void KickPlayerButton_Click(object sender, System.EventArgs e)
        {
			// Make sure a player is selected
			if (PlayerListBox.SelectedIndex == -1)
			{
				return;
			}

			// Otherwise, get the username of the player and boot their ass.
			string __tempUsername = (string) PlayerListBox.SelectedItem;
			PlayerObject __tempPlayerObject = 
				(PlayerObject) _lobbyServer._playerList.Players[__tempUsername];

			_lobbyServer.KickPlayer(__tempPlayerObject);
        }
        #endregion
	}
}
