using System;
using Microsoft.Win32;

/// <summary>
/// Summary description for SI_Registry.
/// </summary>
public class SI_Registry
{
	public const string RegistyBase = @"Software\Tiny Hero";

	public bool IsHKEYCurrentUser = false;
	
	private RegistryKey _regKey = Registry.LocalMachine;
	private string _pathToRegistry = RegistyBase;

	public SI_Registry()
	{
		_createRegistryKey(RegistyBase, false);
	}

	public SI_Registry(string registryBasePath)
	{
		_createRegistryKey(registryBasePath, false);
	}

	public SI_Registry(string registryBasePath, bool isForCurrentUser)
	{
		_createRegistryKey(registryBasePath, isForCurrentUser);
	}

	private void _createRegistryKey(string registryBasePath, bool isForCurrentUser)
	{
		IsHKEYCurrentUser = isForCurrentUser;
		_pathToRegistry = registryBasePath;
		_regKey = _hKey;
	}

	private RegistryKey _hKey
	{
		get
		{
			if (IsHKEYCurrentUser)
			{
				return Registry.CurrentUser;
			}
			else
			{
				return Registry.LocalMachine;
			}
		}
	}

	private void _setSubPathForRegKey(ref string keyName)
	{
		string __subPath = _getSubPath(keyName);

		if (__subPath != string.Empty)
		{
			keyName = keyName.Substring(__subPath.Length + 1);
			_regKey = _hKey.OpenSubKey(_pathToRegistry + @"\" + __subPath, true);
		}
		else
		{
			_regKey = _hKey.OpenSubKey(_pathToRegistry, true);
		}
	}

	private static string _getSubPath(string path)
	{
		int __lastSlashPos = path.LastIndexOf("\\");
		string __subPath = string.Empty;

		if (__lastSlashPos > 0)
		{
			__subPath = path.Substring(0, __lastSlashPos);
		}

		return __subPath;
	}

	// Example: SetRegistryValue(@"Animals\Rabbit\fur", "soft")
	public void SetRegistryValue(string keyName, string keyValue)
	{
		try
		{
			string __subPath = keyName;
			_setSubPathForRegKey(ref keyName);

			// If the full path doesn't exist, create it
			if ( (_regKey == null) && (__subPath != keyName) )
			{
				string[] __subKeys = __subPath.Split('\\');
				_regKey = _hKey.OpenSubKey(_pathToRegistry, true);

				foreach (string key in __subKeys)
				{
					if (_regKey.OpenSubKey(key, false) == null)
					{
						_regKey = _regKey.CreateSubKey(key);
					}
				}
			}

			// Set the value in this key
			if (_regKey != null)
			{
				_regKey.SetValue(keyName, keyValue);
				_regKey.Flush();
				_regKey.Close();
			}
		}
		catch {}
	}

	public string GetRegistryValue(string keyName)
	{
		// Retrieves the value from the app-related key in the registry.
		// Location in registry: HKEY_LOCAL_MACHINE\Software\Tiny Hero\Land Of Legends\Param_Name=value
		try
		{
			string __val = null;
			_setSubPathForRegKey(ref keyName);

			if (_regKey != null)
			{
				__val = _regKey.GetValue(keyName).ToString();
				_regKey.Close();
			}

			if (__val == null)
			{
				return string.Empty;
			}
			else
			{
				return __val;
			}
		}
		catch
		{
			return string.Empty;
		}
	}

	public bool DeleteRegistryValue(string keyName)
	{
		try
		{
			_setSubPathForRegKey(ref keyName);

			if (_regKey == null)
			{
				return false;
			}
			else
			{
				_regKey.DeleteValue(keyName);
				_regKey.Flush();
				_regKey.Close();
				return true;
			}
		}
		catch
		{
			return false;
		}
	}

	public bool DeleteRegistryKey(string keyName)
	{
		try
		{
			_setSubPathForRegKey(ref keyName);

			if (_regKey == null)
			{
				return false;
			}
			else
			{
				_regKey.DeleteSubKey(keyName);
				_regKey.Flush();
				_regKey.Close();
				return true;
			}
		}
		catch
		{
			return false;
		}
	}
}
